import { Outlet } from 'react-router-dom';
import Sidebar from './Sidebar';
import Header from './Header';
import { useState } from 'react';

export default function Layout() {
  const [sidebarCollapsed, setSidebarCollapsed] = useState(false);
  
  const toggleSidebar = () => {
    setSidebarCollapsed(!sidebarCollapsed);
  };

  return (
    <div className="flex min-h-screen bg-gray-100">
      <Sidebar collapsed={sidebarCollapsed} />
      <div className={`flex flex-col flex-grow ${sidebarCollapsed ? 'ml-16' : 'ml-64'} transition-all duration-300`}>
        <Header onToggleSidebar={toggleSidebar} />
        <main className="flex-grow p-6">
          <Outlet />
        </main>
      </div>
    </div>
  );
}