import { createContext, useContext, useState, useEffect } from 'react';
import { jwtDecode } from 'jwt-decode';
import api from '../api';

const AuthCtx = createContext(null);
export const useAuth = () => useContext(AuthCtx);

export default function AuthProvider({ children }) {
  const [user, setUser] = useState(null);

  /* F5: lấy token cũ */
  useEffect(() => {
    const token = localStorage.getItem('access_token');
    if (token) {
      try { setUser(jwtDecode(token)); } catch { localStorage.clear(); }
    }
  }, []);

  /* Gửi nguyên payload lên backend */
  const loginRaw = (payload) => api.post('/auth/login', payload);

  /* Lưu token & set user khi backend trả 200 */
  const finishLogin = (res) => {
    localStorage.setItem('access_token',  res.data.access_token);
    localStorage.setItem('refresh_token', res.data.refresh_token);
    setUser(jwtDecode(res.data.access_token));
  };

  const logout = () => { localStorage.clear(); setUser(null); };

  return (
    <AuthCtx.Provider value={{ user, loginRaw, finishLogin, logout }}>
      {children}
    </AuthCtx.Provider>
  );
}
