import { BrowserRouter, Routes, Route } from 'react-router-dom';
import AuthProvider from '../contexts/AuthContext';
import PrivateRoute from '../contexts/PrivateRoute';
import AdminRoute   from '../contexts/AdminRoute';

import Layout from '../components/Layout';
import Login from '../pages/Login';
import Register from '../pages/Register';
import Dashboard from '../pages/Dashboard';
import TOTPSetup from '../pages/TOTPSetup';
import OTPChallenge from '../pages/OTPChallenge';
import NotFound from '../pages/NotFound';
import Realms      from '../pages/admin/Realms';
import RealmKeys   from '../pages/admin/RealmKeys';
import RealmUsers  from '../pages/admin/RealmUsers';
import Clients from '../pages/admin/Clients';
import Authentication from '../pages/admin/Authentication';


export default function AppRoutes() {
  return (
    <BrowserRouter>
      <AuthProvider>
        <Routes>
          {/* Public routes */}
          <Route path="/login" element={<Login/>}/>
          <Route path="/otp"   element={<OTPChallenge/>}/>
          <Route path="/register" element={<Register/>}/>

          {/* Protected routes with layout */}
          <Route element={<PrivateRoute><Layout /></PrivateRoute>}>
            <Route path="/" element={<Dashboard />} />
            <Route path="/totp" element={<TOTPSetup />} />
            
            {/* Admin routes */}
            <Route path="/admin/realms" element={
              <AdminRoute><Realms /></AdminRoute>
            } />
            <Route path="/admin/realms/:realmId/keys" element={
              <AdminRoute><RealmKeys /></AdminRoute>
            } />
            <Route path="/admin/realms/:realmId/users" element={
              <AdminRoute><RealmUsers /></AdminRoute>
            } />
            <Route path="/admin/clients" element={
              <AdminRoute><Clients /></AdminRoute>
            } />

            {/* Các route mới để phù hợp với sidebar */}
            <Route path="/admin/users" element={
              <AdminRoute><NotFound /></AdminRoute>
            } />
            <Route path="/admin/groups" element={
              <AdminRoute><NotFound /></AdminRoute>
            } />
            <Route path="/admin/roles" element={
              <AdminRoute><NotFound /></AdminRoute>
            } />
            <Route path="/admin/sessions" element={
              <AdminRoute><NotFound /></AdminRoute>
            } />
            <Route path="/admin/events" element={
              <AdminRoute><NotFound /></AdminRoute>
            } />
            <Route path="/admin/realm-settings" element={
              <AdminRoute><NotFound /></AdminRoute>
            } />
            <Route path="/admin/authentication" element={
              <AdminRoute><Authentication /></AdminRoute>
            } />
            <Route path="/admin/identity-providers" element={
              <AdminRoute><NotFound /></AdminRoute>
            } />
            <Route path="/admin/user-federation" element={
              <AdminRoute><NotFound /></AdminRoute>
            } />
          </Route>
          
          <Route path="*" element={<NotFound/>}/>
        </Routes>
      </AuthProvider>
    </BrowserRouter>
  );
}
