
/**
 * Client
**/

import * as runtime from '@prisma/client/runtime/library.js';
import $Types = runtime.Types // general types
import $Public = runtime.Types.Public
import $Utils = runtime.Types.Utils
import $Extensions = runtime.Types.Extensions
import $Result = runtime.Types.Result

export type PrismaPromise<T> = $Public.PrismaPromise<T>


/**
 * Model Realm
 * 
 */
export type Realm = $Result.DefaultSelection<Prisma.$RealmPayload>
/**
 * Model RealmKey
 * 
 */
export type RealmKey = $Result.DefaultSelection<Prisma.$RealmKeyPayload>
/**
 * Model User
 * 
 */
export type User = $Result.DefaultSelection<Prisma.$UserPayload>
/**
 * Model UserSession
 * 
 */
export type UserSession = $Result.DefaultSelection<Prisma.$UserSessionPayload>
/**
 * Model Role
 * 
 */
export type Role = $Result.DefaultSelection<Prisma.$RolePayload>
/**
 * Model UserRole
 * 
 */
export type UserRole = $Result.DefaultSelection<Prisma.$UserRolePayload>
/**
 * Model Client
 * 
 */
export type Client = $Result.DefaultSelection<Prisma.$ClientPayload>
/**
 * Model Scope
 * 
 */
export type Scope = $Result.DefaultSelection<Prisma.$ScopePayload>
/**
 * Model ClientScope
 * 
 */
export type ClientScope = $Result.DefaultSelection<Prisma.$ClientScopePayload>
/**
 * Model AuthorizationCode
 * 
 */
export type AuthorizationCode = $Result.DefaultSelection<Prisma.$AuthorizationCodePayload>
/**
 * Model Token
 * 
 */
export type Token = $Result.DefaultSelection<Prisma.$TokenPayload>

/**
 * Enums
 */
export namespace $Enums {
  export const TokenType: {
  access: 'access',
  refresh: 'refresh',
  id: 'id'
};

export type TokenType = (typeof TokenType)[keyof typeof TokenType]

}

export type TokenType = $Enums.TokenType

export const TokenType: typeof $Enums.TokenType

/**
 * ##  Prisma Client ʲˢ
 *
 * Type-safe database client for TypeScript & Node.js
 * @example
 * ```
 * const prisma = new PrismaClient()
 * // Fetch zero or more Realms
 * const realms = await prisma.realm.findMany()
 * ```
 *
 *
 * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
 */
export class PrismaClient<
  ClientOptions extends Prisma.PrismaClientOptions = Prisma.PrismaClientOptions,
  U = 'log' extends keyof ClientOptions ? ClientOptions['log'] extends Array<Prisma.LogLevel | Prisma.LogDefinition> ? Prisma.GetEvents<ClientOptions['log']> : never : never,
  ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs
> {
  [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['other'] }

    /**
   * ##  Prisma Client ʲˢ
   *
   * Type-safe database client for TypeScript & Node.js
   * @example
   * ```
   * const prisma = new PrismaClient()
   * // Fetch zero or more Realms
   * const realms = await prisma.realm.findMany()
   * ```
   *
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
   */

  constructor(optionsArg ?: Prisma.Subset<ClientOptions, Prisma.PrismaClientOptions>);
  $on<V extends U>(eventType: V, callback: (event: V extends 'query' ? Prisma.QueryEvent : Prisma.LogEvent) => void): PrismaClient;

  /**
   * Connect with the database
   */
  $connect(): $Utils.JsPromise<void>;

  /**
   * Disconnect from the database
   */
  $disconnect(): $Utils.JsPromise<void>;

  /**
   * Add a middleware
   * @deprecated since 4.16.0. For new code, prefer client extensions instead.
   * @see https://pris.ly/d/extensions
   */
  $use(cb: Prisma.Middleware): void

/**
   * Executes a prepared raw query and returns the number of affected rows.
   * @example
   * ```
   * const result = await prisma.$executeRaw`UPDATE User SET cool = ${true} WHERE email = ${'user@email.com'};`
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Executes a raw query and returns the number of affected rows.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$executeRawUnsafe('UPDATE User SET cool = $1 WHERE email = $2 ;', true, 'user@email.com')
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Performs a prepared raw query and returns the `SELECT` data.
   * @example
   * ```
   * const result = await prisma.$queryRaw`SELECT * FROM User WHERE id = ${1} OR email = ${'user@email.com'};`
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<T>;

  /**
   * Performs a raw query and returns the `SELECT` data.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$queryRawUnsafe('SELECT * FROM User WHERE id = $1 OR email = $2;', 1, 'user@email.com')
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<T>;


  /**
   * Allows the running of a sequence of read/write operations that are guaranteed to either succeed or fail as a whole.
   * @example
   * ```
   * const [george, bob, alice] = await prisma.$transaction([
   *   prisma.user.create({ data: { name: 'George' } }),
   *   prisma.user.create({ data: { name: 'Bob' } }),
   *   prisma.user.create({ data: { name: 'Alice' } }),
   * ])
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/concepts/components/prisma-client/transactions).
   */
  $transaction<P extends Prisma.PrismaPromise<any>[]>(arg: [...P], options?: { isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<runtime.Types.Utils.UnwrapTuple<P>>

  $transaction<R>(fn: (prisma: Omit<PrismaClient, runtime.ITXClientDenyList>) => $Utils.JsPromise<R>, options?: { maxWait?: number, timeout?: number, isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<R>


  $extends: $Extensions.ExtendsHook<"extends", Prisma.TypeMapCb<ClientOptions>, ExtArgs, $Utils.Call<Prisma.TypeMapCb<ClientOptions>, {
    extArgs: ExtArgs
  }>>

      /**
   * `prisma.realm`: Exposes CRUD operations for the **Realm** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Realms
    * const realms = await prisma.realm.findMany()
    * ```
    */
  get realm(): Prisma.RealmDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.realmKey`: Exposes CRUD operations for the **RealmKey** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more RealmKeys
    * const realmKeys = await prisma.realmKey.findMany()
    * ```
    */
  get realmKey(): Prisma.RealmKeyDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.user`: Exposes CRUD operations for the **User** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Users
    * const users = await prisma.user.findMany()
    * ```
    */
  get user(): Prisma.UserDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.userSession`: Exposes CRUD operations for the **UserSession** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more UserSessions
    * const userSessions = await prisma.userSession.findMany()
    * ```
    */
  get userSession(): Prisma.UserSessionDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.role`: Exposes CRUD operations for the **Role** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Roles
    * const roles = await prisma.role.findMany()
    * ```
    */
  get role(): Prisma.RoleDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.userRole`: Exposes CRUD operations for the **UserRole** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more UserRoles
    * const userRoles = await prisma.userRole.findMany()
    * ```
    */
  get userRole(): Prisma.UserRoleDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.client`: Exposes CRUD operations for the **Client** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Clients
    * const clients = await prisma.client.findMany()
    * ```
    */
  get client(): Prisma.ClientDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.scope`: Exposes CRUD operations for the **Scope** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Scopes
    * const scopes = await prisma.scope.findMany()
    * ```
    */
  get scope(): Prisma.ScopeDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.clientScope`: Exposes CRUD operations for the **ClientScope** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ClientScopes
    * const clientScopes = await prisma.clientScope.findMany()
    * ```
    */
  get clientScope(): Prisma.ClientScopeDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.authorizationCode`: Exposes CRUD operations for the **AuthorizationCode** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more AuthorizationCodes
    * const authorizationCodes = await prisma.authorizationCode.findMany()
    * ```
    */
  get authorizationCode(): Prisma.AuthorizationCodeDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.token`: Exposes CRUD operations for the **Token** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Tokens
    * const tokens = await prisma.token.findMany()
    * ```
    */
  get token(): Prisma.TokenDelegate<ExtArgs, ClientOptions>;
}

export namespace Prisma {
  export import DMMF = runtime.DMMF

  export type PrismaPromise<T> = $Public.PrismaPromise<T>

  /**
   * Validator
   */
  export import validator = runtime.Public.validator

  /**
   * Prisma Errors
   */
  export import PrismaClientKnownRequestError = runtime.PrismaClientKnownRequestError
  export import PrismaClientUnknownRequestError = runtime.PrismaClientUnknownRequestError
  export import PrismaClientRustPanicError = runtime.PrismaClientRustPanicError
  export import PrismaClientInitializationError = runtime.PrismaClientInitializationError
  export import PrismaClientValidationError = runtime.PrismaClientValidationError

  /**
   * Re-export of sql-template-tag
   */
  export import sql = runtime.sqltag
  export import empty = runtime.empty
  export import join = runtime.join
  export import raw = runtime.raw
  export import Sql = runtime.Sql



  /**
   * Decimal.js
   */
  export import Decimal = runtime.Decimal

  export type DecimalJsLike = runtime.DecimalJsLike

  /**
   * Metrics
   */
  export type Metrics = runtime.Metrics
  export type Metric<T> = runtime.Metric<T>
  export type MetricHistogram = runtime.MetricHistogram
  export type MetricHistogramBucket = runtime.MetricHistogramBucket

  /**
  * Extensions
  */
  export import Extension = $Extensions.UserArgs
  export import getExtensionContext = runtime.Extensions.getExtensionContext
  export import Args = $Public.Args
  export import Payload = $Public.Payload
  export import Result = $Public.Result
  export import Exact = $Public.Exact

  /**
   * Prisma Client JS version: 6.6.0
   * Query Engine version: f676762280b54cd07c770017ed3711ddde35f37a
   */
  export type PrismaVersion = {
    client: string
  }

  export const prismaVersion: PrismaVersion

  /**
   * Utility Types
   */


  export import JsonObject = runtime.JsonObject
  export import JsonArray = runtime.JsonArray
  export import JsonValue = runtime.JsonValue
  export import InputJsonObject = runtime.InputJsonObject
  export import InputJsonArray = runtime.InputJsonArray
  export import InputJsonValue = runtime.InputJsonValue

  /**
   * Types of the values used to represent different kinds of `null` values when working with JSON fields.
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  namespace NullTypes {
    /**
    * Type of `Prisma.DbNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.DbNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class DbNull {
      private DbNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.JsonNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.JsonNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class JsonNull {
      private JsonNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.AnyNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.AnyNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class AnyNull {
      private AnyNull: never
      private constructor()
    }
  }

  /**
   * Helper for filtering JSON entries that have `null` on the database (empty on the db)
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const DbNull: NullTypes.DbNull

  /**
   * Helper for filtering JSON entries that have JSON `null` values (not empty on the db)
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const JsonNull: NullTypes.JsonNull

  /**
   * Helper for filtering JSON entries that are `Prisma.DbNull` or `Prisma.JsonNull`
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const AnyNull: NullTypes.AnyNull

  type SelectAndInclude = {
    select: any
    include: any
  }

  type SelectAndOmit = {
    select: any
    omit: any
  }

  /**
   * Get the type of the value, that the Promise holds.
   */
  export type PromiseType<T extends PromiseLike<any>> = T extends PromiseLike<infer U> ? U : T;

  /**
   * Get the return type of a function which returns a Promise.
   */
  export type PromiseReturnType<T extends (...args: any) => $Utils.JsPromise<any>> = PromiseType<ReturnType<T>>

  /**
   * From T, pick a set of properties whose keys are in the union K
   */
  type Prisma__Pick<T, K extends keyof T> = {
      [P in K]: T[P];
  };


  export type Enumerable<T> = T | Array<T>;

  export type RequiredKeys<T> = {
    [K in keyof T]-?: {} extends Prisma__Pick<T, K> ? never : K
  }[keyof T]

  export type TruthyKeys<T> = keyof {
    [K in keyof T as T[K] extends false | undefined | null ? never : K]: K
  }

  export type TrueKeys<T> = TruthyKeys<Prisma__Pick<T, RequiredKeys<T>>>

  /**
   * Subset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection
   */
  export type Subset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never;
  };

  /**
   * SelectSubset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection.
   * Additionally, it validates, if both select and include are present. If the case, it errors.
   */
  export type SelectSubset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    (T extends SelectAndInclude
      ? 'Please either choose `select` or `include`.'
      : T extends SelectAndOmit
        ? 'Please either choose `select` or `omit`.'
        : {})

  /**
   * Subset + Intersection
   * @desc From `T` pick properties that exist in `U` and intersect `K`
   */
  export type SubsetIntersection<T, U, K> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    K

  type Without<T, U> = { [P in Exclude<keyof T, keyof U>]?: never };

  /**
   * XOR is needed to have a real mutually exclusive union type
   * https://stackoverflow.com/questions/42123407/does-typescript-support-mutually-exclusive-types
   */
  type XOR<T, U> =
    T extends object ?
    U extends object ?
      (Without<T, U> & U) | (Without<U, T> & T)
    : U : T


  /**
   * Is T a Record?
   */
  type IsObject<T extends any> = T extends Array<any>
  ? False
  : T extends Date
  ? False
  : T extends Uint8Array
  ? False
  : T extends BigInt
  ? False
  : T extends object
  ? True
  : False


  /**
   * If it's T[], return T
   */
  export type UnEnumerate<T extends unknown> = T extends Array<infer U> ? U : T

  /**
   * From ts-toolbelt
   */

  type __Either<O extends object, K extends Key> = Omit<O, K> &
    {
      // Merge all but K
      [P in K]: Prisma__Pick<O, P & keyof O> // With K possibilities
    }[K]

  type EitherStrict<O extends object, K extends Key> = Strict<__Either<O, K>>

  type EitherLoose<O extends object, K extends Key> = ComputeRaw<__Either<O, K>>

  type _Either<
    O extends object,
    K extends Key,
    strict extends Boolean
  > = {
    1: EitherStrict<O, K>
    0: EitherLoose<O, K>
  }[strict]

  type Either<
    O extends object,
    K extends Key,
    strict extends Boolean = 1
  > = O extends unknown ? _Either<O, K, strict> : never

  export type Union = any

  type PatchUndefined<O extends object, O1 extends object> = {
    [K in keyof O]: O[K] extends undefined ? At<O1, K> : O[K]
  } & {}

  /** Helper Types for "Merge" **/
  export type IntersectOf<U extends Union> = (
    U extends unknown ? (k: U) => void : never
  ) extends (k: infer I) => void
    ? I
    : never

  export type Overwrite<O extends object, O1 extends object> = {
      [K in keyof O]: K extends keyof O1 ? O1[K] : O[K];
  } & {};

  type _Merge<U extends object> = IntersectOf<Overwrite<U, {
      [K in keyof U]-?: At<U, K>;
  }>>;

  type Key = string | number | symbol;
  type AtBasic<O extends object, K extends Key> = K extends keyof O ? O[K] : never;
  type AtStrict<O extends object, K extends Key> = O[K & keyof O];
  type AtLoose<O extends object, K extends Key> = O extends unknown ? AtStrict<O, K> : never;
  export type At<O extends object, K extends Key, strict extends Boolean = 1> = {
      1: AtStrict<O, K>;
      0: AtLoose<O, K>;
  }[strict];

  export type ComputeRaw<A extends any> = A extends Function ? A : {
    [K in keyof A]: A[K];
  } & {};

  export type OptionalFlat<O> = {
    [K in keyof O]?: O[K];
  } & {};

  type _Record<K extends keyof any, T> = {
    [P in K]: T;
  };

  // cause typescript not to expand types and preserve names
  type NoExpand<T> = T extends unknown ? T : never;

  // this type assumes the passed object is entirely optional
  type AtLeast<O extends object, K extends string> = NoExpand<
    O extends unknown
    ? | (K extends keyof O ? { [P in K]: O[P] } & O : O)
      | {[P in keyof O as P extends K ? P : never]-?: O[P]} & O
    : never>;

  type _Strict<U, _U = U> = U extends unknown ? U & OptionalFlat<_Record<Exclude<Keys<_U>, keyof U>, never>> : never;

  export type Strict<U extends object> = ComputeRaw<_Strict<U>>;
  /** End Helper Types for "Merge" **/

  export type Merge<U extends object> = ComputeRaw<_Merge<Strict<U>>>;

  /**
  A [[Boolean]]
  */
  export type Boolean = True | False

  // /**
  // 1
  // */
  export type True = 1

  /**
  0
  */
  export type False = 0

  export type Not<B extends Boolean> = {
    0: 1
    1: 0
  }[B]

  export type Extends<A1 extends any, A2 extends any> = [A1] extends [never]
    ? 0 // anything `never` is false
    : A1 extends A2
    ? 1
    : 0

  export type Has<U extends Union, U1 extends Union> = Not<
    Extends<Exclude<U1, U>, U1>
  >

  export type Or<B1 extends Boolean, B2 extends Boolean> = {
    0: {
      0: 0
      1: 1
    }
    1: {
      0: 1
      1: 1
    }
  }[B1][B2]

  export type Keys<U extends Union> = U extends unknown ? keyof U : never

  type Cast<A, B> = A extends B ? A : B;

  export const type: unique symbol;



  /**
   * Used by group by
   */

  export type GetScalarType<T, O> = O extends object ? {
    [P in keyof T]: P extends keyof O
      ? O[P]
      : never
  } : never

  type FieldPaths<
    T,
    U = Omit<T, '_avg' | '_sum' | '_count' | '_min' | '_max'>
  > = IsObject<T> extends True ? U : T

  type GetHavingFields<T> = {
    [K in keyof T]: Or<
      Or<Extends<'OR', K>, Extends<'AND', K>>,
      Extends<'NOT', K>
    > extends True
      ? // infer is only needed to not hit TS limit
        // based on the brilliant idea of Pierre-Antoine Mills
        // https://github.com/microsoft/TypeScript/issues/30188#issuecomment-478938437
        T[K] extends infer TK
        ? GetHavingFields<UnEnumerate<TK> extends object ? Merge<UnEnumerate<TK>> : never>
        : never
      : {} extends FieldPaths<T[K]>
      ? never
      : K
  }[keyof T]

  /**
   * Convert tuple to union
   */
  type _TupleToUnion<T> = T extends (infer E)[] ? E : never
  type TupleToUnion<K extends readonly any[]> = _TupleToUnion<K>
  type MaybeTupleToUnion<T> = T extends any[] ? TupleToUnion<T> : T

  /**
   * Like `Pick`, but additionally can also accept an array of keys
   */
  type PickEnumerable<T, K extends Enumerable<keyof T> | keyof T> = Prisma__Pick<T, MaybeTupleToUnion<K>>

  /**
   * Exclude all keys with underscores
   */
  type ExcludeUnderscoreKeys<T extends string> = T extends `_${string}` ? never : T


  export type FieldRef<Model, FieldType> = runtime.FieldRef<Model, FieldType>

  type FieldRefInputType<Model, FieldType> = Model extends never ? never : FieldRef<Model, FieldType>


  export const ModelName: {
    Realm: 'Realm',
    RealmKey: 'RealmKey',
    User: 'User',
    UserSession: 'UserSession',
    Role: 'Role',
    UserRole: 'UserRole',
    Client: 'Client',
    Scope: 'Scope',
    ClientScope: 'ClientScope',
    AuthorizationCode: 'AuthorizationCode',
    Token: 'Token'
  };

  export type ModelName = (typeof ModelName)[keyof typeof ModelName]


  export type Datasources = {
    db?: Datasource
  }

  interface TypeMapCb<ClientOptions = {}> extends $Utils.Fn<{extArgs: $Extensions.InternalArgs }, $Utils.Record<string, any>> {
    returns: Prisma.TypeMap<this['params']['extArgs'], ClientOptions extends { omit: infer OmitOptions } ? OmitOptions : {}>
  }

  export type TypeMap<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> = {
    globalOmitOptions: {
      omit: GlobalOmitOptions
    }
    meta: {
      modelProps: "realm" | "realmKey" | "user" | "userSession" | "role" | "userRole" | "client" | "scope" | "clientScope" | "authorizationCode" | "token"
      txIsolationLevel: Prisma.TransactionIsolationLevel
    }
    model: {
      Realm: {
        payload: Prisma.$RealmPayload<ExtArgs>
        fields: Prisma.RealmFieldRefs
        operations: {
          findUnique: {
            args: Prisma.RealmFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.RealmFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmPayload>
          }
          findFirst: {
            args: Prisma.RealmFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.RealmFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmPayload>
          }
          findMany: {
            args: Prisma.RealmFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmPayload>[]
          }
          create: {
            args: Prisma.RealmCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmPayload>
          }
          createMany: {
            args: Prisma.RealmCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.RealmCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmPayload>[]
          }
          delete: {
            args: Prisma.RealmDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmPayload>
          }
          update: {
            args: Prisma.RealmUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmPayload>
          }
          deleteMany: {
            args: Prisma.RealmDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.RealmUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.RealmUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmPayload>[]
          }
          upsert: {
            args: Prisma.RealmUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmPayload>
          }
          aggregate: {
            args: Prisma.RealmAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateRealm>
          }
          groupBy: {
            args: Prisma.RealmGroupByArgs<ExtArgs>
            result: $Utils.Optional<RealmGroupByOutputType>[]
          }
          count: {
            args: Prisma.RealmCountArgs<ExtArgs>
            result: $Utils.Optional<RealmCountAggregateOutputType> | number
          }
        }
      }
      RealmKey: {
        payload: Prisma.$RealmKeyPayload<ExtArgs>
        fields: Prisma.RealmKeyFieldRefs
        operations: {
          findUnique: {
            args: Prisma.RealmKeyFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmKeyPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.RealmKeyFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmKeyPayload>
          }
          findFirst: {
            args: Prisma.RealmKeyFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmKeyPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.RealmKeyFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmKeyPayload>
          }
          findMany: {
            args: Prisma.RealmKeyFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmKeyPayload>[]
          }
          create: {
            args: Prisma.RealmKeyCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmKeyPayload>
          }
          createMany: {
            args: Prisma.RealmKeyCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.RealmKeyCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmKeyPayload>[]
          }
          delete: {
            args: Prisma.RealmKeyDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmKeyPayload>
          }
          update: {
            args: Prisma.RealmKeyUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmKeyPayload>
          }
          deleteMany: {
            args: Prisma.RealmKeyDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.RealmKeyUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.RealmKeyUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmKeyPayload>[]
          }
          upsert: {
            args: Prisma.RealmKeyUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RealmKeyPayload>
          }
          aggregate: {
            args: Prisma.RealmKeyAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateRealmKey>
          }
          groupBy: {
            args: Prisma.RealmKeyGroupByArgs<ExtArgs>
            result: $Utils.Optional<RealmKeyGroupByOutputType>[]
          }
          count: {
            args: Prisma.RealmKeyCountArgs<ExtArgs>
            result: $Utils.Optional<RealmKeyCountAggregateOutputType> | number
          }
        }
      }
      User: {
        payload: Prisma.$UserPayload<ExtArgs>
        fields: Prisma.UserFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          findFirst: {
            args: Prisma.UserFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          findMany: {
            args: Prisma.UserFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>[]
          }
          create: {
            args: Prisma.UserCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          createMany: {
            args: Prisma.UserCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.UserCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>[]
          }
          delete: {
            args: Prisma.UserDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          update: {
            args: Prisma.UserUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          deleteMany: {
            args: Prisma.UserDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.UserUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.UserUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>[]
          }
          upsert: {
            args: Prisma.UserUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          aggregate: {
            args: Prisma.UserAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUser>
          }
          groupBy: {
            args: Prisma.UserGroupByArgs<ExtArgs>
            result: $Utils.Optional<UserGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserCountArgs<ExtArgs>
            result: $Utils.Optional<UserCountAggregateOutputType> | number
          }
        }
      }
      UserSession: {
        payload: Prisma.$UserSessionPayload<ExtArgs>
        fields: Prisma.UserSessionFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserSessionFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserSessionPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserSessionFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserSessionPayload>
          }
          findFirst: {
            args: Prisma.UserSessionFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserSessionPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserSessionFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserSessionPayload>
          }
          findMany: {
            args: Prisma.UserSessionFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserSessionPayload>[]
          }
          create: {
            args: Prisma.UserSessionCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserSessionPayload>
          }
          createMany: {
            args: Prisma.UserSessionCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.UserSessionCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserSessionPayload>[]
          }
          delete: {
            args: Prisma.UserSessionDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserSessionPayload>
          }
          update: {
            args: Prisma.UserSessionUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserSessionPayload>
          }
          deleteMany: {
            args: Prisma.UserSessionDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.UserSessionUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.UserSessionUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserSessionPayload>[]
          }
          upsert: {
            args: Prisma.UserSessionUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserSessionPayload>
          }
          aggregate: {
            args: Prisma.UserSessionAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUserSession>
          }
          groupBy: {
            args: Prisma.UserSessionGroupByArgs<ExtArgs>
            result: $Utils.Optional<UserSessionGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserSessionCountArgs<ExtArgs>
            result: $Utils.Optional<UserSessionCountAggregateOutputType> | number
          }
        }
      }
      Role: {
        payload: Prisma.$RolePayload<ExtArgs>
        fields: Prisma.RoleFieldRefs
        operations: {
          findUnique: {
            args: Prisma.RoleFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RolePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.RoleFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RolePayload>
          }
          findFirst: {
            args: Prisma.RoleFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RolePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.RoleFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RolePayload>
          }
          findMany: {
            args: Prisma.RoleFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RolePayload>[]
          }
          create: {
            args: Prisma.RoleCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RolePayload>
          }
          createMany: {
            args: Prisma.RoleCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.RoleCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RolePayload>[]
          }
          delete: {
            args: Prisma.RoleDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RolePayload>
          }
          update: {
            args: Prisma.RoleUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RolePayload>
          }
          deleteMany: {
            args: Prisma.RoleDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.RoleUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.RoleUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RolePayload>[]
          }
          upsert: {
            args: Prisma.RoleUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RolePayload>
          }
          aggregate: {
            args: Prisma.RoleAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateRole>
          }
          groupBy: {
            args: Prisma.RoleGroupByArgs<ExtArgs>
            result: $Utils.Optional<RoleGroupByOutputType>[]
          }
          count: {
            args: Prisma.RoleCountArgs<ExtArgs>
            result: $Utils.Optional<RoleCountAggregateOutputType> | number
          }
        }
      }
      UserRole: {
        payload: Prisma.$UserRolePayload<ExtArgs>
        fields: Prisma.UserRoleFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserRoleFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserRolePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserRoleFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserRolePayload>
          }
          findFirst: {
            args: Prisma.UserRoleFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserRolePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserRoleFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserRolePayload>
          }
          findMany: {
            args: Prisma.UserRoleFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserRolePayload>[]
          }
          create: {
            args: Prisma.UserRoleCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserRolePayload>
          }
          createMany: {
            args: Prisma.UserRoleCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.UserRoleCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserRolePayload>[]
          }
          delete: {
            args: Prisma.UserRoleDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserRolePayload>
          }
          update: {
            args: Prisma.UserRoleUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserRolePayload>
          }
          deleteMany: {
            args: Prisma.UserRoleDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.UserRoleUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.UserRoleUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserRolePayload>[]
          }
          upsert: {
            args: Prisma.UserRoleUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserRolePayload>
          }
          aggregate: {
            args: Prisma.UserRoleAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUserRole>
          }
          groupBy: {
            args: Prisma.UserRoleGroupByArgs<ExtArgs>
            result: $Utils.Optional<UserRoleGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserRoleCountArgs<ExtArgs>
            result: $Utils.Optional<UserRoleCountAggregateOutputType> | number
          }
        }
      }
      Client: {
        payload: Prisma.$ClientPayload<ExtArgs>
        fields: Prisma.ClientFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ClientFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ClientFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientPayload>
          }
          findFirst: {
            args: Prisma.ClientFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ClientFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientPayload>
          }
          findMany: {
            args: Prisma.ClientFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientPayload>[]
          }
          create: {
            args: Prisma.ClientCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientPayload>
          }
          createMany: {
            args: Prisma.ClientCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ClientCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientPayload>[]
          }
          delete: {
            args: Prisma.ClientDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientPayload>
          }
          update: {
            args: Prisma.ClientUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientPayload>
          }
          deleteMany: {
            args: Prisma.ClientDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ClientUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.ClientUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientPayload>[]
          }
          upsert: {
            args: Prisma.ClientUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientPayload>
          }
          aggregate: {
            args: Prisma.ClientAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateClient>
          }
          groupBy: {
            args: Prisma.ClientGroupByArgs<ExtArgs>
            result: $Utils.Optional<ClientGroupByOutputType>[]
          }
          count: {
            args: Prisma.ClientCountArgs<ExtArgs>
            result: $Utils.Optional<ClientCountAggregateOutputType> | number
          }
        }
      }
      Scope: {
        payload: Prisma.$ScopePayload<ExtArgs>
        fields: Prisma.ScopeFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ScopeFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ScopePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ScopeFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ScopePayload>
          }
          findFirst: {
            args: Prisma.ScopeFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ScopePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ScopeFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ScopePayload>
          }
          findMany: {
            args: Prisma.ScopeFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ScopePayload>[]
          }
          create: {
            args: Prisma.ScopeCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ScopePayload>
          }
          createMany: {
            args: Prisma.ScopeCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ScopeCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ScopePayload>[]
          }
          delete: {
            args: Prisma.ScopeDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ScopePayload>
          }
          update: {
            args: Prisma.ScopeUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ScopePayload>
          }
          deleteMany: {
            args: Prisma.ScopeDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ScopeUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.ScopeUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ScopePayload>[]
          }
          upsert: {
            args: Prisma.ScopeUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ScopePayload>
          }
          aggregate: {
            args: Prisma.ScopeAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateScope>
          }
          groupBy: {
            args: Prisma.ScopeGroupByArgs<ExtArgs>
            result: $Utils.Optional<ScopeGroupByOutputType>[]
          }
          count: {
            args: Prisma.ScopeCountArgs<ExtArgs>
            result: $Utils.Optional<ScopeCountAggregateOutputType> | number
          }
        }
      }
      ClientScope: {
        payload: Prisma.$ClientScopePayload<ExtArgs>
        fields: Prisma.ClientScopeFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ClientScopeFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientScopePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ClientScopeFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientScopePayload>
          }
          findFirst: {
            args: Prisma.ClientScopeFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientScopePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ClientScopeFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientScopePayload>
          }
          findMany: {
            args: Prisma.ClientScopeFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientScopePayload>[]
          }
          create: {
            args: Prisma.ClientScopeCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientScopePayload>
          }
          createMany: {
            args: Prisma.ClientScopeCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ClientScopeCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientScopePayload>[]
          }
          delete: {
            args: Prisma.ClientScopeDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientScopePayload>
          }
          update: {
            args: Prisma.ClientScopeUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientScopePayload>
          }
          deleteMany: {
            args: Prisma.ClientScopeDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ClientScopeUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.ClientScopeUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientScopePayload>[]
          }
          upsert: {
            args: Prisma.ClientScopeUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ClientScopePayload>
          }
          aggregate: {
            args: Prisma.ClientScopeAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateClientScope>
          }
          groupBy: {
            args: Prisma.ClientScopeGroupByArgs<ExtArgs>
            result: $Utils.Optional<ClientScopeGroupByOutputType>[]
          }
          count: {
            args: Prisma.ClientScopeCountArgs<ExtArgs>
            result: $Utils.Optional<ClientScopeCountAggregateOutputType> | number
          }
        }
      }
      AuthorizationCode: {
        payload: Prisma.$AuthorizationCodePayload<ExtArgs>
        fields: Prisma.AuthorizationCodeFieldRefs
        operations: {
          findUnique: {
            args: Prisma.AuthorizationCodeFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuthorizationCodePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.AuthorizationCodeFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuthorizationCodePayload>
          }
          findFirst: {
            args: Prisma.AuthorizationCodeFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuthorizationCodePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.AuthorizationCodeFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuthorizationCodePayload>
          }
          findMany: {
            args: Prisma.AuthorizationCodeFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuthorizationCodePayload>[]
          }
          create: {
            args: Prisma.AuthorizationCodeCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuthorizationCodePayload>
          }
          createMany: {
            args: Prisma.AuthorizationCodeCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.AuthorizationCodeCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuthorizationCodePayload>[]
          }
          delete: {
            args: Prisma.AuthorizationCodeDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuthorizationCodePayload>
          }
          update: {
            args: Prisma.AuthorizationCodeUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuthorizationCodePayload>
          }
          deleteMany: {
            args: Prisma.AuthorizationCodeDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.AuthorizationCodeUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.AuthorizationCodeUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuthorizationCodePayload>[]
          }
          upsert: {
            args: Prisma.AuthorizationCodeUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuthorizationCodePayload>
          }
          aggregate: {
            args: Prisma.AuthorizationCodeAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAuthorizationCode>
          }
          groupBy: {
            args: Prisma.AuthorizationCodeGroupByArgs<ExtArgs>
            result: $Utils.Optional<AuthorizationCodeGroupByOutputType>[]
          }
          count: {
            args: Prisma.AuthorizationCodeCountArgs<ExtArgs>
            result: $Utils.Optional<AuthorizationCodeCountAggregateOutputType> | number
          }
        }
      }
      Token: {
        payload: Prisma.$TokenPayload<ExtArgs>
        fields: Prisma.TokenFieldRefs
        operations: {
          findUnique: {
            args: Prisma.TokenFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TokenPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.TokenFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TokenPayload>
          }
          findFirst: {
            args: Prisma.TokenFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TokenPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.TokenFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TokenPayload>
          }
          findMany: {
            args: Prisma.TokenFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TokenPayload>[]
          }
          create: {
            args: Prisma.TokenCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TokenPayload>
          }
          createMany: {
            args: Prisma.TokenCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.TokenCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TokenPayload>[]
          }
          delete: {
            args: Prisma.TokenDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TokenPayload>
          }
          update: {
            args: Prisma.TokenUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TokenPayload>
          }
          deleteMany: {
            args: Prisma.TokenDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.TokenUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.TokenUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TokenPayload>[]
          }
          upsert: {
            args: Prisma.TokenUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TokenPayload>
          }
          aggregate: {
            args: Prisma.TokenAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateToken>
          }
          groupBy: {
            args: Prisma.TokenGroupByArgs<ExtArgs>
            result: $Utils.Optional<TokenGroupByOutputType>[]
          }
          count: {
            args: Prisma.TokenCountArgs<ExtArgs>
            result: $Utils.Optional<TokenCountAggregateOutputType> | number
          }
        }
      }
    }
  } & {
    other: {
      payload: any
      operations: {
        $executeRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $executeRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
        $queryRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $queryRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
      }
    }
  }
  export const defineExtension: $Extensions.ExtendsHook<"define", Prisma.TypeMapCb, $Extensions.DefaultArgs>
  export type DefaultPrismaClient = PrismaClient
  export type ErrorFormat = 'pretty' | 'colorless' | 'minimal'
  export interface PrismaClientOptions {
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasources?: Datasources
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasourceUrl?: string
    /**
     * @default "colorless"
     */
    errorFormat?: ErrorFormat
    /**
     * @example
     * ```
     * // Defaults to stdout
     * log: ['query', 'info', 'warn', 'error']
     * 
     * // Emit as events
     * log: [
     *   { emit: 'stdout', level: 'query' },
     *   { emit: 'stdout', level: 'info' },
     *   { emit: 'stdout', level: 'warn' }
     *   { emit: 'stdout', level: 'error' }
     * ]
     * ```
     * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/logging#the-log-option).
     */
    log?: (LogLevel | LogDefinition)[]
    /**
     * The default values for transactionOptions
     * maxWait ?= 2000
     * timeout ?= 5000
     */
    transactionOptions?: {
      maxWait?: number
      timeout?: number
      isolationLevel?: Prisma.TransactionIsolationLevel
    }
    /**
     * Global configuration for omitting model fields by default.
     * 
     * @example
     * ```
     * const prisma = new PrismaClient({
     *   omit: {
     *     user: {
     *       password: true
     *     }
     *   }
     * })
     * ```
     */
    omit?: Prisma.GlobalOmitConfig
  }
  export type GlobalOmitConfig = {
    realm?: RealmOmit
    realmKey?: RealmKeyOmit
    user?: UserOmit
    userSession?: UserSessionOmit
    role?: RoleOmit
    userRole?: UserRoleOmit
    client?: ClientOmit
    scope?: ScopeOmit
    clientScope?: ClientScopeOmit
    authorizationCode?: AuthorizationCodeOmit
    token?: TokenOmit
  }

  /* Types for Logging */
  export type LogLevel = 'info' | 'query' | 'warn' | 'error'
  export type LogDefinition = {
    level: LogLevel
    emit: 'stdout' | 'event'
  }

  export type GetLogType<T extends LogLevel | LogDefinition> = T extends LogDefinition ? T['emit'] extends 'event' ? T['level'] : never : never
  export type GetEvents<T extends any> = T extends Array<LogLevel | LogDefinition> ?
    GetLogType<T[0]> | GetLogType<T[1]> | GetLogType<T[2]> | GetLogType<T[3]>
    : never

  export type QueryEvent = {
    timestamp: Date
    query: string
    params: string
    duration: number
    target: string
  }

  export type LogEvent = {
    timestamp: Date
    message: string
    target: string
  }
  /* End Types for Logging */


  export type PrismaAction =
    | 'findUnique'
    | 'findUniqueOrThrow'
    | 'findMany'
    | 'findFirst'
    | 'findFirstOrThrow'
    | 'create'
    | 'createMany'
    | 'createManyAndReturn'
    | 'update'
    | 'updateMany'
    | 'updateManyAndReturn'
    | 'upsert'
    | 'delete'
    | 'deleteMany'
    | 'executeRaw'
    | 'queryRaw'
    | 'aggregate'
    | 'count'
    | 'runCommandRaw'
    | 'findRaw'
    | 'groupBy'

  /**
   * These options are being passed into the middleware as "params"
   */
  export type MiddlewareParams = {
    model?: ModelName
    action: PrismaAction
    args: any
    dataPath: string[]
    runInTransaction: boolean
  }

  /**
   * The `T` type makes sure, that the `return proceed` is not forgotten in the middleware implementation
   */
  export type Middleware<T = any> = (
    params: MiddlewareParams,
    next: (params: MiddlewareParams) => $Utils.JsPromise<T>,
  ) => $Utils.JsPromise<T>

  // tested in getLogLevel.test.ts
  export function getLogLevel(log: Array<LogLevel | LogDefinition>): LogLevel | undefined;

  /**
   * `PrismaClient` proxy available in interactive transactions.
   */
  export type TransactionClient = Omit<Prisma.DefaultPrismaClient, runtime.ITXClientDenyList>

  export type Datasource = {
    url?: string
  }

  /**
   * Count Types
   */


  /**
   * Count Type RealmCountOutputType
   */

  export type RealmCountOutputType = {
    keys: number
    users: number
    roles: number
    clients: number
    scopes: number
  }

  export type RealmCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    keys?: boolean | RealmCountOutputTypeCountKeysArgs
    users?: boolean | RealmCountOutputTypeCountUsersArgs
    roles?: boolean | RealmCountOutputTypeCountRolesArgs
    clients?: boolean | RealmCountOutputTypeCountClientsArgs
    scopes?: boolean | RealmCountOutputTypeCountScopesArgs
  }

  // Custom InputTypes
  /**
   * RealmCountOutputType without action
   */
  export type RealmCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RealmCountOutputType
     */
    select?: RealmCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * RealmCountOutputType without action
   */
  export type RealmCountOutputTypeCountKeysArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RealmKeyWhereInput
  }

  /**
   * RealmCountOutputType without action
   */
  export type RealmCountOutputTypeCountUsersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserWhereInput
  }

  /**
   * RealmCountOutputType without action
   */
  export type RealmCountOutputTypeCountRolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RoleWhereInput
  }

  /**
   * RealmCountOutputType without action
   */
  export type RealmCountOutputTypeCountClientsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ClientWhereInput
  }

  /**
   * RealmCountOutputType without action
   */
  export type RealmCountOutputTypeCountScopesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ScopeWhereInput
  }


  /**
   * Count Type UserCountOutputType
   */

  export type UserCountOutputType = {
    roles: number
    sessions: number
    tokens: number
    authorizationCodes: number
  }

  export type UserCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    roles?: boolean | UserCountOutputTypeCountRolesArgs
    sessions?: boolean | UserCountOutputTypeCountSessionsArgs
    tokens?: boolean | UserCountOutputTypeCountTokensArgs
    authorizationCodes?: boolean | UserCountOutputTypeCountAuthorizationCodesArgs
  }

  // Custom InputTypes
  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserCountOutputType
     */
    select?: UserCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountRolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserRoleWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountSessionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserSessionWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountTokensArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TokenWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountAuthorizationCodesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AuthorizationCodeWhereInput
  }


  /**
   * Count Type RoleCountOutputType
   */

  export type RoleCountOutputType = {
    userLinks: number
  }

  export type RoleCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    userLinks?: boolean | RoleCountOutputTypeCountUserLinksArgs
  }

  // Custom InputTypes
  /**
   * RoleCountOutputType without action
   */
  export type RoleCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RoleCountOutputType
     */
    select?: RoleCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * RoleCountOutputType without action
   */
  export type RoleCountOutputTypeCountUserLinksArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserRoleWhereInput
  }


  /**
   * Count Type ClientCountOutputType
   */

  export type ClientCountOutputType = {
    roles: number
    scopes: number
    userSessions: number
    tokens: number
    authorizationCodes: number
  }

  export type ClientCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    roles?: boolean | ClientCountOutputTypeCountRolesArgs
    scopes?: boolean | ClientCountOutputTypeCountScopesArgs
    userSessions?: boolean | ClientCountOutputTypeCountUserSessionsArgs
    tokens?: boolean | ClientCountOutputTypeCountTokensArgs
    authorizationCodes?: boolean | ClientCountOutputTypeCountAuthorizationCodesArgs
  }

  // Custom InputTypes
  /**
   * ClientCountOutputType without action
   */
  export type ClientCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ClientCountOutputType
     */
    select?: ClientCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * ClientCountOutputType without action
   */
  export type ClientCountOutputTypeCountRolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RoleWhereInput
  }

  /**
   * ClientCountOutputType without action
   */
  export type ClientCountOutputTypeCountScopesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ClientScopeWhereInput
  }

  /**
   * ClientCountOutputType without action
   */
  export type ClientCountOutputTypeCountUserSessionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserSessionWhereInput
  }

  /**
   * ClientCountOutputType without action
   */
  export type ClientCountOutputTypeCountTokensArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TokenWhereInput
  }

  /**
   * ClientCountOutputType without action
   */
  export type ClientCountOutputTypeCountAuthorizationCodesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AuthorizationCodeWhereInput
  }


  /**
   * Count Type ScopeCountOutputType
   */

  export type ScopeCountOutputType = {
    clients: number
  }

  export type ScopeCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    clients?: boolean | ScopeCountOutputTypeCountClientsArgs
  }

  // Custom InputTypes
  /**
   * ScopeCountOutputType without action
   */
  export type ScopeCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ScopeCountOutputType
     */
    select?: ScopeCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * ScopeCountOutputType without action
   */
  export type ScopeCountOutputTypeCountClientsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ClientScopeWhereInput
  }


  /**
   * Models
   */

  /**
   * Model Realm
   */

  export type AggregateRealm = {
    _count: RealmCountAggregateOutputType | null
    _min: RealmMinAggregateOutputType | null
    _max: RealmMaxAggregateOutputType | null
  }

  export type RealmMinAggregateOutputType = {
    id: string | null
    name: string | null
    description: string | null
    created_at: Date | null
  }

  export type RealmMaxAggregateOutputType = {
    id: string | null
    name: string | null
    description: string | null
    created_at: Date | null
  }

  export type RealmCountAggregateOutputType = {
    id: number
    name: number
    description: number
    created_at: number
    _all: number
  }


  export type RealmMinAggregateInputType = {
    id?: true
    name?: true
    description?: true
    created_at?: true
  }

  export type RealmMaxAggregateInputType = {
    id?: true
    name?: true
    description?: true
    created_at?: true
  }

  export type RealmCountAggregateInputType = {
    id?: true
    name?: true
    description?: true
    created_at?: true
    _all?: true
  }

  export type RealmAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Realm to aggregate.
     */
    where?: RealmWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Realms to fetch.
     */
    orderBy?: RealmOrderByWithRelationInput | RealmOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: RealmWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Realms from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Realms.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Realms
    **/
    _count?: true | RealmCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: RealmMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: RealmMaxAggregateInputType
  }

  export type GetRealmAggregateType<T extends RealmAggregateArgs> = {
        [P in keyof T & keyof AggregateRealm]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateRealm[P]>
      : GetScalarType<T[P], AggregateRealm[P]>
  }




  export type RealmGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RealmWhereInput
    orderBy?: RealmOrderByWithAggregationInput | RealmOrderByWithAggregationInput[]
    by: RealmScalarFieldEnum[] | RealmScalarFieldEnum
    having?: RealmScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: RealmCountAggregateInputType | true
    _min?: RealmMinAggregateInputType
    _max?: RealmMaxAggregateInputType
  }

  export type RealmGroupByOutputType = {
    id: string
    name: string
    description: string | null
    created_at: Date
    _count: RealmCountAggregateOutputType | null
    _min: RealmMinAggregateOutputType | null
    _max: RealmMaxAggregateOutputType | null
  }

  type GetRealmGroupByPayload<T extends RealmGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<RealmGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof RealmGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], RealmGroupByOutputType[P]>
            : GetScalarType<T[P], RealmGroupByOutputType[P]>
        }
      >
    >


  export type RealmSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    description?: boolean
    created_at?: boolean
    keys?: boolean | Realm$keysArgs<ExtArgs>
    users?: boolean | Realm$usersArgs<ExtArgs>
    roles?: boolean | Realm$rolesArgs<ExtArgs>
    clients?: boolean | Realm$clientsArgs<ExtArgs>
    scopes?: boolean | Realm$scopesArgs<ExtArgs>
    _count?: boolean | RealmCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["realm"]>

  export type RealmSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    description?: boolean
    created_at?: boolean
  }, ExtArgs["result"]["realm"]>

  export type RealmSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    description?: boolean
    created_at?: boolean
  }, ExtArgs["result"]["realm"]>

  export type RealmSelectScalar = {
    id?: boolean
    name?: boolean
    description?: boolean
    created_at?: boolean
  }

  export type RealmOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "name" | "description" | "created_at", ExtArgs["result"]["realm"]>
  export type RealmInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    keys?: boolean | Realm$keysArgs<ExtArgs>
    users?: boolean | Realm$usersArgs<ExtArgs>
    roles?: boolean | Realm$rolesArgs<ExtArgs>
    clients?: boolean | Realm$clientsArgs<ExtArgs>
    scopes?: boolean | Realm$scopesArgs<ExtArgs>
    _count?: boolean | RealmCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type RealmIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}
  export type RealmIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}

  export type $RealmPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Realm"
    objects: {
      keys: Prisma.$RealmKeyPayload<ExtArgs>[]
      users: Prisma.$UserPayload<ExtArgs>[]
      roles: Prisma.$RolePayload<ExtArgs>[]
      clients: Prisma.$ClientPayload<ExtArgs>[]
      scopes: Prisma.$ScopePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      name: string
      description: string | null
      created_at: Date
    }, ExtArgs["result"]["realm"]>
    composites: {}
  }

  type RealmGetPayload<S extends boolean | null | undefined | RealmDefaultArgs> = $Result.GetResult<Prisma.$RealmPayload, S>

  type RealmCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<RealmFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: RealmCountAggregateInputType | true
    }

  export interface RealmDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Realm'], meta: { name: 'Realm' } }
    /**
     * Find zero or one Realm that matches the filter.
     * @param {RealmFindUniqueArgs} args - Arguments to find a Realm
     * @example
     * // Get one Realm
     * const realm = await prisma.realm.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends RealmFindUniqueArgs>(args: SelectSubset<T, RealmFindUniqueArgs<ExtArgs>>): Prisma__RealmClient<$Result.GetResult<Prisma.$RealmPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Realm that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {RealmFindUniqueOrThrowArgs} args - Arguments to find a Realm
     * @example
     * // Get one Realm
     * const realm = await prisma.realm.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends RealmFindUniqueOrThrowArgs>(args: SelectSubset<T, RealmFindUniqueOrThrowArgs<ExtArgs>>): Prisma__RealmClient<$Result.GetResult<Prisma.$RealmPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Realm that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RealmFindFirstArgs} args - Arguments to find a Realm
     * @example
     * // Get one Realm
     * const realm = await prisma.realm.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends RealmFindFirstArgs>(args?: SelectSubset<T, RealmFindFirstArgs<ExtArgs>>): Prisma__RealmClient<$Result.GetResult<Prisma.$RealmPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Realm that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RealmFindFirstOrThrowArgs} args - Arguments to find a Realm
     * @example
     * // Get one Realm
     * const realm = await prisma.realm.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends RealmFindFirstOrThrowArgs>(args?: SelectSubset<T, RealmFindFirstOrThrowArgs<ExtArgs>>): Prisma__RealmClient<$Result.GetResult<Prisma.$RealmPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Realms that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RealmFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Realms
     * const realms = await prisma.realm.findMany()
     * 
     * // Get first 10 Realms
     * const realms = await prisma.realm.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const realmWithIdOnly = await prisma.realm.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends RealmFindManyArgs>(args?: SelectSubset<T, RealmFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RealmPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Realm.
     * @param {RealmCreateArgs} args - Arguments to create a Realm.
     * @example
     * // Create one Realm
     * const Realm = await prisma.realm.create({
     *   data: {
     *     // ... data to create a Realm
     *   }
     * })
     * 
     */
    create<T extends RealmCreateArgs>(args: SelectSubset<T, RealmCreateArgs<ExtArgs>>): Prisma__RealmClient<$Result.GetResult<Prisma.$RealmPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Realms.
     * @param {RealmCreateManyArgs} args - Arguments to create many Realms.
     * @example
     * // Create many Realms
     * const realm = await prisma.realm.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends RealmCreateManyArgs>(args?: SelectSubset<T, RealmCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Realms and returns the data saved in the database.
     * @param {RealmCreateManyAndReturnArgs} args - Arguments to create many Realms.
     * @example
     * // Create many Realms
     * const realm = await prisma.realm.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Realms and only return the `id`
     * const realmWithIdOnly = await prisma.realm.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends RealmCreateManyAndReturnArgs>(args?: SelectSubset<T, RealmCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RealmPayload<ExtArgs>, T, "createManyAndReturn", GlobalOmitOptions>>

    /**
     * Delete a Realm.
     * @param {RealmDeleteArgs} args - Arguments to delete one Realm.
     * @example
     * // Delete one Realm
     * const Realm = await prisma.realm.delete({
     *   where: {
     *     // ... filter to delete one Realm
     *   }
     * })
     * 
     */
    delete<T extends RealmDeleteArgs>(args: SelectSubset<T, RealmDeleteArgs<ExtArgs>>): Prisma__RealmClient<$Result.GetResult<Prisma.$RealmPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Realm.
     * @param {RealmUpdateArgs} args - Arguments to update one Realm.
     * @example
     * // Update one Realm
     * const realm = await prisma.realm.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends RealmUpdateArgs>(args: SelectSubset<T, RealmUpdateArgs<ExtArgs>>): Prisma__RealmClient<$Result.GetResult<Prisma.$RealmPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Realms.
     * @param {RealmDeleteManyArgs} args - Arguments to filter Realms to delete.
     * @example
     * // Delete a few Realms
     * const { count } = await prisma.realm.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends RealmDeleteManyArgs>(args?: SelectSubset<T, RealmDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Realms.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RealmUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Realms
     * const realm = await prisma.realm.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends RealmUpdateManyArgs>(args: SelectSubset<T, RealmUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Realms and returns the data updated in the database.
     * @param {RealmUpdateManyAndReturnArgs} args - Arguments to update many Realms.
     * @example
     * // Update many Realms
     * const realm = await prisma.realm.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Realms and only return the `id`
     * const realmWithIdOnly = await prisma.realm.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends RealmUpdateManyAndReturnArgs>(args: SelectSubset<T, RealmUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RealmPayload<ExtArgs>, T, "updateManyAndReturn", GlobalOmitOptions>>

    /**
     * Create or update one Realm.
     * @param {RealmUpsertArgs} args - Arguments to update or create a Realm.
     * @example
     * // Update or create a Realm
     * const realm = await prisma.realm.upsert({
     *   create: {
     *     // ... data to create a Realm
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Realm we want to update
     *   }
     * })
     */
    upsert<T extends RealmUpsertArgs>(args: SelectSubset<T, RealmUpsertArgs<ExtArgs>>): Prisma__RealmClient<$Result.GetResult<Prisma.$RealmPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Realms.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RealmCountArgs} args - Arguments to filter Realms to count.
     * @example
     * // Count the number of Realms
     * const count = await prisma.realm.count({
     *   where: {
     *     // ... the filter for the Realms we want to count
     *   }
     * })
    **/
    count<T extends RealmCountArgs>(
      args?: Subset<T, RealmCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], RealmCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Realm.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RealmAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends RealmAggregateArgs>(args: Subset<T, RealmAggregateArgs>): Prisma.PrismaPromise<GetRealmAggregateType<T>>

    /**
     * Group by Realm.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RealmGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends RealmGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: RealmGroupByArgs['orderBy'] }
        : { orderBy?: RealmGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, RealmGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetRealmGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Realm model
   */
  readonly fields: RealmFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Realm.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__RealmClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    keys<T extends Realm$keysArgs<ExtArgs> = {}>(args?: Subset<T, Realm$keysArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RealmKeyPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    users<T extends Realm$usersArgs<ExtArgs> = {}>(args?: Subset<T, Realm$usersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    roles<T extends Realm$rolesArgs<ExtArgs> = {}>(args?: Subset<T, Realm$rolesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    clients<T extends Realm$clientsArgs<ExtArgs> = {}>(args?: Subset<T, Realm$clientsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ClientPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    scopes<T extends Realm$scopesArgs<ExtArgs> = {}>(args?: Subset<T, Realm$scopesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ScopePayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Realm model
   */
  interface RealmFieldRefs {
    readonly id: FieldRef<"Realm", 'String'>
    readonly name: FieldRef<"Realm", 'String'>
    readonly description: FieldRef<"Realm", 'String'>
    readonly created_at: FieldRef<"Realm", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Realm findUnique
   */
  export type RealmFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Realm
     */
    select?: RealmSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Realm
     */
    omit?: RealmOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmInclude<ExtArgs> | null
    /**
     * Filter, which Realm to fetch.
     */
    where: RealmWhereUniqueInput
  }

  /**
   * Realm findUniqueOrThrow
   */
  export type RealmFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Realm
     */
    select?: RealmSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Realm
     */
    omit?: RealmOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmInclude<ExtArgs> | null
    /**
     * Filter, which Realm to fetch.
     */
    where: RealmWhereUniqueInput
  }

  /**
   * Realm findFirst
   */
  export type RealmFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Realm
     */
    select?: RealmSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Realm
     */
    omit?: RealmOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmInclude<ExtArgs> | null
    /**
     * Filter, which Realm to fetch.
     */
    where?: RealmWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Realms to fetch.
     */
    orderBy?: RealmOrderByWithRelationInput | RealmOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Realms.
     */
    cursor?: RealmWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Realms from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Realms.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Realms.
     */
    distinct?: RealmScalarFieldEnum | RealmScalarFieldEnum[]
  }

  /**
   * Realm findFirstOrThrow
   */
  export type RealmFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Realm
     */
    select?: RealmSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Realm
     */
    omit?: RealmOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmInclude<ExtArgs> | null
    /**
     * Filter, which Realm to fetch.
     */
    where?: RealmWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Realms to fetch.
     */
    orderBy?: RealmOrderByWithRelationInput | RealmOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Realms.
     */
    cursor?: RealmWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Realms from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Realms.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Realms.
     */
    distinct?: RealmScalarFieldEnum | RealmScalarFieldEnum[]
  }

  /**
   * Realm findMany
   */
  export type RealmFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Realm
     */
    select?: RealmSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Realm
     */
    omit?: RealmOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmInclude<ExtArgs> | null
    /**
     * Filter, which Realms to fetch.
     */
    where?: RealmWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Realms to fetch.
     */
    orderBy?: RealmOrderByWithRelationInput | RealmOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Realms.
     */
    cursor?: RealmWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Realms from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Realms.
     */
    skip?: number
    distinct?: RealmScalarFieldEnum | RealmScalarFieldEnum[]
  }

  /**
   * Realm create
   */
  export type RealmCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Realm
     */
    select?: RealmSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Realm
     */
    omit?: RealmOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmInclude<ExtArgs> | null
    /**
     * The data needed to create a Realm.
     */
    data: XOR<RealmCreateInput, RealmUncheckedCreateInput>
  }

  /**
   * Realm createMany
   */
  export type RealmCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Realms.
     */
    data: RealmCreateManyInput | RealmCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Realm createManyAndReturn
   */
  export type RealmCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Realm
     */
    select?: RealmSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Realm
     */
    omit?: RealmOmit<ExtArgs> | null
    /**
     * The data used to create many Realms.
     */
    data: RealmCreateManyInput | RealmCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Realm update
   */
  export type RealmUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Realm
     */
    select?: RealmSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Realm
     */
    omit?: RealmOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmInclude<ExtArgs> | null
    /**
     * The data needed to update a Realm.
     */
    data: XOR<RealmUpdateInput, RealmUncheckedUpdateInput>
    /**
     * Choose, which Realm to update.
     */
    where: RealmWhereUniqueInput
  }

  /**
   * Realm updateMany
   */
  export type RealmUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Realms.
     */
    data: XOR<RealmUpdateManyMutationInput, RealmUncheckedUpdateManyInput>
    /**
     * Filter which Realms to update
     */
    where?: RealmWhereInput
    /**
     * Limit how many Realms to update.
     */
    limit?: number
  }

  /**
   * Realm updateManyAndReturn
   */
  export type RealmUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Realm
     */
    select?: RealmSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Realm
     */
    omit?: RealmOmit<ExtArgs> | null
    /**
     * The data used to update Realms.
     */
    data: XOR<RealmUpdateManyMutationInput, RealmUncheckedUpdateManyInput>
    /**
     * Filter which Realms to update
     */
    where?: RealmWhereInput
    /**
     * Limit how many Realms to update.
     */
    limit?: number
  }

  /**
   * Realm upsert
   */
  export type RealmUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Realm
     */
    select?: RealmSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Realm
     */
    omit?: RealmOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmInclude<ExtArgs> | null
    /**
     * The filter to search for the Realm to update in case it exists.
     */
    where: RealmWhereUniqueInput
    /**
     * In case the Realm found by the `where` argument doesn't exist, create a new Realm with this data.
     */
    create: XOR<RealmCreateInput, RealmUncheckedCreateInput>
    /**
     * In case the Realm was found with the provided `where` argument, update it with this data.
     */
    update: XOR<RealmUpdateInput, RealmUncheckedUpdateInput>
  }

  /**
   * Realm delete
   */
  export type RealmDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Realm
     */
    select?: RealmSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Realm
     */
    omit?: RealmOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmInclude<ExtArgs> | null
    /**
     * Filter which Realm to delete.
     */
    where: RealmWhereUniqueInput
  }

  /**
   * Realm deleteMany
   */
  export type RealmDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Realms to delete
     */
    where?: RealmWhereInput
    /**
     * Limit how many Realms to delete.
     */
    limit?: number
  }

  /**
   * Realm.keys
   */
  export type Realm$keysArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RealmKey
     */
    select?: RealmKeySelect<ExtArgs> | null
    /**
     * Omit specific fields from the RealmKey
     */
    omit?: RealmKeyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmKeyInclude<ExtArgs> | null
    where?: RealmKeyWhereInput
    orderBy?: RealmKeyOrderByWithRelationInput | RealmKeyOrderByWithRelationInput[]
    cursor?: RealmKeyWhereUniqueInput
    take?: number
    skip?: number
    distinct?: RealmKeyScalarFieldEnum | RealmKeyScalarFieldEnum[]
  }

  /**
   * Realm.users
   */
  export type Realm$usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    cursor?: UserWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * Realm.roles
   */
  export type Realm$rolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Role
     */
    omit?: RoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    where?: RoleWhereInput
    orderBy?: RoleOrderByWithRelationInput | RoleOrderByWithRelationInput[]
    cursor?: RoleWhereUniqueInput
    take?: number
    skip?: number
    distinct?: RoleScalarFieldEnum | RoleScalarFieldEnum[]
  }

  /**
   * Realm.clients
   */
  export type Realm$clientsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Client
     */
    select?: ClientSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Client
     */
    omit?: ClientOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientInclude<ExtArgs> | null
    where?: ClientWhereInput
    orderBy?: ClientOrderByWithRelationInput | ClientOrderByWithRelationInput[]
    cursor?: ClientWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ClientScalarFieldEnum | ClientScalarFieldEnum[]
  }

  /**
   * Realm.scopes
   */
  export type Realm$scopesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Scope
     */
    select?: ScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Scope
     */
    omit?: ScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ScopeInclude<ExtArgs> | null
    where?: ScopeWhereInput
    orderBy?: ScopeOrderByWithRelationInput | ScopeOrderByWithRelationInput[]
    cursor?: ScopeWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ScopeScalarFieldEnum | ScopeScalarFieldEnum[]
  }

  /**
   * Realm without action
   */
  export type RealmDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Realm
     */
    select?: RealmSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Realm
     */
    omit?: RealmOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmInclude<ExtArgs> | null
  }


  /**
   * Model RealmKey
   */

  export type AggregateRealmKey = {
    _count: RealmKeyCountAggregateOutputType | null
    _min: RealmKeyMinAggregateOutputType | null
    _max: RealmKeyMaxAggregateOutputType | null
  }

  export type RealmKeyMinAggregateOutputType = {
    id: string | null
    realm_id: string | null
    kid: string | null
    public_key: string | null
    private_key_enc: string | null
    alg: string | null
    created_at: Date | null
    expires_at: Date | null
  }

  export type RealmKeyMaxAggregateOutputType = {
    id: string | null
    realm_id: string | null
    kid: string | null
    public_key: string | null
    private_key_enc: string | null
    alg: string | null
    created_at: Date | null
    expires_at: Date | null
  }

  export type RealmKeyCountAggregateOutputType = {
    id: number
    realm_id: number
    kid: number
    public_key: number
    private_key_enc: number
    alg: number
    created_at: number
    expires_at: number
    _all: number
  }


  export type RealmKeyMinAggregateInputType = {
    id?: true
    realm_id?: true
    kid?: true
    public_key?: true
    private_key_enc?: true
    alg?: true
    created_at?: true
    expires_at?: true
  }

  export type RealmKeyMaxAggregateInputType = {
    id?: true
    realm_id?: true
    kid?: true
    public_key?: true
    private_key_enc?: true
    alg?: true
    created_at?: true
    expires_at?: true
  }

  export type RealmKeyCountAggregateInputType = {
    id?: true
    realm_id?: true
    kid?: true
    public_key?: true
    private_key_enc?: true
    alg?: true
    created_at?: true
    expires_at?: true
    _all?: true
  }

  export type RealmKeyAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which RealmKey to aggregate.
     */
    where?: RealmKeyWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RealmKeys to fetch.
     */
    orderBy?: RealmKeyOrderByWithRelationInput | RealmKeyOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: RealmKeyWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RealmKeys from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RealmKeys.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned RealmKeys
    **/
    _count?: true | RealmKeyCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: RealmKeyMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: RealmKeyMaxAggregateInputType
  }

  export type GetRealmKeyAggregateType<T extends RealmKeyAggregateArgs> = {
        [P in keyof T & keyof AggregateRealmKey]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateRealmKey[P]>
      : GetScalarType<T[P], AggregateRealmKey[P]>
  }




  export type RealmKeyGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RealmKeyWhereInput
    orderBy?: RealmKeyOrderByWithAggregationInput | RealmKeyOrderByWithAggregationInput[]
    by: RealmKeyScalarFieldEnum[] | RealmKeyScalarFieldEnum
    having?: RealmKeyScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: RealmKeyCountAggregateInputType | true
    _min?: RealmKeyMinAggregateInputType
    _max?: RealmKeyMaxAggregateInputType
  }

  export type RealmKeyGroupByOutputType = {
    id: string
    realm_id: string
    kid: string
    public_key: string
    private_key_enc: string
    alg: string
    created_at: Date
    expires_at: Date | null
    _count: RealmKeyCountAggregateOutputType | null
    _min: RealmKeyMinAggregateOutputType | null
    _max: RealmKeyMaxAggregateOutputType | null
  }

  type GetRealmKeyGroupByPayload<T extends RealmKeyGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<RealmKeyGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof RealmKeyGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], RealmKeyGroupByOutputType[P]>
            : GetScalarType<T[P], RealmKeyGroupByOutputType[P]>
        }
      >
    >


  export type RealmKeySelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    realm_id?: boolean
    kid?: boolean
    public_key?: boolean
    private_key_enc?: boolean
    alg?: boolean
    created_at?: boolean
    expires_at?: boolean
    realm?: boolean | RealmDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["realmKey"]>

  export type RealmKeySelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    realm_id?: boolean
    kid?: boolean
    public_key?: boolean
    private_key_enc?: boolean
    alg?: boolean
    created_at?: boolean
    expires_at?: boolean
    realm?: boolean | RealmDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["realmKey"]>

  export type RealmKeySelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    realm_id?: boolean
    kid?: boolean
    public_key?: boolean
    private_key_enc?: boolean
    alg?: boolean
    created_at?: boolean
    expires_at?: boolean
    realm?: boolean | RealmDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["realmKey"]>

  export type RealmKeySelectScalar = {
    id?: boolean
    realm_id?: boolean
    kid?: boolean
    public_key?: boolean
    private_key_enc?: boolean
    alg?: boolean
    created_at?: boolean
    expires_at?: boolean
  }

  export type RealmKeyOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "realm_id" | "kid" | "public_key" | "private_key_enc" | "alg" | "created_at" | "expires_at", ExtArgs["result"]["realmKey"]>
  export type RealmKeyInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    realm?: boolean | RealmDefaultArgs<ExtArgs>
  }
  export type RealmKeyIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    realm?: boolean | RealmDefaultArgs<ExtArgs>
  }
  export type RealmKeyIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    realm?: boolean | RealmDefaultArgs<ExtArgs>
  }

  export type $RealmKeyPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "RealmKey"
    objects: {
      realm: Prisma.$RealmPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      realm_id: string
      kid: string
      public_key: string
      private_key_enc: string
      alg: string
      created_at: Date
      expires_at: Date | null
    }, ExtArgs["result"]["realmKey"]>
    composites: {}
  }

  type RealmKeyGetPayload<S extends boolean | null | undefined | RealmKeyDefaultArgs> = $Result.GetResult<Prisma.$RealmKeyPayload, S>

  type RealmKeyCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<RealmKeyFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: RealmKeyCountAggregateInputType | true
    }

  export interface RealmKeyDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['RealmKey'], meta: { name: 'RealmKey' } }
    /**
     * Find zero or one RealmKey that matches the filter.
     * @param {RealmKeyFindUniqueArgs} args - Arguments to find a RealmKey
     * @example
     * // Get one RealmKey
     * const realmKey = await prisma.realmKey.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends RealmKeyFindUniqueArgs>(args: SelectSubset<T, RealmKeyFindUniqueArgs<ExtArgs>>): Prisma__RealmKeyClient<$Result.GetResult<Prisma.$RealmKeyPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one RealmKey that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {RealmKeyFindUniqueOrThrowArgs} args - Arguments to find a RealmKey
     * @example
     * // Get one RealmKey
     * const realmKey = await prisma.realmKey.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends RealmKeyFindUniqueOrThrowArgs>(args: SelectSubset<T, RealmKeyFindUniqueOrThrowArgs<ExtArgs>>): Prisma__RealmKeyClient<$Result.GetResult<Prisma.$RealmKeyPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first RealmKey that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RealmKeyFindFirstArgs} args - Arguments to find a RealmKey
     * @example
     * // Get one RealmKey
     * const realmKey = await prisma.realmKey.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends RealmKeyFindFirstArgs>(args?: SelectSubset<T, RealmKeyFindFirstArgs<ExtArgs>>): Prisma__RealmKeyClient<$Result.GetResult<Prisma.$RealmKeyPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first RealmKey that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RealmKeyFindFirstOrThrowArgs} args - Arguments to find a RealmKey
     * @example
     * // Get one RealmKey
     * const realmKey = await prisma.realmKey.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends RealmKeyFindFirstOrThrowArgs>(args?: SelectSubset<T, RealmKeyFindFirstOrThrowArgs<ExtArgs>>): Prisma__RealmKeyClient<$Result.GetResult<Prisma.$RealmKeyPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more RealmKeys that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RealmKeyFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all RealmKeys
     * const realmKeys = await prisma.realmKey.findMany()
     * 
     * // Get first 10 RealmKeys
     * const realmKeys = await prisma.realmKey.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const realmKeyWithIdOnly = await prisma.realmKey.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends RealmKeyFindManyArgs>(args?: SelectSubset<T, RealmKeyFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RealmKeyPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a RealmKey.
     * @param {RealmKeyCreateArgs} args - Arguments to create a RealmKey.
     * @example
     * // Create one RealmKey
     * const RealmKey = await prisma.realmKey.create({
     *   data: {
     *     // ... data to create a RealmKey
     *   }
     * })
     * 
     */
    create<T extends RealmKeyCreateArgs>(args: SelectSubset<T, RealmKeyCreateArgs<ExtArgs>>): Prisma__RealmKeyClient<$Result.GetResult<Prisma.$RealmKeyPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many RealmKeys.
     * @param {RealmKeyCreateManyArgs} args - Arguments to create many RealmKeys.
     * @example
     * // Create many RealmKeys
     * const realmKey = await prisma.realmKey.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends RealmKeyCreateManyArgs>(args?: SelectSubset<T, RealmKeyCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many RealmKeys and returns the data saved in the database.
     * @param {RealmKeyCreateManyAndReturnArgs} args - Arguments to create many RealmKeys.
     * @example
     * // Create many RealmKeys
     * const realmKey = await prisma.realmKey.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many RealmKeys and only return the `id`
     * const realmKeyWithIdOnly = await prisma.realmKey.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends RealmKeyCreateManyAndReturnArgs>(args?: SelectSubset<T, RealmKeyCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RealmKeyPayload<ExtArgs>, T, "createManyAndReturn", GlobalOmitOptions>>

    /**
     * Delete a RealmKey.
     * @param {RealmKeyDeleteArgs} args - Arguments to delete one RealmKey.
     * @example
     * // Delete one RealmKey
     * const RealmKey = await prisma.realmKey.delete({
     *   where: {
     *     // ... filter to delete one RealmKey
     *   }
     * })
     * 
     */
    delete<T extends RealmKeyDeleteArgs>(args: SelectSubset<T, RealmKeyDeleteArgs<ExtArgs>>): Prisma__RealmKeyClient<$Result.GetResult<Prisma.$RealmKeyPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one RealmKey.
     * @param {RealmKeyUpdateArgs} args - Arguments to update one RealmKey.
     * @example
     * // Update one RealmKey
     * const realmKey = await prisma.realmKey.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends RealmKeyUpdateArgs>(args: SelectSubset<T, RealmKeyUpdateArgs<ExtArgs>>): Prisma__RealmKeyClient<$Result.GetResult<Prisma.$RealmKeyPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more RealmKeys.
     * @param {RealmKeyDeleteManyArgs} args - Arguments to filter RealmKeys to delete.
     * @example
     * // Delete a few RealmKeys
     * const { count } = await prisma.realmKey.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends RealmKeyDeleteManyArgs>(args?: SelectSubset<T, RealmKeyDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more RealmKeys.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RealmKeyUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many RealmKeys
     * const realmKey = await prisma.realmKey.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends RealmKeyUpdateManyArgs>(args: SelectSubset<T, RealmKeyUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more RealmKeys and returns the data updated in the database.
     * @param {RealmKeyUpdateManyAndReturnArgs} args - Arguments to update many RealmKeys.
     * @example
     * // Update many RealmKeys
     * const realmKey = await prisma.realmKey.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more RealmKeys and only return the `id`
     * const realmKeyWithIdOnly = await prisma.realmKey.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends RealmKeyUpdateManyAndReturnArgs>(args: SelectSubset<T, RealmKeyUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RealmKeyPayload<ExtArgs>, T, "updateManyAndReturn", GlobalOmitOptions>>

    /**
     * Create or update one RealmKey.
     * @param {RealmKeyUpsertArgs} args - Arguments to update or create a RealmKey.
     * @example
     * // Update or create a RealmKey
     * const realmKey = await prisma.realmKey.upsert({
     *   create: {
     *     // ... data to create a RealmKey
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the RealmKey we want to update
     *   }
     * })
     */
    upsert<T extends RealmKeyUpsertArgs>(args: SelectSubset<T, RealmKeyUpsertArgs<ExtArgs>>): Prisma__RealmKeyClient<$Result.GetResult<Prisma.$RealmKeyPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of RealmKeys.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RealmKeyCountArgs} args - Arguments to filter RealmKeys to count.
     * @example
     * // Count the number of RealmKeys
     * const count = await prisma.realmKey.count({
     *   where: {
     *     // ... the filter for the RealmKeys we want to count
     *   }
     * })
    **/
    count<T extends RealmKeyCountArgs>(
      args?: Subset<T, RealmKeyCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], RealmKeyCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a RealmKey.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RealmKeyAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends RealmKeyAggregateArgs>(args: Subset<T, RealmKeyAggregateArgs>): Prisma.PrismaPromise<GetRealmKeyAggregateType<T>>

    /**
     * Group by RealmKey.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RealmKeyGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends RealmKeyGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: RealmKeyGroupByArgs['orderBy'] }
        : { orderBy?: RealmKeyGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, RealmKeyGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetRealmKeyGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the RealmKey model
   */
  readonly fields: RealmKeyFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for RealmKey.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__RealmKeyClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    realm<T extends RealmDefaultArgs<ExtArgs> = {}>(args?: Subset<T, RealmDefaultArgs<ExtArgs>>): Prisma__RealmClient<$Result.GetResult<Prisma.$RealmPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the RealmKey model
   */
  interface RealmKeyFieldRefs {
    readonly id: FieldRef<"RealmKey", 'String'>
    readonly realm_id: FieldRef<"RealmKey", 'String'>
    readonly kid: FieldRef<"RealmKey", 'String'>
    readonly public_key: FieldRef<"RealmKey", 'String'>
    readonly private_key_enc: FieldRef<"RealmKey", 'String'>
    readonly alg: FieldRef<"RealmKey", 'String'>
    readonly created_at: FieldRef<"RealmKey", 'DateTime'>
    readonly expires_at: FieldRef<"RealmKey", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * RealmKey findUnique
   */
  export type RealmKeyFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RealmKey
     */
    select?: RealmKeySelect<ExtArgs> | null
    /**
     * Omit specific fields from the RealmKey
     */
    omit?: RealmKeyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmKeyInclude<ExtArgs> | null
    /**
     * Filter, which RealmKey to fetch.
     */
    where: RealmKeyWhereUniqueInput
  }

  /**
   * RealmKey findUniqueOrThrow
   */
  export type RealmKeyFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RealmKey
     */
    select?: RealmKeySelect<ExtArgs> | null
    /**
     * Omit specific fields from the RealmKey
     */
    omit?: RealmKeyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmKeyInclude<ExtArgs> | null
    /**
     * Filter, which RealmKey to fetch.
     */
    where: RealmKeyWhereUniqueInput
  }

  /**
   * RealmKey findFirst
   */
  export type RealmKeyFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RealmKey
     */
    select?: RealmKeySelect<ExtArgs> | null
    /**
     * Omit specific fields from the RealmKey
     */
    omit?: RealmKeyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmKeyInclude<ExtArgs> | null
    /**
     * Filter, which RealmKey to fetch.
     */
    where?: RealmKeyWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RealmKeys to fetch.
     */
    orderBy?: RealmKeyOrderByWithRelationInput | RealmKeyOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for RealmKeys.
     */
    cursor?: RealmKeyWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RealmKeys from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RealmKeys.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of RealmKeys.
     */
    distinct?: RealmKeyScalarFieldEnum | RealmKeyScalarFieldEnum[]
  }

  /**
   * RealmKey findFirstOrThrow
   */
  export type RealmKeyFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RealmKey
     */
    select?: RealmKeySelect<ExtArgs> | null
    /**
     * Omit specific fields from the RealmKey
     */
    omit?: RealmKeyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmKeyInclude<ExtArgs> | null
    /**
     * Filter, which RealmKey to fetch.
     */
    where?: RealmKeyWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RealmKeys to fetch.
     */
    orderBy?: RealmKeyOrderByWithRelationInput | RealmKeyOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for RealmKeys.
     */
    cursor?: RealmKeyWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RealmKeys from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RealmKeys.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of RealmKeys.
     */
    distinct?: RealmKeyScalarFieldEnum | RealmKeyScalarFieldEnum[]
  }

  /**
   * RealmKey findMany
   */
  export type RealmKeyFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RealmKey
     */
    select?: RealmKeySelect<ExtArgs> | null
    /**
     * Omit specific fields from the RealmKey
     */
    omit?: RealmKeyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmKeyInclude<ExtArgs> | null
    /**
     * Filter, which RealmKeys to fetch.
     */
    where?: RealmKeyWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RealmKeys to fetch.
     */
    orderBy?: RealmKeyOrderByWithRelationInput | RealmKeyOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing RealmKeys.
     */
    cursor?: RealmKeyWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RealmKeys from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RealmKeys.
     */
    skip?: number
    distinct?: RealmKeyScalarFieldEnum | RealmKeyScalarFieldEnum[]
  }

  /**
   * RealmKey create
   */
  export type RealmKeyCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RealmKey
     */
    select?: RealmKeySelect<ExtArgs> | null
    /**
     * Omit specific fields from the RealmKey
     */
    omit?: RealmKeyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmKeyInclude<ExtArgs> | null
    /**
     * The data needed to create a RealmKey.
     */
    data: XOR<RealmKeyCreateInput, RealmKeyUncheckedCreateInput>
  }

  /**
   * RealmKey createMany
   */
  export type RealmKeyCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many RealmKeys.
     */
    data: RealmKeyCreateManyInput | RealmKeyCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * RealmKey createManyAndReturn
   */
  export type RealmKeyCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RealmKey
     */
    select?: RealmKeySelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the RealmKey
     */
    omit?: RealmKeyOmit<ExtArgs> | null
    /**
     * The data used to create many RealmKeys.
     */
    data: RealmKeyCreateManyInput | RealmKeyCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmKeyIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * RealmKey update
   */
  export type RealmKeyUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RealmKey
     */
    select?: RealmKeySelect<ExtArgs> | null
    /**
     * Omit specific fields from the RealmKey
     */
    omit?: RealmKeyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmKeyInclude<ExtArgs> | null
    /**
     * The data needed to update a RealmKey.
     */
    data: XOR<RealmKeyUpdateInput, RealmKeyUncheckedUpdateInput>
    /**
     * Choose, which RealmKey to update.
     */
    where: RealmKeyWhereUniqueInput
  }

  /**
   * RealmKey updateMany
   */
  export type RealmKeyUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update RealmKeys.
     */
    data: XOR<RealmKeyUpdateManyMutationInput, RealmKeyUncheckedUpdateManyInput>
    /**
     * Filter which RealmKeys to update
     */
    where?: RealmKeyWhereInput
    /**
     * Limit how many RealmKeys to update.
     */
    limit?: number
  }

  /**
   * RealmKey updateManyAndReturn
   */
  export type RealmKeyUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RealmKey
     */
    select?: RealmKeySelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the RealmKey
     */
    omit?: RealmKeyOmit<ExtArgs> | null
    /**
     * The data used to update RealmKeys.
     */
    data: XOR<RealmKeyUpdateManyMutationInput, RealmKeyUncheckedUpdateManyInput>
    /**
     * Filter which RealmKeys to update
     */
    where?: RealmKeyWhereInput
    /**
     * Limit how many RealmKeys to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmKeyIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * RealmKey upsert
   */
  export type RealmKeyUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RealmKey
     */
    select?: RealmKeySelect<ExtArgs> | null
    /**
     * Omit specific fields from the RealmKey
     */
    omit?: RealmKeyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmKeyInclude<ExtArgs> | null
    /**
     * The filter to search for the RealmKey to update in case it exists.
     */
    where: RealmKeyWhereUniqueInput
    /**
     * In case the RealmKey found by the `where` argument doesn't exist, create a new RealmKey with this data.
     */
    create: XOR<RealmKeyCreateInput, RealmKeyUncheckedCreateInput>
    /**
     * In case the RealmKey was found with the provided `where` argument, update it with this data.
     */
    update: XOR<RealmKeyUpdateInput, RealmKeyUncheckedUpdateInput>
  }

  /**
   * RealmKey delete
   */
  export type RealmKeyDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RealmKey
     */
    select?: RealmKeySelect<ExtArgs> | null
    /**
     * Omit specific fields from the RealmKey
     */
    omit?: RealmKeyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmKeyInclude<ExtArgs> | null
    /**
     * Filter which RealmKey to delete.
     */
    where: RealmKeyWhereUniqueInput
  }

  /**
   * RealmKey deleteMany
   */
  export type RealmKeyDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which RealmKeys to delete
     */
    where?: RealmKeyWhereInput
    /**
     * Limit how many RealmKeys to delete.
     */
    limit?: number
  }

  /**
   * RealmKey without action
   */
  export type RealmKeyDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RealmKey
     */
    select?: RealmKeySelect<ExtArgs> | null
    /**
     * Omit specific fields from the RealmKey
     */
    omit?: RealmKeyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RealmKeyInclude<ExtArgs> | null
  }


  /**
   * Model User
   */

  export type AggregateUser = {
    _count: UserCountAggregateOutputType | null
    _avg: UserAvgAggregateOutputType | null
    _sum: UserSumAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  export type UserAvgAggregateOutputType = {
    pbkdf2_iter: number | null
  }

  export type UserSumAggregateOutputType = {
    pbkdf2_iter: number | null
  }

  export type UserMinAggregateOutputType = {
    id: string | null
    realm_id: string | null
    username: string | null
    email: string | null
    password_hash: string | null
    password_salt: string | null
    pbkdf2_iter: number | null
    totp_secret: string | null
    totp_enabled: boolean | null
    email_verified: boolean | null
    is_active: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type UserMaxAggregateOutputType = {
    id: string | null
    realm_id: string | null
    username: string | null
    email: string | null
    password_hash: string | null
    password_salt: string | null
    pbkdf2_iter: number | null
    totp_secret: string | null
    totp_enabled: boolean | null
    email_verified: boolean | null
    is_active: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type UserCountAggregateOutputType = {
    id: number
    realm_id: number
    username: number
    email: number
    password_hash: number
    password_salt: number
    pbkdf2_iter: number
    totp_secret: number
    totp_enabled: number
    email_verified: number
    is_active: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type UserAvgAggregateInputType = {
    pbkdf2_iter?: true
  }

  export type UserSumAggregateInputType = {
    pbkdf2_iter?: true
  }

  export type UserMinAggregateInputType = {
    id?: true
    realm_id?: true
    username?: true
    email?: true
    password_hash?: true
    password_salt?: true
    pbkdf2_iter?: true
    totp_secret?: true
    totp_enabled?: true
    email_verified?: true
    is_active?: true
    created_at?: true
    updated_at?: true
  }

  export type UserMaxAggregateInputType = {
    id?: true
    realm_id?: true
    username?: true
    email?: true
    password_hash?: true
    password_salt?: true
    pbkdf2_iter?: true
    totp_secret?: true
    totp_enabled?: true
    email_verified?: true
    is_active?: true
    created_at?: true
    updated_at?: true
  }

  export type UserCountAggregateInputType = {
    id?: true
    realm_id?: true
    username?: true
    email?: true
    password_hash?: true
    password_salt?: true
    pbkdf2_iter?: true
    totp_secret?: true
    totp_enabled?: true
    email_verified?: true
    is_active?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type UserAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which User to aggregate.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Users
    **/
    _count?: true | UserCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserMaxAggregateInputType
  }

  export type GetUserAggregateType<T extends UserAggregateArgs> = {
        [P in keyof T & keyof AggregateUser]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUser[P]>
      : GetScalarType<T[P], AggregateUser[P]>
  }




  export type UserGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserWhereInput
    orderBy?: UserOrderByWithAggregationInput | UserOrderByWithAggregationInput[]
    by: UserScalarFieldEnum[] | UserScalarFieldEnum
    having?: UserScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserCountAggregateInputType | true
    _avg?: UserAvgAggregateInputType
    _sum?: UserSumAggregateInputType
    _min?: UserMinAggregateInputType
    _max?: UserMaxAggregateInputType
  }

  export type UserGroupByOutputType = {
    id: string
    realm_id: string
    username: string
    email: string
    password_hash: string
    password_salt: string
    pbkdf2_iter: number
    totp_secret: string | null
    totp_enabled: boolean
    email_verified: boolean
    is_active: boolean
    created_at: Date
    updated_at: Date
    _count: UserCountAggregateOutputType | null
    _avg: UserAvgAggregateOutputType | null
    _sum: UserSumAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  type GetUserGroupByPayload<T extends UserGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserGroupByOutputType[P]>
            : GetScalarType<T[P], UserGroupByOutputType[P]>
        }
      >
    >


  export type UserSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    realm_id?: boolean
    username?: boolean
    email?: boolean
    password_hash?: boolean
    password_salt?: boolean
    pbkdf2_iter?: boolean
    totp_secret?: boolean
    totp_enabled?: boolean
    email_verified?: boolean
    is_active?: boolean
    created_at?: boolean
    updated_at?: boolean
    realm?: boolean | RealmDefaultArgs<ExtArgs>
    roles?: boolean | User$rolesArgs<ExtArgs>
    sessions?: boolean | User$sessionsArgs<ExtArgs>
    tokens?: boolean | User$tokensArgs<ExtArgs>
    authorizationCodes?: boolean | User$authorizationCodesArgs<ExtArgs>
    _count?: boolean | UserCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["user"]>

  export type UserSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    realm_id?: boolean
    username?: boolean
    email?: boolean
    password_hash?: boolean
    password_salt?: boolean
    pbkdf2_iter?: boolean
    totp_secret?: boolean
    totp_enabled?: boolean
    email_verified?: boolean
    is_active?: boolean
    created_at?: boolean
    updated_at?: boolean
    realm?: boolean | RealmDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["user"]>

  export type UserSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    realm_id?: boolean
    username?: boolean
    email?: boolean
    password_hash?: boolean
    password_salt?: boolean
    pbkdf2_iter?: boolean
    totp_secret?: boolean
    totp_enabled?: boolean
    email_verified?: boolean
    is_active?: boolean
    created_at?: boolean
    updated_at?: boolean
    realm?: boolean | RealmDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["user"]>

  export type UserSelectScalar = {
    id?: boolean
    realm_id?: boolean
    username?: boolean
    email?: boolean
    password_hash?: boolean
    password_salt?: boolean
    pbkdf2_iter?: boolean
    totp_secret?: boolean
    totp_enabled?: boolean
    email_verified?: boolean
    is_active?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type UserOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "realm_id" | "username" | "email" | "password_hash" | "password_salt" | "pbkdf2_iter" | "totp_secret" | "totp_enabled" | "email_verified" | "is_active" | "created_at" | "updated_at", ExtArgs["result"]["user"]>
  export type UserInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    realm?: boolean | RealmDefaultArgs<ExtArgs>
    roles?: boolean | User$rolesArgs<ExtArgs>
    sessions?: boolean | User$sessionsArgs<ExtArgs>
    tokens?: boolean | User$tokensArgs<ExtArgs>
    authorizationCodes?: boolean | User$authorizationCodesArgs<ExtArgs>
    _count?: boolean | UserCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type UserIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    realm?: boolean | RealmDefaultArgs<ExtArgs>
  }
  export type UserIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    realm?: boolean | RealmDefaultArgs<ExtArgs>
  }

  export type $UserPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "User"
    objects: {
      realm: Prisma.$RealmPayload<ExtArgs>
      roles: Prisma.$UserRolePayload<ExtArgs>[]
      sessions: Prisma.$UserSessionPayload<ExtArgs>[]
      tokens: Prisma.$TokenPayload<ExtArgs>[]
      authorizationCodes: Prisma.$AuthorizationCodePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      realm_id: string
      username: string
      email: string
      password_hash: string
      password_salt: string
      pbkdf2_iter: number
      totp_secret: string | null
      totp_enabled: boolean
      email_verified: boolean
      is_active: boolean
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["user"]>
    composites: {}
  }

  type UserGetPayload<S extends boolean | null | undefined | UserDefaultArgs> = $Result.GetResult<Prisma.$UserPayload, S>

  type UserCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<UserFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: UserCountAggregateInputType | true
    }

  export interface UserDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['User'], meta: { name: 'User' } }
    /**
     * Find zero or one User that matches the filter.
     * @param {UserFindUniqueArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends UserFindUniqueArgs>(args: SelectSubset<T, UserFindUniqueArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one User that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {UserFindUniqueOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends UserFindUniqueOrThrowArgs>(args: SelectSubset<T, UserFindUniqueOrThrowArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first User that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindFirstArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends UserFindFirstArgs>(args?: SelectSubset<T, UserFindFirstArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first User that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindFirstOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends UserFindFirstOrThrowArgs>(args?: SelectSubset<T, UserFindFirstOrThrowArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Users that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Users
     * const users = await prisma.user.findMany()
     * 
     * // Get first 10 Users
     * const users = await prisma.user.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userWithIdOnly = await prisma.user.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends UserFindManyArgs>(args?: SelectSubset<T, UserFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a User.
     * @param {UserCreateArgs} args - Arguments to create a User.
     * @example
     * // Create one User
     * const User = await prisma.user.create({
     *   data: {
     *     // ... data to create a User
     *   }
     * })
     * 
     */
    create<T extends UserCreateArgs>(args: SelectSubset<T, UserCreateArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Users.
     * @param {UserCreateManyArgs} args - Arguments to create many Users.
     * @example
     * // Create many Users
     * const user = await prisma.user.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends UserCreateManyArgs>(args?: SelectSubset<T, UserCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Users and returns the data saved in the database.
     * @param {UserCreateManyAndReturnArgs} args - Arguments to create many Users.
     * @example
     * // Create many Users
     * const user = await prisma.user.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Users and only return the `id`
     * const userWithIdOnly = await prisma.user.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends UserCreateManyAndReturnArgs>(args?: SelectSubset<T, UserCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "createManyAndReturn", GlobalOmitOptions>>

    /**
     * Delete a User.
     * @param {UserDeleteArgs} args - Arguments to delete one User.
     * @example
     * // Delete one User
     * const User = await prisma.user.delete({
     *   where: {
     *     // ... filter to delete one User
     *   }
     * })
     * 
     */
    delete<T extends UserDeleteArgs>(args: SelectSubset<T, UserDeleteArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one User.
     * @param {UserUpdateArgs} args - Arguments to update one User.
     * @example
     * // Update one User
     * const user = await prisma.user.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends UserUpdateArgs>(args: SelectSubset<T, UserUpdateArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Users.
     * @param {UserDeleteManyArgs} args - Arguments to filter Users to delete.
     * @example
     * // Delete a few Users
     * const { count } = await prisma.user.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends UserDeleteManyArgs>(args?: SelectSubset<T, UserDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Users
     * const user = await prisma.user.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends UserUpdateManyArgs>(args: SelectSubset<T, UserUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Users and returns the data updated in the database.
     * @param {UserUpdateManyAndReturnArgs} args - Arguments to update many Users.
     * @example
     * // Update many Users
     * const user = await prisma.user.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Users and only return the `id`
     * const userWithIdOnly = await prisma.user.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends UserUpdateManyAndReturnArgs>(args: SelectSubset<T, UserUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "updateManyAndReturn", GlobalOmitOptions>>

    /**
     * Create or update one User.
     * @param {UserUpsertArgs} args - Arguments to update or create a User.
     * @example
     * // Update or create a User
     * const user = await prisma.user.upsert({
     *   create: {
     *     // ... data to create a User
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the User we want to update
     *   }
     * })
     */
    upsert<T extends UserUpsertArgs>(args: SelectSubset<T, UserUpsertArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserCountArgs} args - Arguments to filter Users to count.
     * @example
     * // Count the number of Users
     * const count = await prisma.user.count({
     *   where: {
     *     // ... the filter for the Users we want to count
     *   }
     * })
    **/
    count<T extends UserCountArgs>(
      args?: Subset<T, UserCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserAggregateArgs>(args: Subset<T, UserAggregateArgs>): Prisma.PrismaPromise<GetUserAggregateType<T>>

    /**
     * Group by User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserGroupByArgs['orderBy'] }
        : { orderBy?: UserGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the User model
   */
  readonly fields: UserFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for User.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    realm<T extends RealmDefaultArgs<ExtArgs> = {}>(args?: Subset<T, RealmDefaultArgs<ExtArgs>>): Prisma__RealmClient<$Result.GetResult<Prisma.$RealmPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    roles<T extends User$rolesArgs<ExtArgs> = {}>(args?: Subset<T, User$rolesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserRolePayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    sessions<T extends User$sessionsArgs<ExtArgs> = {}>(args?: Subset<T, User$sessionsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserSessionPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    tokens<T extends User$tokensArgs<ExtArgs> = {}>(args?: Subset<T, User$tokensArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TokenPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    authorizationCodes<T extends User$authorizationCodesArgs<ExtArgs> = {}>(args?: Subset<T, User$authorizationCodesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AuthorizationCodePayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the User model
   */
  interface UserFieldRefs {
    readonly id: FieldRef<"User", 'String'>
    readonly realm_id: FieldRef<"User", 'String'>
    readonly username: FieldRef<"User", 'String'>
    readonly email: FieldRef<"User", 'String'>
    readonly password_hash: FieldRef<"User", 'String'>
    readonly password_salt: FieldRef<"User", 'String'>
    readonly pbkdf2_iter: FieldRef<"User", 'Int'>
    readonly totp_secret: FieldRef<"User", 'String'>
    readonly totp_enabled: FieldRef<"User", 'Boolean'>
    readonly email_verified: FieldRef<"User", 'Boolean'>
    readonly is_active: FieldRef<"User", 'Boolean'>
    readonly created_at: FieldRef<"User", 'DateTime'>
    readonly updated_at: FieldRef<"User", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * User findUnique
   */
  export type UserFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User findUniqueOrThrow
   */
  export type UserFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User findFirst
   */
  export type UserFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Users.
     */
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User findFirstOrThrow
   */
  export type UserFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Users.
     */
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User findMany
   */
  export type UserFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which Users to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User create
   */
  export type UserCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The data needed to create a User.
     */
    data: XOR<UserCreateInput, UserUncheckedCreateInput>
  }

  /**
   * User createMany
   */
  export type UserCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Users.
     */
    data: UserCreateManyInput | UserCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * User createManyAndReturn
   */
  export type UserCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * The data used to create many Users.
     */
    data: UserCreateManyInput | UserCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * User update
   */
  export type UserUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The data needed to update a User.
     */
    data: XOR<UserUpdateInput, UserUncheckedUpdateInput>
    /**
     * Choose, which User to update.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User updateMany
   */
  export type UserUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Users.
     */
    data: XOR<UserUpdateManyMutationInput, UserUncheckedUpdateManyInput>
    /**
     * Filter which Users to update
     */
    where?: UserWhereInput
    /**
     * Limit how many Users to update.
     */
    limit?: number
  }

  /**
   * User updateManyAndReturn
   */
  export type UserUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * The data used to update Users.
     */
    data: XOR<UserUpdateManyMutationInput, UserUncheckedUpdateManyInput>
    /**
     * Filter which Users to update
     */
    where?: UserWhereInput
    /**
     * Limit how many Users to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * User upsert
   */
  export type UserUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The filter to search for the User to update in case it exists.
     */
    where: UserWhereUniqueInput
    /**
     * In case the User found by the `where` argument doesn't exist, create a new User with this data.
     */
    create: XOR<UserCreateInput, UserUncheckedCreateInput>
    /**
     * In case the User was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserUpdateInput, UserUncheckedUpdateInput>
  }

  /**
   * User delete
   */
  export type UserDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter which User to delete.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User deleteMany
   */
  export type UserDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Users to delete
     */
    where?: UserWhereInput
    /**
     * Limit how many Users to delete.
     */
    limit?: number
  }

  /**
   * User.roles
   */
  export type User$rolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRole
     */
    select?: UserRoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserRole
     */
    omit?: UserRoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRoleInclude<ExtArgs> | null
    where?: UserRoleWhereInput
    orderBy?: UserRoleOrderByWithRelationInput | UserRoleOrderByWithRelationInput[]
    cursor?: UserRoleWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserRoleScalarFieldEnum | UserRoleScalarFieldEnum[]
  }

  /**
   * User.sessions
   */
  export type User$sessionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserSession
     */
    select?: UserSessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserSession
     */
    omit?: UserSessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserSessionInclude<ExtArgs> | null
    where?: UserSessionWhereInput
    orderBy?: UserSessionOrderByWithRelationInput | UserSessionOrderByWithRelationInput[]
    cursor?: UserSessionWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserSessionScalarFieldEnum | UserSessionScalarFieldEnum[]
  }

  /**
   * User.tokens
   */
  export type User$tokensArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Token
     */
    select?: TokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Token
     */
    omit?: TokenOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TokenInclude<ExtArgs> | null
    where?: TokenWhereInput
    orderBy?: TokenOrderByWithRelationInput | TokenOrderByWithRelationInput[]
    cursor?: TokenWhereUniqueInput
    take?: number
    skip?: number
    distinct?: TokenScalarFieldEnum | TokenScalarFieldEnum[]
  }

  /**
   * User.authorizationCodes
   */
  export type User$authorizationCodesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuthorizationCode
     */
    select?: AuthorizationCodeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuthorizationCode
     */
    omit?: AuthorizationCodeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuthorizationCodeInclude<ExtArgs> | null
    where?: AuthorizationCodeWhereInput
    orderBy?: AuthorizationCodeOrderByWithRelationInput | AuthorizationCodeOrderByWithRelationInput[]
    cursor?: AuthorizationCodeWhereUniqueInput
    take?: number
    skip?: number
    distinct?: AuthorizationCodeScalarFieldEnum | AuthorizationCodeScalarFieldEnum[]
  }

  /**
   * User without action
   */
  export type UserDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
  }


  /**
   * Model UserSession
   */

  export type AggregateUserSession = {
    _count: UserSessionCountAggregateOutputType | null
    _min: UserSessionMinAggregateOutputType | null
    _max: UserSessionMaxAggregateOutputType | null
  }

  export type UserSessionMinAggregateOutputType = {
    id: string | null
    user_id: string | null
    client_id: string | null
    ip_addr: string | null
    user_agent: string | null
    login_time: Date | null
    logout_time: Date | null
  }

  export type UserSessionMaxAggregateOutputType = {
    id: string | null
    user_id: string | null
    client_id: string | null
    ip_addr: string | null
    user_agent: string | null
    login_time: Date | null
    logout_time: Date | null
  }

  export type UserSessionCountAggregateOutputType = {
    id: number
    user_id: number
    client_id: number
    ip_addr: number
    user_agent: number
    login_time: number
    logout_time: number
    _all: number
  }


  export type UserSessionMinAggregateInputType = {
    id?: true
    user_id?: true
    client_id?: true
    ip_addr?: true
    user_agent?: true
    login_time?: true
    logout_time?: true
  }

  export type UserSessionMaxAggregateInputType = {
    id?: true
    user_id?: true
    client_id?: true
    ip_addr?: true
    user_agent?: true
    login_time?: true
    logout_time?: true
  }

  export type UserSessionCountAggregateInputType = {
    id?: true
    user_id?: true
    client_id?: true
    ip_addr?: true
    user_agent?: true
    login_time?: true
    logout_time?: true
    _all?: true
  }

  export type UserSessionAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserSession to aggregate.
     */
    where?: UserSessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserSessions to fetch.
     */
    orderBy?: UserSessionOrderByWithRelationInput | UserSessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserSessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserSessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserSessions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned UserSessions
    **/
    _count?: true | UserSessionCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserSessionMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserSessionMaxAggregateInputType
  }

  export type GetUserSessionAggregateType<T extends UserSessionAggregateArgs> = {
        [P in keyof T & keyof AggregateUserSession]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUserSession[P]>
      : GetScalarType<T[P], AggregateUserSession[P]>
  }




  export type UserSessionGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserSessionWhereInput
    orderBy?: UserSessionOrderByWithAggregationInput | UserSessionOrderByWithAggregationInput[]
    by: UserSessionScalarFieldEnum[] | UserSessionScalarFieldEnum
    having?: UserSessionScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserSessionCountAggregateInputType | true
    _min?: UserSessionMinAggregateInputType
    _max?: UserSessionMaxAggregateInputType
  }

  export type UserSessionGroupByOutputType = {
    id: string
    user_id: string
    client_id: string
    ip_addr: string
    user_agent: string
    login_time: Date
    logout_time: Date | null
    _count: UserSessionCountAggregateOutputType | null
    _min: UserSessionMinAggregateOutputType | null
    _max: UserSessionMaxAggregateOutputType | null
  }

  type GetUserSessionGroupByPayload<T extends UserSessionGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserSessionGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserSessionGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserSessionGroupByOutputType[P]>
            : GetScalarType<T[P], UserSessionGroupByOutputType[P]>
        }
      >
    >


  export type UserSessionSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    client_id?: boolean
    ip_addr?: boolean
    user_agent?: boolean
    login_time?: boolean
    logout_time?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    client?: boolean | ClientDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userSession"]>

  export type UserSessionSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    client_id?: boolean
    ip_addr?: boolean
    user_agent?: boolean
    login_time?: boolean
    logout_time?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    client?: boolean | ClientDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userSession"]>

  export type UserSessionSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    client_id?: boolean
    ip_addr?: boolean
    user_agent?: boolean
    login_time?: boolean
    logout_time?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    client?: boolean | ClientDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userSession"]>

  export type UserSessionSelectScalar = {
    id?: boolean
    user_id?: boolean
    client_id?: boolean
    ip_addr?: boolean
    user_agent?: boolean
    login_time?: boolean
    logout_time?: boolean
  }

  export type UserSessionOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "user_id" | "client_id" | "ip_addr" | "user_agent" | "login_time" | "logout_time", ExtArgs["result"]["userSession"]>
  export type UserSessionInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    client?: boolean | ClientDefaultArgs<ExtArgs>
  }
  export type UserSessionIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    client?: boolean | ClientDefaultArgs<ExtArgs>
  }
  export type UserSessionIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    client?: boolean | ClientDefaultArgs<ExtArgs>
  }

  export type $UserSessionPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "UserSession"
    objects: {
      user: Prisma.$UserPayload<ExtArgs>
      client: Prisma.$ClientPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      user_id: string
      client_id: string
      ip_addr: string
      user_agent: string
      login_time: Date
      logout_time: Date | null
    }, ExtArgs["result"]["userSession"]>
    composites: {}
  }

  type UserSessionGetPayload<S extends boolean | null | undefined | UserSessionDefaultArgs> = $Result.GetResult<Prisma.$UserSessionPayload, S>

  type UserSessionCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<UserSessionFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: UserSessionCountAggregateInputType | true
    }

  export interface UserSessionDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['UserSession'], meta: { name: 'UserSession' } }
    /**
     * Find zero or one UserSession that matches the filter.
     * @param {UserSessionFindUniqueArgs} args - Arguments to find a UserSession
     * @example
     * // Get one UserSession
     * const userSession = await prisma.userSession.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends UserSessionFindUniqueArgs>(args: SelectSubset<T, UserSessionFindUniqueArgs<ExtArgs>>): Prisma__UserSessionClient<$Result.GetResult<Prisma.$UserSessionPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one UserSession that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {UserSessionFindUniqueOrThrowArgs} args - Arguments to find a UserSession
     * @example
     * // Get one UserSession
     * const userSession = await prisma.userSession.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends UserSessionFindUniqueOrThrowArgs>(args: SelectSubset<T, UserSessionFindUniqueOrThrowArgs<ExtArgs>>): Prisma__UserSessionClient<$Result.GetResult<Prisma.$UserSessionPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first UserSession that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserSessionFindFirstArgs} args - Arguments to find a UserSession
     * @example
     * // Get one UserSession
     * const userSession = await prisma.userSession.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends UserSessionFindFirstArgs>(args?: SelectSubset<T, UserSessionFindFirstArgs<ExtArgs>>): Prisma__UserSessionClient<$Result.GetResult<Prisma.$UserSessionPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first UserSession that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserSessionFindFirstOrThrowArgs} args - Arguments to find a UserSession
     * @example
     * // Get one UserSession
     * const userSession = await prisma.userSession.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends UserSessionFindFirstOrThrowArgs>(args?: SelectSubset<T, UserSessionFindFirstOrThrowArgs<ExtArgs>>): Prisma__UserSessionClient<$Result.GetResult<Prisma.$UserSessionPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more UserSessions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserSessionFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all UserSessions
     * const userSessions = await prisma.userSession.findMany()
     * 
     * // Get first 10 UserSessions
     * const userSessions = await prisma.userSession.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userSessionWithIdOnly = await prisma.userSession.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends UserSessionFindManyArgs>(args?: SelectSubset<T, UserSessionFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserSessionPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a UserSession.
     * @param {UserSessionCreateArgs} args - Arguments to create a UserSession.
     * @example
     * // Create one UserSession
     * const UserSession = await prisma.userSession.create({
     *   data: {
     *     // ... data to create a UserSession
     *   }
     * })
     * 
     */
    create<T extends UserSessionCreateArgs>(args: SelectSubset<T, UserSessionCreateArgs<ExtArgs>>): Prisma__UserSessionClient<$Result.GetResult<Prisma.$UserSessionPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many UserSessions.
     * @param {UserSessionCreateManyArgs} args - Arguments to create many UserSessions.
     * @example
     * // Create many UserSessions
     * const userSession = await prisma.userSession.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends UserSessionCreateManyArgs>(args?: SelectSubset<T, UserSessionCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many UserSessions and returns the data saved in the database.
     * @param {UserSessionCreateManyAndReturnArgs} args - Arguments to create many UserSessions.
     * @example
     * // Create many UserSessions
     * const userSession = await prisma.userSession.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many UserSessions and only return the `id`
     * const userSessionWithIdOnly = await prisma.userSession.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends UserSessionCreateManyAndReturnArgs>(args?: SelectSubset<T, UserSessionCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserSessionPayload<ExtArgs>, T, "createManyAndReturn", GlobalOmitOptions>>

    /**
     * Delete a UserSession.
     * @param {UserSessionDeleteArgs} args - Arguments to delete one UserSession.
     * @example
     * // Delete one UserSession
     * const UserSession = await prisma.userSession.delete({
     *   where: {
     *     // ... filter to delete one UserSession
     *   }
     * })
     * 
     */
    delete<T extends UserSessionDeleteArgs>(args: SelectSubset<T, UserSessionDeleteArgs<ExtArgs>>): Prisma__UserSessionClient<$Result.GetResult<Prisma.$UserSessionPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one UserSession.
     * @param {UserSessionUpdateArgs} args - Arguments to update one UserSession.
     * @example
     * // Update one UserSession
     * const userSession = await prisma.userSession.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends UserSessionUpdateArgs>(args: SelectSubset<T, UserSessionUpdateArgs<ExtArgs>>): Prisma__UserSessionClient<$Result.GetResult<Prisma.$UserSessionPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more UserSessions.
     * @param {UserSessionDeleteManyArgs} args - Arguments to filter UserSessions to delete.
     * @example
     * // Delete a few UserSessions
     * const { count } = await prisma.userSession.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends UserSessionDeleteManyArgs>(args?: SelectSubset<T, UserSessionDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserSessions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserSessionUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many UserSessions
     * const userSession = await prisma.userSession.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends UserSessionUpdateManyArgs>(args: SelectSubset<T, UserSessionUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserSessions and returns the data updated in the database.
     * @param {UserSessionUpdateManyAndReturnArgs} args - Arguments to update many UserSessions.
     * @example
     * // Update many UserSessions
     * const userSession = await prisma.userSession.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more UserSessions and only return the `id`
     * const userSessionWithIdOnly = await prisma.userSession.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends UserSessionUpdateManyAndReturnArgs>(args: SelectSubset<T, UserSessionUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserSessionPayload<ExtArgs>, T, "updateManyAndReturn", GlobalOmitOptions>>

    /**
     * Create or update one UserSession.
     * @param {UserSessionUpsertArgs} args - Arguments to update or create a UserSession.
     * @example
     * // Update or create a UserSession
     * const userSession = await prisma.userSession.upsert({
     *   create: {
     *     // ... data to create a UserSession
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the UserSession we want to update
     *   }
     * })
     */
    upsert<T extends UserSessionUpsertArgs>(args: SelectSubset<T, UserSessionUpsertArgs<ExtArgs>>): Prisma__UserSessionClient<$Result.GetResult<Prisma.$UserSessionPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of UserSessions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserSessionCountArgs} args - Arguments to filter UserSessions to count.
     * @example
     * // Count the number of UserSessions
     * const count = await prisma.userSession.count({
     *   where: {
     *     // ... the filter for the UserSessions we want to count
     *   }
     * })
    **/
    count<T extends UserSessionCountArgs>(
      args?: Subset<T, UserSessionCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserSessionCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a UserSession.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserSessionAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserSessionAggregateArgs>(args: Subset<T, UserSessionAggregateArgs>): Prisma.PrismaPromise<GetUserSessionAggregateType<T>>

    /**
     * Group by UserSession.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserSessionGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserSessionGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserSessionGroupByArgs['orderBy'] }
        : { orderBy?: UserSessionGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserSessionGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserSessionGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the UserSession model
   */
  readonly fields: UserSessionFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for UserSession.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserSessionClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    user<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    client<T extends ClientDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ClientDefaultArgs<ExtArgs>>): Prisma__ClientClient<$Result.GetResult<Prisma.$ClientPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the UserSession model
   */
  interface UserSessionFieldRefs {
    readonly id: FieldRef<"UserSession", 'String'>
    readonly user_id: FieldRef<"UserSession", 'String'>
    readonly client_id: FieldRef<"UserSession", 'String'>
    readonly ip_addr: FieldRef<"UserSession", 'String'>
    readonly user_agent: FieldRef<"UserSession", 'String'>
    readonly login_time: FieldRef<"UserSession", 'DateTime'>
    readonly logout_time: FieldRef<"UserSession", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * UserSession findUnique
   */
  export type UserSessionFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserSession
     */
    select?: UserSessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserSession
     */
    omit?: UserSessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserSessionInclude<ExtArgs> | null
    /**
     * Filter, which UserSession to fetch.
     */
    where: UserSessionWhereUniqueInput
  }

  /**
   * UserSession findUniqueOrThrow
   */
  export type UserSessionFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserSession
     */
    select?: UserSessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserSession
     */
    omit?: UserSessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserSessionInclude<ExtArgs> | null
    /**
     * Filter, which UserSession to fetch.
     */
    where: UserSessionWhereUniqueInput
  }

  /**
   * UserSession findFirst
   */
  export type UserSessionFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserSession
     */
    select?: UserSessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserSession
     */
    omit?: UserSessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserSessionInclude<ExtArgs> | null
    /**
     * Filter, which UserSession to fetch.
     */
    where?: UserSessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserSessions to fetch.
     */
    orderBy?: UserSessionOrderByWithRelationInput | UserSessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserSessions.
     */
    cursor?: UserSessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserSessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserSessions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserSessions.
     */
    distinct?: UserSessionScalarFieldEnum | UserSessionScalarFieldEnum[]
  }

  /**
   * UserSession findFirstOrThrow
   */
  export type UserSessionFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserSession
     */
    select?: UserSessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserSession
     */
    omit?: UserSessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserSessionInclude<ExtArgs> | null
    /**
     * Filter, which UserSession to fetch.
     */
    where?: UserSessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserSessions to fetch.
     */
    orderBy?: UserSessionOrderByWithRelationInput | UserSessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserSessions.
     */
    cursor?: UserSessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserSessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserSessions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserSessions.
     */
    distinct?: UserSessionScalarFieldEnum | UserSessionScalarFieldEnum[]
  }

  /**
   * UserSession findMany
   */
  export type UserSessionFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserSession
     */
    select?: UserSessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserSession
     */
    omit?: UserSessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserSessionInclude<ExtArgs> | null
    /**
     * Filter, which UserSessions to fetch.
     */
    where?: UserSessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserSessions to fetch.
     */
    orderBy?: UserSessionOrderByWithRelationInput | UserSessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing UserSessions.
     */
    cursor?: UserSessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserSessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserSessions.
     */
    skip?: number
    distinct?: UserSessionScalarFieldEnum | UserSessionScalarFieldEnum[]
  }

  /**
   * UserSession create
   */
  export type UserSessionCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserSession
     */
    select?: UserSessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserSession
     */
    omit?: UserSessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserSessionInclude<ExtArgs> | null
    /**
     * The data needed to create a UserSession.
     */
    data: XOR<UserSessionCreateInput, UserSessionUncheckedCreateInput>
  }

  /**
   * UserSession createMany
   */
  export type UserSessionCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many UserSessions.
     */
    data: UserSessionCreateManyInput | UserSessionCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * UserSession createManyAndReturn
   */
  export type UserSessionCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserSession
     */
    select?: UserSessionSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the UserSession
     */
    omit?: UserSessionOmit<ExtArgs> | null
    /**
     * The data used to create many UserSessions.
     */
    data: UserSessionCreateManyInput | UserSessionCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserSessionIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * UserSession update
   */
  export type UserSessionUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserSession
     */
    select?: UserSessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserSession
     */
    omit?: UserSessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserSessionInclude<ExtArgs> | null
    /**
     * The data needed to update a UserSession.
     */
    data: XOR<UserSessionUpdateInput, UserSessionUncheckedUpdateInput>
    /**
     * Choose, which UserSession to update.
     */
    where: UserSessionWhereUniqueInput
  }

  /**
   * UserSession updateMany
   */
  export type UserSessionUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update UserSessions.
     */
    data: XOR<UserSessionUpdateManyMutationInput, UserSessionUncheckedUpdateManyInput>
    /**
     * Filter which UserSessions to update
     */
    where?: UserSessionWhereInput
    /**
     * Limit how many UserSessions to update.
     */
    limit?: number
  }

  /**
   * UserSession updateManyAndReturn
   */
  export type UserSessionUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserSession
     */
    select?: UserSessionSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the UserSession
     */
    omit?: UserSessionOmit<ExtArgs> | null
    /**
     * The data used to update UserSessions.
     */
    data: XOR<UserSessionUpdateManyMutationInput, UserSessionUncheckedUpdateManyInput>
    /**
     * Filter which UserSessions to update
     */
    where?: UserSessionWhereInput
    /**
     * Limit how many UserSessions to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserSessionIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * UserSession upsert
   */
  export type UserSessionUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserSession
     */
    select?: UserSessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserSession
     */
    omit?: UserSessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserSessionInclude<ExtArgs> | null
    /**
     * The filter to search for the UserSession to update in case it exists.
     */
    where: UserSessionWhereUniqueInput
    /**
     * In case the UserSession found by the `where` argument doesn't exist, create a new UserSession with this data.
     */
    create: XOR<UserSessionCreateInput, UserSessionUncheckedCreateInput>
    /**
     * In case the UserSession was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserSessionUpdateInput, UserSessionUncheckedUpdateInput>
  }

  /**
   * UserSession delete
   */
  export type UserSessionDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserSession
     */
    select?: UserSessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserSession
     */
    omit?: UserSessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserSessionInclude<ExtArgs> | null
    /**
     * Filter which UserSession to delete.
     */
    where: UserSessionWhereUniqueInput
  }

  /**
   * UserSession deleteMany
   */
  export type UserSessionDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserSessions to delete
     */
    where?: UserSessionWhereInput
    /**
     * Limit how many UserSessions to delete.
     */
    limit?: number
  }

  /**
   * UserSession without action
   */
  export type UserSessionDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserSession
     */
    select?: UserSessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserSession
     */
    omit?: UserSessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserSessionInclude<ExtArgs> | null
  }


  /**
   * Model Role
   */

  export type AggregateRole = {
    _count: RoleCountAggregateOutputType | null
    _min: RoleMinAggregateOutputType | null
    _max: RoleMaxAggregateOutputType | null
  }

  export type RoleMinAggregateOutputType = {
    id: string | null
    realm_id: string | null
    client_id: string | null
    name: string | null
    description: string | null
    is_client_role: boolean | null
  }

  export type RoleMaxAggregateOutputType = {
    id: string | null
    realm_id: string | null
    client_id: string | null
    name: string | null
    description: string | null
    is_client_role: boolean | null
  }

  export type RoleCountAggregateOutputType = {
    id: number
    realm_id: number
    client_id: number
    name: number
    description: number
    is_client_role: number
    _all: number
  }


  export type RoleMinAggregateInputType = {
    id?: true
    realm_id?: true
    client_id?: true
    name?: true
    description?: true
    is_client_role?: true
  }

  export type RoleMaxAggregateInputType = {
    id?: true
    realm_id?: true
    client_id?: true
    name?: true
    description?: true
    is_client_role?: true
  }

  export type RoleCountAggregateInputType = {
    id?: true
    realm_id?: true
    client_id?: true
    name?: true
    description?: true
    is_client_role?: true
    _all?: true
  }

  export type RoleAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Role to aggregate.
     */
    where?: RoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Roles to fetch.
     */
    orderBy?: RoleOrderByWithRelationInput | RoleOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: RoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Roles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Roles
    **/
    _count?: true | RoleCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: RoleMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: RoleMaxAggregateInputType
  }

  export type GetRoleAggregateType<T extends RoleAggregateArgs> = {
        [P in keyof T & keyof AggregateRole]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateRole[P]>
      : GetScalarType<T[P], AggregateRole[P]>
  }




  export type RoleGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RoleWhereInput
    orderBy?: RoleOrderByWithAggregationInput | RoleOrderByWithAggregationInput[]
    by: RoleScalarFieldEnum[] | RoleScalarFieldEnum
    having?: RoleScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: RoleCountAggregateInputType | true
    _min?: RoleMinAggregateInputType
    _max?: RoleMaxAggregateInputType
  }

  export type RoleGroupByOutputType = {
    id: string
    realm_id: string
    client_id: string | null
    name: string
    description: string | null
    is_client_role: boolean
    _count: RoleCountAggregateOutputType | null
    _min: RoleMinAggregateOutputType | null
    _max: RoleMaxAggregateOutputType | null
  }

  type GetRoleGroupByPayload<T extends RoleGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<RoleGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof RoleGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], RoleGroupByOutputType[P]>
            : GetScalarType<T[P], RoleGroupByOutputType[P]>
        }
      >
    >


  export type RoleSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    realm_id?: boolean
    client_id?: boolean
    name?: boolean
    description?: boolean
    is_client_role?: boolean
    realm?: boolean | RealmDefaultArgs<ExtArgs>
    client?: boolean | Role$clientArgs<ExtArgs>
    userLinks?: boolean | Role$userLinksArgs<ExtArgs>
    _count?: boolean | RoleCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["role"]>

  export type RoleSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    realm_id?: boolean
    client_id?: boolean
    name?: boolean
    description?: boolean
    is_client_role?: boolean
    realm?: boolean | RealmDefaultArgs<ExtArgs>
    client?: boolean | Role$clientArgs<ExtArgs>
  }, ExtArgs["result"]["role"]>

  export type RoleSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    realm_id?: boolean
    client_id?: boolean
    name?: boolean
    description?: boolean
    is_client_role?: boolean
    realm?: boolean | RealmDefaultArgs<ExtArgs>
    client?: boolean | Role$clientArgs<ExtArgs>
  }, ExtArgs["result"]["role"]>

  export type RoleSelectScalar = {
    id?: boolean
    realm_id?: boolean
    client_id?: boolean
    name?: boolean
    description?: boolean
    is_client_role?: boolean
  }

  export type RoleOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "realm_id" | "client_id" | "name" | "description" | "is_client_role", ExtArgs["result"]["role"]>
  export type RoleInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    realm?: boolean | RealmDefaultArgs<ExtArgs>
    client?: boolean | Role$clientArgs<ExtArgs>
    userLinks?: boolean | Role$userLinksArgs<ExtArgs>
    _count?: boolean | RoleCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type RoleIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    realm?: boolean | RealmDefaultArgs<ExtArgs>
    client?: boolean | Role$clientArgs<ExtArgs>
  }
  export type RoleIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    realm?: boolean | RealmDefaultArgs<ExtArgs>
    client?: boolean | Role$clientArgs<ExtArgs>
  }

  export type $RolePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Role"
    objects: {
      realm: Prisma.$RealmPayload<ExtArgs>
      client: Prisma.$ClientPayload<ExtArgs> | null
      userLinks: Prisma.$UserRolePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      realm_id: string
      client_id: string | null
      name: string
      description: string | null
      is_client_role: boolean
    }, ExtArgs["result"]["role"]>
    composites: {}
  }

  type RoleGetPayload<S extends boolean | null | undefined | RoleDefaultArgs> = $Result.GetResult<Prisma.$RolePayload, S>

  type RoleCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<RoleFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: RoleCountAggregateInputType | true
    }

  export interface RoleDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Role'], meta: { name: 'Role' } }
    /**
     * Find zero or one Role that matches the filter.
     * @param {RoleFindUniqueArgs} args - Arguments to find a Role
     * @example
     * // Get one Role
     * const role = await prisma.role.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends RoleFindUniqueArgs>(args: SelectSubset<T, RoleFindUniqueArgs<ExtArgs>>): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Role that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {RoleFindUniqueOrThrowArgs} args - Arguments to find a Role
     * @example
     * // Get one Role
     * const role = await prisma.role.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends RoleFindUniqueOrThrowArgs>(args: SelectSubset<T, RoleFindUniqueOrThrowArgs<ExtArgs>>): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Role that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleFindFirstArgs} args - Arguments to find a Role
     * @example
     * // Get one Role
     * const role = await prisma.role.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends RoleFindFirstArgs>(args?: SelectSubset<T, RoleFindFirstArgs<ExtArgs>>): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Role that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleFindFirstOrThrowArgs} args - Arguments to find a Role
     * @example
     * // Get one Role
     * const role = await prisma.role.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends RoleFindFirstOrThrowArgs>(args?: SelectSubset<T, RoleFindFirstOrThrowArgs<ExtArgs>>): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Roles that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Roles
     * const roles = await prisma.role.findMany()
     * 
     * // Get first 10 Roles
     * const roles = await prisma.role.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const roleWithIdOnly = await prisma.role.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends RoleFindManyArgs>(args?: SelectSubset<T, RoleFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Role.
     * @param {RoleCreateArgs} args - Arguments to create a Role.
     * @example
     * // Create one Role
     * const Role = await prisma.role.create({
     *   data: {
     *     // ... data to create a Role
     *   }
     * })
     * 
     */
    create<T extends RoleCreateArgs>(args: SelectSubset<T, RoleCreateArgs<ExtArgs>>): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Roles.
     * @param {RoleCreateManyArgs} args - Arguments to create many Roles.
     * @example
     * // Create many Roles
     * const role = await prisma.role.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends RoleCreateManyArgs>(args?: SelectSubset<T, RoleCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Roles and returns the data saved in the database.
     * @param {RoleCreateManyAndReturnArgs} args - Arguments to create many Roles.
     * @example
     * // Create many Roles
     * const role = await prisma.role.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Roles and only return the `id`
     * const roleWithIdOnly = await prisma.role.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends RoleCreateManyAndReturnArgs>(args?: SelectSubset<T, RoleCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, "createManyAndReturn", GlobalOmitOptions>>

    /**
     * Delete a Role.
     * @param {RoleDeleteArgs} args - Arguments to delete one Role.
     * @example
     * // Delete one Role
     * const Role = await prisma.role.delete({
     *   where: {
     *     // ... filter to delete one Role
     *   }
     * })
     * 
     */
    delete<T extends RoleDeleteArgs>(args: SelectSubset<T, RoleDeleteArgs<ExtArgs>>): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Role.
     * @param {RoleUpdateArgs} args - Arguments to update one Role.
     * @example
     * // Update one Role
     * const role = await prisma.role.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends RoleUpdateArgs>(args: SelectSubset<T, RoleUpdateArgs<ExtArgs>>): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Roles.
     * @param {RoleDeleteManyArgs} args - Arguments to filter Roles to delete.
     * @example
     * // Delete a few Roles
     * const { count } = await prisma.role.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends RoleDeleteManyArgs>(args?: SelectSubset<T, RoleDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Roles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Roles
     * const role = await prisma.role.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends RoleUpdateManyArgs>(args: SelectSubset<T, RoleUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Roles and returns the data updated in the database.
     * @param {RoleUpdateManyAndReturnArgs} args - Arguments to update many Roles.
     * @example
     * // Update many Roles
     * const role = await prisma.role.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Roles and only return the `id`
     * const roleWithIdOnly = await prisma.role.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends RoleUpdateManyAndReturnArgs>(args: SelectSubset<T, RoleUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, "updateManyAndReturn", GlobalOmitOptions>>

    /**
     * Create or update one Role.
     * @param {RoleUpsertArgs} args - Arguments to update or create a Role.
     * @example
     * // Update or create a Role
     * const role = await prisma.role.upsert({
     *   create: {
     *     // ... data to create a Role
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Role we want to update
     *   }
     * })
     */
    upsert<T extends RoleUpsertArgs>(args: SelectSubset<T, RoleUpsertArgs<ExtArgs>>): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Roles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleCountArgs} args - Arguments to filter Roles to count.
     * @example
     * // Count the number of Roles
     * const count = await prisma.role.count({
     *   where: {
     *     // ... the filter for the Roles we want to count
     *   }
     * })
    **/
    count<T extends RoleCountArgs>(
      args?: Subset<T, RoleCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], RoleCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Role.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends RoleAggregateArgs>(args: Subset<T, RoleAggregateArgs>): Prisma.PrismaPromise<GetRoleAggregateType<T>>

    /**
     * Group by Role.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends RoleGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: RoleGroupByArgs['orderBy'] }
        : { orderBy?: RoleGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, RoleGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetRoleGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Role model
   */
  readonly fields: RoleFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Role.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__RoleClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    realm<T extends RealmDefaultArgs<ExtArgs> = {}>(args?: Subset<T, RealmDefaultArgs<ExtArgs>>): Prisma__RealmClient<$Result.GetResult<Prisma.$RealmPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    client<T extends Role$clientArgs<ExtArgs> = {}>(args?: Subset<T, Role$clientArgs<ExtArgs>>): Prisma__ClientClient<$Result.GetResult<Prisma.$ClientPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>
    userLinks<T extends Role$userLinksArgs<ExtArgs> = {}>(args?: Subset<T, Role$userLinksArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserRolePayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Role model
   */
  interface RoleFieldRefs {
    readonly id: FieldRef<"Role", 'String'>
    readonly realm_id: FieldRef<"Role", 'String'>
    readonly client_id: FieldRef<"Role", 'String'>
    readonly name: FieldRef<"Role", 'String'>
    readonly description: FieldRef<"Role", 'String'>
    readonly is_client_role: FieldRef<"Role", 'Boolean'>
  }
    

  // Custom InputTypes
  /**
   * Role findUnique
   */
  export type RoleFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Role
     */
    omit?: RoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * Filter, which Role to fetch.
     */
    where: RoleWhereUniqueInput
  }

  /**
   * Role findUniqueOrThrow
   */
  export type RoleFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Role
     */
    omit?: RoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * Filter, which Role to fetch.
     */
    where: RoleWhereUniqueInput
  }

  /**
   * Role findFirst
   */
  export type RoleFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Role
     */
    omit?: RoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * Filter, which Role to fetch.
     */
    where?: RoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Roles to fetch.
     */
    orderBy?: RoleOrderByWithRelationInput | RoleOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Roles.
     */
    cursor?: RoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Roles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Roles.
     */
    distinct?: RoleScalarFieldEnum | RoleScalarFieldEnum[]
  }

  /**
   * Role findFirstOrThrow
   */
  export type RoleFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Role
     */
    omit?: RoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * Filter, which Role to fetch.
     */
    where?: RoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Roles to fetch.
     */
    orderBy?: RoleOrderByWithRelationInput | RoleOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Roles.
     */
    cursor?: RoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Roles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Roles.
     */
    distinct?: RoleScalarFieldEnum | RoleScalarFieldEnum[]
  }

  /**
   * Role findMany
   */
  export type RoleFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Role
     */
    omit?: RoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * Filter, which Roles to fetch.
     */
    where?: RoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Roles to fetch.
     */
    orderBy?: RoleOrderByWithRelationInput | RoleOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Roles.
     */
    cursor?: RoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Roles.
     */
    skip?: number
    distinct?: RoleScalarFieldEnum | RoleScalarFieldEnum[]
  }

  /**
   * Role create
   */
  export type RoleCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Role
     */
    omit?: RoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * The data needed to create a Role.
     */
    data: XOR<RoleCreateInput, RoleUncheckedCreateInput>
  }

  /**
   * Role createMany
   */
  export type RoleCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Roles.
     */
    data: RoleCreateManyInput | RoleCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Role createManyAndReturn
   */
  export type RoleCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Role
     */
    omit?: RoleOmit<ExtArgs> | null
    /**
     * The data used to create many Roles.
     */
    data: RoleCreateManyInput | RoleCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * Role update
   */
  export type RoleUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Role
     */
    omit?: RoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * The data needed to update a Role.
     */
    data: XOR<RoleUpdateInput, RoleUncheckedUpdateInput>
    /**
     * Choose, which Role to update.
     */
    where: RoleWhereUniqueInput
  }

  /**
   * Role updateMany
   */
  export type RoleUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Roles.
     */
    data: XOR<RoleUpdateManyMutationInput, RoleUncheckedUpdateManyInput>
    /**
     * Filter which Roles to update
     */
    where?: RoleWhereInput
    /**
     * Limit how many Roles to update.
     */
    limit?: number
  }

  /**
   * Role updateManyAndReturn
   */
  export type RoleUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Role
     */
    omit?: RoleOmit<ExtArgs> | null
    /**
     * The data used to update Roles.
     */
    data: XOR<RoleUpdateManyMutationInput, RoleUncheckedUpdateManyInput>
    /**
     * Filter which Roles to update
     */
    where?: RoleWhereInput
    /**
     * Limit how many Roles to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * Role upsert
   */
  export type RoleUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Role
     */
    omit?: RoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * The filter to search for the Role to update in case it exists.
     */
    where: RoleWhereUniqueInput
    /**
     * In case the Role found by the `where` argument doesn't exist, create a new Role with this data.
     */
    create: XOR<RoleCreateInput, RoleUncheckedCreateInput>
    /**
     * In case the Role was found with the provided `where` argument, update it with this data.
     */
    update: XOR<RoleUpdateInput, RoleUncheckedUpdateInput>
  }

  /**
   * Role delete
   */
  export type RoleDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Role
     */
    omit?: RoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * Filter which Role to delete.
     */
    where: RoleWhereUniqueInput
  }

  /**
   * Role deleteMany
   */
  export type RoleDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Roles to delete
     */
    where?: RoleWhereInput
    /**
     * Limit how many Roles to delete.
     */
    limit?: number
  }

  /**
   * Role.client
   */
  export type Role$clientArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Client
     */
    select?: ClientSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Client
     */
    omit?: ClientOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientInclude<ExtArgs> | null
    where?: ClientWhereInput
  }

  /**
   * Role.userLinks
   */
  export type Role$userLinksArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRole
     */
    select?: UserRoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserRole
     */
    omit?: UserRoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRoleInclude<ExtArgs> | null
    where?: UserRoleWhereInput
    orderBy?: UserRoleOrderByWithRelationInput | UserRoleOrderByWithRelationInput[]
    cursor?: UserRoleWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserRoleScalarFieldEnum | UserRoleScalarFieldEnum[]
  }

  /**
   * Role without action
   */
  export type RoleDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Role
     */
    omit?: RoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
  }


  /**
   * Model UserRole
   */

  export type AggregateUserRole = {
    _count: UserRoleCountAggregateOutputType | null
    _min: UserRoleMinAggregateOutputType | null
    _max: UserRoleMaxAggregateOutputType | null
  }

  export type UserRoleMinAggregateOutputType = {
    user_id: string | null
    role_id: string | null
  }

  export type UserRoleMaxAggregateOutputType = {
    user_id: string | null
    role_id: string | null
  }

  export type UserRoleCountAggregateOutputType = {
    user_id: number
    role_id: number
    _all: number
  }


  export type UserRoleMinAggregateInputType = {
    user_id?: true
    role_id?: true
  }

  export type UserRoleMaxAggregateInputType = {
    user_id?: true
    role_id?: true
  }

  export type UserRoleCountAggregateInputType = {
    user_id?: true
    role_id?: true
    _all?: true
  }

  export type UserRoleAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserRole to aggregate.
     */
    where?: UserRoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserRoles to fetch.
     */
    orderBy?: UserRoleOrderByWithRelationInput | UserRoleOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserRoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserRoles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserRoles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned UserRoles
    **/
    _count?: true | UserRoleCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserRoleMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserRoleMaxAggregateInputType
  }

  export type GetUserRoleAggregateType<T extends UserRoleAggregateArgs> = {
        [P in keyof T & keyof AggregateUserRole]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUserRole[P]>
      : GetScalarType<T[P], AggregateUserRole[P]>
  }




  export type UserRoleGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserRoleWhereInput
    orderBy?: UserRoleOrderByWithAggregationInput | UserRoleOrderByWithAggregationInput[]
    by: UserRoleScalarFieldEnum[] | UserRoleScalarFieldEnum
    having?: UserRoleScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserRoleCountAggregateInputType | true
    _min?: UserRoleMinAggregateInputType
    _max?: UserRoleMaxAggregateInputType
  }

  export type UserRoleGroupByOutputType = {
    user_id: string
    role_id: string
    _count: UserRoleCountAggregateOutputType | null
    _min: UserRoleMinAggregateOutputType | null
    _max: UserRoleMaxAggregateOutputType | null
  }

  type GetUserRoleGroupByPayload<T extends UserRoleGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserRoleGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserRoleGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserRoleGroupByOutputType[P]>
            : GetScalarType<T[P], UserRoleGroupByOutputType[P]>
        }
      >
    >


  export type UserRoleSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    user_id?: boolean
    role_id?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    role?: boolean | RoleDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userRole"]>

  export type UserRoleSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    user_id?: boolean
    role_id?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    role?: boolean | RoleDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userRole"]>

  export type UserRoleSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    user_id?: boolean
    role_id?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    role?: boolean | RoleDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userRole"]>

  export type UserRoleSelectScalar = {
    user_id?: boolean
    role_id?: boolean
  }

  export type UserRoleOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"user_id" | "role_id", ExtArgs["result"]["userRole"]>
  export type UserRoleInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    role?: boolean | RoleDefaultArgs<ExtArgs>
  }
  export type UserRoleIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    role?: boolean | RoleDefaultArgs<ExtArgs>
  }
  export type UserRoleIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    role?: boolean | RoleDefaultArgs<ExtArgs>
  }

  export type $UserRolePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "UserRole"
    objects: {
      user: Prisma.$UserPayload<ExtArgs>
      role: Prisma.$RolePayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      user_id: string
      role_id: string
    }, ExtArgs["result"]["userRole"]>
    composites: {}
  }

  type UserRoleGetPayload<S extends boolean | null | undefined | UserRoleDefaultArgs> = $Result.GetResult<Prisma.$UserRolePayload, S>

  type UserRoleCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<UserRoleFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: UserRoleCountAggregateInputType | true
    }

  export interface UserRoleDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['UserRole'], meta: { name: 'UserRole' } }
    /**
     * Find zero or one UserRole that matches the filter.
     * @param {UserRoleFindUniqueArgs} args - Arguments to find a UserRole
     * @example
     * // Get one UserRole
     * const userRole = await prisma.userRole.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends UserRoleFindUniqueArgs>(args: SelectSubset<T, UserRoleFindUniqueArgs<ExtArgs>>): Prisma__UserRoleClient<$Result.GetResult<Prisma.$UserRolePayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one UserRole that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {UserRoleFindUniqueOrThrowArgs} args - Arguments to find a UserRole
     * @example
     * // Get one UserRole
     * const userRole = await prisma.userRole.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends UserRoleFindUniqueOrThrowArgs>(args: SelectSubset<T, UserRoleFindUniqueOrThrowArgs<ExtArgs>>): Prisma__UserRoleClient<$Result.GetResult<Prisma.$UserRolePayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first UserRole that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRoleFindFirstArgs} args - Arguments to find a UserRole
     * @example
     * // Get one UserRole
     * const userRole = await prisma.userRole.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends UserRoleFindFirstArgs>(args?: SelectSubset<T, UserRoleFindFirstArgs<ExtArgs>>): Prisma__UserRoleClient<$Result.GetResult<Prisma.$UserRolePayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first UserRole that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRoleFindFirstOrThrowArgs} args - Arguments to find a UserRole
     * @example
     * // Get one UserRole
     * const userRole = await prisma.userRole.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends UserRoleFindFirstOrThrowArgs>(args?: SelectSubset<T, UserRoleFindFirstOrThrowArgs<ExtArgs>>): Prisma__UserRoleClient<$Result.GetResult<Prisma.$UserRolePayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more UserRoles that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRoleFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all UserRoles
     * const userRoles = await prisma.userRole.findMany()
     * 
     * // Get first 10 UserRoles
     * const userRoles = await prisma.userRole.findMany({ take: 10 })
     * 
     * // Only select the `user_id`
     * const userRoleWithUser_idOnly = await prisma.userRole.findMany({ select: { user_id: true } })
     * 
     */
    findMany<T extends UserRoleFindManyArgs>(args?: SelectSubset<T, UserRoleFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserRolePayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a UserRole.
     * @param {UserRoleCreateArgs} args - Arguments to create a UserRole.
     * @example
     * // Create one UserRole
     * const UserRole = await prisma.userRole.create({
     *   data: {
     *     // ... data to create a UserRole
     *   }
     * })
     * 
     */
    create<T extends UserRoleCreateArgs>(args: SelectSubset<T, UserRoleCreateArgs<ExtArgs>>): Prisma__UserRoleClient<$Result.GetResult<Prisma.$UserRolePayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many UserRoles.
     * @param {UserRoleCreateManyArgs} args - Arguments to create many UserRoles.
     * @example
     * // Create many UserRoles
     * const userRole = await prisma.userRole.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends UserRoleCreateManyArgs>(args?: SelectSubset<T, UserRoleCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many UserRoles and returns the data saved in the database.
     * @param {UserRoleCreateManyAndReturnArgs} args - Arguments to create many UserRoles.
     * @example
     * // Create many UserRoles
     * const userRole = await prisma.userRole.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many UserRoles and only return the `user_id`
     * const userRoleWithUser_idOnly = await prisma.userRole.createManyAndReturn({
     *   select: { user_id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends UserRoleCreateManyAndReturnArgs>(args?: SelectSubset<T, UserRoleCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserRolePayload<ExtArgs>, T, "createManyAndReturn", GlobalOmitOptions>>

    /**
     * Delete a UserRole.
     * @param {UserRoleDeleteArgs} args - Arguments to delete one UserRole.
     * @example
     * // Delete one UserRole
     * const UserRole = await prisma.userRole.delete({
     *   where: {
     *     // ... filter to delete one UserRole
     *   }
     * })
     * 
     */
    delete<T extends UserRoleDeleteArgs>(args: SelectSubset<T, UserRoleDeleteArgs<ExtArgs>>): Prisma__UserRoleClient<$Result.GetResult<Prisma.$UserRolePayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one UserRole.
     * @param {UserRoleUpdateArgs} args - Arguments to update one UserRole.
     * @example
     * // Update one UserRole
     * const userRole = await prisma.userRole.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends UserRoleUpdateArgs>(args: SelectSubset<T, UserRoleUpdateArgs<ExtArgs>>): Prisma__UserRoleClient<$Result.GetResult<Prisma.$UserRolePayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more UserRoles.
     * @param {UserRoleDeleteManyArgs} args - Arguments to filter UserRoles to delete.
     * @example
     * // Delete a few UserRoles
     * const { count } = await prisma.userRole.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends UserRoleDeleteManyArgs>(args?: SelectSubset<T, UserRoleDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserRoles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRoleUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many UserRoles
     * const userRole = await prisma.userRole.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends UserRoleUpdateManyArgs>(args: SelectSubset<T, UserRoleUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserRoles and returns the data updated in the database.
     * @param {UserRoleUpdateManyAndReturnArgs} args - Arguments to update many UserRoles.
     * @example
     * // Update many UserRoles
     * const userRole = await prisma.userRole.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more UserRoles and only return the `user_id`
     * const userRoleWithUser_idOnly = await prisma.userRole.updateManyAndReturn({
     *   select: { user_id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends UserRoleUpdateManyAndReturnArgs>(args: SelectSubset<T, UserRoleUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserRolePayload<ExtArgs>, T, "updateManyAndReturn", GlobalOmitOptions>>

    /**
     * Create or update one UserRole.
     * @param {UserRoleUpsertArgs} args - Arguments to update or create a UserRole.
     * @example
     * // Update or create a UserRole
     * const userRole = await prisma.userRole.upsert({
     *   create: {
     *     // ... data to create a UserRole
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the UserRole we want to update
     *   }
     * })
     */
    upsert<T extends UserRoleUpsertArgs>(args: SelectSubset<T, UserRoleUpsertArgs<ExtArgs>>): Prisma__UserRoleClient<$Result.GetResult<Prisma.$UserRolePayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of UserRoles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRoleCountArgs} args - Arguments to filter UserRoles to count.
     * @example
     * // Count the number of UserRoles
     * const count = await prisma.userRole.count({
     *   where: {
     *     // ... the filter for the UserRoles we want to count
     *   }
     * })
    **/
    count<T extends UserRoleCountArgs>(
      args?: Subset<T, UserRoleCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserRoleCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a UserRole.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRoleAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserRoleAggregateArgs>(args: Subset<T, UserRoleAggregateArgs>): Prisma.PrismaPromise<GetUserRoleAggregateType<T>>

    /**
     * Group by UserRole.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRoleGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserRoleGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserRoleGroupByArgs['orderBy'] }
        : { orderBy?: UserRoleGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserRoleGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserRoleGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the UserRole model
   */
  readonly fields: UserRoleFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for UserRole.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserRoleClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    user<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    role<T extends RoleDefaultArgs<ExtArgs> = {}>(args?: Subset<T, RoleDefaultArgs<ExtArgs>>): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the UserRole model
   */
  interface UserRoleFieldRefs {
    readonly user_id: FieldRef<"UserRole", 'String'>
    readonly role_id: FieldRef<"UserRole", 'String'>
  }
    

  // Custom InputTypes
  /**
   * UserRole findUnique
   */
  export type UserRoleFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRole
     */
    select?: UserRoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserRole
     */
    omit?: UserRoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRoleInclude<ExtArgs> | null
    /**
     * Filter, which UserRole to fetch.
     */
    where: UserRoleWhereUniqueInput
  }

  /**
   * UserRole findUniqueOrThrow
   */
  export type UserRoleFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRole
     */
    select?: UserRoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserRole
     */
    omit?: UserRoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRoleInclude<ExtArgs> | null
    /**
     * Filter, which UserRole to fetch.
     */
    where: UserRoleWhereUniqueInput
  }

  /**
   * UserRole findFirst
   */
  export type UserRoleFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRole
     */
    select?: UserRoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserRole
     */
    omit?: UserRoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRoleInclude<ExtArgs> | null
    /**
     * Filter, which UserRole to fetch.
     */
    where?: UserRoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserRoles to fetch.
     */
    orderBy?: UserRoleOrderByWithRelationInput | UserRoleOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserRoles.
     */
    cursor?: UserRoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserRoles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserRoles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserRoles.
     */
    distinct?: UserRoleScalarFieldEnum | UserRoleScalarFieldEnum[]
  }

  /**
   * UserRole findFirstOrThrow
   */
  export type UserRoleFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRole
     */
    select?: UserRoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserRole
     */
    omit?: UserRoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRoleInclude<ExtArgs> | null
    /**
     * Filter, which UserRole to fetch.
     */
    where?: UserRoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserRoles to fetch.
     */
    orderBy?: UserRoleOrderByWithRelationInput | UserRoleOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserRoles.
     */
    cursor?: UserRoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserRoles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserRoles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserRoles.
     */
    distinct?: UserRoleScalarFieldEnum | UserRoleScalarFieldEnum[]
  }

  /**
   * UserRole findMany
   */
  export type UserRoleFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRole
     */
    select?: UserRoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserRole
     */
    omit?: UserRoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRoleInclude<ExtArgs> | null
    /**
     * Filter, which UserRoles to fetch.
     */
    where?: UserRoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserRoles to fetch.
     */
    orderBy?: UserRoleOrderByWithRelationInput | UserRoleOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing UserRoles.
     */
    cursor?: UserRoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserRoles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserRoles.
     */
    skip?: number
    distinct?: UserRoleScalarFieldEnum | UserRoleScalarFieldEnum[]
  }

  /**
   * UserRole create
   */
  export type UserRoleCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRole
     */
    select?: UserRoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserRole
     */
    omit?: UserRoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRoleInclude<ExtArgs> | null
    /**
     * The data needed to create a UserRole.
     */
    data: XOR<UserRoleCreateInput, UserRoleUncheckedCreateInput>
  }

  /**
   * UserRole createMany
   */
  export type UserRoleCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many UserRoles.
     */
    data: UserRoleCreateManyInput | UserRoleCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * UserRole createManyAndReturn
   */
  export type UserRoleCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRole
     */
    select?: UserRoleSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the UserRole
     */
    omit?: UserRoleOmit<ExtArgs> | null
    /**
     * The data used to create many UserRoles.
     */
    data: UserRoleCreateManyInput | UserRoleCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRoleIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * UserRole update
   */
  export type UserRoleUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRole
     */
    select?: UserRoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserRole
     */
    omit?: UserRoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRoleInclude<ExtArgs> | null
    /**
     * The data needed to update a UserRole.
     */
    data: XOR<UserRoleUpdateInput, UserRoleUncheckedUpdateInput>
    /**
     * Choose, which UserRole to update.
     */
    where: UserRoleWhereUniqueInput
  }

  /**
   * UserRole updateMany
   */
  export type UserRoleUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update UserRoles.
     */
    data: XOR<UserRoleUpdateManyMutationInput, UserRoleUncheckedUpdateManyInput>
    /**
     * Filter which UserRoles to update
     */
    where?: UserRoleWhereInput
    /**
     * Limit how many UserRoles to update.
     */
    limit?: number
  }

  /**
   * UserRole updateManyAndReturn
   */
  export type UserRoleUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRole
     */
    select?: UserRoleSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the UserRole
     */
    omit?: UserRoleOmit<ExtArgs> | null
    /**
     * The data used to update UserRoles.
     */
    data: XOR<UserRoleUpdateManyMutationInput, UserRoleUncheckedUpdateManyInput>
    /**
     * Filter which UserRoles to update
     */
    where?: UserRoleWhereInput
    /**
     * Limit how many UserRoles to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRoleIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * UserRole upsert
   */
  export type UserRoleUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRole
     */
    select?: UserRoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserRole
     */
    omit?: UserRoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRoleInclude<ExtArgs> | null
    /**
     * The filter to search for the UserRole to update in case it exists.
     */
    where: UserRoleWhereUniqueInput
    /**
     * In case the UserRole found by the `where` argument doesn't exist, create a new UserRole with this data.
     */
    create: XOR<UserRoleCreateInput, UserRoleUncheckedCreateInput>
    /**
     * In case the UserRole was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserRoleUpdateInput, UserRoleUncheckedUpdateInput>
  }

  /**
   * UserRole delete
   */
  export type UserRoleDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRole
     */
    select?: UserRoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserRole
     */
    omit?: UserRoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRoleInclude<ExtArgs> | null
    /**
     * Filter which UserRole to delete.
     */
    where: UserRoleWhereUniqueInput
  }

  /**
   * UserRole deleteMany
   */
  export type UserRoleDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserRoles to delete
     */
    where?: UserRoleWhereInput
    /**
     * Limit how many UserRoles to delete.
     */
    limit?: number
  }

  /**
   * UserRole without action
   */
  export type UserRoleDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRole
     */
    select?: UserRoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserRole
     */
    omit?: UserRoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRoleInclude<ExtArgs> | null
  }


  /**
   * Model Client
   */

  export type AggregateClient = {
    _count: ClientCountAggregateOutputType | null
    _avg: ClientAvgAggregateOutputType | null
    _sum: ClientSumAggregateOutputType | null
    _min: ClientMinAggregateOutputType | null
    _max: ClientMaxAggregateOutputType | null
  }

  export type ClientAvgAggregateOutputType = {
    access_token_life: number | null
    refresh_token_life: number | null
  }

  export type ClientSumAggregateOutputType = {
    access_token_life: number | null
    refresh_token_life: number | null
  }

  export type ClientMinAggregateOutputType = {
    id: string | null
    realm_id: string | null
    client_id: string | null
    client_name: string | null
    client_secret_hash: string | null
    access_token_life: number | null
    refresh_token_life: number | null
    created_at: Date | null
  }

  export type ClientMaxAggregateOutputType = {
    id: string | null
    realm_id: string | null
    client_id: string | null
    client_name: string | null
    client_secret_hash: string | null
    access_token_life: number | null
    refresh_token_life: number | null
    created_at: Date | null
  }

  export type ClientCountAggregateOutputType = {
    id: number
    realm_id: number
    client_id: number
    client_name: number
    client_secret_hash: number
    redirect_uris: number
    grant_types: number
    access_token_life: number
    refresh_token_life: number
    created_at: number
    _all: number
  }


  export type ClientAvgAggregateInputType = {
    access_token_life?: true
    refresh_token_life?: true
  }

  export type ClientSumAggregateInputType = {
    access_token_life?: true
    refresh_token_life?: true
  }

  export type ClientMinAggregateInputType = {
    id?: true
    realm_id?: true
    client_id?: true
    client_name?: true
    client_secret_hash?: true
    access_token_life?: true
    refresh_token_life?: true
    created_at?: true
  }

  export type ClientMaxAggregateInputType = {
    id?: true
    realm_id?: true
    client_id?: true
    client_name?: true
    client_secret_hash?: true
    access_token_life?: true
    refresh_token_life?: true
    created_at?: true
  }

  export type ClientCountAggregateInputType = {
    id?: true
    realm_id?: true
    client_id?: true
    client_name?: true
    client_secret_hash?: true
    redirect_uris?: true
    grant_types?: true
    access_token_life?: true
    refresh_token_life?: true
    created_at?: true
    _all?: true
  }

  export type ClientAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Client to aggregate.
     */
    where?: ClientWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Clients to fetch.
     */
    orderBy?: ClientOrderByWithRelationInput | ClientOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ClientWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Clients from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Clients.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Clients
    **/
    _count?: true | ClientCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ClientAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ClientSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ClientMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ClientMaxAggregateInputType
  }

  export type GetClientAggregateType<T extends ClientAggregateArgs> = {
        [P in keyof T & keyof AggregateClient]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateClient[P]>
      : GetScalarType<T[P], AggregateClient[P]>
  }




  export type ClientGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ClientWhereInput
    orderBy?: ClientOrderByWithAggregationInput | ClientOrderByWithAggregationInput[]
    by: ClientScalarFieldEnum[] | ClientScalarFieldEnum
    having?: ClientScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ClientCountAggregateInputType | true
    _avg?: ClientAvgAggregateInputType
    _sum?: ClientSumAggregateInputType
    _min?: ClientMinAggregateInputType
    _max?: ClientMaxAggregateInputType
  }

  export type ClientGroupByOutputType = {
    id: string
    realm_id: string
    client_id: string
    client_name: string | null
    client_secret_hash: string
    redirect_uris: string[]
    grant_types: string[]
    access_token_life: number
    refresh_token_life: number
    created_at: Date
    _count: ClientCountAggregateOutputType | null
    _avg: ClientAvgAggregateOutputType | null
    _sum: ClientSumAggregateOutputType | null
    _min: ClientMinAggregateOutputType | null
    _max: ClientMaxAggregateOutputType | null
  }

  type GetClientGroupByPayload<T extends ClientGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ClientGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ClientGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ClientGroupByOutputType[P]>
            : GetScalarType<T[P], ClientGroupByOutputType[P]>
        }
      >
    >


  export type ClientSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    realm_id?: boolean
    client_id?: boolean
    client_name?: boolean
    client_secret_hash?: boolean
    redirect_uris?: boolean
    grant_types?: boolean
    access_token_life?: boolean
    refresh_token_life?: boolean
    created_at?: boolean
    realm?: boolean | RealmDefaultArgs<ExtArgs>
    roles?: boolean | Client$rolesArgs<ExtArgs>
    scopes?: boolean | Client$scopesArgs<ExtArgs>
    userSessions?: boolean | Client$userSessionsArgs<ExtArgs>
    tokens?: boolean | Client$tokensArgs<ExtArgs>
    authorizationCodes?: boolean | Client$authorizationCodesArgs<ExtArgs>
    _count?: boolean | ClientCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["client"]>

  export type ClientSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    realm_id?: boolean
    client_id?: boolean
    client_name?: boolean
    client_secret_hash?: boolean
    redirect_uris?: boolean
    grant_types?: boolean
    access_token_life?: boolean
    refresh_token_life?: boolean
    created_at?: boolean
    realm?: boolean | RealmDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["client"]>

  export type ClientSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    realm_id?: boolean
    client_id?: boolean
    client_name?: boolean
    client_secret_hash?: boolean
    redirect_uris?: boolean
    grant_types?: boolean
    access_token_life?: boolean
    refresh_token_life?: boolean
    created_at?: boolean
    realm?: boolean | RealmDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["client"]>

  export type ClientSelectScalar = {
    id?: boolean
    realm_id?: boolean
    client_id?: boolean
    client_name?: boolean
    client_secret_hash?: boolean
    redirect_uris?: boolean
    grant_types?: boolean
    access_token_life?: boolean
    refresh_token_life?: boolean
    created_at?: boolean
  }

  export type ClientOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "realm_id" | "client_id" | "client_name" | "client_secret_hash" | "redirect_uris" | "grant_types" | "access_token_life" | "refresh_token_life" | "created_at", ExtArgs["result"]["client"]>
  export type ClientInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    realm?: boolean | RealmDefaultArgs<ExtArgs>
    roles?: boolean | Client$rolesArgs<ExtArgs>
    scopes?: boolean | Client$scopesArgs<ExtArgs>
    userSessions?: boolean | Client$userSessionsArgs<ExtArgs>
    tokens?: boolean | Client$tokensArgs<ExtArgs>
    authorizationCodes?: boolean | Client$authorizationCodesArgs<ExtArgs>
    _count?: boolean | ClientCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type ClientIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    realm?: boolean | RealmDefaultArgs<ExtArgs>
  }
  export type ClientIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    realm?: boolean | RealmDefaultArgs<ExtArgs>
  }

  export type $ClientPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Client"
    objects: {
      realm: Prisma.$RealmPayload<ExtArgs>
      roles: Prisma.$RolePayload<ExtArgs>[]
      scopes: Prisma.$ClientScopePayload<ExtArgs>[]
      userSessions: Prisma.$UserSessionPayload<ExtArgs>[]
      tokens: Prisma.$TokenPayload<ExtArgs>[]
      authorizationCodes: Prisma.$AuthorizationCodePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      realm_id: string
      client_id: string
      client_name: string | null
      client_secret_hash: string
      redirect_uris: string[]
      grant_types: string[]
      access_token_life: number
      refresh_token_life: number
      created_at: Date
    }, ExtArgs["result"]["client"]>
    composites: {}
  }

  type ClientGetPayload<S extends boolean | null | undefined | ClientDefaultArgs> = $Result.GetResult<Prisma.$ClientPayload, S>

  type ClientCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ClientFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ClientCountAggregateInputType | true
    }

  export interface ClientDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Client'], meta: { name: 'Client' } }
    /**
     * Find zero or one Client that matches the filter.
     * @param {ClientFindUniqueArgs} args - Arguments to find a Client
     * @example
     * // Get one Client
     * const client = await prisma.client.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ClientFindUniqueArgs>(args: SelectSubset<T, ClientFindUniqueArgs<ExtArgs>>): Prisma__ClientClient<$Result.GetResult<Prisma.$ClientPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Client that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ClientFindUniqueOrThrowArgs} args - Arguments to find a Client
     * @example
     * // Get one Client
     * const client = await prisma.client.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ClientFindUniqueOrThrowArgs>(args: SelectSubset<T, ClientFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ClientClient<$Result.GetResult<Prisma.$ClientPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Client that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ClientFindFirstArgs} args - Arguments to find a Client
     * @example
     * // Get one Client
     * const client = await prisma.client.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ClientFindFirstArgs>(args?: SelectSubset<T, ClientFindFirstArgs<ExtArgs>>): Prisma__ClientClient<$Result.GetResult<Prisma.$ClientPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Client that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ClientFindFirstOrThrowArgs} args - Arguments to find a Client
     * @example
     * // Get one Client
     * const client = await prisma.client.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ClientFindFirstOrThrowArgs>(args?: SelectSubset<T, ClientFindFirstOrThrowArgs<ExtArgs>>): Prisma__ClientClient<$Result.GetResult<Prisma.$ClientPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Clients that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ClientFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Clients
     * const clients = await prisma.client.findMany()
     * 
     * // Get first 10 Clients
     * const clients = await prisma.client.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const clientWithIdOnly = await prisma.client.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ClientFindManyArgs>(args?: SelectSubset<T, ClientFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ClientPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Client.
     * @param {ClientCreateArgs} args - Arguments to create a Client.
     * @example
     * // Create one Client
     * const Client = await prisma.client.create({
     *   data: {
     *     // ... data to create a Client
     *   }
     * })
     * 
     */
    create<T extends ClientCreateArgs>(args: SelectSubset<T, ClientCreateArgs<ExtArgs>>): Prisma__ClientClient<$Result.GetResult<Prisma.$ClientPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Clients.
     * @param {ClientCreateManyArgs} args - Arguments to create many Clients.
     * @example
     * // Create many Clients
     * const client = await prisma.client.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ClientCreateManyArgs>(args?: SelectSubset<T, ClientCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Clients and returns the data saved in the database.
     * @param {ClientCreateManyAndReturnArgs} args - Arguments to create many Clients.
     * @example
     * // Create many Clients
     * const client = await prisma.client.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Clients and only return the `id`
     * const clientWithIdOnly = await prisma.client.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends ClientCreateManyAndReturnArgs>(args?: SelectSubset<T, ClientCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ClientPayload<ExtArgs>, T, "createManyAndReturn", GlobalOmitOptions>>

    /**
     * Delete a Client.
     * @param {ClientDeleteArgs} args - Arguments to delete one Client.
     * @example
     * // Delete one Client
     * const Client = await prisma.client.delete({
     *   where: {
     *     // ... filter to delete one Client
     *   }
     * })
     * 
     */
    delete<T extends ClientDeleteArgs>(args: SelectSubset<T, ClientDeleteArgs<ExtArgs>>): Prisma__ClientClient<$Result.GetResult<Prisma.$ClientPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Client.
     * @param {ClientUpdateArgs} args - Arguments to update one Client.
     * @example
     * // Update one Client
     * const client = await prisma.client.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ClientUpdateArgs>(args: SelectSubset<T, ClientUpdateArgs<ExtArgs>>): Prisma__ClientClient<$Result.GetResult<Prisma.$ClientPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Clients.
     * @param {ClientDeleteManyArgs} args - Arguments to filter Clients to delete.
     * @example
     * // Delete a few Clients
     * const { count } = await prisma.client.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ClientDeleteManyArgs>(args?: SelectSubset<T, ClientDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Clients.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ClientUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Clients
     * const client = await prisma.client.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ClientUpdateManyArgs>(args: SelectSubset<T, ClientUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Clients and returns the data updated in the database.
     * @param {ClientUpdateManyAndReturnArgs} args - Arguments to update many Clients.
     * @example
     * // Update many Clients
     * const client = await prisma.client.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Clients and only return the `id`
     * const clientWithIdOnly = await prisma.client.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends ClientUpdateManyAndReturnArgs>(args: SelectSubset<T, ClientUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ClientPayload<ExtArgs>, T, "updateManyAndReturn", GlobalOmitOptions>>

    /**
     * Create or update one Client.
     * @param {ClientUpsertArgs} args - Arguments to update or create a Client.
     * @example
     * // Update or create a Client
     * const client = await prisma.client.upsert({
     *   create: {
     *     // ... data to create a Client
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Client we want to update
     *   }
     * })
     */
    upsert<T extends ClientUpsertArgs>(args: SelectSubset<T, ClientUpsertArgs<ExtArgs>>): Prisma__ClientClient<$Result.GetResult<Prisma.$ClientPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Clients.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ClientCountArgs} args - Arguments to filter Clients to count.
     * @example
     * // Count the number of Clients
     * const count = await prisma.client.count({
     *   where: {
     *     // ... the filter for the Clients we want to count
     *   }
     * })
    **/
    count<T extends ClientCountArgs>(
      args?: Subset<T, ClientCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ClientCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Client.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ClientAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ClientAggregateArgs>(args: Subset<T, ClientAggregateArgs>): Prisma.PrismaPromise<GetClientAggregateType<T>>

    /**
     * Group by Client.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ClientGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ClientGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ClientGroupByArgs['orderBy'] }
        : { orderBy?: ClientGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ClientGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetClientGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Client model
   */
  readonly fields: ClientFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Client.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ClientClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    realm<T extends RealmDefaultArgs<ExtArgs> = {}>(args?: Subset<T, RealmDefaultArgs<ExtArgs>>): Prisma__RealmClient<$Result.GetResult<Prisma.$RealmPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    roles<T extends Client$rolesArgs<ExtArgs> = {}>(args?: Subset<T, Client$rolesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    scopes<T extends Client$scopesArgs<ExtArgs> = {}>(args?: Subset<T, Client$scopesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ClientScopePayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    userSessions<T extends Client$userSessionsArgs<ExtArgs> = {}>(args?: Subset<T, Client$userSessionsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserSessionPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    tokens<T extends Client$tokensArgs<ExtArgs> = {}>(args?: Subset<T, Client$tokensArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TokenPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    authorizationCodes<T extends Client$authorizationCodesArgs<ExtArgs> = {}>(args?: Subset<T, Client$authorizationCodesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AuthorizationCodePayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Client model
   */
  interface ClientFieldRefs {
    readonly id: FieldRef<"Client", 'String'>
    readonly realm_id: FieldRef<"Client", 'String'>
    readonly client_id: FieldRef<"Client", 'String'>
    readonly client_name: FieldRef<"Client", 'String'>
    readonly client_secret_hash: FieldRef<"Client", 'String'>
    readonly redirect_uris: FieldRef<"Client", 'String[]'>
    readonly grant_types: FieldRef<"Client", 'String[]'>
    readonly access_token_life: FieldRef<"Client", 'Int'>
    readonly refresh_token_life: FieldRef<"Client", 'Int'>
    readonly created_at: FieldRef<"Client", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Client findUnique
   */
  export type ClientFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Client
     */
    select?: ClientSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Client
     */
    omit?: ClientOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientInclude<ExtArgs> | null
    /**
     * Filter, which Client to fetch.
     */
    where: ClientWhereUniqueInput
  }

  /**
   * Client findUniqueOrThrow
   */
  export type ClientFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Client
     */
    select?: ClientSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Client
     */
    omit?: ClientOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientInclude<ExtArgs> | null
    /**
     * Filter, which Client to fetch.
     */
    where: ClientWhereUniqueInput
  }

  /**
   * Client findFirst
   */
  export type ClientFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Client
     */
    select?: ClientSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Client
     */
    omit?: ClientOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientInclude<ExtArgs> | null
    /**
     * Filter, which Client to fetch.
     */
    where?: ClientWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Clients to fetch.
     */
    orderBy?: ClientOrderByWithRelationInput | ClientOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Clients.
     */
    cursor?: ClientWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Clients from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Clients.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Clients.
     */
    distinct?: ClientScalarFieldEnum | ClientScalarFieldEnum[]
  }

  /**
   * Client findFirstOrThrow
   */
  export type ClientFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Client
     */
    select?: ClientSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Client
     */
    omit?: ClientOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientInclude<ExtArgs> | null
    /**
     * Filter, which Client to fetch.
     */
    where?: ClientWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Clients to fetch.
     */
    orderBy?: ClientOrderByWithRelationInput | ClientOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Clients.
     */
    cursor?: ClientWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Clients from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Clients.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Clients.
     */
    distinct?: ClientScalarFieldEnum | ClientScalarFieldEnum[]
  }

  /**
   * Client findMany
   */
  export type ClientFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Client
     */
    select?: ClientSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Client
     */
    omit?: ClientOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientInclude<ExtArgs> | null
    /**
     * Filter, which Clients to fetch.
     */
    where?: ClientWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Clients to fetch.
     */
    orderBy?: ClientOrderByWithRelationInput | ClientOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Clients.
     */
    cursor?: ClientWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Clients from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Clients.
     */
    skip?: number
    distinct?: ClientScalarFieldEnum | ClientScalarFieldEnum[]
  }

  /**
   * Client create
   */
  export type ClientCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Client
     */
    select?: ClientSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Client
     */
    omit?: ClientOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientInclude<ExtArgs> | null
    /**
     * The data needed to create a Client.
     */
    data: XOR<ClientCreateInput, ClientUncheckedCreateInput>
  }

  /**
   * Client createMany
   */
  export type ClientCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Clients.
     */
    data: ClientCreateManyInput | ClientCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Client createManyAndReturn
   */
  export type ClientCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Client
     */
    select?: ClientSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Client
     */
    omit?: ClientOmit<ExtArgs> | null
    /**
     * The data used to create many Clients.
     */
    data: ClientCreateManyInput | ClientCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * Client update
   */
  export type ClientUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Client
     */
    select?: ClientSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Client
     */
    omit?: ClientOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientInclude<ExtArgs> | null
    /**
     * The data needed to update a Client.
     */
    data: XOR<ClientUpdateInput, ClientUncheckedUpdateInput>
    /**
     * Choose, which Client to update.
     */
    where: ClientWhereUniqueInput
  }

  /**
   * Client updateMany
   */
  export type ClientUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Clients.
     */
    data: XOR<ClientUpdateManyMutationInput, ClientUncheckedUpdateManyInput>
    /**
     * Filter which Clients to update
     */
    where?: ClientWhereInput
    /**
     * Limit how many Clients to update.
     */
    limit?: number
  }

  /**
   * Client updateManyAndReturn
   */
  export type ClientUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Client
     */
    select?: ClientSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Client
     */
    omit?: ClientOmit<ExtArgs> | null
    /**
     * The data used to update Clients.
     */
    data: XOR<ClientUpdateManyMutationInput, ClientUncheckedUpdateManyInput>
    /**
     * Filter which Clients to update
     */
    where?: ClientWhereInput
    /**
     * Limit how many Clients to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * Client upsert
   */
  export type ClientUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Client
     */
    select?: ClientSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Client
     */
    omit?: ClientOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientInclude<ExtArgs> | null
    /**
     * The filter to search for the Client to update in case it exists.
     */
    where: ClientWhereUniqueInput
    /**
     * In case the Client found by the `where` argument doesn't exist, create a new Client with this data.
     */
    create: XOR<ClientCreateInput, ClientUncheckedCreateInput>
    /**
     * In case the Client was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ClientUpdateInput, ClientUncheckedUpdateInput>
  }

  /**
   * Client delete
   */
  export type ClientDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Client
     */
    select?: ClientSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Client
     */
    omit?: ClientOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientInclude<ExtArgs> | null
    /**
     * Filter which Client to delete.
     */
    where: ClientWhereUniqueInput
  }

  /**
   * Client deleteMany
   */
  export type ClientDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Clients to delete
     */
    where?: ClientWhereInput
    /**
     * Limit how many Clients to delete.
     */
    limit?: number
  }

  /**
   * Client.roles
   */
  export type Client$rolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Role
     */
    omit?: RoleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    where?: RoleWhereInput
    orderBy?: RoleOrderByWithRelationInput | RoleOrderByWithRelationInput[]
    cursor?: RoleWhereUniqueInput
    take?: number
    skip?: number
    distinct?: RoleScalarFieldEnum | RoleScalarFieldEnum[]
  }

  /**
   * Client.scopes
   */
  export type Client$scopesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ClientScope
     */
    select?: ClientScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ClientScope
     */
    omit?: ClientScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientScopeInclude<ExtArgs> | null
    where?: ClientScopeWhereInput
    orderBy?: ClientScopeOrderByWithRelationInput | ClientScopeOrderByWithRelationInput[]
    cursor?: ClientScopeWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ClientScopeScalarFieldEnum | ClientScopeScalarFieldEnum[]
  }

  /**
   * Client.userSessions
   */
  export type Client$userSessionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserSession
     */
    select?: UserSessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserSession
     */
    omit?: UserSessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserSessionInclude<ExtArgs> | null
    where?: UserSessionWhereInput
    orderBy?: UserSessionOrderByWithRelationInput | UserSessionOrderByWithRelationInput[]
    cursor?: UserSessionWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserSessionScalarFieldEnum | UserSessionScalarFieldEnum[]
  }

  /**
   * Client.tokens
   */
  export type Client$tokensArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Token
     */
    select?: TokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Token
     */
    omit?: TokenOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TokenInclude<ExtArgs> | null
    where?: TokenWhereInput
    orderBy?: TokenOrderByWithRelationInput | TokenOrderByWithRelationInput[]
    cursor?: TokenWhereUniqueInput
    take?: number
    skip?: number
    distinct?: TokenScalarFieldEnum | TokenScalarFieldEnum[]
  }

  /**
   * Client.authorizationCodes
   */
  export type Client$authorizationCodesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuthorizationCode
     */
    select?: AuthorizationCodeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuthorizationCode
     */
    omit?: AuthorizationCodeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuthorizationCodeInclude<ExtArgs> | null
    where?: AuthorizationCodeWhereInput
    orderBy?: AuthorizationCodeOrderByWithRelationInput | AuthorizationCodeOrderByWithRelationInput[]
    cursor?: AuthorizationCodeWhereUniqueInput
    take?: number
    skip?: number
    distinct?: AuthorizationCodeScalarFieldEnum | AuthorizationCodeScalarFieldEnum[]
  }

  /**
   * Client without action
   */
  export type ClientDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Client
     */
    select?: ClientSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Client
     */
    omit?: ClientOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientInclude<ExtArgs> | null
  }


  /**
   * Model Scope
   */

  export type AggregateScope = {
    _count: ScopeCountAggregateOutputType | null
    _min: ScopeMinAggregateOutputType | null
    _max: ScopeMaxAggregateOutputType | null
  }

  export type ScopeMinAggregateOutputType = {
    id: string | null
    realm_id: string | null
    name: string | null
    description: string | null
  }

  export type ScopeMaxAggregateOutputType = {
    id: string | null
    realm_id: string | null
    name: string | null
    description: string | null
  }

  export type ScopeCountAggregateOutputType = {
    id: number
    realm_id: number
    name: number
    description: number
    _all: number
  }


  export type ScopeMinAggregateInputType = {
    id?: true
    realm_id?: true
    name?: true
    description?: true
  }

  export type ScopeMaxAggregateInputType = {
    id?: true
    realm_id?: true
    name?: true
    description?: true
  }

  export type ScopeCountAggregateInputType = {
    id?: true
    realm_id?: true
    name?: true
    description?: true
    _all?: true
  }

  export type ScopeAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Scope to aggregate.
     */
    where?: ScopeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Scopes to fetch.
     */
    orderBy?: ScopeOrderByWithRelationInput | ScopeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ScopeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Scopes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Scopes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Scopes
    **/
    _count?: true | ScopeCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ScopeMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ScopeMaxAggregateInputType
  }

  export type GetScopeAggregateType<T extends ScopeAggregateArgs> = {
        [P in keyof T & keyof AggregateScope]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateScope[P]>
      : GetScalarType<T[P], AggregateScope[P]>
  }




  export type ScopeGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ScopeWhereInput
    orderBy?: ScopeOrderByWithAggregationInput | ScopeOrderByWithAggregationInput[]
    by: ScopeScalarFieldEnum[] | ScopeScalarFieldEnum
    having?: ScopeScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ScopeCountAggregateInputType | true
    _min?: ScopeMinAggregateInputType
    _max?: ScopeMaxAggregateInputType
  }

  export type ScopeGroupByOutputType = {
    id: string
    realm_id: string
    name: string
    description: string | null
    _count: ScopeCountAggregateOutputType | null
    _min: ScopeMinAggregateOutputType | null
    _max: ScopeMaxAggregateOutputType | null
  }

  type GetScopeGroupByPayload<T extends ScopeGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ScopeGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ScopeGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ScopeGroupByOutputType[P]>
            : GetScalarType<T[P], ScopeGroupByOutputType[P]>
        }
      >
    >


  export type ScopeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    realm_id?: boolean
    name?: boolean
    description?: boolean
    realm?: boolean | RealmDefaultArgs<ExtArgs>
    clients?: boolean | Scope$clientsArgs<ExtArgs>
    _count?: boolean | ScopeCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["scope"]>

  export type ScopeSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    realm_id?: boolean
    name?: boolean
    description?: boolean
    realm?: boolean | RealmDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["scope"]>

  export type ScopeSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    realm_id?: boolean
    name?: boolean
    description?: boolean
    realm?: boolean | RealmDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["scope"]>

  export type ScopeSelectScalar = {
    id?: boolean
    realm_id?: boolean
    name?: boolean
    description?: boolean
  }

  export type ScopeOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "realm_id" | "name" | "description", ExtArgs["result"]["scope"]>
  export type ScopeInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    realm?: boolean | RealmDefaultArgs<ExtArgs>
    clients?: boolean | Scope$clientsArgs<ExtArgs>
    _count?: boolean | ScopeCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type ScopeIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    realm?: boolean | RealmDefaultArgs<ExtArgs>
  }
  export type ScopeIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    realm?: boolean | RealmDefaultArgs<ExtArgs>
  }

  export type $ScopePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Scope"
    objects: {
      realm: Prisma.$RealmPayload<ExtArgs>
      clients: Prisma.$ClientScopePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      realm_id: string
      name: string
      description: string | null
    }, ExtArgs["result"]["scope"]>
    composites: {}
  }

  type ScopeGetPayload<S extends boolean | null | undefined | ScopeDefaultArgs> = $Result.GetResult<Prisma.$ScopePayload, S>

  type ScopeCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ScopeFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ScopeCountAggregateInputType | true
    }

  export interface ScopeDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Scope'], meta: { name: 'Scope' } }
    /**
     * Find zero or one Scope that matches the filter.
     * @param {ScopeFindUniqueArgs} args - Arguments to find a Scope
     * @example
     * // Get one Scope
     * const scope = await prisma.scope.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ScopeFindUniqueArgs>(args: SelectSubset<T, ScopeFindUniqueArgs<ExtArgs>>): Prisma__ScopeClient<$Result.GetResult<Prisma.$ScopePayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Scope that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ScopeFindUniqueOrThrowArgs} args - Arguments to find a Scope
     * @example
     * // Get one Scope
     * const scope = await prisma.scope.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ScopeFindUniqueOrThrowArgs>(args: SelectSubset<T, ScopeFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ScopeClient<$Result.GetResult<Prisma.$ScopePayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Scope that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ScopeFindFirstArgs} args - Arguments to find a Scope
     * @example
     * // Get one Scope
     * const scope = await prisma.scope.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ScopeFindFirstArgs>(args?: SelectSubset<T, ScopeFindFirstArgs<ExtArgs>>): Prisma__ScopeClient<$Result.GetResult<Prisma.$ScopePayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Scope that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ScopeFindFirstOrThrowArgs} args - Arguments to find a Scope
     * @example
     * // Get one Scope
     * const scope = await prisma.scope.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ScopeFindFirstOrThrowArgs>(args?: SelectSubset<T, ScopeFindFirstOrThrowArgs<ExtArgs>>): Prisma__ScopeClient<$Result.GetResult<Prisma.$ScopePayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Scopes that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ScopeFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Scopes
     * const scopes = await prisma.scope.findMany()
     * 
     * // Get first 10 Scopes
     * const scopes = await prisma.scope.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const scopeWithIdOnly = await prisma.scope.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ScopeFindManyArgs>(args?: SelectSubset<T, ScopeFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ScopePayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Scope.
     * @param {ScopeCreateArgs} args - Arguments to create a Scope.
     * @example
     * // Create one Scope
     * const Scope = await prisma.scope.create({
     *   data: {
     *     // ... data to create a Scope
     *   }
     * })
     * 
     */
    create<T extends ScopeCreateArgs>(args: SelectSubset<T, ScopeCreateArgs<ExtArgs>>): Prisma__ScopeClient<$Result.GetResult<Prisma.$ScopePayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Scopes.
     * @param {ScopeCreateManyArgs} args - Arguments to create many Scopes.
     * @example
     * // Create many Scopes
     * const scope = await prisma.scope.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ScopeCreateManyArgs>(args?: SelectSubset<T, ScopeCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Scopes and returns the data saved in the database.
     * @param {ScopeCreateManyAndReturnArgs} args - Arguments to create many Scopes.
     * @example
     * // Create many Scopes
     * const scope = await prisma.scope.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Scopes and only return the `id`
     * const scopeWithIdOnly = await prisma.scope.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends ScopeCreateManyAndReturnArgs>(args?: SelectSubset<T, ScopeCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ScopePayload<ExtArgs>, T, "createManyAndReturn", GlobalOmitOptions>>

    /**
     * Delete a Scope.
     * @param {ScopeDeleteArgs} args - Arguments to delete one Scope.
     * @example
     * // Delete one Scope
     * const Scope = await prisma.scope.delete({
     *   where: {
     *     // ... filter to delete one Scope
     *   }
     * })
     * 
     */
    delete<T extends ScopeDeleteArgs>(args: SelectSubset<T, ScopeDeleteArgs<ExtArgs>>): Prisma__ScopeClient<$Result.GetResult<Prisma.$ScopePayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Scope.
     * @param {ScopeUpdateArgs} args - Arguments to update one Scope.
     * @example
     * // Update one Scope
     * const scope = await prisma.scope.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ScopeUpdateArgs>(args: SelectSubset<T, ScopeUpdateArgs<ExtArgs>>): Prisma__ScopeClient<$Result.GetResult<Prisma.$ScopePayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Scopes.
     * @param {ScopeDeleteManyArgs} args - Arguments to filter Scopes to delete.
     * @example
     * // Delete a few Scopes
     * const { count } = await prisma.scope.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ScopeDeleteManyArgs>(args?: SelectSubset<T, ScopeDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Scopes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ScopeUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Scopes
     * const scope = await prisma.scope.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ScopeUpdateManyArgs>(args: SelectSubset<T, ScopeUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Scopes and returns the data updated in the database.
     * @param {ScopeUpdateManyAndReturnArgs} args - Arguments to update many Scopes.
     * @example
     * // Update many Scopes
     * const scope = await prisma.scope.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Scopes and only return the `id`
     * const scopeWithIdOnly = await prisma.scope.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends ScopeUpdateManyAndReturnArgs>(args: SelectSubset<T, ScopeUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ScopePayload<ExtArgs>, T, "updateManyAndReturn", GlobalOmitOptions>>

    /**
     * Create or update one Scope.
     * @param {ScopeUpsertArgs} args - Arguments to update or create a Scope.
     * @example
     * // Update or create a Scope
     * const scope = await prisma.scope.upsert({
     *   create: {
     *     // ... data to create a Scope
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Scope we want to update
     *   }
     * })
     */
    upsert<T extends ScopeUpsertArgs>(args: SelectSubset<T, ScopeUpsertArgs<ExtArgs>>): Prisma__ScopeClient<$Result.GetResult<Prisma.$ScopePayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Scopes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ScopeCountArgs} args - Arguments to filter Scopes to count.
     * @example
     * // Count the number of Scopes
     * const count = await prisma.scope.count({
     *   where: {
     *     // ... the filter for the Scopes we want to count
     *   }
     * })
    **/
    count<T extends ScopeCountArgs>(
      args?: Subset<T, ScopeCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ScopeCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Scope.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ScopeAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ScopeAggregateArgs>(args: Subset<T, ScopeAggregateArgs>): Prisma.PrismaPromise<GetScopeAggregateType<T>>

    /**
     * Group by Scope.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ScopeGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ScopeGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ScopeGroupByArgs['orderBy'] }
        : { orderBy?: ScopeGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ScopeGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetScopeGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Scope model
   */
  readonly fields: ScopeFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Scope.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ScopeClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    realm<T extends RealmDefaultArgs<ExtArgs> = {}>(args?: Subset<T, RealmDefaultArgs<ExtArgs>>): Prisma__RealmClient<$Result.GetResult<Prisma.$RealmPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    clients<T extends Scope$clientsArgs<ExtArgs> = {}>(args?: Subset<T, Scope$clientsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ClientScopePayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Scope model
   */
  interface ScopeFieldRefs {
    readonly id: FieldRef<"Scope", 'String'>
    readonly realm_id: FieldRef<"Scope", 'String'>
    readonly name: FieldRef<"Scope", 'String'>
    readonly description: FieldRef<"Scope", 'String'>
  }
    

  // Custom InputTypes
  /**
   * Scope findUnique
   */
  export type ScopeFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Scope
     */
    select?: ScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Scope
     */
    omit?: ScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ScopeInclude<ExtArgs> | null
    /**
     * Filter, which Scope to fetch.
     */
    where: ScopeWhereUniqueInput
  }

  /**
   * Scope findUniqueOrThrow
   */
  export type ScopeFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Scope
     */
    select?: ScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Scope
     */
    omit?: ScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ScopeInclude<ExtArgs> | null
    /**
     * Filter, which Scope to fetch.
     */
    where: ScopeWhereUniqueInput
  }

  /**
   * Scope findFirst
   */
  export type ScopeFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Scope
     */
    select?: ScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Scope
     */
    omit?: ScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ScopeInclude<ExtArgs> | null
    /**
     * Filter, which Scope to fetch.
     */
    where?: ScopeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Scopes to fetch.
     */
    orderBy?: ScopeOrderByWithRelationInput | ScopeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Scopes.
     */
    cursor?: ScopeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Scopes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Scopes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Scopes.
     */
    distinct?: ScopeScalarFieldEnum | ScopeScalarFieldEnum[]
  }

  /**
   * Scope findFirstOrThrow
   */
  export type ScopeFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Scope
     */
    select?: ScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Scope
     */
    omit?: ScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ScopeInclude<ExtArgs> | null
    /**
     * Filter, which Scope to fetch.
     */
    where?: ScopeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Scopes to fetch.
     */
    orderBy?: ScopeOrderByWithRelationInput | ScopeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Scopes.
     */
    cursor?: ScopeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Scopes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Scopes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Scopes.
     */
    distinct?: ScopeScalarFieldEnum | ScopeScalarFieldEnum[]
  }

  /**
   * Scope findMany
   */
  export type ScopeFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Scope
     */
    select?: ScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Scope
     */
    omit?: ScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ScopeInclude<ExtArgs> | null
    /**
     * Filter, which Scopes to fetch.
     */
    where?: ScopeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Scopes to fetch.
     */
    orderBy?: ScopeOrderByWithRelationInput | ScopeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Scopes.
     */
    cursor?: ScopeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Scopes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Scopes.
     */
    skip?: number
    distinct?: ScopeScalarFieldEnum | ScopeScalarFieldEnum[]
  }

  /**
   * Scope create
   */
  export type ScopeCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Scope
     */
    select?: ScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Scope
     */
    omit?: ScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ScopeInclude<ExtArgs> | null
    /**
     * The data needed to create a Scope.
     */
    data: XOR<ScopeCreateInput, ScopeUncheckedCreateInput>
  }

  /**
   * Scope createMany
   */
  export type ScopeCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Scopes.
     */
    data: ScopeCreateManyInput | ScopeCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Scope createManyAndReturn
   */
  export type ScopeCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Scope
     */
    select?: ScopeSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Scope
     */
    omit?: ScopeOmit<ExtArgs> | null
    /**
     * The data used to create many Scopes.
     */
    data: ScopeCreateManyInput | ScopeCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ScopeIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * Scope update
   */
  export type ScopeUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Scope
     */
    select?: ScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Scope
     */
    omit?: ScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ScopeInclude<ExtArgs> | null
    /**
     * The data needed to update a Scope.
     */
    data: XOR<ScopeUpdateInput, ScopeUncheckedUpdateInput>
    /**
     * Choose, which Scope to update.
     */
    where: ScopeWhereUniqueInput
  }

  /**
   * Scope updateMany
   */
  export type ScopeUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Scopes.
     */
    data: XOR<ScopeUpdateManyMutationInput, ScopeUncheckedUpdateManyInput>
    /**
     * Filter which Scopes to update
     */
    where?: ScopeWhereInput
    /**
     * Limit how many Scopes to update.
     */
    limit?: number
  }

  /**
   * Scope updateManyAndReturn
   */
  export type ScopeUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Scope
     */
    select?: ScopeSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Scope
     */
    omit?: ScopeOmit<ExtArgs> | null
    /**
     * The data used to update Scopes.
     */
    data: XOR<ScopeUpdateManyMutationInput, ScopeUncheckedUpdateManyInput>
    /**
     * Filter which Scopes to update
     */
    where?: ScopeWhereInput
    /**
     * Limit how many Scopes to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ScopeIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * Scope upsert
   */
  export type ScopeUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Scope
     */
    select?: ScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Scope
     */
    omit?: ScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ScopeInclude<ExtArgs> | null
    /**
     * The filter to search for the Scope to update in case it exists.
     */
    where: ScopeWhereUniqueInput
    /**
     * In case the Scope found by the `where` argument doesn't exist, create a new Scope with this data.
     */
    create: XOR<ScopeCreateInput, ScopeUncheckedCreateInput>
    /**
     * In case the Scope was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ScopeUpdateInput, ScopeUncheckedUpdateInput>
  }

  /**
   * Scope delete
   */
  export type ScopeDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Scope
     */
    select?: ScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Scope
     */
    omit?: ScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ScopeInclude<ExtArgs> | null
    /**
     * Filter which Scope to delete.
     */
    where: ScopeWhereUniqueInput
  }

  /**
   * Scope deleteMany
   */
  export type ScopeDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Scopes to delete
     */
    where?: ScopeWhereInput
    /**
     * Limit how many Scopes to delete.
     */
    limit?: number
  }

  /**
   * Scope.clients
   */
  export type Scope$clientsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ClientScope
     */
    select?: ClientScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ClientScope
     */
    omit?: ClientScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientScopeInclude<ExtArgs> | null
    where?: ClientScopeWhereInput
    orderBy?: ClientScopeOrderByWithRelationInput | ClientScopeOrderByWithRelationInput[]
    cursor?: ClientScopeWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ClientScopeScalarFieldEnum | ClientScopeScalarFieldEnum[]
  }

  /**
   * Scope without action
   */
  export type ScopeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Scope
     */
    select?: ScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Scope
     */
    omit?: ScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ScopeInclude<ExtArgs> | null
  }


  /**
   * Model ClientScope
   */

  export type AggregateClientScope = {
    _count: ClientScopeCountAggregateOutputType | null
    _min: ClientScopeMinAggregateOutputType | null
    _max: ClientScopeMaxAggregateOutputType | null
  }

  export type ClientScopeMinAggregateOutputType = {
    client_id: string | null
    scope_id: string | null
    is_default: boolean | null
  }

  export type ClientScopeMaxAggregateOutputType = {
    client_id: string | null
    scope_id: string | null
    is_default: boolean | null
  }

  export type ClientScopeCountAggregateOutputType = {
    client_id: number
    scope_id: number
    is_default: number
    _all: number
  }


  export type ClientScopeMinAggregateInputType = {
    client_id?: true
    scope_id?: true
    is_default?: true
  }

  export type ClientScopeMaxAggregateInputType = {
    client_id?: true
    scope_id?: true
    is_default?: true
  }

  export type ClientScopeCountAggregateInputType = {
    client_id?: true
    scope_id?: true
    is_default?: true
    _all?: true
  }

  export type ClientScopeAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ClientScope to aggregate.
     */
    where?: ClientScopeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ClientScopes to fetch.
     */
    orderBy?: ClientScopeOrderByWithRelationInput | ClientScopeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ClientScopeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ClientScopes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ClientScopes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ClientScopes
    **/
    _count?: true | ClientScopeCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ClientScopeMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ClientScopeMaxAggregateInputType
  }

  export type GetClientScopeAggregateType<T extends ClientScopeAggregateArgs> = {
        [P in keyof T & keyof AggregateClientScope]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateClientScope[P]>
      : GetScalarType<T[P], AggregateClientScope[P]>
  }




  export type ClientScopeGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ClientScopeWhereInput
    orderBy?: ClientScopeOrderByWithAggregationInput | ClientScopeOrderByWithAggregationInput[]
    by: ClientScopeScalarFieldEnum[] | ClientScopeScalarFieldEnum
    having?: ClientScopeScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ClientScopeCountAggregateInputType | true
    _min?: ClientScopeMinAggregateInputType
    _max?: ClientScopeMaxAggregateInputType
  }

  export type ClientScopeGroupByOutputType = {
    client_id: string
    scope_id: string
    is_default: boolean
    _count: ClientScopeCountAggregateOutputType | null
    _min: ClientScopeMinAggregateOutputType | null
    _max: ClientScopeMaxAggregateOutputType | null
  }

  type GetClientScopeGroupByPayload<T extends ClientScopeGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ClientScopeGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ClientScopeGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ClientScopeGroupByOutputType[P]>
            : GetScalarType<T[P], ClientScopeGroupByOutputType[P]>
        }
      >
    >


  export type ClientScopeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    client_id?: boolean
    scope_id?: boolean
    is_default?: boolean
    client?: boolean | ClientDefaultArgs<ExtArgs>
    scope?: boolean | ScopeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["clientScope"]>

  export type ClientScopeSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    client_id?: boolean
    scope_id?: boolean
    is_default?: boolean
    client?: boolean | ClientDefaultArgs<ExtArgs>
    scope?: boolean | ScopeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["clientScope"]>

  export type ClientScopeSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    client_id?: boolean
    scope_id?: boolean
    is_default?: boolean
    client?: boolean | ClientDefaultArgs<ExtArgs>
    scope?: boolean | ScopeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["clientScope"]>

  export type ClientScopeSelectScalar = {
    client_id?: boolean
    scope_id?: boolean
    is_default?: boolean
  }

  export type ClientScopeOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"client_id" | "scope_id" | "is_default", ExtArgs["result"]["clientScope"]>
  export type ClientScopeInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    client?: boolean | ClientDefaultArgs<ExtArgs>
    scope?: boolean | ScopeDefaultArgs<ExtArgs>
  }
  export type ClientScopeIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    client?: boolean | ClientDefaultArgs<ExtArgs>
    scope?: boolean | ScopeDefaultArgs<ExtArgs>
  }
  export type ClientScopeIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    client?: boolean | ClientDefaultArgs<ExtArgs>
    scope?: boolean | ScopeDefaultArgs<ExtArgs>
  }

  export type $ClientScopePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ClientScope"
    objects: {
      client: Prisma.$ClientPayload<ExtArgs>
      scope: Prisma.$ScopePayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      client_id: string
      scope_id: string
      is_default: boolean
    }, ExtArgs["result"]["clientScope"]>
    composites: {}
  }

  type ClientScopeGetPayload<S extends boolean | null | undefined | ClientScopeDefaultArgs> = $Result.GetResult<Prisma.$ClientScopePayload, S>

  type ClientScopeCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ClientScopeFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ClientScopeCountAggregateInputType | true
    }

  export interface ClientScopeDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ClientScope'], meta: { name: 'ClientScope' } }
    /**
     * Find zero or one ClientScope that matches the filter.
     * @param {ClientScopeFindUniqueArgs} args - Arguments to find a ClientScope
     * @example
     * // Get one ClientScope
     * const clientScope = await prisma.clientScope.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ClientScopeFindUniqueArgs>(args: SelectSubset<T, ClientScopeFindUniqueArgs<ExtArgs>>): Prisma__ClientScopeClient<$Result.GetResult<Prisma.$ClientScopePayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one ClientScope that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ClientScopeFindUniqueOrThrowArgs} args - Arguments to find a ClientScope
     * @example
     * // Get one ClientScope
     * const clientScope = await prisma.clientScope.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ClientScopeFindUniqueOrThrowArgs>(args: SelectSubset<T, ClientScopeFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ClientScopeClient<$Result.GetResult<Prisma.$ClientScopePayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first ClientScope that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ClientScopeFindFirstArgs} args - Arguments to find a ClientScope
     * @example
     * // Get one ClientScope
     * const clientScope = await prisma.clientScope.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ClientScopeFindFirstArgs>(args?: SelectSubset<T, ClientScopeFindFirstArgs<ExtArgs>>): Prisma__ClientScopeClient<$Result.GetResult<Prisma.$ClientScopePayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first ClientScope that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ClientScopeFindFirstOrThrowArgs} args - Arguments to find a ClientScope
     * @example
     * // Get one ClientScope
     * const clientScope = await prisma.clientScope.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ClientScopeFindFirstOrThrowArgs>(args?: SelectSubset<T, ClientScopeFindFirstOrThrowArgs<ExtArgs>>): Prisma__ClientScopeClient<$Result.GetResult<Prisma.$ClientScopePayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more ClientScopes that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ClientScopeFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ClientScopes
     * const clientScopes = await prisma.clientScope.findMany()
     * 
     * // Get first 10 ClientScopes
     * const clientScopes = await prisma.clientScope.findMany({ take: 10 })
     * 
     * // Only select the `client_id`
     * const clientScopeWithClient_idOnly = await prisma.clientScope.findMany({ select: { client_id: true } })
     * 
     */
    findMany<T extends ClientScopeFindManyArgs>(args?: SelectSubset<T, ClientScopeFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ClientScopePayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a ClientScope.
     * @param {ClientScopeCreateArgs} args - Arguments to create a ClientScope.
     * @example
     * // Create one ClientScope
     * const ClientScope = await prisma.clientScope.create({
     *   data: {
     *     // ... data to create a ClientScope
     *   }
     * })
     * 
     */
    create<T extends ClientScopeCreateArgs>(args: SelectSubset<T, ClientScopeCreateArgs<ExtArgs>>): Prisma__ClientScopeClient<$Result.GetResult<Prisma.$ClientScopePayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many ClientScopes.
     * @param {ClientScopeCreateManyArgs} args - Arguments to create many ClientScopes.
     * @example
     * // Create many ClientScopes
     * const clientScope = await prisma.clientScope.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ClientScopeCreateManyArgs>(args?: SelectSubset<T, ClientScopeCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many ClientScopes and returns the data saved in the database.
     * @param {ClientScopeCreateManyAndReturnArgs} args - Arguments to create many ClientScopes.
     * @example
     * // Create many ClientScopes
     * const clientScope = await prisma.clientScope.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many ClientScopes and only return the `client_id`
     * const clientScopeWithClient_idOnly = await prisma.clientScope.createManyAndReturn({
     *   select: { client_id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends ClientScopeCreateManyAndReturnArgs>(args?: SelectSubset<T, ClientScopeCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ClientScopePayload<ExtArgs>, T, "createManyAndReturn", GlobalOmitOptions>>

    /**
     * Delete a ClientScope.
     * @param {ClientScopeDeleteArgs} args - Arguments to delete one ClientScope.
     * @example
     * // Delete one ClientScope
     * const ClientScope = await prisma.clientScope.delete({
     *   where: {
     *     // ... filter to delete one ClientScope
     *   }
     * })
     * 
     */
    delete<T extends ClientScopeDeleteArgs>(args: SelectSubset<T, ClientScopeDeleteArgs<ExtArgs>>): Prisma__ClientScopeClient<$Result.GetResult<Prisma.$ClientScopePayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one ClientScope.
     * @param {ClientScopeUpdateArgs} args - Arguments to update one ClientScope.
     * @example
     * // Update one ClientScope
     * const clientScope = await prisma.clientScope.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ClientScopeUpdateArgs>(args: SelectSubset<T, ClientScopeUpdateArgs<ExtArgs>>): Prisma__ClientScopeClient<$Result.GetResult<Prisma.$ClientScopePayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more ClientScopes.
     * @param {ClientScopeDeleteManyArgs} args - Arguments to filter ClientScopes to delete.
     * @example
     * // Delete a few ClientScopes
     * const { count } = await prisma.clientScope.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ClientScopeDeleteManyArgs>(args?: SelectSubset<T, ClientScopeDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ClientScopes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ClientScopeUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ClientScopes
     * const clientScope = await prisma.clientScope.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ClientScopeUpdateManyArgs>(args: SelectSubset<T, ClientScopeUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ClientScopes and returns the data updated in the database.
     * @param {ClientScopeUpdateManyAndReturnArgs} args - Arguments to update many ClientScopes.
     * @example
     * // Update many ClientScopes
     * const clientScope = await prisma.clientScope.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more ClientScopes and only return the `client_id`
     * const clientScopeWithClient_idOnly = await prisma.clientScope.updateManyAndReturn({
     *   select: { client_id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends ClientScopeUpdateManyAndReturnArgs>(args: SelectSubset<T, ClientScopeUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ClientScopePayload<ExtArgs>, T, "updateManyAndReturn", GlobalOmitOptions>>

    /**
     * Create or update one ClientScope.
     * @param {ClientScopeUpsertArgs} args - Arguments to update or create a ClientScope.
     * @example
     * // Update or create a ClientScope
     * const clientScope = await prisma.clientScope.upsert({
     *   create: {
     *     // ... data to create a ClientScope
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ClientScope we want to update
     *   }
     * })
     */
    upsert<T extends ClientScopeUpsertArgs>(args: SelectSubset<T, ClientScopeUpsertArgs<ExtArgs>>): Prisma__ClientScopeClient<$Result.GetResult<Prisma.$ClientScopePayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of ClientScopes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ClientScopeCountArgs} args - Arguments to filter ClientScopes to count.
     * @example
     * // Count the number of ClientScopes
     * const count = await prisma.clientScope.count({
     *   where: {
     *     // ... the filter for the ClientScopes we want to count
     *   }
     * })
    **/
    count<T extends ClientScopeCountArgs>(
      args?: Subset<T, ClientScopeCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ClientScopeCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ClientScope.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ClientScopeAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ClientScopeAggregateArgs>(args: Subset<T, ClientScopeAggregateArgs>): Prisma.PrismaPromise<GetClientScopeAggregateType<T>>

    /**
     * Group by ClientScope.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ClientScopeGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ClientScopeGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ClientScopeGroupByArgs['orderBy'] }
        : { orderBy?: ClientScopeGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ClientScopeGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetClientScopeGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ClientScope model
   */
  readonly fields: ClientScopeFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ClientScope.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ClientScopeClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    client<T extends ClientDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ClientDefaultArgs<ExtArgs>>): Prisma__ClientClient<$Result.GetResult<Prisma.$ClientPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    scope<T extends ScopeDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ScopeDefaultArgs<ExtArgs>>): Prisma__ScopeClient<$Result.GetResult<Prisma.$ScopePayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ClientScope model
   */
  interface ClientScopeFieldRefs {
    readonly client_id: FieldRef<"ClientScope", 'String'>
    readonly scope_id: FieldRef<"ClientScope", 'String'>
    readonly is_default: FieldRef<"ClientScope", 'Boolean'>
  }
    

  // Custom InputTypes
  /**
   * ClientScope findUnique
   */
  export type ClientScopeFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ClientScope
     */
    select?: ClientScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ClientScope
     */
    omit?: ClientScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientScopeInclude<ExtArgs> | null
    /**
     * Filter, which ClientScope to fetch.
     */
    where: ClientScopeWhereUniqueInput
  }

  /**
   * ClientScope findUniqueOrThrow
   */
  export type ClientScopeFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ClientScope
     */
    select?: ClientScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ClientScope
     */
    omit?: ClientScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientScopeInclude<ExtArgs> | null
    /**
     * Filter, which ClientScope to fetch.
     */
    where: ClientScopeWhereUniqueInput
  }

  /**
   * ClientScope findFirst
   */
  export type ClientScopeFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ClientScope
     */
    select?: ClientScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ClientScope
     */
    omit?: ClientScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientScopeInclude<ExtArgs> | null
    /**
     * Filter, which ClientScope to fetch.
     */
    where?: ClientScopeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ClientScopes to fetch.
     */
    orderBy?: ClientScopeOrderByWithRelationInput | ClientScopeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ClientScopes.
     */
    cursor?: ClientScopeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ClientScopes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ClientScopes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ClientScopes.
     */
    distinct?: ClientScopeScalarFieldEnum | ClientScopeScalarFieldEnum[]
  }

  /**
   * ClientScope findFirstOrThrow
   */
  export type ClientScopeFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ClientScope
     */
    select?: ClientScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ClientScope
     */
    omit?: ClientScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientScopeInclude<ExtArgs> | null
    /**
     * Filter, which ClientScope to fetch.
     */
    where?: ClientScopeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ClientScopes to fetch.
     */
    orderBy?: ClientScopeOrderByWithRelationInput | ClientScopeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ClientScopes.
     */
    cursor?: ClientScopeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ClientScopes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ClientScopes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ClientScopes.
     */
    distinct?: ClientScopeScalarFieldEnum | ClientScopeScalarFieldEnum[]
  }

  /**
   * ClientScope findMany
   */
  export type ClientScopeFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ClientScope
     */
    select?: ClientScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ClientScope
     */
    omit?: ClientScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientScopeInclude<ExtArgs> | null
    /**
     * Filter, which ClientScopes to fetch.
     */
    where?: ClientScopeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ClientScopes to fetch.
     */
    orderBy?: ClientScopeOrderByWithRelationInput | ClientScopeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ClientScopes.
     */
    cursor?: ClientScopeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ClientScopes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ClientScopes.
     */
    skip?: number
    distinct?: ClientScopeScalarFieldEnum | ClientScopeScalarFieldEnum[]
  }

  /**
   * ClientScope create
   */
  export type ClientScopeCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ClientScope
     */
    select?: ClientScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ClientScope
     */
    omit?: ClientScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientScopeInclude<ExtArgs> | null
    /**
     * The data needed to create a ClientScope.
     */
    data: XOR<ClientScopeCreateInput, ClientScopeUncheckedCreateInput>
  }

  /**
   * ClientScope createMany
   */
  export type ClientScopeCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ClientScopes.
     */
    data: ClientScopeCreateManyInput | ClientScopeCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ClientScope createManyAndReturn
   */
  export type ClientScopeCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ClientScope
     */
    select?: ClientScopeSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the ClientScope
     */
    omit?: ClientScopeOmit<ExtArgs> | null
    /**
     * The data used to create many ClientScopes.
     */
    data: ClientScopeCreateManyInput | ClientScopeCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientScopeIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * ClientScope update
   */
  export type ClientScopeUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ClientScope
     */
    select?: ClientScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ClientScope
     */
    omit?: ClientScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientScopeInclude<ExtArgs> | null
    /**
     * The data needed to update a ClientScope.
     */
    data: XOR<ClientScopeUpdateInput, ClientScopeUncheckedUpdateInput>
    /**
     * Choose, which ClientScope to update.
     */
    where: ClientScopeWhereUniqueInput
  }

  /**
   * ClientScope updateMany
   */
  export type ClientScopeUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ClientScopes.
     */
    data: XOR<ClientScopeUpdateManyMutationInput, ClientScopeUncheckedUpdateManyInput>
    /**
     * Filter which ClientScopes to update
     */
    where?: ClientScopeWhereInput
    /**
     * Limit how many ClientScopes to update.
     */
    limit?: number
  }

  /**
   * ClientScope updateManyAndReturn
   */
  export type ClientScopeUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ClientScope
     */
    select?: ClientScopeSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the ClientScope
     */
    omit?: ClientScopeOmit<ExtArgs> | null
    /**
     * The data used to update ClientScopes.
     */
    data: XOR<ClientScopeUpdateManyMutationInput, ClientScopeUncheckedUpdateManyInput>
    /**
     * Filter which ClientScopes to update
     */
    where?: ClientScopeWhereInput
    /**
     * Limit how many ClientScopes to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientScopeIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * ClientScope upsert
   */
  export type ClientScopeUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ClientScope
     */
    select?: ClientScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ClientScope
     */
    omit?: ClientScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientScopeInclude<ExtArgs> | null
    /**
     * The filter to search for the ClientScope to update in case it exists.
     */
    where: ClientScopeWhereUniqueInput
    /**
     * In case the ClientScope found by the `where` argument doesn't exist, create a new ClientScope with this data.
     */
    create: XOR<ClientScopeCreateInput, ClientScopeUncheckedCreateInput>
    /**
     * In case the ClientScope was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ClientScopeUpdateInput, ClientScopeUncheckedUpdateInput>
  }

  /**
   * ClientScope delete
   */
  export type ClientScopeDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ClientScope
     */
    select?: ClientScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ClientScope
     */
    omit?: ClientScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientScopeInclude<ExtArgs> | null
    /**
     * Filter which ClientScope to delete.
     */
    where: ClientScopeWhereUniqueInput
  }

  /**
   * ClientScope deleteMany
   */
  export type ClientScopeDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ClientScopes to delete
     */
    where?: ClientScopeWhereInput
    /**
     * Limit how many ClientScopes to delete.
     */
    limit?: number
  }

  /**
   * ClientScope without action
   */
  export type ClientScopeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ClientScope
     */
    select?: ClientScopeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ClientScope
     */
    omit?: ClientScopeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ClientScopeInclude<ExtArgs> | null
  }


  /**
   * Model AuthorizationCode
   */

  export type AggregateAuthorizationCode = {
    _count: AuthorizationCodeCountAggregateOutputType | null
    _min: AuthorizationCodeMinAggregateOutputType | null
    _max: AuthorizationCodeMaxAggregateOutputType | null
  }

  export type AuthorizationCodeMinAggregateOutputType = {
    code: string | null
    user_id: string | null
    client_id: string | null
    redirect_uri: string | null
    scope: string | null
    expires_at: Date | null
    created_at: Date | null
    code_challenge: string | null
  }

  export type AuthorizationCodeMaxAggregateOutputType = {
    code: string | null
    user_id: string | null
    client_id: string | null
    redirect_uri: string | null
    scope: string | null
    expires_at: Date | null
    created_at: Date | null
    code_challenge: string | null
  }

  export type AuthorizationCodeCountAggregateOutputType = {
    code: number
    user_id: number
    client_id: number
    redirect_uri: number
    scope: number
    expires_at: number
    created_at: number
    code_challenge: number
    _all: number
  }


  export type AuthorizationCodeMinAggregateInputType = {
    code?: true
    user_id?: true
    client_id?: true
    redirect_uri?: true
    scope?: true
    expires_at?: true
    created_at?: true
    code_challenge?: true
  }

  export type AuthorizationCodeMaxAggregateInputType = {
    code?: true
    user_id?: true
    client_id?: true
    redirect_uri?: true
    scope?: true
    expires_at?: true
    created_at?: true
    code_challenge?: true
  }

  export type AuthorizationCodeCountAggregateInputType = {
    code?: true
    user_id?: true
    client_id?: true
    redirect_uri?: true
    scope?: true
    expires_at?: true
    created_at?: true
    code_challenge?: true
    _all?: true
  }

  export type AuthorizationCodeAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which AuthorizationCode to aggregate.
     */
    where?: AuthorizationCodeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AuthorizationCodes to fetch.
     */
    orderBy?: AuthorizationCodeOrderByWithRelationInput | AuthorizationCodeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: AuthorizationCodeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AuthorizationCodes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AuthorizationCodes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned AuthorizationCodes
    **/
    _count?: true | AuthorizationCodeCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: AuthorizationCodeMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: AuthorizationCodeMaxAggregateInputType
  }

  export type GetAuthorizationCodeAggregateType<T extends AuthorizationCodeAggregateArgs> = {
        [P in keyof T & keyof AggregateAuthorizationCode]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAuthorizationCode[P]>
      : GetScalarType<T[P], AggregateAuthorizationCode[P]>
  }




  export type AuthorizationCodeGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AuthorizationCodeWhereInput
    orderBy?: AuthorizationCodeOrderByWithAggregationInput | AuthorizationCodeOrderByWithAggregationInput[]
    by: AuthorizationCodeScalarFieldEnum[] | AuthorizationCodeScalarFieldEnum
    having?: AuthorizationCodeScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: AuthorizationCodeCountAggregateInputType | true
    _min?: AuthorizationCodeMinAggregateInputType
    _max?: AuthorizationCodeMaxAggregateInputType
  }

  export type AuthorizationCodeGroupByOutputType = {
    code: string
    user_id: string
    client_id: string
    redirect_uri: string
    scope: string
    expires_at: Date
    created_at: Date
    code_challenge: string | null
    _count: AuthorizationCodeCountAggregateOutputType | null
    _min: AuthorizationCodeMinAggregateOutputType | null
    _max: AuthorizationCodeMaxAggregateOutputType | null
  }

  type GetAuthorizationCodeGroupByPayload<T extends AuthorizationCodeGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<AuthorizationCodeGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof AuthorizationCodeGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], AuthorizationCodeGroupByOutputType[P]>
            : GetScalarType<T[P], AuthorizationCodeGroupByOutputType[P]>
        }
      >
    >


  export type AuthorizationCodeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    code?: boolean
    user_id?: boolean
    client_id?: boolean
    redirect_uri?: boolean
    scope?: boolean
    expires_at?: boolean
    created_at?: boolean
    code_challenge?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    client?: boolean | ClientDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["authorizationCode"]>

  export type AuthorizationCodeSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    code?: boolean
    user_id?: boolean
    client_id?: boolean
    redirect_uri?: boolean
    scope?: boolean
    expires_at?: boolean
    created_at?: boolean
    code_challenge?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    client?: boolean | ClientDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["authorizationCode"]>

  export type AuthorizationCodeSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    code?: boolean
    user_id?: boolean
    client_id?: boolean
    redirect_uri?: boolean
    scope?: boolean
    expires_at?: boolean
    created_at?: boolean
    code_challenge?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    client?: boolean | ClientDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["authorizationCode"]>

  export type AuthorizationCodeSelectScalar = {
    code?: boolean
    user_id?: boolean
    client_id?: boolean
    redirect_uri?: boolean
    scope?: boolean
    expires_at?: boolean
    created_at?: boolean
    code_challenge?: boolean
  }

  export type AuthorizationCodeOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"code" | "user_id" | "client_id" | "redirect_uri" | "scope" | "expires_at" | "created_at" | "code_challenge", ExtArgs["result"]["authorizationCode"]>
  export type AuthorizationCodeInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    client?: boolean | ClientDefaultArgs<ExtArgs>
  }
  export type AuthorizationCodeIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    client?: boolean | ClientDefaultArgs<ExtArgs>
  }
  export type AuthorizationCodeIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    client?: boolean | ClientDefaultArgs<ExtArgs>
  }

  export type $AuthorizationCodePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "AuthorizationCode"
    objects: {
      user: Prisma.$UserPayload<ExtArgs>
      client: Prisma.$ClientPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      code: string
      user_id: string
      client_id: string
      redirect_uri: string
      scope: string
      expires_at: Date
      created_at: Date
      code_challenge: string | null
    }, ExtArgs["result"]["authorizationCode"]>
    composites: {}
  }

  type AuthorizationCodeGetPayload<S extends boolean | null | undefined | AuthorizationCodeDefaultArgs> = $Result.GetResult<Prisma.$AuthorizationCodePayload, S>

  type AuthorizationCodeCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<AuthorizationCodeFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: AuthorizationCodeCountAggregateInputType | true
    }

  export interface AuthorizationCodeDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['AuthorizationCode'], meta: { name: 'AuthorizationCode' } }
    /**
     * Find zero or one AuthorizationCode that matches the filter.
     * @param {AuthorizationCodeFindUniqueArgs} args - Arguments to find a AuthorizationCode
     * @example
     * // Get one AuthorizationCode
     * const authorizationCode = await prisma.authorizationCode.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends AuthorizationCodeFindUniqueArgs>(args: SelectSubset<T, AuthorizationCodeFindUniqueArgs<ExtArgs>>): Prisma__AuthorizationCodeClient<$Result.GetResult<Prisma.$AuthorizationCodePayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one AuthorizationCode that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {AuthorizationCodeFindUniqueOrThrowArgs} args - Arguments to find a AuthorizationCode
     * @example
     * // Get one AuthorizationCode
     * const authorizationCode = await prisma.authorizationCode.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends AuthorizationCodeFindUniqueOrThrowArgs>(args: SelectSubset<T, AuthorizationCodeFindUniqueOrThrowArgs<ExtArgs>>): Prisma__AuthorizationCodeClient<$Result.GetResult<Prisma.$AuthorizationCodePayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first AuthorizationCode that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuthorizationCodeFindFirstArgs} args - Arguments to find a AuthorizationCode
     * @example
     * // Get one AuthorizationCode
     * const authorizationCode = await prisma.authorizationCode.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends AuthorizationCodeFindFirstArgs>(args?: SelectSubset<T, AuthorizationCodeFindFirstArgs<ExtArgs>>): Prisma__AuthorizationCodeClient<$Result.GetResult<Prisma.$AuthorizationCodePayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first AuthorizationCode that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuthorizationCodeFindFirstOrThrowArgs} args - Arguments to find a AuthorizationCode
     * @example
     * // Get one AuthorizationCode
     * const authorizationCode = await prisma.authorizationCode.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends AuthorizationCodeFindFirstOrThrowArgs>(args?: SelectSubset<T, AuthorizationCodeFindFirstOrThrowArgs<ExtArgs>>): Prisma__AuthorizationCodeClient<$Result.GetResult<Prisma.$AuthorizationCodePayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more AuthorizationCodes that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuthorizationCodeFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all AuthorizationCodes
     * const authorizationCodes = await prisma.authorizationCode.findMany()
     * 
     * // Get first 10 AuthorizationCodes
     * const authorizationCodes = await prisma.authorizationCode.findMany({ take: 10 })
     * 
     * // Only select the `code`
     * const authorizationCodeWithCodeOnly = await prisma.authorizationCode.findMany({ select: { code: true } })
     * 
     */
    findMany<T extends AuthorizationCodeFindManyArgs>(args?: SelectSubset<T, AuthorizationCodeFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AuthorizationCodePayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a AuthorizationCode.
     * @param {AuthorizationCodeCreateArgs} args - Arguments to create a AuthorizationCode.
     * @example
     * // Create one AuthorizationCode
     * const AuthorizationCode = await prisma.authorizationCode.create({
     *   data: {
     *     // ... data to create a AuthorizationCode
     *   }
     * })
     * 
     */
    create<T extends AuthorizationCodeCreateArgs>(args: SelectSubset<T, AuthorizationCodeCreateArgs<ExtArgs>>): Prisma__AuthorizationCodeClient<$Result.GetResult<Prisma.$AuthorizationCodePayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many AuthorizationCodes.
     * @param {AuthorizationCodeCreateManyArgs} args - Arguments to create many AuthorizationCodes.
     * @example
     * // Create many AuthorizationCodes
     * const authorizationCode = await prisma.authorizationCode.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends AuthorizationCodeCreateManyArgs>(args?: SelectSubset<T, AuthorizationCodeCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many AuthorizationCodes and returns the data saved in the database.
     * @param {AuthorizationCodeCreateManyAndReturnArgs} args - Arguments to create many AuthorizationCodes.
     * @example
     * // Create many AuthorizationCodes
     * const authorizationCode = await prisma.authorizationCode.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many AuthorizationCodes and only return the `code`
     * const authorizationCodeWithCodeOnly = await prisma.authorizationCode.createManyAndReturn({
     *   select: { code: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends AuthorizationCodeCreateManyAndReturnArgs>(args?: SelectSubset<T, AuthorizationCodeCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AuthorizationCodePayload<ExtArgs>, T, "createManyAndReturn", GlobalOmitOptions>>

    /**
     * Delete a AuthorizationCode.
     * @param {AuthorizationCodeDeleteArgs} args - Arguments to delete one AuthorizationCode.
     * @example
     * // Delete one AuthorizationCode
     * const AuthorizationCode = await prisma.authorizationCode.delete({
     *   where: {
     *     // ... filter to delete one AuthorizationCode
     *   }
     * })
     * 
     */
    delete<T extends AuthorizationCodeDeleteArgs>(args: SelectSubset<T, AuthorizationCodeDeleteArgs<ExtArgs>>): Prisma__AuthorizationCodeClient<$Result.GetResult<Prisma.$AuthorizationCodePayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one AuthorizationCode.
     * @param {AuthorizationCodeUpdateArgs} args - Arguments to update one AuthorizationCode.
     * @example
     * // Update one AuthorizationCode
     * const authorizationCode = await prisma.authorizationCode.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends AuthorizationCodeUpdateArgs>(args: SelectSubset<T, AuthorizationCodeUpdateArgs<ExtArgs>>): Prisma__AuthorizationCodeClient<$Result.GetResult<Prisma.$AuthorizationCodePayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more AuthorizationCodes.
     * @param {AuthorizationCodeDeleteManyArgs} args - Arguments to filter AuthorizationCodes to delete.
     * @example
     * // Delete a few AuthorizationCodes
     * const { count } = await prisma.authorizationCode.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends AuthorizationCodeDeleteManyArgs>(args?: SelectSubset<T, AuthorizationCodeDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more AuthorizationCodes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuthorizationCodeUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many AuthorizationCodes
     * const authorizationCode = await prisma.authorizationCode.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends AuthorizationCodeUpdateManyArgs>(args: SelectSubset<T, AuthorizationCodeUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more AuthorizationCodes and returns the data updated in the database.
     * @param {AuthorizationCodeUpdateManyAndReturnArgs} args - Arguments to update many AuthorizationCodes.
     * @example
     * // Update many AuthorizationCodes
     * const authorizationCode = await prisma.authorizationCode.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more AuthorizationCodes and only return the `code`
     * const authorizationCodeWithCodeOnly = await prisma.authorizationCode.updateManyAndReturn({
     *   select: { code: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends AuthorizationCodeUpdateManyAndReturnArgs>(args: SelectSubset<T, AuthorizationCodeUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AuthorizationCodePayload<ExtArgs>, T, "updateManyAndReturn", GlobalOmitOptions>>

    /**
     * Create or update one AuthorizationCode.
     * @param {AuthorizationCodeUpsertArgs} args - Arguments to update or create a AuthorizationCode.
     * @example
     * // Update or create a AuthorizationCode
     * const authorizationCode = await prisma.authorizationCode.upsert({
     *   create: {
     *     // ... data to create a AuthorizationCode
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the AuthorizationCode we want to update
     *   }
     * })
     */
    upsert<T extends AuthorizationCodeUpsertArgs>(args: SelectSubset<T, AuthorizationCodeUpsertArgs<ExtArgs>>): Prisma__AuthorizationCodeClient<$Result.GetResult<Prisma.$AuthorizationCodePayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of AuthorizationCodes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuthorizationCodeCountArgs} args - Arguments to filter AuthorizationCodes to count.
     * @example
     * // Count the number of AuthorizationCodes
     * const count = await prisma.authorizationCode.count({
     *   where: {
     *     // ... the filter for the AuthorizationCodes we want to count
     *   }
     * })
    **/
    count<T extends AuthorizationCodeCountArgs>(
      args?: Subset<T, AuthorizationCodeCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], AuthorizationCodeCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a AuthorizationCode.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuthorizationCodeAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends AuthorizationCodeAggregateArgs>(args: Subset<T, AuthorizationCodeAggregateArgs>): Prisma.PrismaPromise<GetAuthorizationCodeAggregateType<T>>

    /**
     * Group by AuthorizationCode.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuthorizationCodeGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends AuthorizationCodeGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: AuthorizationCodeGroupByArgs['orderBy'] }
        : { orderBy?: AuthorizationCodeGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, AuthorizationCodeGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAuthorizationCodeGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the AuthorizationCode model
   */
  readonly fields: AuthorizationCodeFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for AuthorizationCode.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__AuthorizationCodeClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    user<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    client<T extends ClientDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ClientDefaultArgs<ExtArgs>>): Prisma__ClientClient<$Result.GetResult<Prisma.$ClientPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the AuthorizationCode model
   */
  interface AuthorizationCodeFieldRefs {
    readonly code: FieldRef<"AuthorizationCode", 'String'>
    readonly user_id: FieldRef<"AuthorizationCode", 'String'>
    readonly client_id: FieldRef<"AuthorizationCode", 'String'>
    readonly redirect_uri: FieldRef<"AuthorizationCode", 'String'>
    readonly scope: FieldRef<"AuthorizationCode", 'String'>
    readonly expires_at: FieldRef<"AuthorizationCode", 'DateTime'>
    readonly created_at: FieldRef<"AuthorizationCode", 'DateTime'>
    readonly code_challenge: FieldRef<"AuthorizationCode", 'String'>
  }
    

  // Custom InputTypes
  /**
   * AuthorizationCode findUnique
   */
  export type AuthorizationCodeFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuthorizationCode
     */
    select?: AuthorizationCodeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuthorizationCode
     */
    omit?: AuthorizationCodeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuthorizationCodeInclude<ExtArgs> | null
    /**
     * Filter, which AuthorizationCode to fetch.
     */
    where: AuthorizationCodeWhereUniqueInput
  }

  /**
   * AuthorizationCode findUniqueOrThrow
   */
  export type AuthorizationCodeFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuthorizationCode
     */
    select?: AuthorizationCodeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuthorizationCode
     */
    omit?: AuthorizationCodeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuthorizationCodeInclude<ExtArgs> | null
    /**
     * Filter, which AuthorizationCode to fetch.
     */
    where: AuthorizationCodeWhereUniqueInput
  }

  /**
   * AuthorizationCode findFirst
   */
  export type AuthorizationCodeFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuthorizationCode
     */
    select?: AuthorizationCodeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuthorizationCode
     */
    omit?: AuthorizationCodeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuthorizationCodeInclude<ExtArgs> | null
    /**
     * Filter, which AuthorizationCode to fetch.
     */
    where?: AuthorizationCodeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AuthorizationCodes to fetch.
     */
    orderBy?: AuthorizationCodeOrderByWithRelationInput | AuthorizationCodeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for AuthorizationCodes.
     */
    cursor?: AuthorizationCodeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AuthorizationCodes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AuthorizationCodes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of AuthorizationCodes.
     */
    distinct?: AuthorizationCodeScalarFieldEnum | AuthorizationCodeScalarFieldEnum[]
  }

  /**
   * AuthorizationCode findFirstOrThrow
   */
  export type AuthorizationCodeFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuthorizationCode
     */
    select?: AuthorizationCodeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuthorizationCode
     */
    omit?: AuthorizationCodeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuthorizationCodeInclude<ExtArgs> | null
    /**
     * Filter, which AuthorizationCode to fetch.
     */
    where?: AuthorizationCodeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AuthorizationCodes to fetch.
     */
    orderBy?: AuthorizationCodeOrderByWithRelationInput | AuthorizationCodeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for AuthorizationCodes.
     */
    cursor?: AuthorizationCodeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AuthorizationCodes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AuthorizationCodes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of AuthorizationCodes.
     */
    distinct?: AuthorizationCodeScalarFieldEnum | AuthorizationCodeScalarFieldEnum[]
  }

  /**
   * AuthorizationCode findMany
   */
  export type AuthorizationCodeFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuthorizationCode
     */
    select?: AuthorizationCodeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuthorizationCode
     */
    omit?: AuthorizationCodeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuthorizationCodeInclude<ExtArgs> | null
    /**
     * Filter, which AuthorizationCodes to fetch.
     */
    where?: AuthorizationCodeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AuthorizationCodes to fetch.
     */
    orderBy?: AuthorizationCodeOrderByWithRelationInput | AuthorizationCodeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing AuthorizationCodes.
     */
    cursor?: AuthorizationCodeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AuthorizationCodes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AuthorizationCodes.
     */
    skip?: number
    distinct?: AuthorizationCodeScalarFieldEnum | AuthorizationCodeScalarFieldEnum[]
  }

  /**
   * AuthorizationCode create
   */
  export type AuthorizationCodeCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuthorizationCode
     */
    select?: AuthorizationCodeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuthorizationCode
     */
    omit?: AuthorizationCodeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuthorizationCodeInclude<ExtArgs> | null
    /**
     * The data needed to create a AuthorizationCode.
     */
    data: XOR<AuthorizationCodeCreateInput, AuthorizationCodeUncheckedCreateInput>
  }

  /**
   * AuthorizationCode createMany
   */
  export type AuthorizationCodeCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many AuthorizationCodes.
     */
    data: AuthorizationCodeCreateManyInput | AuthorizationCodeCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * AuthorizationCode createManyAndReturn
   */
  export type AuthorizationCodeCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuthorizationCode
     */
    select?: AuthorizationCodeSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the AuthorizationCode
     */
    omit?: AuthorizationCodeOmit<ExtArgs> | null
    /**
     * The data used to create many AuthorizationCodes.
     */
    data: AuthorizationCodeCreateManyInput | AuthorizationCodeCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuthorizationCodeIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * AuthorizationCode update
   */
  export type AuthorizationCodeUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuthorizationCode
     */
    select?: AuthorizationCodeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuthorizationCode
     */
    omit?: AuthorizationCodeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuthorizationCodeInclude<ExtArgs> | null
    /**
     * The data needed to update a AuthorizationCode.
     */
    data: XOR<AuthorizationCodeUpdateInput, AuthorizationCodeUncheckedUpdateInput>
    /**
     * Choose, which AuthorizationCode to update.
     */
    where: AuthorizationCodeWhereUniqueInput
  }

  /**
   * AuthorizationCode updateMany
   */
  export type AuthorizationCodeUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update AuthorizationCodes.
     */
    data: XOR<AuthorizationCodeUpdateManyMutationInput, AuthorizationCodeUncheckedUpdateManyInput>
    /**
     * Filter which AuthorizationCodes to update
     */
    where?: AuthorizationCodeWhereInput
    /**
     * Limit how many AuthorizationCodes to update.
     */
    limit?: number
  }

  /**
   * AuthorizationCode updateManyAndReturn
   */
  export type AuthorizationCodeUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuthorizationCode
     */
    select?: AuthorizationCodeSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the AuthorizationCode
     */
    omit?: AuthorizationCodeOmit<ExtArgs> | null
    /**
     * The data used to update AuthorizationCodes.
     */
    data: XOR<AuthorizationCodeUpdateManyMutationInput, AuthorizationCodeUncheckedUpdateManyInput>
    /**
     * Filter which AuthorizationCodes to update
     */
    where?: AuthorizationCodeWhereInput
    /**
     * Limit how many AuthorizationCodes to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuthorizationCodeIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * AuthorizationCode upsert
   */
  export type AuthorizationCodeUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuthorizationCode
     */
    select?: AuthorizationCodeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuthorizationCode
     */
    omit?: AuthorizationCodeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuthorizationCodeInclude<ExtArgs> | null
    /**
     * The filter to search for the AuthorizationCode to update in case it exists.
     */
    where: AuthorizationCodeWhereUniqueInput
    /**
     * In case the AuthorizationCode found by the `where` argument doesn't exist, create a new AuthorizationCode with this data.
     */
    create: XOR<AuthorizationCodeCreateInput, AuthorizationCodeUncheckedCreateInput>
    /**
     * In case the AuthorizationCode was found with the provided `where` argument, update it with this data.
     */
    update: XOR<AuthorizationCodeUpdateInput, AuthorizationCodeUncheckedUpdateInput>
  }

  /**
   * AuthorizationCode delete
   */
  export type AuthorizationCodeDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuthorizationCode
     */
    select?: AuthorizationCodeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuthorizationCode
     */
    omit?: AuthorizationCodeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuthorizationCodeInclude<ExtArgs> | null
    /**
     * Filter which AuthorizationCode to delete.
     */
    where: AuthorizationCodeWhereUniqueInput
  }

  /**
   * AuthorizationCode deleteMany
   */
  export type AuthorizationCodeDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which AuthorizationCodes to delete
     */
    where?: AuthorizationCodeWhereInput
    /**
     * Limit how many AuthorizationCodes to delete.
     */
    limit?: number
  }

  /**
   * AuthorizationCode without action
   */
  export type AuthorizationCodeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuthorizationCode
     */
    select?: AuthorizationCodeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuthorizationCode
     */
    omit?: AuthorizationCodeOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuthorizationCodeInclude<ExtArgs> | null
  }


  /**
   * Model Token
   */

  export type AggregateToken = {
    _count: TokenCountAggregateOutputType | null
    _min: TokenMinAggregateOutputType | null
    _max: TokenMaxAggregateOutputType | null
  }

  export type TokenMinAggregateOutputType = {
    id: string | null
    user_id: string | null
    client_id: string | null
    token_type: $Enums.TokenType | null
    jwt_id: string | null
    issued_at: Date | null
    expires_at: Date | null
    revoked_at: Date | null
    scope: string | null
  }

  export type TokenMaxAggregateOutputType = {
    id: string | null
    user_id: string | null
    client_id: string | null
    token_type: $Enums.TokenType | null
    jwt_id: string | null
    issued_at: Date | null
    expires_at: Date | null
    revoked_at: Date | null
    scope: string | null
  }

  export type TokenCountAggregateOutputType = {
    id: number
    user_id: number
    client_id: number
    token_type: number
    jwt_id: number
    issued_at: number
    expires_at: number
    revoked_at: number
    scope: number
    _all: number
  }


  export type TokenMinAggregateInputType = {
    id?: true
    user_id?: true
    client_id?: true
    token_type?: true
    jwt_id?: true
    issued_at?: true
    expires_at?: true
    revoked_at?: true
    scope?: true
  }

  export type TokenMaxAggregateInputType = {
    id?: true
    user_id?: true
    client_id?: true
    token_type?: true
    jwt_id?: true
    issued_at?: true
    expires_at?: true
    revoked_at?: true
    scope?: true
  }

  export type TokenCountAggregateInputType = {
    id?: true
    user_id?: true
    client_id?: true
    token_type?: true
    jwt_id?: true
    issued_at?: true
    expires_at?: true
    revoked_at?: true
    scope?: true
    _all?: true
  }

  export type TokenAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Token to aggregate.
     */
    where?: TokenWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Tokens to fetch.
     */
    orderBy?: TokenOrderByWithRelationInput | TokenOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: TokenWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Tokens from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Tokens.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Tokens
    **/
    _count?: true | TokenCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: TokenMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: TokenMaxAggregateInputType
  }

  export type GetTokenAggregateType<T extends TokenAggregateArgs> = {
        [P in keyof T & keyof AggregateToken]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateToken[P]>
      : GetScalarType<T[P], AggregateToken[P]>
  }




  export type TokenGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TokenWhereInput
    orderBy?: TokenOrderByWithAggregationInput | TokenOrderByWithAggregationInput[]
    by: TokenScalarFieldEnum[] | TokenScalarFieldEnum
    having?: TokenScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: TokenCountAggregateInputType | true
    _min?: TokenMinAggregateInputType
    _max?: TokenMaxAggregateInputType
  }

  export type TokenGroupByOutputType = {
    id: string
    user_id: string | null
    client_id: string
    token_type: $Enums.TokenType
    jwt_id: string
    issued_at: Date
    expires_at: Date
    revoked_at: Date | null
    scope: string
    _count: TokenCountAggregateOutputType | null
    _min: TokenMinAggregateOutputType | null
    _max: TokenMaxAggregateOutputType | null
  }

  type GetTokenGroupByPayload<T extends TokenGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<TokenGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof TokenGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], TokenGroupByOutputType[P]>
            : GetScalarType<T[P], TokenGroupByOutputType[P]>
        }
      >
    >


  export type TokenSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    client_id?: boolean
    token_type?: boolean
    jwt_id?: boolean
    issued_at?: boolean
    expires_at?: boolean
    revoked_at?: boolean
    scope?: boolean
    user?: boolean | Token$userArgs<ExtArgs>
    client?: boolean | ClientDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["token"]>

  export type TokenSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    client_id?: boolean
    token_type?: boolean
    jwt_id?: boolean
    issued_at?: boolean
    expires_at?: boolean
    revoked_at?: boolean
    scope?: boolean
    user?: boolean | Token$userArgs<ExtArgs>
    client?: boolean | ClientDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["token"]>

  export type TokenSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    client_id?: boolean
    token_type?: boolean
    jwt_id?: boolean
    issued_at?: boolean
    expires_at?: boolean
    revoked_at?: boolean
    scope?: boolean
    user?: boolean | Token$userArgs<ExtArgs>
    client?: boolean | ClientDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["token"]>

  export type TokenSelectScalar = {
    id?: boolean
    user_id?: boolean
    client_id?: boolean
    token_type?: boolean
    jwt_id?: boolean
    issued_at?: boolean
    expires_at?: boolean
    revoked_at?: boolean
    scope?: boolean
  }

  export type TokenOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "user_id" | "client_id" | "token_type" | "jwt_id" | "issued_at" | "expires_at" | "revoked_at" | "scope", ExtArgs["result"]["token"]>
  export type TokenInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | Token$userArgs<ExtArgs>
    client?: boolean | ClientDefaultArgs<ExtArgs>
  }
  export type TokenIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | Token$userArgs<ExtArgs>
    client?: boolean | ClientDefaultArgs<ExtArgs>
  }
  export type TokenIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | Token$userArgs<ExtArgs>
    client?: boolean | ClientDefaultArgs<ExtArgs>
  }

  export type $TokenPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Token"
    objects: {
      user: Prisma.$UserPayload<ExtArgs> | null
      client: Prisma.$ClientPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      user_id: string | null
      client_id: string
      token_type: $Enums.TokenType
      jwt_id: string
      issued_at: Date
      expires_at: Date
      revoked_at: Date | null
      scope: string
    }, ExtArgs["result"]["token"]>
    composites: {}
  }

  type TokenGetPayload<S extends boolean | null | undefined | TokenDefaultArgs> = $Result.GetResult<Prisma.$TokenPayload, S>

  type TokenCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<TokenFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: TokenCountAggregateInputType | true
    }

  export interface TokenDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Token'], meta: { name: 'Token' } }
    /**
     * Find zero or one Token that matches the filter.
     * @param {TokenFindUniqueArgs} args - Arguments to find a Token
     * @example
     * // Get one Token
     * const token = await prisma.token.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends TokenFindUniqueArgs>(args: SelectSubset<T, TokenFindUniqueArgs<ExtArgs>>): Prisma__TokenClient<$Result.GetResult<Prisma.$TokenPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Token that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {TokenFindUniqueOrThrowArgs} args - Arguments to find a Token
     * @example
     * // Get one Token
     * const token = await prisma.token.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends TokenFindUniqueOrThrowArgs>(args: SelectSubset<T, TokenFindUniqueOrThrowArgs<ExtArgs>>): Prisma__TokenClient<$Result.GetResult<Prisma.$TokenPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Token that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TokenFindFirstArgs} args - Arguments to find a Token
     * @example
     * // Get one Token
     * const token = await prisma.token.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends TokenFindFirstArgs>(args?: SelectSubset<T, TokenFindFirstArgs<ExtArgs>>): Prisma__TokenClient<$Result.GetResult<Prisma.$TokenPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Token that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TokenFindFirstOrThrowArgs} args - Arguments to find a Token
     * @example
     * // Get one Token
     * const token = await prisma.token.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends TokenFindFirstOrThrowArgs>(args?: SelectSubset<T, TokenFindFirstOrThrowArgs<ExtArgs>>): Prisma__TokenClient<$Result.GetResult<Prisma.$TokenPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Tokens that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TokenFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Tokens
     * const tokens = await prisma.token.findMany()
     * 
     * // Get first 10 Tokens
     * const tokens = await prisma.token.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const tokenWithIdOnly = await prisma.token.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends TokenFindManyArgs>(args?: SelectSubset<T, TokenFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TokenPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Token.
     * @param {TokenCreateArgs} args - Arguments to create a Token.
     * @example
     * // Create one Token
     * const Token = await prisma.token.create({
     *   data: {
     *     // ... data to create a Token
     *   }
     * })
     * 
     */
    create<T extends TokenCreateArgs>(args: SelectSubset<T, TokenCreateArgs<ExtArgs>>): Prisma__TokenClient<$Result.GetResult<Prisma.$TokenPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Tokens.
     * @param {TokenCreateManyArgs} args - Arguments to create many Tokens.
     * @example
     * // Create many Tokens
     * const token = await prisma.token.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends TokenCreateManyArgs>(args?: SelectSubset<T, TokenCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Tokens and returns the data saved in the database.
     * @param {TokenCreateManyAndReturnArgs} args - Arguments to create many Tokens.
     * @example
     * // Create many Tokens
     * const token = await prisma.token.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Tokens and only return the `id`
     * const tokenWithIdOnly = await prisma.token.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends TokenCreateManyAndReturnArgs>(args?: SelectSubset<T, TokenCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TokenPayload<ExtArgs>, T, "createManyAndReturn", GlobalOmitOptions>>

    /**
     * Delete a Token.
     * @param {TokenDeleteArgs} args - Arguments to delete one Token.
     * @example
     * // Delete one Token
     * const Token = await prisma.token.delete({
     *   where: {
     *     // ... filter to delete one Token
     *   }
     * })
     * 
     */
    delete<T extends TokenDeleteArgs>(args: SelectSubset<T, TokenDeleteArgs<ExtArgs>>): Prisma__TokenClient<$Result.GetResult<Prisma.$TokenPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Token.
     * @param {TokenUpdateArgs} args - Arguments to update one Token.
     * @example
     * // Update one Token
     * const token = await prisma.token.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends TokenUpdateArgs>(args: SelectSubset<T, TokenUpdateArgs<ExtArgs>>): Prisma__TokenClient<$Result.GetResult<Prisma.$TokenPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Tokens.
     * @param {TokenDeleteManyArgs} args - Arguments to filter Tokens to delete.
     * @example
     * // Delete a few Tokens
     * const { count } = await prisma.token.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends TokenDeleteManyArgs>(args?: SelectSubset<T, TokenDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Tokens.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TokenUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Tokens
     * const token = await prisma.token.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends TokenUpdateManyArgs>(args: SelectSubset<T, TokenUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Tokens and returns the data updated in the database.
     * @param {TokenUpdateManyAndReturnArgs} args - Arguments to update many Tokens.
     * @example
     * // Update many Tokens
     * const token = await prisma.token.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Tokens and only return the `id`
     * const tokenWithIdOnly = await prisma.token.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends TokenUpdateManyAndReturnArgs>(args: SelectSubset<T, TokenUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TokenPayload<ExtArgs>, T, "updateManyAndReturn", GlobalOmitOptions>>

    /**
     * Create or update one Token.
     * @param {TokenUpsertArgs} args - Arguments to update or create a Token.
     * @example
     * // Update or create a Token
     * const token = await prisma.token.upsert({
     *   create: {
     *     // ... data to create a Token
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Token we want to update
     *   }
     * })
     */
    upsert<T extends TokenUpsertArgs>(args: SelectSubset<T, TokenUpsertArgs<ExtArgs>>): Prisma__TokenClient<$Result.GetResult<Prisma.$TokenPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Tokens.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TokenCountArgs} args - Arguments to filter Tokens to count.
     * @example
     * // Count the number of Tokens
     * const count = await prisma.token.count({
     *   where: {
     *     // ... the filter for the Tokens we want to count
     *   }
     * })
    **/
    count<T extends TokenCountArgs>(
      args?: Subset<T, TokenCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], TokenCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Token.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TokenAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends TokenAggregateArgs>(args: Subset<T, TokenAggregateArgs>): Prisma.PrismaPromise<GetTokenAggregateType<T>>

    /**
     * Group by Token.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TokenGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends TokenGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: TokenGroupByArgs['orderBy'] }
        : { orderBy?: TokenGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, TokenGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetTokenGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Token model
   */
  readonly fields: TokenFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Token.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__TokenClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    user<T extends Token$userArgs<ExtArgs> = {}>(args?: Subset<T, Token$userArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>
    client<T extends ClientDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ClientDefaultArgs<ExtArgs>>): Prisma__ClientClient<$Result.GetResult<Prisma.$ClientPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Token model
   */
  interface TokenFieldRefs {
    readonly id: FieldRef<"Token", 'String'>
    readonly user_id: FieldRef<"Token", 'String'>
    readonly client_id: FieldRef<"Token", 'String'>
    readonly token_type: FieldRef<"Token", 'TokenType'>
    readonly jwt_id: FieldRef<"Token", 'String'>
    readonly issued_at: FieldRef<"Token", 'DateTime'>
    readonly expires_at: FieldRef<"Token", 'DateTime'>
    readonly revoked_at: FieldRef<"Token", 'DateTime'>
    readonly scope: FieldRef<"Token", 'String'>
  }
    

  // Custom InputTypes
  /**
   * Token findUnique
   */
  export type TokenFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Token
     */
    select?: TokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Token
     */
    omit?: TokenOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TokenInclude<ExtArgs> | null
    /**
     * Filter, which Token to fetch.
     */
    where: TokenWhereUniqueInput
  }

  /**
   * Token findUniqueOrThrow
   */
  export type TokenFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Token
     */
    select?: TokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Token
     */
    omit?: TokenOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TokenInclude<ExtArgs> | null
    /**
     * Filter, which Token to fetch.
     */
    where: TokenWhereUniqueInput
  }

  /**
   * Token findFirst
   */
  export type TokenFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Token
     */
    select?: TokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Token
     */
    omit?: TokenOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TokenInclude<ExtArgs> | null
    /**
     * Filter, which Token to fetch.
     */
    where?: TokenWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Tokens to fetch.
     */
    orderBy?: TokenOrderByWithRelationInput | TokenOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Tokens.
     */
    cursor?: TokenWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Tokens from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Tokens.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Tokens.
     */
    distinct?: TokenScalarFieldEnum | TokenScalarFieldEnum[]
  }

  /**
   * Token findFirstOrThrow
   */
  export type TokenFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Token
     */
    select?: TokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Token
     */
    omit?: TokenOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TokenInclude<ExtArgs> | null
    /**
     * Filter, which Token to fetch.
     */
    where?: TokenWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Tokens to fetch.
     */
    orderBy?: TokenOrderByWithRelationInput | TokenOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Tokens.
     */
    cursor?: TokenWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Tokens from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Tokens.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Tokens.
     */
    distinct?: TokenScalarFieldEnum | TokenScalarFieldEnum[]
  }

  /**
   * Token findMany
   */
  export type TokenFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Token
     */
    select?: TokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Token
     */
    omit?: TokenOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TokenInclude<ExtArgs> | null
    /**
     * Filter, which Tokens to fetch.
     */
    where?: TokenWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Tokens to fetch.
     */
    orderBy?: TokenOrderByWithRelationInput | TokenOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Tokens.
     */
    cursor?: TokenWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Tokens from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Tokens.
     */
    skip?: number
    distinct?: TokenScalarFieldEnum | TokenScalarFieldEnum[]
  }

  /**
   * Token create
   */
  export type TokenCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Token
     */
    select?: TokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Token
     */
    omit?: TokenOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TokenInclude<ExtArgs> | null
    /**
     * The data needed to create a Token.
     */
    data: XOR<TokenCreateInput, TokenUncheckedCreateInput>
  }

  /**
   * Token createMany
   */
  export type TokenCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Tokens.
     */
    data: TokenCreateManyInput | TokenCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Token createManyAndReturn
   */
  export type TokenCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Token
     */
    select?: TokenSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Token
     */
    omit?: TokenOmit<ExtArgs> | null
    /**
     * The data used to create many Tokens.
     */
    data: TokenCreateManyInput | TokenCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TokenIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * Token update
   */
  export type TokenUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Token
     */
    select?: TokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Token
     */
    omit?: TokenOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TokenInclude<ExtArgs> | null
    /**
     * The data needed to update a Token.
     */
    data: XOR<TokenUpdateInput, TokenUncheckedUpdateInput>
    /**
     * Choose, which Token to update.
     */
    where: TokenWhereUniqueInput
  }

  /**
   * Token updateMany
   */
  export type TokenUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Tokens.
     */
    data: XOR<TokenUpdateManyMutationInput, TokenUncheckedUpdateManyInput>
    /**
     * Filter which Tokens to update
     */
    where?: TokenWhereInput
    /**
     * Limit how many Tokens to update.
     */
    limit?: number
  }

  /**
   * Token updateManyAndReturn
   */
  export type TokenUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Token
     */
    select?: TokenSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Token
     */
    omit?: TokenOmit<ExtArgs> | null
    /**
     * The data used to update Tokens.
     */
    data: XOR<TokenUpdateManyMutationInput, TokenUncheckedUpdateManyInput>
    /**
     * Filter which Tokens to update
     */
    where?: TokenWhereInput
    /**
     * Limit how many Tokens to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TokenIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * Token upsert
   */
  export type TokenUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Token
     */
    select?: TokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Token
     */
    omit?: TokenOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TokenInclude<ExtArgs> | null
    /**
     * The filter to search for the Token to update in case it exists.
     */
    where: TokenWhereUniqueInput
    /**
     * In case the Token found by the `where` argument doesn't exist, create a new Token with this data.
     */
    create: XOR<TokenCreateInput, TokenUncheckedCreateInput>
    /**
     * In case the Token was found with the provided `where` argument, update it with this data.
     */
    update: XOR<TokenUpdateInput, TokenUncheckedUpdateInput>
  }

  /**
   * Token delete
   */
  export type TokenDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Token
     */
    select?: TokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Token
     */
    omit?: TokenOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TokenInclude<ExtArgs> | null
    /**
     * Filter which Token to delete.
     */
    where: TokenWhereUniqueInput
  }

  /**
   * Token deleteMany
   */
  export type TokenDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Tokens to delete
     */
    where?: TokenWhereInput
    /**
     * Limit how many Tokens to delete.
     */
    limit?: number
  }

  /**
   * Token.user
   */
  export type Token$userArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * Token without action
   */
  export type TokenDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Token
     */
    select?: TokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Token
     */
    omit?: TokenOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TokenInclude<ExtArgs> | null
  }


  /**
   * Enums
   */

  export const TransactionIsolationLevel: {
    ReadUncommitted: 'ReadUncommitted',
    ReadCommitted: 'ReadCommitted',
    RepeatableRead: 'RepeatableRead',
    Serializable: 'Serializable'
  };

  export type TransactionIsolationLevel = (typeof TransactionIsolationLevel)[keyof typeof TransactionIsolationLevel]


  export const RealmScalarFieldEnum: {
    id: 'id',
    name: 'name',
    description: 'description',
    created_at: 'created_at'
  };

  export type RealmScalarFieldEnum = (typeof RealmScalarFieldEnum)[keyof typeof RealmScalarFieldEnum]


  export const RealmKeyScalarFieldEnum: {
    id: 'id',
    realm_id: 'realm_id',
    kid: 'kid',
    public_key: 'public_key',
    private_key_enc: 'private_key_enc',
    alg: 'alg',
    created_at: 'created_at',
    expires_at: 'expires_at'
  };

  export type RealmKeyScalarFieldEnum = (typeof RealmKeyScalarFieldEnum)[keyof typeof RealmKeyScalarFieldEnum]


  export const UserScalarFieldEnum: {
    id: 'id',
    realm_id: 'realm_id',
    username: 'username',
    email: 'email',
    password_hash: 'password_hash',
    password_salt: 'password_salt',
    pbkdf2_iter: 'pbkdf2_iter',
    totp_secret: 'totp_secret',
    totp_enabled: 'totp_enabled',
    email_verified: 'email_verified',
    is_active: 'is_active',
    created_at: 'created_at',
    updated_at: 'updated_at'
  };

  export type UserScalarFieldEnum = (typeof UserScalarFieldEnum)[keyof typeof UserScalarFieldEnum]


  export const UserSessionScalarFieldEnum: {
    id: 'id',
    user_id: 'user_id',
    client_id: 'client_id',
    ip_addr: 'ip_addr',
    user_agent: 'user_agent',
    login_time: 'login_time',
    logout_time: 'logout_time'
  };

  export type UserSessionScalarFieldEnum = (typeof UserSessionScalarFieldEnum)[keyof typeof UserSessionScalarFieldEnum]


  export const RoleScalarFieldEnum: {
    id: 'id',
    realm_id: 'realm_id',
    client_id: 'client_id',
    name: 'name',
    description: 'description',
    is_client_role: 'is_client_role'
  };

  export type RoleScalarFieldEnum = (typeof RoleScalarFieldEnum)[keyof typeof RoleScalarFieldEnum]


  export const UserRoleScalarFieldEnum: {
    user_id: 'user_id',
    role_id: 'role_id'
  };

  export type UserRoleScalarFieldEnum = (typeof UserRoleScalarFieldEnum)[keyof typeof UserRoleScalarFieldEnum]


  export const ClientScalarFieldEnum: {
    id: 'id',
    realm_id: 'realm_id',
    client_id: 'client_id',
    client_name: 'client_name',
    client_secret_hash: 'client_secret_hash',
    redirect_uris: 'redirect_uris',
    grant_types: 'grant_types',
    access_token_life: 'access_token_life',
    refresh_token_life: 'refresh_token_life',
    created_at: 'created_at'
  };

  export type ClientScalarFieldEnum = (typeof ClientScalarFieldEnum)[keyof typeof ClientScalarFieldEnum]


  export const ScopeScalarFieldEnum: {
    id: 'id',
    realm_id: 'realm_id',
    name: 'name',
    description: 'description'
  };

  export type ScopeScalarFieldEnum = (typeof ScopeScalarFieldEnum)[keyof typeof ScopeScalarFieldEnum]


  export const ClientScopeScalarFieldEnum: {
    client_id: 'client_id',
    scope_id: 'scope_id',
    is_default: 'is_default'
  };

  export type ClientScopeScalarFieldEnum = (typeof ClientScopeScalarFieldEnum)[keyof typeof ClientScopeScalarFieldEnum]


  export const AuthorizationCodeScalarFieldEnum: {
    code: 'code',
    user_id: 'user_id',
    client_id: 'client_id',
    redirect_uri: 'redirect_uri',
    scope: 'scope',
    expires_at: 'expires_at',
    created_at: 'created_at',
    code_challenge: 'code_challenge'
  };

  export type AuthorizationCodeScalarFieldEnum = (typeof AuthorizationCodeScalarFieldEnum)[keyof typeof AuthorizationCodeScalarFieldEnum]


  export const TokenScalarFieldEnum: {
    id: 'id',
    user_id: 'user_id',
    client_id: 'client_id',
    token_type: 'token_type',
    jwt_id: 'jwt_id',
    issued_at: 'issued_at',
    expires_at: 'expires_at',
    revoked_at: 'revoked_at',
    scope: 'scope'
  };

  export type TokenScalarFieldEnum = (typeof TokenScalarFieldEnum)[keyof typeof TokenScalarFieldEnum]


  export const SortOrder: {
    asc: 'asc',
    desc: 'desc'
  };

  export type SortOrder = (typeof SortOrder)[keyof typeof SortOrder]


  export const QueryMode: {
    default: 'default',
    insensitive: 'insensitive'
  };

  export type QueryMode = (typeof QueryMode)[keyof typeof QueryMode]


  export const NullsOrder: {
    first: 'first',
    last: 'last'
  };

  export type NullsOrder = (typeof NullsOrder)[keyof typeof NullsOrder]


  /**
   * Field references
   */


  /**
   * Reference to a field of type 'String'
   */
  export type StringFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'String'>
    


  /**
   * Reference to a field of type 'String[]'
   */
  export type ListStringFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'String[]'>
    


  /**
   * Reference to a field of type 'DateTime'
   */
  export type DateTimeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'DateTime'>
    


  /**
   * Reference to a field of type 'DateTime[]'
   */
  export type ListDateTimeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'DateTime[]'>
    


  /**
   * Reference to a field of type 'Int'
   */
  export type IntFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Int'>
    


  /**
   * Reference to a field of type 'Int[]'
   */
  export type ListIntFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Int[]'>
    


  /**
   * Reference to a field of type 'Boolean'
   */
  export type BooleanFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Boolean'>
    


  /**
   * Reference to a field of type 'TokenType'
   */
  export type EnumTokenTypeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'TokenType'>
    


  /**
   * Reference to a field of type 'TokenType[]'
   */
  export type ListEnumTokenTypeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'TokenType[]'>
    


  /**
   * Reference to a field of type 'Float'
   */
  export type FloatFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Float'>
    


  /**
   * Reference to a field of type 'Float[]'
   */
  export type ListFloatFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Float[]'>
    
  /**
   * Deep Input Types
   */


  export type RealmWhereInput = {
    AND?: RealmWhereInput | RealmWhereInput[]
    OR?: RealmWhereInput[]
    NOT?: RealmWhereInput | RealmWhereInput[]
    id?: StringFilter<"Realm"> | string
    name?: StringFilter<"Realm"> | string
    description?: StringNullableFilter<"Realm"> | string | null
    created_at?: DateTimeFilter<"Realm"> | Date | string
    keys?: RealmKeyListRelationFilter
    users?: UserListRelationFilter
    roles?: RoleListRelationFilter
    clients?: ClientListRelationFilter
    scopes?: ScopeListRelationFilter
  }

  export type RealmOrderByWithRelationInput = {
    id?: SortOrder
    name?: SortOrder
    description?: SortOrderInput | SortOrder
    created_at?: SortOrder
    keys?: RealmKeyOrderByRelationAggregateInput
    users?: UserOrderByRelationAggregateInput
    roles?: RoleOrderByRelationAggregateInput
    clients?: ClientOrderByRelationAggregateInput
    scopes?: ScopeOrderByRelationAggregateInput
  }

  export type RealmWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    name?: string
    AND?: RealmWhereInput | RealmWhereInput[]
    OR?: RealmWhereInput[]
    NOT?: RealmWhereInput | RealmWhereInput[]
    description?: StringNullableFilter<"Realm"> | string | null
    created_at?: DateTimeFilter<"Realm"> | Date | string
    keys?: RealmKeyListRelationFilter
    users?: UserListRelationFilter
    roles?: RoleListRelationFilter
    clients?: ClientListRelationFilter
    scopes?: ScopeListRelationFilter
  }, "id" | "name">

  export type RealmOrderByWithAggregationInput = {
    id?: SortOrder
    name?: SortOrder
    description?: SortOrderInput | SortOrder
    created_at?: SortOrder
    _count?: RealmCountOrderByAggregateInput
    _max?: RealmMaxOrderByAggregateInput
    _min?: RealmMinOrderByAggregateInput
  }

  export type RealmScalarWhereWithAggregatesInput = {
    AND?: RealmScalarWhereWithAggregatesInput | RealmScalarWhereWithAggregatesInput[]
    OR?: RealmScalarWhereWithAggregatesInput[]
    NOT?: RealmScalarWhereWithAggregatesInput | RealmScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"Realm"> | string
    name?: StringWithAggregatesFilter<"Realm"> | string
    description?: StringNullableWithAggregatesFilter<"Realm"> | string | null
    created_at?: DateTimeWithAggregatesFilter<"Realm"> | Date | string
  }

  export type RealmKeyWhereInput = {
    AND?: RealmKeyWhereInput | RealmKeyWhereInput[]
    OR?: RealmKeyWhereInput[]
    NOT?: RealmKeyWhereInput | RealmKeyWhereInput[]
    id?: StringFilter<"RealmKey"> | string
    realm_id?: StringFilter<"RealmKey"> | string
    kid?: StringFilter<"RealmKey"> | string
    public_key?: StringFilter<"RealmKey"> | string
    private_key_enc?: StringFilter<"RealmKey"> | string
    alg?: StringFilter<"RealmKey"> | string
    created_at?: DateTimeFilter<"RealmKey"> | Date | string
    expires_at?: DateTimeNullableFilter<"RealmKey"> | Date | string | null
    realm?: XOR<RealmScalarRelationFilter, RealmWhereInput>
  }

  export type RealmKeyOrderByWithRelationInput = {
    id?: SortOrder
    realm_id?: SortOrder
    kid?: SortOrder
    public_key?: SortOrder
    private_key_enc?: SortOrder
    alg?: SortOrder
    created_at?: SortOrder
    expires_at?: SortOrderInput | SortOrder
    realm?: RealmOrderByWithRelationInput
  }

  export type RealmKeyWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    kid?: string
    AND?: RealmKeyWhereInput | RealmKeyWhereInput[]
    OR?: RealmKeyWhereInput[]
    NOT?: RealmKeyWhereInput | RealmKeyWhereInput[]
    realm_id?: StringFilter<"RealmKey"> | string
    public_key?: StringFilter<"RealmKey"> | string
    private_key_enc?: StringFilter<"RealmKey"> | string
    alg?: StringFilter<"RealmKey"> | string
    created_at?: DateTimeFilter<"RealmKey"> | Date | string
    expires_at?: DateTimeNullableFilter<"RealmKey"> | Date | string | null
    realm?: XOR<RealmScalarRelationFilter, RealmWhereInput>
  }, "id" | "kid">

  export type RealmKeyOrderByWithAggregationInput = {
    id?: SortOrder
    realm_id?: SortOrder
    kid?: SortOrder
    public_key?: SortOrder
    private_key_enc?: SortOrder
    alg?: SortOrder
    created_at?: SortOrder
    expires_at?: SortOrderInput | SortOrder
    _count?: RealmKeyCountOrderByAggregateInput
    _max?: RealmKeyMaxOrderByAggregateInput
    _min?: RealmKeyMinOrderByAggregateInput
  }

  export type RealmKeyScalarWhereWithAggregatesInput = {
    AND?: RealmKeyScalarWhereWithAggregatesInput | RealmKeyScalarWhereWithAggregatesInput[]
    OR?: RealmKeyScalarWhereWithAggregatesInput[]
    NOT?: RealmKeyScalarWhereWithAggregatesInput | RealmKeyScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"RealmKey"> | string
    realm_id?: StringWithAggregatesFilter<"RealmKey"> | string
    kid?: StringWithAggregatesFilter<"RealmKey"> | string
    public_key?: StringWithAggregatesFilter<"RealmKey"> | string
    private_key_enc?: StringWithAggregatesFilter<"RealmKey"> | string
    alg?: StringWithAggregatesFilter<"RealmKey"> | string
    created_at?: DateTimeWithAggregatesFilter<"RealmKey"> | Date | string
    expires_at?: DateTimeNullableWithAggregatesFilter<"RealmKey"> | Date | string | null
  }

  export type UserWhereInput = {
    AND?: UserWhereInput | UserWhereInput[]
    OR?: UserWhereInput[]
    NOT?: UserWhereInput | UserWhereInput[]
    id?: StringFilter<"User"> | string
    realm_id?: StringFilter<"User"> | string
    username?: StringFilter<"User"> | string
    email?: StringFilter<"User"> | string
    password_hash?: StringFilter<"User"> | string
    password_salt?: StringFilter<"User"> | string
    pbkdf2_iter?: IntFilter<"User"> | number
    totp_secret?: StringNullableFilter<"User"> | string | null
    totp_enabled?: BoolFilter<"User"> | boolean
    email_verified?: BoolFilter<"User"> | boolean
    is_active?: BoolFilter<"User"> | boolean
    created_at?: DateTimeFilter<"User"> | Date | string
    updated_at?: DateTimeFilter<"User"> | Date | string
    realm?: XOR<RealmScalarRelationFilter, RealmWhereInput>
    roles?: UserRoleListRelationFilter
    sessions?: UserSessionListRelationFilter
    tokens?: TokenListRelationFilter
    authorizationCodes?: AuthorizationCodeListRelationFilter
  }

  export type UserOrderByWithRelationInput = {
    id?: SortOrder
    realm_id?: SortOrder
    username?: SortOrder
    email?: SortOrder
    password_hash?: SortOrder
    password_salt?: SortOrder
    pbkdf2_iter?: SortOrder
    totp_secret?: SortOrderInput | SortOrder
    totp_enabled?: SortOrder
    email_verified?: SortOrder
    is_active?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    realm?: RealmOrderByWithRelationInput
    roles?: UserRoleOrderByRelationAggregateInput
    sessions?: UserSessionOrderByRelationAggregateInput
    tokens?: TokenOrderByRelationAggregateInput
    authorizationCodes?: AuthorizationCodeOrderByRelationAggregateInput
  }

  export type UserWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    realm_id_username?: UserRealm_idUsernameCompoundUniqueInput
    realm_id_email?: UserRealm_idEmailCompoundUniqueInput
    AND?: UserWhereInput | UserWhereInput[]
    OR?: UserWhereInput[]
    NOT?: UserWhereInput | UserWhereInput[]
    realm_id?: StringFilter<"User"> | string
    username?: StringFilter<"User"> | string
    email?: StringFilter<"User"> | string
    password_hash?: StringFilter<"User"> | string
    password_salt?: StringFilter<"User"> | string
    pbkdf2_iter?: IntFilter<"User"> | number
    totp_secret?: StringNullableFilter<"User"> | string | null
    totp_enabled?: BoolFilter<"User"> | boolean
    email_verified?: BoolFilter<"User"> | boolean
    is_active?: BoolFilter<"User"> | boolean
    created_at?: DateTimeFilter<"User"> | Date | string
    updated_at?: DateTimeFilter<"User"> | Date | string
    realm?: XOR<RealmScalarRelationFilter, RealmWhereInput>
    roles?: UserRoleListRelationFilter
    sessions?: UserSessionListRelationFilter
    tokens?: TokenListRelationFilter
    authorizationCodes?: AuthorizationCodeListRelationFilter
  }, "id" | "realm_id_username" | "realm_id_email">

  export type UserOrderByWithAggregationInput = {
    id?: SortOrder
    realm_id?: SortOrder
    username?: SortOrder
    email?: SortOrder
    password_hash?: SortOrder
    password_salt?: SortOrder
    pbkdf2_iter?: SortOrder
    totp_secret?: SortOrderInput | SortOrder
    totp_enabled?: SortOrder
    email_verified?: SortOrder
    is_active?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    _count?: UserCountOrderByAggregateInput
    _avg?: UserAvgOrderByAggregateInput
    _max?: UserMaxOrderByAggregateInput
    _min?: UserMinOrderByAggregateInput
    _sum?: UserSumOrderByAggregateInput
  }

  export type UserScalarWhereWithAggregatesInput = {
    AND?: UserScalarWhereWithAggregatesInput | UserScalarWhereWithAggregatesInput[]
    OR?: UserScalarWhereWithAggregatesInput[]
    NOT?: UserScalarWhereWithAggregatesInput | UserScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"User"> | string
    realm_id?: StringWithAggregatesFilter<"User"> | string
    username?: StringWithAggregatesFilter<"User"> | string
    email?: StringWithAggregatesFilter<"User"> | string
    password_hash?: StringWithAggregatesFilter<"User"> | string
    password_salt?: StringWithAggregatesFilter<"User"> | string
    pbkdf2_iter?: IntWithAggregatesFilter<"User"> | number
    totp_secret?: StringNullableWithAggregatesFilter<"User"> | string | null
    totp_enabled?: BoolWithAggregatesFilter<"User"> | boolean
    email_verified?: BoolWithAggregatesFilter<"User"> | boolean
    is_active?: BoolWithAggregatesFilter<"User"> | boolean
    created_at?: DateTimeWithAggregatesFilter<"User"> | Date | string
    updated_at?: DateTimeWithAggregatesFilter<"User"> | Date | string
  }

  export type UserSessionWhereInput = {
    AND?: UserSessionWhereInput | UserSessionWhereInput[]
    OR?: UserSessionWhereInput[]
    NOT?: UserSessionWhereInput | UserSessionWhereInput[]
    id?: StringFilter<"UserSession"> | string
    user_id?: StringFilter<"UserSession"> | string
    client_id?: StringFilter<"UserSession"> | string
    ip_addr?: StringFilter<"UserSession"> | string
    user_agent?: StringFilter<"UserSession"> | string
    login_time?: DateTimeFilter<"UserSession"> | Date | string
    logout_time?: DateTimeNullableFilter<"UserSession"> | Date | string | null
    user?: XOR<UserScalarRelationFilter, UserWhereInput>
    client?: XOR<ClientScalarRelationFilter, ClientWhereInput>
  }

  export type UserSessionOrderByWithRelationInput = {
    id?: SortOrder
    user_id?: SortOrder
    client_id?: SortOrder
    ip_addr?: SortOrder
    user_agent?: SortOrder
    login_time?: SortOrder
    logout_time?: SortOrderInput | SortOrder
    user?: UserOrderByWithRelationInput
    client?: ClientOrderByWithRelationInput
  }

  export type UserSessionWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    AND?: UserSessionWhereInput | UserSessionWhereInput[]
    OR?: UserSessionWhereInput[]
    NOT?: UserSessionWhereInput | UserSessionWhereInput[]
    user_id?: StringFilter<"UserSession"> | string
    client_id?: StringFilter<"UserSession"> | string
    ip_addr?: StringFilter<"UserSession"> | string
    user_agent?: StringFilter<"UserSession"> | string
    login_time?: DateTimeFilter<"UserSession"> | Date | string
    logout_time?: DateTimeNullableFilter<"UserSession"> | Date | string | null
    user?: XOR<UserScalarRelationFilter, UserWhereInput>
    client?: XOR<ClientScalarRelationFilter, ClientWhereInput>
  }, "id">

  export type UserSessionOrderByWithAggregationInput = {
    id?: SortOrder
    user_id?: SortOrder
    client_id?: SortOrder
    ip_addr?: SortOrder
    user_agent?: SortOrder
    login_time?: SortOrder
    logout_time?: SortOrderInput | SortOrder
    _count?: UserSessionCountOrderByAggregateInput
    _max?: UserSessionMaxOrderByAggregateInput
    _min?: UserSessionMinOrderByAggregateInput
  }

  export type UserSessionScalarWhereWithAggregatesInput = {
    AND?: UserSessionScalarWhereWithAggregatesInput | UserSessionScalarWhereWithAggregatesInput[]
    OR?: UserSessionScalarWhereWithAggregatesInput[]
    NOT?: UserSessionScalarWhereWithAggregatesInput | UserSessionScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"UserSession"> | string
    user_id?: StringWithAggregatesFilter<"UserSession"> | string
    client_id?: StringWithAggregatesFilter<"UserSession"> | string
    ip_addr?: StringWithAggregatesFilter<"UserSession"> | string
    user_agent?: StringWithAggregatesFilter<"UserSession"> | string
    login_time?: DateTimeWithAggregatesFilter<"UserSession"> | Date | string
    logout_time?: DateTimeNullableWithAggregatesFilter<"UserSession"> | Date | string | null
  }

  export type RoleWhereInput = {
    AND?: RoleWhereInput | RoleWhereInput[]
    OR?: RoleWhereInput[]
    NOT?: RoleWhereInput | RoleWhereInput[]
    id?: StringFilter<"Role"> | string
    realm_id?: StringFilter<"Role"> | string
    client_id?: StringNullableFilter<"Role"> | string | null
    name?: StringFilter<"Role"> | string
    description?: StringNullableFilter<"Role"> | string | null
    is_client_role?: BoolFilter<"Role"> | boolean
    realm?: XOR<RealmScalarRelationFilter, RealmWhereInput>
    client?: XOR<ClientNullableScalarRelationFilter, ClientWhereInput> | null
    userLinks?: UserRoleListRelationFilter
  }

  export type RoleOrderByWithRelationInput = {
    id?: SortOrder
    realm_id?: SortOrder
    client_id?: SortOrderInput | SortOrder
    name?: SortOrder
    description?: SortOrderInput | SortOrder
    is_client_role?: SortOrder
    realm?: RealmOrderByWithRelationInput
    client?: ClientOrderByWithRelationInput
    userLinks?: UserRoleOrderByRelationAggregateInput
  }

  export type RoleWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    realm_id_client_id_name?: RoleRealm_idClient_idNameCompoundUniqueInput
    AND?: RoleWhereInput | RoleWhereInput[]
    OR?: RoleWhereInput[]
    NOT?: RoleWhereInput | RoleWhereInput[]
    realm_id?: StringFilter<"Role"> | string
    client_id?: StringNullableFilter<"Role"> | string | null
    name?: StringFilter<"Role"> | string
    description?: StringNullableFilter<"Role"> | string | null
    is_client_role?: BoolFilter<"Role"> | boolean
    realm?: XOR<RealmScalarRelationFilter, RealmWhereInput>
    client?: XOR<ClientNullableScalarRelationFilter, ClientWhereInput> | null
    userLinks?: UserRoleListRelationFilter
  }, "id" | "realm_id_client_id_name">

  export type RoleOrderByWithAggregationInput = {
    id?: SortOrder
    realm_id?: SortOrder
    client_id?: SortOrderInput | SortOrder
    name?: SortOrder
    description?: SortOrderInput | SortOrder
    is_client_role?: SortOrder
    _count?: RoleCountOrderByAggregateInput
    _max?: RoleMaxOrderByAggregateInput
    _min?: RoleMinOrderByAggregateInput
  }

  export type RoleScalarWhereWithAggregatesInput = {
    AND?: RoleScalarWhereWithAggregatesInput | RoleScalarWhereWithAggregatesInput[]
    OR?: RoleScalarWhereWithAggregatesInput[]
    NOT?: RoleScalarWhereWithAggregatesInput | RoleScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"Role"> | string
    realm_id?: StringWithAggregatesFilter<"Role"> | string
    client_id?: StringNullableWithAggregatesFilter<"Role"> | string | null
    name?: StringWithAggregatesFilter<"Role"> | string
    description?: StringNullableWithAggregatesFilter<"Role"> | string | null
    is_client_role?: BoolWithAggregatesFilter<"Role"> | boolean
  }

  export type UserRoleWhereInput = {
    AND?: UserRoleWhereInput | UserRoleWhereInput[]
    OR?: UserRoleWhereInput[]
    NOT?: UserRoleWhereInput | UserRoleWhereInput[]
    user_id?: StringFilter<"UserRole"> | string
    role_id?: StringFilter<"UserRole"> | string
    user?: XOR<UserScalarRelationFilter, UserWhereInput>
    role?: XOR<RoleScalarRelationFilter, RoleWhereInput>
  }

  export type UserRoleOrderByWithRelationInput = {
    user_id?: SortOrder
    role_id?: SortOrder
    user?: UserOrderByWithRelationInput
    role?: RoleOrderByWithRelationInput
  }

  export type UserRoleWhereUniqueInput = Prisma.AtLeast<{
    user_id_role_id?: UserRoleUser_idRole_idCompoundUniqueInput
    AND?: UserRoleWhereInput | UserRoleWhereInput[]
    OR?: UserRoleWhereInput[]
    NOT?: UserRoleWhereInput | UserRoleWhereInput[]
    user_id?: StringFilter<"UserRole"> | string
    role_id?: StringFilter<"UserRole"> | string
    user?: XOR<UserScalarRelationFilter, UserWhereInput>
    role?: XOR<RoleScalarRelationFilter, RoleWhereInput>
  }, "user_id_role_id">

  export type UserRoleOrderByWithAggregationInput = {
    user_id?: SortOrder
    role_id?: SortOrder
    _count?: UserRoleCountOrderByAggregateInput
    _max?: UserRoleMaxOrderByAggregateInput
    _min?: UserRoleMinOrderByAggregateInput
  }

  export type UserRoleScalarWhereWithAggregatesInput = {
    AND?: UserRoleScalarWhereWithAggregatesInput | UserRoleScalarWhereWithAggregatesInput[]
    OR?: UserRoleScalarWhereWithAggregatesInput[]
    NOT?: UserRoleScalarWhereWithAggregatesInput | UserRoleScalarWhereWithAggregatesInput[]
    user_id?: StringWithAggregatesFilter<"UserRole"> | string
    role_id?: StringWithAggregatesFilter<"UserRole"> | string
  }

  export type ClientWhereInput = {
    AND?: ClientWhereInput | ClientWhereInput[]
    OR?: ClientWhereInput[]
    NOT?: ClientWhereInput | ClientWhereInput[]
    id?: StringFilter<"Client"> | string
    realm_id?: StringFilter<"Client"> | string
    client_id?: StringFilter<"Client"> | string
    client_name?: StringNullableFilter<"Client"> | string | null
    client_secret_hash?: StringFilter<"Client"> | string
    redirect_uris?: StringNullableListFilter<"Client">
    grant_types?: StringNullableListFilter<"Client">
    access_token_life?: IntFilter<"Client"> | number
    refresh_token_life?: IntFilter<"Client"> | number
    created_at?: DateTimeFilter<"Client"> | Date | string
    realm?: XOR<RealmScalarRelationFilter, RealmWhereInput>
    roles?: RoleListRelationFilter
    scopes?: ClientScopeListRelationFilter
    userSessions?: UserSessionListRelationFilter
    tokens?: TokenListRelationFilter
    authorizationCodes?: AuthorizationCodeListRelationFilter
  }

  export type ClientOrderByWithRelationInput = {
    id?: SortOrder
    realm_id?: SortOrder
    client_id?: SortOrder
    client_name?: SortOrderInput | SortOrder
    client_secret_hash?: SortOrder
    redirect_uris?: SortOrder
    grant_types?: SortOrder
    access_token_life?: SortOrder
    refresh_token_life?: SortOrder
    created_at?: SortOrder
    realm?: RealmOrderByWithRelationInput
    roles?: RoleOrderByRelationAggregateInput
    scopes?: ClientScopeOrderByRelationAggregateInput
    userSessions?: UserSessionOrderByRelationAggregateInput
    tokens?: TokenOrderByRelationAggregateInput
    authorizationCodes?: AuthorizationCodeOrderByRelationAggregateInput
  }

  export type ClientWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    realm_id_client_id?: ClientRealm_idClient_idCompoundUniqueInput
    AND?: ClientWhereInput | ClientWhereInput[]
    OR?: ClientWhereInput[]
    NOT?: ClientWhereInput | ClientWhereInput[]
    realm_id?: StringFilter<"Client"> | string
    client_id?: StringFilter<"Client"> | string
    client_name?: StringNullableFilter<"Client"> | string | null
    client_secret_hash?: StringFilter<"Client"> | string
    redirect_uris?: StringNullableListFilter<"Client">
    grant_types?: StringNullableListFilter<"Client">
    access_token_life?: IntFilter<"Client"> | number
    refresh_token_life?: IntFilter<"Client"> | number
    created_at?: DateTimeFilter<"Client"> | Date | string
    realm?: XOR<RealmScalarRelationFilter, RealmWhereInput>
    roles?: RoleListRelationFilter
    scopes?: ClientScopeListRelationFilter
    userSessions?: UserSessionListRelationFilter
    tokens?: TokenListRelationFilter
    authorizationCodes?: AuthorizationCodeListRelationFilter
  }, "id" | "realm_id_client_id">

  export type ClientOrderByWithAggregationInput = {
    id?: SortOrder
    realm_id?: SortOrder
    client_id?: SortOrder
    client_name?: SortOrderInput | SortOrder
    client_secret_hash?: SortOrder
    redirect_uris?: SortOrder
    grant_types?: SortOrder
    access_token_life?: SortOrder
    refresh_token_life?: SortOrder
    created_at?: SortOrder
    _count?: ClientCountOrderByAggregateInput
    _avg?: ClientAvgOrderByAggregateInput
    _max?: ClientMaxOrderByAggregateInput
    _min?: ClientMinOrderByAggregateInput
    _sum?: ClientSumOrderByAggregateInput
  }

  export type ClientScalarWhereWithAggregatesInput = {
    AND?: ClientScalarWhereWithAggregatesInput | ClientScalarWhereWithAggregatesInput[]
    OR?: ClientScalarWhereWithAggregatesInput[]
    NOT?: ClientScalarWhereWithAggregatesInput | ClientScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"Client"> | string
    realm_id?: StringWithAggregatesFilter<"Client"> | string
    client_id?: StringWithAggregatesFilter<"Client"> | string
    client_name?: StringNullableWithAggregatesFilter<"Client"> | string | null
    client_secret_hash?: StringWithAggregatesFilter<"Client"> | string
    redirect_uris?: StringNullableListFilter<"Client">
    grant_types?: StringNullableListFilter<"Client">
    access_token_life?: IntWithAggregatesFilter<"Client"> | number
    refresh_token_life?: IntWithAggregatesFilter<"Client"> | number
    created_at?: DateTimeWithAggregatesFilter<"Client"> | Date | string
  }

  export type ScopeWhereInput = {
    AND?: ScopeWhereInput | ScopeWhereInput[]
    OR?: ScopeWhereInput[]
    NOT?: ScopeWhereInput | ScopeWhereInput[]
    id?: StringFilter<"Scope"> | string
    realm_id?: StringFilter<"Scope"> | string
    name?: StringFilter<"Scope"> | string
    description?: StringNullableFilter<"Scope"> | string | null
    realm?: XOR<RealmScalarRelationFilter, RealmWhereInput>
    clients?: ClientScopeListRelationFilter
  }

  export type ScopeOrderByWithRelationInput = {
    id?: SortOrder
    realm_id?: SortOrder
    name?: SortOrder
    description?: SortOrderInput | SortOrder
    realm?: RealmOrderByWithRelationInput
    clients?: ClientScopeOrderByRelationAggregateInput
  }

  export type ScopeWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    realm_id_name?: ScopeRealm_idNameCompoundUniqueInput
    AND?: ScopeWhereInput | ScopeWhereInput[]
    OR?: ScopeWhereInput[]
    NOT?: ScopeWhereInput | ScopeWhereInput[]
    realm_id?: StringFilter<"Scope"> | string
    name?: StringFilter<"Scope"> | string
    description?: StringNullableFilter<"Scope"> | string | null
    realm?: XOR<RealmScalarRelationFilter, RealmWhereInput>
    clients?: ClientScopeListRelationFilter
  }, "id" | "realm_id_name">

  export type ScopeOrderByWithAggregationInput = {
    id?: SortOrder
    realm_id?: SortOrder
    name?: SortOrder
    description?: SortOrderInput | SortOrder
    _count?: ScopeCountOrderByAggregateInput
    _max?: ScopeMaxOrderByAggregateInput
    _min?: ScopeMinOrderByAggregateInput
  }

  export type ScopeScalarWhereWithAggregatesInput = {
    AND?: ScopeScalarWhereWithAggregatesInput | ScopeScalarWhereWithAggregatesInput[]
    OR?: ScopeScalarWhereWithAggregatesInput[]
    NOT?: ScopeScalarWhereWithAggregatesInput | ScopeScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"Scope"> | string
    realm_id?: StringWithAggregatesFilter<"Scope"> | string
    name?: StringWithAggregatesFilter<"Scope"> | string
    description?: StringNullableWithAggregatesFilter<"Scope"> | string | null
  }

  export type ClientScopeWhereInput = {
    AND?: ClientScopeWhereInput | ClientScopeWhereInput[]
    OR?: ClientScopeWhereInput[]
    NOT?: ClientScopeWhereInput | ClientScopeWhereInput[]
    client_id?: StringFilter<"ClientScope"> | string
    scope_id?: StringFilter<"ClientScope"> | string
    is_default?: BoolFilter<"ClientScope"> | boolean
    client?: XOR<ClientScalarRelationFilter, ClientWhereInput>
    scope?: XOR<ScopeScalarRelationFilter, ScopeWhereInput>
  }

  export type ClientScopeOrderByWithRelationInput = {
    client_id?: SortOrder
    scope_id?: SortOrder
    is_default?: SortOrder
    client?: ClientOrderByWithRelationInput
    scope?: ScopeOrderByWithRelationInput
  }

  export type ClientScopeWhereUniqueInput = Prisma.AtLeast<{
    client_id_scope_id?: ClientScopeClient_idScope_idCompoundUniqueInput
    AND?: ClientScopeWhereInput | ClientScopeWhereInput[]
    OR?: ClientScopeWhereInput[]
    NOT?: ClientScopeWhereInput | ClientScopeWhereInput[]
    client_id?: StringFilter<"ClientScope"> | string
    scope_id?: StringFilter<"ClientScope"> | string
    is_default?: BoolFilter<"ClientScope"> | boolean
    client?: XOR<ClientScalarRelationFilter, ClientWhereInput>
    scope?: XOR<ScopeScalarRelationFilter, ScopeWhereInput>
  }, "client_id_scope_id">

  export type ClientScopeOrderByWithAggregationInput = {
    client_id?: SortOrder
    scope_id?: SortOrder
    is_default?: SortOrder
    _count?: ClientScopeCountOrderByAggregateInput
    _max?: ClientScopeMaxOrderByAggregateInput
    _min?: ClientScopeMinOrderByAggregateInput
  }

  export type ClientScopeScalarWhereWithAggregatesInput = {
    AND?: ClientScopeScalarWhereWithAggregatesInput | ClientScopeScalarWhereWithAggregatesInput[]
    OR?: ClientScopeScalarWhereWithAggregatesInput[]
    NOT?: ClientScopeScalarWhereWithAggregatesInput | ClientScopeScalarWhereWithAggregatesInput[]
    client_id?: StringWithAggregatesFilter<"ClientScope"> | string
    scope_id?: StringWithAggregatesFilter<"ClientScope"> | string
    is_default?: BoolWithAggregatesFilter<"ClientScope"> | boolean
  }

  export type AuthorizationCodeWhereInput = {
    AND?: AuthorizationCodeWhereInput | AuthorizationCodeWhereInput[]
    OR?: AuthorizationCodeWhereInput[]
    NOT?: AuthorizationCodeWhereInput | AuthorizationCodeWhereInput[]
    code?: StringFilter<"AuthorizationCode"> | string
    user_id?: StringFilter<"AuthorizationCode"> | string
    client_id?: StringFilter<"AuthorizationCode"> | string
    redirect_uri?: StringFilter<"AuthorizationCode"> | string
    scope?: StringFilter<"AuthorizationCode"> | string
    expires_at?: DateTimeFilter<"AuthorizationCode"> | Date | string
    created_at?: DateTimeFilter<"AuthorizationCode"> | Date | string
    code_challenge?: StringNullableFilter<"AuthorizationCode"> | string | null
    user?: XOR<UserScalarRelationFilter, UserWhereInput>
    client?: XOR<ClientScalarRelationFilter, ClientWhereInput>
  }

  export type AuthorizationCodeOrderByWithRelationInput = {
    code?: SortOrder
    user_id?: SortOrder
    client_id?: SortOrder
    redirect_uri?: SortOrder
    scope?: SortOrder
    expires_at?: SortOrder
    created_at?: SortOrder
    code_challenge?: SortOrderInput | SortOrder
    user?: UserOrderByWithRelationInput
    client?: ClientOrderByWithRelationInput
  }

  export type AuthorizationCodeWhereUniqueInput = Prisma.AtLeast<{
    code?: string
    AND?: AuthorizationCodeWhereInput | AuthorizationCodeWhereInput[]
    OR?: AuthorizationCodeWhereInput[]
    NOT?: AuthorizationCodeWhereInput | AuthorizationCodeWhereInput[]
    user_id?: StringFilter<"AuthorizationCode"> | string
    client_id?: StringFilter<"AuthorizationCode"> | string
    redirect_uri?: StringFilter<"AuthorizationCode"> | string
    scope?: StringFilter<"AuthorizationCode"> | string
    expires_at?: DateTimeFilter<"AuthorizationCode"> | Date | string
    created_at?: DateTimeFilter<"AuthorizationCode"> | Date | string
    code_challenge?: StringNullableFilter<"AuthorizationCode"> | string | null
    user?: XOR<UserScalarRelationFilter, UserWhereInput>
    client?: XOR<ClientScalarRelationFilter, ClientWhereInput>
  }, "code">

  export type AuthorizationCodeOrderByWithAggregationInput = {
    code?: SortOrder
    user_id?: SortOrder
    client_id?: SortOrder
    redirect_uri?: SortOrder
    scope?: SortOrder
    expires_at?: SortOrder
    created_at?: SortOrder
    code_challenge?: SortOrderInput | SortOrder
    _count?: AuthorizationCodeCountOrderByAggregateInput
    _max?: AuthorizationCodeMaxOrderByAggregateInput
    _min?: AuthorizationCodeMinOrderByAggregateInput
  }

  export type AuthorizationCodeScalarWhereWithAggregatesInput = {
    AND?: AuthorizationCodeScalarWhereWithAggregatesInput | AuthorizationCodeScalarWhereWithAggregatesInput[]
    OR?: AuthorizationCodeScalarWhereWithAggregatesInput[]
    NOT?: AuthorizationCodeScalarWhereWithAggregatesInput | AuthorizationCodeScalarWhereWithAggregatesInput[]
    code?: StringWithAggregatesFilter<"AuthorizationCode"> | string
    user_id?: StringWithAggregatesFilter<"AuthorizationCode"> | string
    client_id?: StringWithAggregatesFilter<"AuthorizationCode"> | string
    redirect_uri?: StringWithAggregatesFilter<"AuthorizationCode"> | string
    scope?: StringWithAggregatesFilter<"AuthorizationCode"> | string
    expires_at?: DateTimeWithAggregatesFilter<"AuthorizationCode"> | Date | string
    created_at?: DateTimeWithAggregatesFilter<"AuthorizationCode"> | Date | string
    code_challenge?: StringNullableWithAggregatesFilter<"AuthorizationCode"> | string | null
  }

  export type TokenWhereInput = {
    AND?: TokenWhereInput | TokenWhereInput[]
    OR?: TokenWhereInput[]
    NOT?: TokenWhereInput | TokenWhereInput[]
    id?: StringFilter<"Token"> | string
    user_id?: StringNullableFilter<"Token"> | string | null
    client_id?: StringFilter<"Token"> | string
    token_type?: EnumTokenTypeFilter<"Token"> | $Enums.TokenType
    jwt_id?: StringFilter<"Token"> | string
    issued_at?: DateTimeFilter<"Token"> | Date | string
    expires_at?: DateTimeFilter<"Token"> | Date | string
    revoked_at?: DateTimeNullableFilter<"Token"> | Date | string | null
    scope?: StringFilter<"Token"> | string
    user?: XOR<UserNullableScalarRelationFilter, UserWhereInput> | null
    client?: XOR<ClientScalarRelationFilter, ClientWhereInput>
  }

  export type TokenOrderByWithRelationInput = {
    id?: SortOrder
    user_id?: SortOrderInput | SortOrder
    client_id?: SortOrder
    token_type?: SortOrder
    jwt_id?: SortOrder
    issued_at?: SortOrder
    expires_at?: SortOrder
    revoked_at?: SortOrderInput | SortOrder
    scope?: SortOrder
    user?: UserOrderByWithRelationInput
    client?: ClientOrderByWithRelationInput
  }

  export type TokenWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    jwt_id?: string
    AND?: TokenWhereInput | TokenWhereInput[]
    OR?: TokenWhereInput[]
    NOT?: TokenWhereInput | TokenWhereInput[]
    user_id?: StringNullableFilter<"Token"> | string | null
    client_id?: StringFilter<"Token"> | string
    token_type?: EnumTokenTypeFilter<"Token"> | $Enums.TokenType
    issued_at?: DateTimeFilter<"Token"> | Date | string
    expires_at?: DateTimeFilter<"Token"> | Date | string
    revoked_at?: DateTimeNullableFilter<"Token"> | Date | string | null
    scope?: StringFilter<"Token"> | string
    user?: XOR<UserNullableScalarRelationFilter, UserWhereInput> | null
    client?: XOR<ClientScalarRelationFilter, ClientWhereInput>
  }, "id" | "jwt_id">

  export type TokenOrderByWithAggregationInput = {
    id?: SortOrder
    user_id?: SortOrderInput | SortOrder
    client_id?: SortOrder
    token_type?: SortOrder
    jwt_id?: SortOrder
    issued_at?: SortOrder
    expires_at?: SortOrder
    revoked_at?: SortOrderInput | SortOrder
    scope?: SortOrder
    _count?: TokenCountOrderByAggregateInput
    _max?: TokenMaxOrderByAggregateInput
    _min?: TokenMinOrderByAggregateInput
  }

  export type TokenScalarWhereWithAggregatesInput = {
    AND?: TokenScalarWhereWithAggregatesInput | TokenScalarWhereWithAggregatesInput[]
    OR?: TokenScalarWhereWithAggregatesInput[]
    NOT?: TokenScalarWhereWithAggregatesInput | TokenScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"Token"> | string
    user_id?: StringNullableWithAggregatesFilter<"Token"> | string | null
    client_id?: StringWithAggregatesFilter<"Token"> | string
    token_type?: EnumTokenTypeWithAggregatesFilter<"Token"> | $Enums.TokenType
    jwt_id?: StringWithAggregatesFilter<"Token"> | string
    issued_at?: DateTimeWithAggregatesFilter<"Token"> | Date | string
    expires_at?: DateTimeWithAggregatesFilter<"Token"> | Date | string
    revoked_at?: DateTimeNullableWithAggregatesFilter<"Token"> | Date | string | null
    scope?: StringWithAggregatesFilter<"Token"> | string
  }

  export type RealmCreateInput = {
    id?: string
    name: string
    description?: string | null
    created_at?: Date | string
    keys?: RealmKeyCreateNestedManyWithoutRealmInput
    users?: UserCreateNestedManyWithoutRealmInput
    roles?: RoleCreateNestedManyWithoutRealmInput
    clients?: ClientCreateNestedManyWithoutRealmInput
    scopes?: ScopeCreateNestedManyWithoutRealmInput
  }

  export type RealmUncheckedCreateInput = {
    id?: string
    name: string
    description?: string | null
    created_at?: Date | string
    keys?: RealmKeyUncheckedCreateNestedManyWithoutRealmInput
    users?: UserUncheckedCreateNestedManyWithoutRealmInput
    roles?: RoleUncheckedCreateNestedManyWithoutRealmInput
    clients?: ClientUncheckedCreateNestedManyWithoutRealmInput
    scopes?: ScopeUncheckedCreateNestedManyWithoutRealmInput
  }

  export type RealmUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    keys?: RealmKeyUpdateManyWithoutRealmNestedInput
    users?: UserUpdateManyWithoutRealmNestedInput
    roles?: RoleUpdateManyWithoutRealmNestedInput
    clients?: ClientUpdateManyWithoutRealmNestedInput
    scopes?: ScopeUpdateManyWithoutRealmNestedInput
  }

  export type RealmUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    keys?: RealmKeyUncheckedUpdateManyWithoutRealmNestedInput
    users?: UserUncheckedUpdateManyWithoutRealmNestedInput
    roles?: RoleUncheckedUpdateManyWithoutRealmNestedInput
    clients?: ClientUncheckedUpdateManyWithoutRealmNestedInput
    scopes?: ScopeUncheckedUpdateManyWithoutRealmNestedInput
  }

  export type RealmCreateManyInput = {
    id?: string
    name: string
    description?: string | null
    created_at?: Date | string
  }

  export type RealmUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type RealmUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type RealmKeyCreateInput = {
    id?: string
    kid: string
    public_key: string
    private_key_enc: string
    alg: string
    created_at?: Date | string
    expires_at?: Date | string | null
    realm: RealmCreateNestedOneWithoutKeysInput
  }

  export type RealmKeyUncheckedCreateInput = {
    id?: string
    realm_id: string
    kid: string
    public_key: string
    private_key_enc: string
    alg: string
    created_at?: Date | string
    expires_at?: Date | string | null
  }

  export type RealmKeyUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    kid?: StringFieldUpdateOperationsInput | string
    public_key?: StringFieldUpdateOperationsInput | string
    private_key_enc?: StringFieldUpdateOperationsInput | string
    alg?: StringFieldUpdateOperationsInput | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    expires_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    realm?: RealmUpdateOneRequiredWithoutKeysNestedInput
  }

  export type RealmKeyUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    kid?: StringFieldUpdateOperationsInput | string
    public_key?: StringFieldUpdateOperationsInput | string
    private_key_enc?: StringFieldUpdateOperationsInput | string
    alg?: StringFieldUpdateOperationsInput | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    expires_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type RealmKeyCreateManyInput = {
    id?: string
    realm_id: string
    kid: string
    public_key: string
    private_key_enc: string
    alg: string
    created_at?: Date | string
    expires_at?: Date | string | null
  }

  export type RealmKeyUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    kid?: StringFieldUpdateOperationsInput | string
    public_key?: StringFieldUpdateOperationsInput | string
    private_key_enc?: StringFieldUpdateOperationsInput | string
    alg?: StringFieldUpdateOperationsInput | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    expires_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type RealmKeyUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    kid?: StringFieldUpdateOperationsInput | string
    public_key?: StringFieldUpdateOperationsInput | string
    private_key_enc?: StringFieldUpdateOperationsInput | string
    alg?: StringFieldUpdateOperationsInput | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    expires_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type UserCreateInput = {
    id?: string
    username: string
    email: string
    password_hash: string
    password_salt: string
    pbkdf2_iter: number
    totp_secret?: string | null
    totp_enabled?: boolean
    email_verified?: boolean
    is_active?: boolean
    created_at?: Date | string
    updated_at?: Date | string
    realm: RealmCreateNestedOneWithoutUsersInput
    roles?: UserRoleCreateNestedManyWithoutUserInput
    sessions?: UserSessionCreateNestedManyWithoutUserInput
    tokens?: TokenCreateNestedManyWithoutUserInput
    authorizationCodes?: AuthorizationCodeCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateInput = {
    id?: string
    realm_id: string
    username: string
    email: string
    password_hash: string
    password_salt: string
    pbkdf2_iter: number
    totp_secret?: string | null
    totp_enabled?: boolean
    email_verified?: boolean
    is_active?: boolean
    created_at?: Date | string
    updated_at?: Date | string
    roles?: UserRoleUncheckedCreateNestedManyWithoutUserInput
    sessions?: UserSessionUncheckedCreateNestedManyWithoutUserInput
    tokens?: TokenUncheckedCreateNestedManyWithoutUserInput
    authorizationCodes?: AuthorizationCodeUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password_hash?: StringFieldUpdateOperationsInput | string
    password_salt?: StringFieldUpdateOperationsInput | string
    pbkdf2_iter?: IntFieldUpdateOperationsInput | number
    totp_secret?: NullableStringFieldUpdateOperationsInput | string | null
    totp_enabled?: BoolFieldUpdateOperationsInput | boolean
    email_verified?: BoolFieldUpdateOperationsInput | boolean
    is_active?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    realm?: RealmUpdateOneRequiredWithoutUsersNestedInput
    roles?: UserRoleUpdateManyWithoutUserNestedInput
    sessions?: UserSessionUpdateManyWithoutUserNestedInput
    tokens?: TokenUpdateManyWithoutUserNestedInput
    authorizationCodes?: AuthorizationCodeUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password_hash?: StringFieldUpdateOperationsInput | string
    password_salt?: StringFieldUpdateOperationsInput | string
    pbkdf2_iter?: IntFieldUpdateOperationsInput | number
    totp_secret?: NullableStringFieldUpdateOperationsInput | string | null
    totp_enabled?: BoolFieldUpdateOperationsInput | boolean
    email_verified?: BoolFieldUpdateOperationsInput | boolean
    is_active?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    roles?: UserRoleUncheckedUpdateManyWithoutUserNestedInput
    sessions?: UserSessionUncheckedUpdateManyWithoutUserNestedInput
    tokens?: TokenUncheckedUpdateManyWithoutUserNestedInput
    authorizationCodes?: AuthorizationCodeUncheckedUpdateManyWithoutUserNestedInput
  }

  export type UserCreateManyInput = {
    id?: string
    realm_id: string
    username: string
    email: string
    password_hash: string
    password_salt: string
    pbkdf2_iter: number
    totp_secret?: string | null
    totp_enabled?: boolean
    email_verified?: boolean
    is_active?: boolean
    created_at?: Date | string
    updated_at?: Date | string
  }

  export type UserUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password_hash?: StringFieldUpdateOperationsInput | string
    password_salt?: StringFieldUpdateOperationsInput | string
    pbkdf2_iter?: IntFieldUpdateOperationsInput | number
    totp_secret?: NullableStringFieldUpdateOperationsInput | string | null
    totp_enabled?: BoolFieldUpdateOperationsInput | boolean
    email_verified?: BoolFieldUpdateOperationsInput | boolean
    is_active?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type UserUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password_hash?: StringFieldUpdateOperationsInput | string
    password_salt?: StringFieldUpdateOperationsInput | string
    pbkdf2_iter?: IntFieldUpdateOperationsInput | number
    totp_secret?: NullableStringFieldUpdateOperationsInput | string | null
    totp_enabled?: BoolFieldUpdateOperationsInput | boolean
    email_verified?: BoolFieldUpdateOperationsInput | boolean
    is_active?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type UserSessionCreateInput = {
    id?: string
    ip_addr: string
    user_agent: string
    login_time?: Date | string
    logout_time?: Date | string | null
    user: UserCreateNestedOneWithoutSessionsInput
    client: ClientCreateNestedOneWithoutUserSessionsInput
  }

  export type UserSessionUncheckedCreateInput = {
    id?: string
    user_id: string
    client_id: string
    ip_addr: string
    user_agent: string
    login_time?: Date | string
    logout_time?: Date | string | null
  }

  export type UserSessionUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    ip_addr?: StringFieldUpdateOperationsInput | string
    user_agent?: StringFieldUpdateOperationsInput | string
    login_time?: DateTimeFieldUpdateOperationsInput | Date | string
    logout_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    user?: UserUpdateOneRequiredWithoutSessionsNestedInput
    client?: ClientUpdateOneRequiredWithoutUserSessionsNestedInput
  }

  export type UserSessionUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    ip_addr?: StringFieldUpdateOperationsInput | string
    user_agent?: StringFieldUpdateOperationsInput | string
    login_time?: DateTimeFieldUpdateOperationsInput | Date | string
    logout_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type UserSessionCreateManyInput = {
    id?: string
    user_id: string
    client_id: string
    ip_addr: string
    user_agent: string
    login_time?: Date | string
    logout_time?: Date | string | null
  }

  export type UserSessionUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    ip_addr?: StringFieldUpdateOperationsInput | string
    user_agent?: StringFieldUpdateOperationsInput | string
    login_time?: DateTimeFieldUpdateOperationsInput | Date | string
    logout_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type UserSessionUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    ip_addr?: StringFieldUpdateOperationsInput | string
    user_agent?: StringFieldUpdateOperationsInput | string
    login_time?: DateTimeFieldUpdateOperationsInput | Date | string
    logout_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type RoleCreateInput = {
    id?: string
    name: string
    description?: string | null
    is_client_role?: boolean
    realm: RealmCreateNestedOneWithoutRolesInput
    client?: ClientCreateNestedOneWithoutRolesInput
    userLinks?: UserRoleCreateNestedManyWithoutRoleInput
  }

  export type RoleUncheckedCreateInput = {
    id?: string
    realm_id: string
    client_id?: string | null
    name: string
    description?: string | null
    is_client_role?: boolean
    userLinks?: UserRoleUncheckedCreateNestedManyWithoutRoleInput
  }

  export type RoleUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    is_client_role?: BoolFieldUpdateOperationsInput | boolean
    realm?: RealmUpdateOneRequiredWithoutRolesNestedInput
    client?: ClientUpdateOneWithoutRolesNestedInput
    userLinks?: UserRoleUpdateManyWithoutRoleNestedInput
  }

  export type RoleUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    client_id?: NullableStringFieldUpdateOperationsInput | string | null
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    is_client_role?: BoolFieldUpdateOperationsInput | boolean
    userLinks?: UserRoleUncheckedUpdateManyWithoutRoleNestedInput
  }

  export type RoleCreateManyInput = {
    id?: string
    realm_id: string
    client_id?: string | null
    name: string
    description?: string | null
    is_client_role?: boolean
  }

  export type RoleUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    is_client_role?: BoolFieldUpdateOperationsInput | boolean
  }

  export type RoleUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    client_id?: NullableStringFieldUpdateOperationsInput | string | null
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    is_client_role?: BoolFieldUpdateOperationsInput | boolean
  }

  export type UserRoleCreateInput = {
    user: UserCreateNestedOneWithoutRolesInput
    role: RoleCreateNestedOneWithoutUserLinksInput
  }

  export type UserRoleUncheckedCreateInput = {
    user_id: string
    role_id: string
  }

  export type UserRoleUpdateInput = {
    user?: UserUpdateOneRequiredWithoutRolesNestedInput
    role?: RoleUpdateOneRequiredWithoutUserLinksNestedInput
  }

  export type UserRoleUncheckedUpdateInput = {
    user_id?: StringFieldUpdateOperationsInput | string
    role_id?: StringFieldUpdateOperationsInput | string
  }

  export type UserRoleCreateManyInput = {
    user_id: string
    role_id: string
  }

  export type UserRoleUpdateManyMutationInput = {

  }

  export type UserRoleUncheckedUpdateManyInput = {
    user_id?: StringFieldUpdateOperationsInput | string
    role_id?: StringFieldUpdateOperationsInput | string
  }

  export type ClientCreateInput = {
    id?: string
    client_id: string
    client_name?: string | null
    client_secret_hash: string
    redirect_uris?: ClientCreateredirect_urisInput | string[]
    grant_types?: ClientCreategrant_typesInput | string[]
    access_token_life?: number
    refresh_token_life?: number
    created_at?: Date | string
    realm: RealmCreateNestedOneWithoutClientsInput
    roles?: RoleCreateNestedManyWithoutClientInput
    scopes?: ClientScopeCreateNestedManyWithoutClientInput
    userSessions?: UserSessionCreateNestedManyWithoutClientInput
    tokens?: TokenCreateNestedManyWithoutClientInput
    authorizationCodes?: AuthorizationCodeCreateNestedManyWithoutClientInput
  }

  export type ClientUncheckedCreateInput = {
    id?: string
    realm_id: string
    client_id: string
    client_name?: string | null
    client_secret_hash: string
    redirect_uris?: ClientCreateredirect_urisInput | string[]
    grant_types?: ClientCreategrant_typesInput | string[]
    access_token_life?: number
    refresh_token_life?: number
    created_at?: Date | string
    roles?: RoleUncheckedCreateNestedManyWithoutClientInput
    scopes?: ClientScopeUncheckedCreateNestedManyWithoutClientInput
    userSessions?: UserSessionUncheckedCreateNestedManyWithoutClientInput
    tokens?: TokenUncheckedCreateNestedManyWithoutClientInput
    authorizationCodes?: AuthorizationCodeUncheckedCreateNestedManyWithoutClientInput
  }

  export type ClientUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    client_name?: NullableStringFieldUpdateOperationsInput | string | null
    client_secret_hash?: StringFieldUpdateOperationsInput | string
    redirect_uris?: ClientUpdateredirect_urisInput | string[]
    grant_types?: ClientUpdategrant_typesInput | string[]
    access_token_life?: IntFieldUpdateOperationsInput | number
    refresh_token_life?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    realm?: RealmUpdateOneRequiredWithoutClientsNestedInput
    roles?: RoleUpdateManyWithoutClientNestedInput
    scopes?: ClientScopeUpdateManyWithoutClientNestedInput
    userSessions?: UserSessionUpdateManyWithoutClientNestedInput
    tokens?: TokenUpdateManyWithoutClientNestedInput
    authorizationCodes?: AuthorizationCodeUpdateManyWithoutClientNestedInput
  }

  export type ClientUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    client_name?: NullableStringFieldUpdateOperationsInput | string | null
    client_secret_hash?: StringFieldUpdateOperationsInput | string
    redirect_uris?: ClientUpdateredirect_urisInput | string[]
    grant_types?: ClientUpdategrant_typesInput | string[]
    access_token_life?: IntFieldUpdateOperationsInput | number
    refresh_token_life?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    roles?: RoleUncheckedUpdateManyWithoutClientNestedInput
    scopes?: ClientScopeUncheckedUpdateManyWithoutClientNestedInput
    userSessions?: UserSessionUncheckedUpdateManyWithoutClientNestedInput
    tokens?: TokenUncheckedUpdateManyWithoutClientNestedInput
    authorizationCodes?: AuthorizationCodeUncheckedUpdateManyWithoutClientNestedInput
  }

  export type ClientCreateManyInput = {
    id?: string
    realm_id: string
    client_id: string
    client_name?: string | null
    client_secret_hash: string
    redirect_uris?: ClientCreateredirect_urisInput | string[]
    grant_types?: ClientCreategrant_typesInput | string[]
    access_token_life?: number
    refresh_token_life?: number
    created_at?: Date | string
  }

  export type ClientUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    client_name?: NullableStringFieldUpdateOperationsInput | string | null
    client_secret_hash?: StringFieldUpdateOperationsInput | string
    redirect_uris?: ClientUpdateredirect_urisInput | string[]
    grant_types?: ClientUpdategrant_typesInput | string[]
    access_token_life?: IntFieldUpdateOperationsInput | number
    refresh_token_life?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type ClientUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    client_name?: NullableStringFieldUpdateOperationsInput | string | null
    client_secret_hash?: StringFieldUpdateOperationsInput | string
    redirect_uris?: ClientUpdateredirect_urisInput | string[]
    grant_types?: ClientUpdategrant_typesInput | string[]
    access_token_life?: IntFieldUpdateOperationsInput | number
    refresh_token_life?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type ScopeCreateInput = {
    id?: string
    name: string
    description?: string | null
    realm: RealmCreateNestedOneWithoutScopesInput
    clients?: ClientScopeCreateNestedManyWithoutScopeInput
  }

  export type ScopeUncheckedCreateInput = {
    id?: string
    realm_id: string
    name: string
    description?: string | null
    clients?: ClientScopeUncheckedCreateNestedManyWithoutScopeInput
  }

  export type ScopeUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    realm?: RealmUpdateOneRequiredWithoutScopesNestedInput
    clients?: ClientScopeUpdateManyWithoutScopeNestedInput
  }

  export type ScopeUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    clients?: ClientScopeUncheckedUpdateManyWithoutScopeNestedInput
  }

  export type ScopeCreateManyInput = {
    id?: string
    realm_id: string
    name: string
    description?: string | null
  }

  export type ScopeUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type ScopeUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type ClientScopeCreateInput = {
    is_default?: boolean
    client: ClientCreateNestedOneWithoutScopesInput
    scope: ScopeCreateNestedOneWithoutClientsInput
  }

  export type ClientScopeUncheckedCreateInput = {
    client_id: string
    scope_id: string
    is_default?: boolean
  }

  export type ClientScopeUpdateInput = {
    is_default?: BoolFieldUpdateOperationsInput | boolean
    client?: ClientUpdateOneRequiredWithoutScopesNestedInput
    scope?: ScopeUpdateOneRequiredWithoutClientsNestedInput
  }

  export type ClientScopeUncheckedUpdateInput = {
    client_id?: StringFieldUpdateOperationsInput | string
    scope_id?: StringFieldUpdateOperationsInput | string
    is_default?: BoolFieldUpdateOperationsInput | boolean
  }

  export type ClientScopeCreateManyInput = {
    client_id: string
    scope_id: string
    is_default?: boolean
  }

  export type ClientScopeUpdateManyMutationInput = {
    is_default?: BoolFieldUpdateOperationsInput | boolean
  }

  export type ClientScopeUncheckedUpdateManyInput = {
    client_id?: StringFieldUpdateOperationsInput | string
    scope_id?: StringFieldUpdateOperationsInput | string
    is_default?: BoolFieldUpdateOperationsInput | boolean
  }

  export type AuthorizationCodeCreateInput = {
    code: string
    redirect_uri: string
    scope: string
    expires_at: Date | string
    created_at?: Date | string
    code_challenge?: string | null
    user: UserCreateNestedOneWithoutAuthorizationCodesInput
    client: ClientCreateNestedOneWithoutAuthorizationCodesInput
  }

  export type AuthorizationCodeUncheckedCreateInput = {
    code: string
    user_id: string
    client_id: string
    redirect_uri: string
    scope: string
    expires_at: Date | string
    created_at?: Date | string
    code_challenge?: string | null
  }

  export type AuthorizationCodeUpdateInput = {
    code?: StringFieldUpdateOperationsInput | string
    redirect_uri?: StringFieldUpdateOperationsInput | string
    scope?: StringFieldUpdateOperationsInput | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    code_challenge?: NullableStringFieldUpdateOperationsInput | string | null
    user?: UserUpdateOneRequiredWithoutAuthorizationCodesNestedInput
    client?: ClientUpdateOneRequiredWithoutAuthorizationCodesNestedInput
  }

  export type AuthorizationCodeUncheckedUpdateInput = {
    code?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    redirect_uri?: StringFieldUpdateOperationsInput | string
    scope?: StringFieldUpdateOperationsInput | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    code_challenge?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type AuthorizationCodeCreateManyInput = {
    code: string
    user_id: string
    client_id: string
    redirect_uri: string
    scope: string
    expires_at: Date | string
    created_at?: Date | string
    code_challenge?: string | null
  }

  export type AuthorizationCodeUpdateManyMutationInput = {
    code?: StringFieldUpdateOperationsInput | string
    redirect_uri?: StringFieldUpdateOperationsInput | string
    scope?: StringFieldUpdateOperationsInput | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    code_challenge?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type AuthorizationCodeUncheckedUpdateManyInput = {
    code?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    redirect_uri?: StringFieldUpdateOperationsInput | string
    scope?: StringFieldUpdateOperationsInput | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    code_challenge?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type TokenCreateInput = {
    id?: string
    token_type: $Enums.TokenType
    jwt_id: string
    issued_at?: Date | string
    expires_at: Date | string
    revoked_at?: Date | string | null
    scope: string
    user?: UserCreateNestedOneWithoutTokensInput
    client: ClientCreateNestedOneWithoutTokensInput
  }

  export type TokenUncheckedCreateInput = {
    id?: string
    user_id?: string | null
    client_id: string
    token_type: $Enums.TokenType
    jwt_id: string
    issued_at?: Date | string
    expires_at: Date | string
    revoked_at?: Date | string | null
    scope: string
  }

  export type TokenUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    token_type?: EnumTokenTypeFieldUpdateOperationsInput | $Enums.TokenType
    jwt_id?: StringFieldUpdateOperationsInput | string
    issued_at?: DateTimeFieldUpdateOperationsInput | Date | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    revoked_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    scope?: StringFieldUpdateOperationsInput | string
    user?: UserUpdateOneWithoutTokensNestedInput
    client?: ClientUpdateOneRequiredWithoutTokensNestedInput
  }

  export type TokenUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: NullableStringFieldUpdateOperationsInput | string | null
    client_id?: StringFieldUpdateOperationsInput | string
    token_type?: EnumTokenTypeFieldUpdateOperationsInput | $Enums.TokenType
    jwt_id?: StringFieldUpdateOperationsInput | string
    issued_at?: DateTimeFieldUpdateOperationsInput | Date | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    revoked_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    scope?: StringFieldUpdateOperationsInput | string
  }

  export type TokenCreateManyInput = {
    id?: string
    user_id?: string | null
    client_id: string
    token_type: $Enums.TokenType
    jwt_id: string
    issued_at?: Date | string
    expires_at: Date | string
    revoked_at?: Date | string | null
    scope: string
  }

  export type TokenUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    token_type?: EnumTokenTypeFieldUpdateOperationsInput | $Enums.TokenType
    jwt_id?: StringFieldUpdateOperationsInput | string
    issued_at?: DateTimeFieldUpdateOperationsInput | Date | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    revoked_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    scope?: StringFieldUpdateOperationsInput | string
  }

  export type TokenUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: NullableStringFieldUpdateOperationsInput | string | null
    client_id?: StringFieldUpdateOperationsInput | string
    token_type?: EnumTokenTypeFieldUpdateOperationsInput | $Enums.TokenType
    jwt_id?: StringFieldUpdateOperationsInput | string
    issued_at?: DateTimeFieldUpdateOperationsInput | Date | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    revoked_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    scope?: StringFieldUpdateOperationsInput | string
  }

  export type StringFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[] | ListStringFieldRefInput<$PrismaModel>
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel>
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    mode?: QueryMode
    not?: NestedStringFilter<$PrismaModel> | string
  }

  export type StringNullableFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | ListStringFieldRefInput<$PrismaModel> | null
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel> | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    mode?: QueryMode
    not?: NestedStringNullableFilter<$PrismaModel> | string | null
  }

  export type DateTimeFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeFilter<$PrismaModel> | Date | string
  }

  export type RealmKeyListRelationFilter = {
    every?: RealmKeyWhereInput
    some?: RealmKeyWhereInput
    none?: RealmKeyWhereInput
  }

  export type UserListRelationFilter = {
    every?: UserWhereInput
    some?: UserWhereInput
    none?: UserWhereInput
  }

  export type RoleListRelationFilter = {
    every?: RoleWhereInput
    some?: RoleWhereInput
    none?: RoleWhereInput
  }

  export type ClientListRelationFilter = {
    every?: ClientWhereInput
    some?: ClientWhereInput
    none?: ClientWhereInput
  }

  export type ScopeListRelationFilter = {
    every?: ScopeWhereInput
    some?: ScopeWhereInput
    none?: ScopeWhereInput
  }

  export type SortOrderInput = {
    sort: SortOrder
    nulls?: NullsOrder
  }

  export type RealmKeyOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type UserOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type RoleOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type ClientOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type ScopeOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type RealmCountOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    description?: SortOrder
    created_at?: SortOrder
  }

  export type RealmMaxOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    description?: SortOrder
    created_at?: SortOrder
  }

  export type RealmMinOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    description?: SortOrder
    created_at?: SortOrder
  }

  export type StringWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[] | ListStringFieldRefInput<$PrismaModel>
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel>
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    mode?: QueryMode
    not?: NestedStringWithAggregatesFilter<$PrismaModel> | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedStringFilter<$PrismaModel>
    _max?: NestedStringFilter<$PrismaModel>
  }

  export type StringNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | ListStringFieldRefInput<$PrismaModel> | null
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel> | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    mode?: QueryMode
    not?: NestedStringNullableWithAggregatesFilter<$PrismaModel> | string | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedStringNullableFilter<$PrismaModel>
    _max?: NestedStringNullableFilter<$PrismaModel>
  }

  export type DateTimeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeWithAggregatesFilter<$PrismaModel> | Date | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedDateTimeFilter<$PrismaModel>
    _max?: NestedDateTimeFilter<$PrismaModel>
  }

  export type DateTimeNullableFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel> | null
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeNullableFilter<$PrismaModel> | Date | string | null
  }

  export type RealmScalarRelationFilter = {
    is?: RealmWhereInput
    isNot?: RealmWhereInput
  }

  export type RealmKeyCountOrderByAggregateInput = {
    id?: SortOrder
    realm_id?: SortOrder
    kid?: SortOrder
    public_key?: SortOrder
    private_key_enc?: SortOrder
    alg?: SortOrder
    created_at?: SortOrder
    expires_at?: SortOrder
  }

  export type RealmKeyMaxOrderByAggregateInput = {
    id?: SortOrder
    realm_id?: SortOrder
    kid?: SortOrder
    public_key?: SortOrder
    private_key_enc?: SortOrder
    alg?: SortOrder
    created_at?: SortOrder
    expires_at?: SortOrder
  }

  export type RealmKeyMinOrderByAggregateInput = {
    id?: SortOrder
    realm_id?: SortOrder
    kid?: SortOrder
    public_key?: SortOrder
    private_key_enc?: SortOrder
    alg?: SortOrder
    created_at?: SortOrder
    expires_at?: SortOrder
  }

  export type DateTimeNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel> | null
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeNullableWithAggregatesFilter<$PrismaModel> | Date | string | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedDateTimeNullableFilter<$PrismaModel>
    _max?: NestedDateTimeNullableFilter<$PrismaModel>
  }

  export type IntFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[] | ListIntFieldRefInput<$PrismaModel>
    notIn?: number[] | ListIntFieldRefInput<$PrismaModel>
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntFilter<$PrismaModel> | number
  }

  export type BoolFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolFilter<$PrismaModel> | boolean
  }

  export type UserRoleListRelationFilter = {
    every?: UserRoleWhereInput
    some?: UserRoleWhereInput
    none?: UserRoleWhereInput
  }

  export type UserSessionListRelationFilter = {
    every?: UserSessionWhereInput
    some?: UserSessionWhereInput
    none?: UserSessionWhereInput
  }

  export type TokenListRelationFilter = {
    every?: TokenWhereInput
    some?: TokenWhereInput
    none?: TokenWhereInput
  }

  export type AuthorizationCodeListRelationFilter = {
    every?: AuthorizationCodeWhereInput
    some?: AuthorizationCodeWhereInput
    none?: AuthorizationCodeWhereInput
  }

  export type UserRoleOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type UserSessionOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type TokenOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type AuthorizationCodeOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type UserRealm_idUsernameCompoundUniqueInput = {
    realm_id: string
    username: string
  }

  export type UserRealm_idEmailCompoundUniqueInput = {
    realm_id: string
    email: string
  }

  export type UserCountOrderByAggregateInput = {
    id?: SortOrder
    realm_id?: SortOrder
    username?: SortOrder
    email?: SortOrder
    password_hash?: SortOrder
    password_salt?: SortOrder
    pbkdf2_iter?: SortOrder
    totp_secret?: SortOrder
    totp_enabled?: SortOrder
    email_verified?: SortOrder
    is_active?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
  }

  export type UserAvgOrderByAggregateInput = {
    pbkdf2_iter?: SortOrder
  }

  export type UserMaxOrderByAggregateInput = {
    id?: SortOrder
    realm_id?: SortOrder
    username?: SortOrder
    email?: SortOrder
    password_hash?: SortOrder
    password_salt?: SortOrder
    pbkdf2_iter?: SortOrder
    totp_secret?: SortOrder
    totp_enabled?: SortOrder
    email_verified?: SortOrder
    is_active?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
  }

  export type UserMinOrderByAggregateInput = {
    id?: SortOrder
    realm_id?: SortOrder
    username?: SortOrder
    email?: SortOrder
    password_hash?: SortOrder
    password_salt?: SortOrder
    pbkdf2_iter?: SortOrder
    totp_secret?: SortOrder
    totp_enabled?: SortOrder
    email_verified?: SortOrder
    is_active?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
  }

  export type UserSumOrderByAggregateInput = {
    pbkdf2_iter?: SortOrder
  }

  export type IntWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[] | ListIntFieldRefInput<$PrismaModel>
    notIn?: number[] | ListIntFieldRefInput<$PrismaModel>
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntWithAggregatesFilter<$PrismaModel> | number
    _count?: NestedIntFilter<$PrismaModel>
    _avg?: NestedFloatFilter<$PrismaModel>
    _sum?: NestedIntFilter<$PrismaModel>
    _min?: NestedIntFilter<$PrismaModel>
    _max?: NestedIntFilter<$PrismaModel>
  }

  export type BoolWithAggregatesFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolWithAggregatesFilter<$PrismaModel> | boolean
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedBoolFilter<$PrismaModel>
    _max?: NestedBoolFilter<$PrismaModel>
  }

  export type UserScalarRelationFilter = {
    is?: UserWhereInput
    isNot?: UserWhereInput
  }

  export type ClientScalarRelationFilter = {
    is?: ClientWhereInput
    isNot?: ClientWhereInput
  }

  export type UserSessionCountOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    client_id?: SortOrder
    ip_addr?: SortOrder
    user_agent?: SortOrder
    login_time?: SortOrder
    logout_time?: SortOrder
  }

  export type UserSessionMaxOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    client_id?: SortOrder
    ip_addr?: SortOrder
    user_agent?: SortOrder
    login_time?: SortOrder
    logout_time?: SortOrder
  }

  export type UserSessionMinOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    client_id?: SortOrder
    ip_addr?: SortOrder
    user_agent?: SortOrder
    login_time?: SortOrder
    logout_time?: SortOrder
  }

  export type ClientNullableScalarRelationFilter = {
    is?: ClientWhereInput | null
    isNot?: ClientWhereInput | null
  }

  export type RoleRealm_idClient_idNameCompoundUniqueInput = {
    realm_id: string
    client_id: string
    name: string
  }

  export type RoleCountOrderByAggregateInput = {
    id?: SortOrder
    realm_id?: SortOrder
    client_id?: SortOrder
    name?: SortOrder
    description?: SortOrder
    is_client_role?: SortOrder
  }

  export type RoleMaxOrderByAggregateInput = {
    id?: SortOrder
    realm_id?: SortOrder
    client_id?: SortOrder
    name?: SortOrder
    description?: SortOrder
    is_client_role?: SortOrder
  }

  export type RoleMinOrderByAggregateInput = {
    id?: SortOrder
    realm_id?: SortOrder
    client_id?: SortOrder
    name?: SortOrder
    description?: SortOrder
    is_client_role?: SortOrder
  }

  export type RoleScalarRelationFilter = {
    is?: RoleWhereInput
    isNot?: RoleWhereInput
  }

  export type UserRoleUser_idRole_idCompoundUniqueInput = {
    user_id: string
    role_id: string
  }

  export type UserRoleCountOrderByAggregateInput = {
    user_id?: SortOrder
    role_id?: SortOrder
  }

  export type UserRoleMaxOrderByAggregateInput = {
    user_id?: SortOrder
    role_id?: SortOrder
  }

  export type UserRoleMinOrderByAggregateInput = {
    user_id?: SortOrder
    role_id?: SortOrder
  }

  export type StringNullableListFilter<$PrismaModel = never> = {
    equals?: string[] | ListStringFieldRefInput<$PrismaModel> | null
    has?: string | StringFieldRefInput<$PrismaModel> | null
    hasEvery?: string[] | ListStringFieldRefInput<$PrismaModel>
    hasSome?: string[] | ListStringFieldRefInput<$PrismaModel>
    isEmpty?: boolean
  }

  export type ClientScopeListRelationFilter = {
    every?: ClientScopeWhereInput
    some?: ClientScopeWhereInput
    none?: ClientScopeWhereInput
  }

  export type ClientScopeOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type ClientRealm_idClient_idCompoundUniqueInput = {
    realm_id: string
    client_id: string
  }

  export type ClientCountOrderByAggregateInput = {
    id?: SortOrder
    realm_id?: SortOrder
    client_id?: SortOrder
    client_name?: SortOrder
    client_secret_hash?: SortOrder
    redirect_uris?: SortOrder
    grant_types?: SortOrder
    access_token_life?: SortOrder
    refresh_token_life?: SortOrder
    created_at?: SortOrder
  }

  export type ClientAvgOrderByAggregateInput = {
    access_token_life?: SortOrder
    refresh_token_life?: SortOrder
  }

  export type ClientMaxOrderByAggregateInput = {
    id?: SortOrder
    realm_id?: SortOrder
    client_id?: SortOrder
    client_name?: SortOrder
    client_secret_hash?: SortOrder
    access_token_life?: SortOrder
    refresh_token_life?: SortOrder
    created_at?: SortOrder
  }

  export type ClientMinOrderByAggregateInput = {
    id?: SortOrder
    realm_id?: SortOrder
    client_id?: SortOrder
    client_name?: SortOrder
    client_secret_hash?: SortOrder
    access_token_life?: SortOrder
    refresh_token_life?: SortOrder
    created_at?: SortOrder
  }

  export type ClientSumOrderByAggregateInput = {
    access_token_life?: SortOrder
    refresh_token_life?: SortOrder
  }

  export type ScopeRealm_idNameCompoundUniqueInput = {
    realm_id: string
    name: string
  }

  export type ScopeCountOrderByAggregateInput = {
    id?: SortOrder
    realm_id?: SortOrder
    name?: SortOrder
    description?: SortOrder
  }

  export type ScopeMaxOrderByAggregateInput = {
    id?: SortOrder
    realm_id?: SortOrder
    name?: SortOrder
    description?: SortOrder
  }

  export type ScopeMinOrderByAggregateInput = {
    id?: SortOrder
    realm_id?: SortOrder
    name?: SortOrder
    description?: SortOrder
  }

  export type ScopeScalarRelationFilter = {
    is?: ScopeWhereInput
    isNot?: ScopeWhereInput
  }

  export type ClientScopeClient_idScope_idCompoundUniqueInput = {
    client_id: string
    scope_id: string
  }

  export type ClientScopeCountOrderByAggregateInput = {
    client_id?: SortOrder
    scope_id?: SortOrder
    is_default?: SortOrder
  }

  export type ClientScopeMaxOrderByAggregateInput = {
    client_id?: SortOrder
    scope_id?: SortOrder
    is_default?: SortOrder
  }

  export type ClientScopeMinOrderByAggregateInput = {
    client_id?: SortOrder
    scope_id?: SortOrder
    is_default?: SortOrder
  }

  export type AuthorizationCodeCountOrderByAggregateInput = {
    code?: SortOrder
    user_id?: SortOrder
    client_id?: SortOrder
    redirect_uri?: SortOrder
    scope?: SortOrder
    expires_at?: SortOrder
    created_at?: SortOrder
    code_challenge?: SortOrder
  }

  export type AuthorizationCodeMaxOrderByAggregateInput = {
    code?: SortOrder
    user_id?: SortOrder
    client_id?: SortOrder
    redirect_uri?: SortOrder
    scope?: SortOrder
    expires_at?: SortOrder
    created_at?: SortOrder
    code_challenge?: SortOrder
  }

  export type AuthorizationCodeMinOrderByAggregateInput = {
    code?: SortOrder
    user_id?: SortOrder
    client_id?: SortOrder
    redirect_uri?: SortOrder
    scope?: SortOrder
    expires_at?: SortOrder
    created_at?: SortOrder
    code_challenge?: SortOrder
  }

  export type EnumTokenTypeFilter<$PrismaModel = never> = {
    equals?: $Enums.TokenType | EnumTokenTypeFieldRefInput<$PrismaModel>
    in?: $Enums.TokenType[] | ListEnumTokenTypeFieldRefInput<$PrismaModel>
    notIn?: $Enums.TokenType[] | ListEnumTokenTypeFieldRefInput<$PrismaModel>
    not?: NestedEnumTokenTypeFilter<$PrismaModel> | $Enums.TokenType
  }

  export type UserNullableScalarRelationFilter = {
    is?: UserWhereInput | null
    isNot?: UserWhereInput | null
  }

  export type TokenCountOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    client_id?: SortOrder
    token_type?: SortOrder
    jwt_id?: SortOrder
    issued_at?: SortOrder
    expires_at?: SortOrder
    revoked_at?: SortOrder
    scope?: SortOrder
  }

  export type TokenMaxOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    client_id?: SortOrder
    token_type?: SortOrder
    jwt_id?: SortOrder
    issued_at?: SortOrder
    expires_at?: SortOrder
    revoked_at?: SortOrder
    scope?: SortOrder
  }

  export type TokenMinOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    client_id?: SortOrder
    token_type?: SortOrder
    jwt_id?: SortOrder
    issued_at?: SortOrder
    expires_at?: SortOrder
    revoked_at?: SortOrder
    scope?: SortOrder
  }

  export type EnumTokenTypeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.TokenType | EnumTokenTypeFieldRefInput<$PrismaModel>
    in?: $Enums.TokenType[] | ListEnumTokenTypeFieldRefInput<$PrismaModel>
    notIn?: $Enums.TokenType[] | ListEnumTokenTypeFieldRefInput<$PrismaModel>
    not?: NestedEnumTokenTypeWithAggregatesFilter<$PrismaModel> | $Enums.TokenType
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumTokenTypeFilter<$PrismaModel>
    _max?: NestedEnumTokenTypeFilter<$PrismaModel>
  }

  export type RealmKeyCreateNestedManyWithoutRealmInput = {
    create?: XOR<RealmKeyCreateWithoutRealmInput, RealmKeyUncheckedCreateWithoutRealmInput> | RealmKeyCreateWithoutRealmInput[] | RealmKeyUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: RealmKeyCreateOrConnectWithoutRealmInput | RealmKeyCreateOrConnectWithoutRealmInput[]
    createMany?: RealmKeyCreateManyRealmInputEnvelope
    connect?: RealmKeyWhereUniqueInput | RealmKeyWhereUniqueInput[]
  }

  export type UserCreateNestedManyWithoutRealmInput = {
    create?: XOR<UserCreateWithoutRealmInput, UserUncheckedCreateWithoutRealmInput> | UserCreateWithoutRealmInput[] | UserUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: UserCreateOrConnectWithoutRealmInput | UserCreateOrConnectWithoutRealmInput[]
    createMany?: UserCreateManyRealmInputEnvelope
    connect?: UserWhereUniqueInput | UserWhereUniqueInput[]
  }

  export type RoleCreateNestedManyWithoutRealmInput = {
    create?: XOR<RoleCreateWithoutRealmInput, RoleUncheckedCreateWithoutRealmInput> | RoleCreateWithoutRealmInput[] | RoleUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: RoleCreateOrConnectWithoutRealmInput | RoleCreateOrConnectWithoutRealmInput[]
    createMany?: RoleCreateManyRealmInputEnvelope
    connect?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
  }

  export type ClientCreateNestedManyWithoutRealmInput = {
    create?: XOR<ClientCreateWithoutRealmInput, ClientUncheckedCreateWithoutRealmInput> | ClientCreateWithoutRealmInput[] | ClientUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: ClientCreateOrConnectWithoutRealmInput | ClientCreateOrConnectWithoutRealmInput[]
    createMany?: ClientCreateManyRealmInputEnvelope
    connect?: ClientWhereUniqueInput | ClientWhereUniqueInput[]
  }

  export type ScopeCreateNestedManyWithoutRealmInput = {
    create?: XOR<ScopeCreateWithoutRealmInput, ScopeUncheckedCreateWithoutRealmInput> | ScopeCreateWithoutRealmInput[] | ScopeUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: ScopeCreateOrConnectWithoutRealmInput | ScopeCreateOrConnectWithoutRealmInput[]
    createMany?: ScopeCreateManyRealmInputEnvelope
    connect?: ScopeWhereUniqueInput | ScopeWhereUniqueInput[]
  }

  export type RealmKeyUncheckedCreateNestedManyWithoutRealmInput = {
    create?: XOR<RealmKeyCreateWithoutRealmInput, RealmKeyUncheckedCreateWithoutRealmInput> | RealmKeyCreateWithoutRealmInput[] | RealmKeyUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: RealmKeyCreateOrConnectWithoutRealmInput | RealmKeyCreateOrConnectWithoutRealmInput[]
    createMany?: RealmKeyCreateManyRealmInputEnvelope
    connect?: RealmKeyWhereUniqueInput | RealmKeyWhereUniqueInput[]
  }

  export type UserUncheckedCreateNestedManyWithoutRealmInput = {
    create?: XOR<UserCreateWithoutRealmInput, UserUncheckedCreateWithoutRealmInput> | UserCreateWithoutRealmInput[] | UserUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: UserCreateOrConnectWithoutRealmInput | UserCreateOrConnectWithoutRealmInput[]
    createMany?: UserCreateManyRealmInputEnvelope
    connect?: UserWhereUniqueInput | UserWhereUniqueInput[]
  }

  export type RoleUncheckedCreateNestedManyWithoutRealmInput = {
    create?: XOR<RoleCreateWithoutRealmInput, RoleUncheckedCreateWithoutRealmInput> | RoleCreateWithoutRealmInput[] | RoleUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: RoleCreateOrConnectWithoutRealmInput | RoleCreateOrConnectWithoutRealmInput[]
    createMany?: RoleCreateManyRealmInputEnvelope
    connect?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
  }

  export type ClientUncheckedCreateNestedManyWithoutRealmInput = {
    create?: XOR<ClientCreateWithoutRealmInput, ClientUncheckedCreateWithoutRealmInput> | ClientCreateWithoutRealmInput[] | ClientUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: ClientCreateOrConnectWithoutRealmInput | ClientCreateOrConnectWithoutRealmInput[]
    createMany?: ClientCreateManyRealmInputEnvelope
    connect?: ClientWhereUniqueInput | ClientWhereUniqueInput[]
  }

  export type ScopeUncheckedCreateNestedManyWithoutRealmInput = {
    create?: XOR<ScopeCreateWithoutRealmInput, ScopeUncheckedCreateWithoutRealmInput> | ScopeCreateWithoutRealmInput[] | ScopeUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: ScopeCreateOrConnectWithoutRealmInput | ScopeCreateOrConnectWithoutRealmInput[]
    createMany?: ScopeCreateManyRealmInputEnvelope
    connect?: ScopeWhereUniqueInput | ScopeWhereUniqueInput[]
  }

  export type StringFieldUpdateOperationsInput = {
    set?: string
  }

  export type NullableStringFieldUpdateOperationsInput = {
    set?: string | null
  }

  export type DateTimeFieldUpdateOperationsInput = {
    set?: Date | string
  }

  export type RealmKeyUpdateManyWithoutRealmNestedInput = {
    create?: XOR<RealmKeyCreateWithoutRealmInput, RealmKeyUncheckedCreateWithoutRealmInput> | RealmKeyCreateWithoutRealmInput[] | RealmKeyUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: RealmKeyCreateOrConnectWithoutRealmInput | RealmKeyCreateOrConnectWithoutRealmInput[]
    upsert?: RealmKeyUpsertWithWhereUniqueWithoutRealmInput | RealmKeyUpsertWithWhereUniqueWithoutRealmInput[]
    createMany?: RealmKeyCreateManyRealmInputEnvelope
    set?: RealmKeyWhereUniqueInput | RealmKeyWhereUniqueInput[]
    disconnect?: RealmKeyWhereUniqueInput | RealmKeyWhereUniqueInput[]
    delete?: RealmKeyWhereUniqueInput | RealmKeyWhereUniqueInput[]
    connect?: RealmKeyWhereUniqueInput | RealmKeyWhereUniqueInput[]
    update?: RealmKeyUpdateWithWhereUniqueWithoutRealmInput | RealmKeyUpdateWithWhereUniqueWithoutRealmInput[]
    updateMany?: RealmKeyUpdateManyWithWhereWithoutRealmInput | RealmKeyUpdateManyWithWhereWithoutRealmInput[]
    deleteMany?: RealmKeyScalarWhereInput | RealmKeyScalarWhereInput[]
  }

  export type UserUpdateManyWithoutRealmNestedInput = {
    create?: XOR<UserCreateWithoutRealmInput, UserUncheckedCreateWithoutRealmInput> | UserCreateWithoutRealmInput[] | UserUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: UserCreateOrConnectWithoutRealmInput | UserCreateOrConnectWithoutRealmInput[]
    upsert?: UserUpsertWithWhereUniqueWithoutRealmInput | UserUpsertWithWhereUniqueWithoutRealmInput[]
    createMany?: UserCreateManyRealmInputEnvelope
    set?: UserWhereUniqueInput | UserWhereUniqueInput[]
    disconnect?: UserWhereUniqueInput | UserWhereUniqueInput[]
    delete?: UserWhereUniqueInput | UserWhereUniqueInput[]
    connect?: UserWhereUniqueInput | UserWhereUniqueInput[]
    update?: UserUpdateWithWhereUniqueWithoutRealmInput | UserUpdateWithWhereUniqueWithoutRealmInput[]
    updateMany?: UserUpdateManyWithWhereWithoutRealmInput | UserUpdateManyWithWhereWithoutRealmInput[]
    deleteMany?: UserScalarWhereInput | UserScalarWhereInput[]
  }

  export type RoleUpdateManyWithoutRealmNestedInput = {
    create?: XOR<RoleCreateWithoutRealmInput, RoleUncheckedCreateWithoutRealmInput> | RoleCreateWithoutRealmInput[] | RoleUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: RoleCreateOrConnectWithoutRealmInput | RoleCreateOrConnectWithoutRealmInput[]
    upsert?: RoleUpsertWithWhereUniqueWithoutRealmInput | RoleUpsertWithWhereUniqueWithoutRealmInput[]
    createMany?: RoleCreateManyRealmInputEnvelope
    set?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
    disconnect?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
    delete?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
    connect?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
    update?: RoleUpdateWithWhereUniqueWithoutRealmInput | RoleUpdateWithWhereUniqueWithoutRealmInput[]
    updateMany?: RoleUpdateManyWithWhereWithoutRealmInput | RoleUpdateManyWithWhereWithoutRealmInput[]
    deleteMany?: RoleScalarWhereInput | RoleScalarWhereInput[]
  }

  export type ClientUpdateManyWithoutRealmNestedInput = {
    create?: XOR<ClientCreateWithoutRealmInput, ClientUncheckedCreateWithoutRealmInput> | ClientCreateWithoutRealmInput[] | ClientUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: ClientCreateOrConnectWithoutRealmInput | ClientCreateOrConnectWithoutRealmInput[]
    upsert?: ClientUpsertWithWhereUniqueWithoutRealmInput | ClientUpsertWithWhereUniqueWithoutRealmInput[]
    createMany?: ClientCreateManyRealmInputEnvelope
    set?: ClientWhereUniqueInput | ClientWhereUniqueInput[]
    disconnect?: ClientWhereUniqueInput | ClientWhereUniqueInput[]
    delete?: ClientWhereUniqueInput | ClientWhereUniqueInput[]
    connect?: ClientWhereUniqueInput | ClientWhereUniqueInput[]
    update?: ClientUpdateWithWhereUniqueWithoutRealmInput | ClientUpdateWithWhereUniqueWithoutRealmInput[]
    updateMany?: ClientUpdateManyWithWhereWithoutRealmInput | ClientUpdateManyWithWhereWithoutRealmInput[]
    deleteMany?: ClientScalarWhereInput | ClientScalarWhereInput[]
  }

  export type ScopeUpdateManyWithoutRealmNestedInput = {
    create?: XOR<ScopeCreateWithoutRealmInput, ScopeUncheckedCreateWithoutRealmInput> | ScopeCreateWithoutRealmInput[] | ScopeUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: ScopeCreateOrConnectWithoutRealmInput | ScopeCreateOrConnectWithoutRealmInput[]
    upsert?: ScopeUpsertWithWhereUniqueWithoutRealmInput | ScopeUpsertWithWhereUniqueWithoutRealmInput[]
    createMany?: ScopeCreateManyRealmInputEnvelope
    set?: ScopeWhereUniqueInput | ScopeWhereUniqueInput[]
    disconnect?: ScopeWhereUniqueInput | ScopeWhereUniqueInput[]
    delete?: ScopeWhereUniqueInput | ScopeWhereUniqueInput[]
    connect?: ScopeWhereUniqueInput | ScopeWhereUniqueInput[]
    update?: ScopeUpdateWithWhereUniqueWithoutRealmInput | ScopeUpdateWithWhereUniqueWithoutRealmInput[]
    updateMany?: ScopeUpdateManyWithWhereWithoutRealmInput | ScopeUpdateManyWithWhereWithoutRealmInput[]
    deleteMany?: ScopeScalarWhereInput | ScopeScalarWhereInput[]
  }

  export type RealmKeyUncheckedUpdateManyWithoutRealmNestedInput = {
    create?: XOR<RealmKeyCreateWithoutRealmInput, RealmKeyUncheckedCreateWithoutRealmInput> | RealmKeyCreateWithoutRealmInput[] | RealmKeyUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: RealmKeyCreateOrConnectWithoutRealmInput | RealmKeyCreateOrConnectWithoutRealmInput[]
    upsert?: RealmKeyUpsertWithWhereUniqueWithoutRealmInput | RealmKeyUpsertWithWhereUniqueWithoutRealmInput[]
    createMany?: RealmKeyCreateManyRealmInputEnvelope
    set?: RealmKeyWhereUniqueInput | RealmKeyWhereUniqueInput[]
    disconnect?: RealmKeyWhereUniqueInput | RealmKeyWhereUniqueInput[]
    delete?: RealmKeyWhereUniqueInput | RealmKeyWhereUniqueInput[]
    connect?: RealmKeyWhereUniqueInput | RealmKeyWhereUniqueInput[]
    update?: RealmKeyUpdateWithWhereUniqueWithoutRealmInput | RealmKeyUpdateWithWhereUniqueWithoutRealmInput[]
    updateMany?: RealmKeyUpdateManyWithWhereWithoutRealmInput | RealmKeyUpdateManyWithWhereWithoutRealmInput[]
    deleteMany?: RealmKeyScalarWhereInput | RealmKeyScalarWhereInput[]
  }

  export type UserUncheckedUpdateManyWithoutRealmNestedInput = {
    create?: XOR<UserCreateWithoutRealmInput, UserUncheckedCreateWithoutRealmInput> | UserCreateWithoutRealmInput[] | UserUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: UserCreateOrConnectWithoutRealmInput | UserCreateOrConnectWithoutRealmInput[]
    upsert?: UserUpsertWithWhereUniqueWithoutRealmInput | UserUpsertWithWhereUniqueWithoutRealmInput[]
    createMany?: UserCreateManyRealmInputEnvelope
    set?: UserWhereUniqueInput | UserWhereUniqueInput[]
    disconnect?: UserWhereUniqueInput | UserWhereUniqueInput[]
    delete?: UserWhereUniqueInput | UserWhereUniqueInput[]
    connect?: UserWhereUniqueInput | UserWhereUniqueInput[]
    update?: UserUpdateWithWhereUniqueWithoutRealmInput | UserUpdateWithWhereUniqueWithoutRealmInput[]
    updateMany?: UserUpdateManyWithWhereWithoutRealmInput | UserUpdateManyWithWhereWithoutRealmInput[]
    deleteMany?: UserScalarWhereInput | UserScalarWhereInput[]
  }

  export type RoleUncheckedUpdateManyWithoutRealmNestedInput = {
    create?: XOR<RoleCreateWithoutRealmInput, RoleUncheckedCreateWithoutRealmInput> | RoleCreateWithoutRealmInput[] | RoleUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: RoleCreateOrConnectWithoutRealmInput | RoleCreateOrConnectWithoutRealmInput[]
    upsert?: RoleUpsertWithWhereUniqueWithoutRealmInput | RoleUpsertWithWhereUniqueWithoutRealmInput[]
    createMany?: RoleCreateManyRealmInputEnvelope
    set?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
    disconnect?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
    delete?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
    connect?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
    update?: RoleUpdateWithWhereUniqueWithoutRealmInput | RoleUpdateWithWhereUniqueWithoutRealmInput[]
    updateMany?: RoleUpdateManyWithWhereWithoutRealmInput | RoleUpdateManyWithWhereWithoutRealmInput[]
    deleteMany?: RoleScalarWhereInput | RoleScalarWhereInput[]
  }

  export type ClientUncheckedUpdateManyWithoutRealmNestedInput = {
    create?: XOR<ClientCreateWithoutRealmInput, ClientUncheckedCreateWithoutRealmInput> | ClientCreateWithoutRealmInput[] | ClientUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: ClientCreateOrConnectWithoutRealmInput | ClientCreateOrConnectWithoutRealmInput[]
    upsert?: ClientUpsertWithWhereUniqueWithoutRealmInput | ClientUpsertWithWhereUniqueWithoutRealmInput[]
    createMany?: ClientCreateManyRealmInputEnvelope
    set?: ClientWhereUniqueInput | ClientWhereUniqueInput[]
    disconnect?: ClientWhereUniqueInput | ClientWhereUniqueInput[]
    delete?: ClientWhereUniqueInput | ClientWhereUniqueInput[]
    connect?: ClientWhereUniqueInput | ClientWhereUniqueInput[]
    update?: ClientUpdateWithWhereUniqueWithoutRealmInput | ClientUpdateWithWhereUniqueWithoutRealmInput[]
    updateMany?: ClientUpdateManyWithWhereWithoutRealmInput | ClientUpdateManyWithWhereWithoutRealmInput[]
    deleteMany?: ClientScalarWhereInput | ClientScalarWhereInput[]
  }

  export type ScopeUncheckedUpdateManyWithoutRealmNestedInput = {
    create?: XOR<ScopeCreateWithoutRealmInput, ScopeUncheckedCreateWithoutRealmInput> | ScopeCreateWithoutRealmInput[] | ScopeUncheckedCreateWithoutRealmInput[]
    connectOrCreate?: ScopeCreateOrConnectWithoutRealmInput | ScopeCreateOrConnectWithoutRealmInput[]
    upsert?: ScopeUpsertWithWhereUniqueWithoutRealmInput | ScopeUpsertWithWhereUniqueWithoutRealmInput[]
    createMany?: ScopeCreateManyRealmInputEnvelope
    set?: ScopeWhereUniqueInput | ScopeWhereUniqueInput[]
    disconnect?: ScopeWhereUniqueInput | ScopeWhereUniqueInput[]
    delete?: ScopeWhereUniqueInput | ScopeWhereUniqueInput[]
    connect?: ScopeWhereUniqueInput | ScopeWhereUniqueInput[]
    update?: ScopeUpdateWithWhereUniqueWithoutRealmInput | ScopeUpdateWithWhereUniqueWithoutRealmInput[]
    updateMany?: ScopeUpdateManyWithWhereWithoutRealmInput | ScopeUpdateManyWithWhereWithoutRealmInput[]
    deleteMany?: ScopeScalarWhereInput | ScopeScalarWhereInput[]
  }

  export type RealmCreateNestedOneWithoutKeysInput = {
    create?: XOR<RealmCreateWithoutKeysInput, RealmUncheckedCreateWithoutKeysInput>
    connectOrCreate?: RealmCreateOrConnectWithoutKeysInput
    connect?: RealmWhereUniqueInput
  }

  export type NullableDateTimeFieldUpdateOperationsInput = {
    set?: Date | string | null
  }

  export type RealmUpdateOneRequiredWithoutKeysNestedInput = {
    create?: XOR<RealmCreateWithoutKeysInput, RealmUncheckedCreateWithoutKeysInput>
    connectOrCreate?: RealmCreateOrConnectWithoutKeysInput
    upsert?: RealmUpsertWithoutKeysInput
    connect?: RealmWhereUniqueInput
    update?: XOR<XOR<RealmUpdateToOneWithWhereWithoutKeysInput, RealmUpdateWithoutKeysInput>, RealmUncheckedUpdateWithoutKeysInput>
  }

  export type RealmCreateNestedOneWithoutUsersInput = {
    create?: XOR<RealmCreateWithoutUsersInput, RealmUncheckedCreateWithoutUsersInput>
    connectOrCreate?: RealmCreateOrConnectWithoutUsersInput
    connect?: RealmWhereUniqueInput
  }

  export type UserRoleCreateNestedManyWithoutUserInput = {
    create?: XOR<UserRoleCreateWithoutUserInput, UserRoleUncheckedCreateWithoutUserInput> | UserRoleCreateWithoutUserInput[] | UserRoleUncheckedCreateWithoutUserInput[]
    connectOrCreate?: UserRoleCreateOrConnectWithoutUserInput | UserRoleCreateOrConnectWithoutUserInput[]
    createMany?: UserRoleCreateManyUserInputEnvelope
    connect?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
  }

  export type UserSessionCreateNestedManyWithoutUserInput = {
    create?: XOR<UserSessionCreateWithoutUserInput, UserSessionUncheckedCreateWithoutUserInput> | UserSessionCreateWithoutUserInput[] | UserSessionUncheckedCreateWithoutUserInput[]
    connectOrCreate?: UserSessionCreateOrConnectWithoutUserInput | UserSessionCreateOrConnectWithoutUserInput[]
    createMany?: UserSessionCreateManyUserInputEnvelope
    connect?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
  }

  export type TokenCreateNestedManyWithoutUserInput = {
    create?: XOR<TokenCreateWithoutUserInput, TokenUncheckedCreateWithoutUserInput> | TokenCreateWithoutUserInput[] | TokenUncheckedCreateWithoutUserInput[]
    connectOrCreate?: TokenCreateOrConnectWithoutUserInput | TokenCreateOrConnectWithoutUserInput[]
    createMany?: TokenCreateManyUserInputEnvelope
    connect?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
  }

  export type AuthorizationCodeCreateNestedManyWithoutUserInput = {
    create?: XOR<AuthorizationCodeCreateWithoutUserInput, AuthorizationCodeUncheckedCreateWithoutUserInput> | AuthorizationCodeCreateWithoutUserInput[] | AuthorizationCodeUncheckedCreateWithoutUserInput[]
    connectOrCreate?: AuthorizationCodeCreateOrConnectWithoutUserInput | AuthorizationCodeCreateOrConnectWithoutUserInput[]
    createMany?: AuthorizationCodeCreateManyUserInputEnvelope
    connect?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
  }

  export type UserRoleUncheckedCreateNestedManyWithoutUserInput = {
    create?: XOR<UserRoleCreateWithoutUserInput, UserRoleUncheckedCreateWithoutUserInput> | UserRoleCreateWithoutUserInput[] | UserRoleUncheckedCreateWithoutUserInput[]
    connectOrCreate?: UserRoleCreateOrConnectWithoutUserInput | UserRoleCreateOrConnectWithoutUserInput[]
    createMany?: UserRoleCreateManyUserInputEnvelope
    connect?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
  }

  export type UserSessionUncheckedCreateNestedManyWithoutUserInput = {
    create?: XOR<UserSessionCreateWithoutUserInput, UserSessionUncheckedCreateWithoutUserInput> | UserSessionCreateWithoutUserInput[] | UserSessionUncheckedCreateWithoutUserInput[]
    connectOrCreate?: UserSessionCreateOrConnectWithoutUserInput | UserSessionCreateOrConnectWithoutUserInput[]
    createMany?: UserSessionCreateManyUserInputEnvelope
    connect?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
  }

  export type TokenUncheckedCreateNestedManyWithoutUserInput = {
    create?: XOR<TokenCreateWithoutUserInput, TokenUncheckedCreateWithoutUserInput> | TokenCreateWithoutUserInput[] | TokenUncheckedCreateWithoutUserInput[]
    connectOrCreate?: TokenCreateOrConnectWithoutUserInput | TokenCreateOrConnectWithoutUserInput[]
    createMany?: TokenCreateManyUserInputEnvelope
    connect?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
  }

  export type AuthorizationCodeUncheckedCreateNestedManyWithoutUserInput = {
    create?: XOR<AuthorizationCodeCreateWithoutUserInput, AuthorizationCodeUncheckedCreateWithoutUserInput> | AuthorizationCodeCreateWithoutUserInput[] | AuthorizationCodeUncheckedCreateWithoutUserInput[]
    connectOrCreate?: AuthorizationCodeCreateOrConnectWithoutUserInput | AuthorizationCodeCreateOrConnectWithoutUserInput[]
    createMany?: AuthorizationCodeCreateManyUserInputEnvelope
    connect?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
  }

  export type IntFieldUpdateOperationsInput = {
    set?: number
    increment?: number
    decrement?: number
    multiply?: number
    divide?: number
  }

  export type BoolFieldUpdateOperationsInput = {
    set?: boolean
  }

  export type RealmUpdateOneRequiredWithoutUsersNestedInput = {
    create?: XOR<RealmCreateWithoutUsersInput, RealmUncheckedCreateWithoutUsersInput>
    connectOrCreate?: RealmCreateOrConnectWithoutUsersInput
    upsert?: RealmUpsertWithoutUsersInput
    connect?: RealmWhereUniqueInput
    update?: XOR<XOR<RealmUpdateToOneWithWhereWithoutUsersInput, RealmUpdateWithoutUsersInput>, RealmUncheckedUpdateWithoutUsersInput>
  }

  export type UserRoleUpdateManyWithoutUserNestedInput = {
    create?: XOR<UserRoleCreateWithoutUserInput, UserRoleUncheckedCreateWithoutUserInput> | UserRoleCreateWithoutUserInput[] | UserRoleUncheckedCreateWithoutUserInput[]
    connectOrCreate?: UserRoleCreateOrConnectWithoutUserInput | UserRoleCreateOrConnectWithoutUserInput[]
    upsert?: UserRoleUpsertWithWhereUniqueWithoutUserInput | UserRoleUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: UserRoleCreateManyUserInputEnvelope
    set?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
    disconnect?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
    delete?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
    connect?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
    update?: UserRoleUpdateWithWhereUniqueWithoutUserInput | UserRoleUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: UserRoleUpdateManyWithWhereWithoutUserInput | UserRoleUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: UserRoleScalarWhereInput | UserRoleScalarWhereInput[]
  }

  export type UserSessionUpdateManyWithoutUserNestedInput = {
    create?: XOR<UserSessionCreateWithoutUserInput, UserSessionUncheckedCreateWithoutUserInput> | UserSessionCreateWithoutUserInput[] | UserSessionUncheckedCreateWithoutUserInput[]
    connectOrCreate?: UserSessionCreateOrConnectWithoutUserInput | UserSessionCreateOrConnectWithoutUserInput[]
    upsert?: UserSessionUpsertWithWhereUniqueWithoutUserInput | UserSessionUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: UserSessionCreateManyUserInputEnvelope
    set?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
    disconnect?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
    delete?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
    connect?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
    update?: UserSessionUpdateWithWhereUniqueWithoutUserInput | UserSessionUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: UserSessionUpdateManyWithWhereWithoutUserInput | UserSessionUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: UserSessionScalarWhereInput | UserSessionScalarWhereInput[]
  }

  export type TokenUpdateManyWithoutUserNestedInput = {
    create?: XOR<TokenCreateWithoutUserInput, TokenUncheckedCreateWithoutUserInput> | TokenCreateWithoutUserInput[] | TokenUncheckedCreateWithoutUserInput[]
    connectOrCreate?: TokenCreateOrConnectWithoutUserInput | TokenCreateOrConnectWithoutUserInput[]
    upsert?: TokenUpsertWithWhereUniqueWithoutUserInput | TokenUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: TokenCreateManyUserInputEnvelope
    set?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
    disconnect?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
    delete?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
    connect?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
    update?: TokenUpdateWithWhereUniqueWithoutUserInput | TokenUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: TokenUpdateManyWithWhereWithoutUserInput | TokenUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: TokenScalarWhereInput | TokenScalarWhereInput[]
  }

  export type AuthorizationCodeUpdateManyWithoutUserNestedInput = {
    create?: XOR<AuthorizationCodeCreateWithoutUserInput, AuthorizationCodeUncheckedCreateWithoutUserInput> | AuthorizationCodeCreateWithoutUserInput[] | AuthorizationCodeUncheckedCreateWithoutUserInput[]
    connectOrCreate?: AuthorizationCodeCreateOrConnectWithoutUserInput | AuthorizationCodeCreateOrConnectWithoutUserInput[]
    upsert?: AuthorizationCodeUpsertWithWhereUniqueWithoutUserInput | AuthorizationCodeUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: AuthorizationCodeCreateManyUserInputEnvelope
    set?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
    disconnect?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
    delete?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
    connect?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
    update?: AuthorizationCodeUpdateWithWhereUniqueWithoutUserInput | AuthorizationCodeUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: AuthorizationCodeUpdateManyWithWhereWithoutUserInput | AuthorizationCodeUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: AuthorizationCodeScalarWhereInput | AuthorizationCodeScalarWhereInput[]
  }

  export type UserRoleUncheckedUpdateManyWithoutUserNestedInput = {
    create?: XOR<UserRoleCreateWithoutUserInput, UserRoleUncheckedCreateWithoutUserInput> | UserRoleCreateWithoutUserInput[] | UserRoleUncheckedCreateWithoutUserInput[]
    connectOrCreate?: UserRoleCreateOrConnectWithoutUserInput | UserRoleCreateOrConnectWithoutUserInput[]
    upsert?: UserRoleUpsertWithWhereUniqueWithoutUserInput | UserRoleUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: UserRoleCreateManyUserInputEnvelope
    set?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
    disconnect?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
    delete?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
    connect?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
    update?: UserRoleUpdateWithWhereUniqueWithoutUserInput | UserRoleUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: UserRoleUpdateManyWithWhereWithoutUserInput | UserRoleUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: UserRoleScalarWhereInput | UserRoleScalarWhereInput[]
  }

  export type UserSessionUncheckedUpdateManyWithoutUserNestedInput = {
    create?: XOR<UserSessionCreateWithoutUserInput, UserSessionUncheckedCreateWithoutUserInput> | UserSessionCreateWithoutUserInput[] | UserSessionUncheckedCreateWithoutUserInput[]
    connectOrCreate?: UserSessionCreateOrConnectWithoutUserInput | UserSessionCreateOrConnectWithoutUserInput[]
    upsert?: UserSessionUpsertWithWhereUniqueWithoutUserInput | UserSessionUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: UserSessionCreateManyUserInputEnvelope
    set?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
    disconnect?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
    delete?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
    connect?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
    update?: UserSessionUpdateWithWhereUniqueWithoutUserInput | UserSessionUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: UserSessionUpdateManyWithWhereWithoutUserInput | UserSessionUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: UserSessionScalarWhereInput | UserSessionScalarWhereInput[]
  }

  export type TokenUncheckedUpdateManyWithoutUserNestedInput = {
    create?: XOR<TokenCreateWithoutUserInput, TokenUncheckedCreateWithoutUserInput> | TokenCreateWithoutUserInput[] | TokenUncheckedCreateWithoutUserInput[]
    connectOrCreate?: TokenCreateOrConnectWithoutUserInput | TokenCreateOrConnectWithoutUserInput[]
    upsert?: TokenUpsertWithWhereUniqueWithoutUserInput | TokenUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: TokenCreateManyUserInputEnvelope
    set?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
    disconnect?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
    delete?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
    connect?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
    update?: TokenUpdateWithWhereUniqueWithoutUserInput | TokenUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: TokenUpdateManyWithWhereWithoutUserInput | TokenUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: TokenScalarWhereInput | TokenScalarWhereInput[]
  }

  export type AuthorizationCodeUncheckedUpdateManyWithoutUserNestedInput = {
    create?: XOR<AuthorizationCodeCreateWithoutUserInput, AuthorizationCodeUncheckedCreateWithoutUserInput> | AuthorizationCodeCreateWithoutUserInput[] | AuthorizationCodeUncheckedCreateWithoutUserInput[]
    connectOrCreate?: AuthorizationCodeCreateOrConnectWithoutUserInput | AuthorizationCodeCreateOrConnectWithoutUserInput[]
    upsert?: AuthorizationCodeUpsertWithWhereUniqueWithoutUserInput | AuthorizationCodeUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: AuthorizationCodeCreateManyUserInputEnvelope
    set?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
    disconnect?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
    delete?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
    connect?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
    update?: AuthorizationCodeUpdateWithWhereUniqueWithoutUserInput | AuthorizationCodeUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: AuthorizationCodeUpdateManyWithWhereWithoutUserInput | AuthorizationCodeUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: AuthorizationCodeScalarWhereInput | AuthorizationCodeScalarWhereInput[]
  }

  export type UserCreateNestedOneWithoutSessionsInput = {
    create?: XOR<UserCreateWithoutSessionsInput, UserUncheckedCreateWithoutSessionsInput>
    connectOrCreate?: UserCreateOrConnectWithoutSessionsInput
    connect?: UserWhereUniqueInput
  }

  export type ClientCreateNestedOneWithoutUserSessionsInput = {
    create?: XOR<ClientCreateWithoutUserSessionsInput, ClientUncheckedCreateWithoutUserSessionsInput>
    connectOrCreate?: ClientCreateOrConnectWithoutUserSessionsInput
    connect?: ClientWhereUniqueInput
  }

  export type UserUpdateOneRequiredWithoutSessionsNestedInput = {
    create?: XOR<UserCreateWithoutSessionsInput, UserUncheckedCreateWithoutSessionsInput>
    connectOrCreate?: UserCreateOrConnectWithoutSessionsInput
    upsert?: UserUpsertWithoutSessionsInput
    connect?: UserWhereUniqueInput
    update?: XOR<XOR<UserUpdateToOneWithWhereWithoutSessionsInput, UserUpdateWithoutSessionsInput>, UserUncheckedUpdateWithoutSessionsInput>
  }

  export type ClientUpdateOneRequiredWithoutUserSessionsNestedInput = {
    create?: XOR<ClientCreateWithoutUserSessionsInput, ClientUncheckedCreateWithoutUserSessionsInput>
    connectOrCreate?: ClientCreateOrConnectWithoutUserSessionsInput
    upsert?: ClientUpsertWithoutUserSessionsInput
    connect?: ClientWhereUniqueInput
    update?: XOR<XOR<ClientUpdateToOneWithWhereWithoutUserSessionsInput, ClientUpdateWithoutUserSessionsInput>, ClientUncheckedUpdateWithoutUserSessionsInput>
  }

  export type RealmCreateNestedOneWithoutRolesInput = {
    create?: XOR<RealmCreateWithoutRolesInput, RealmUncheckedCreateWithoutRolesInput>
    connectOrCreate?: RealmCreateOrConnectWithoutRolesInput
    connect?: RealmWhereUniqueInput
  }

  export type ClientCreateNestedOneWithoutRolesInput = {
    create?: XOR<ClientCreateWithoutRolesInput, ClientUncheckedCreateWithoutRolesInput>
    connectOrCreate?: ClientCreateOrConnectWithoutRolesInput
    connect?: ClientWhereUniqueInput
  }

  export type UserRoleCreateNestedManyWithoutRoleInput = {
    create?: XOR<UserRoleCreateWithoutRoleInput, UserRoleUncheckedCreateWithoutRoleInput> | UserRoleCreateWithoutRoleInput[] | UserRoleUncheckedCreateWithoutRoleInput[]
    connectOrCreate?: UserRoleCreateOrConnectWithoutRoleInput | UserRoleCreateOrConnectWithoutRoleInput[]
    createMany?: UserRoleCreateManyRoleInputEnvelope
    connect?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
  }

  export type UserRoleUncheckedCreateNestedManyWithoutRoleInput = {
    create?: XOR<UserRoleCreateWithoutRoleInput, UserRoleUncheckedCreateWithoutRoleInput> | UserRoleCreateWithoutRoleInput[] | UserRoleUncheckedCreateWithoutRoleInput[]
    connectOrCreate?: UserRoleCreateOrConnectWithoutRoleInput | UserRoleCreateOrConnectWithoutRoleInput[]
    createMany?: UserRoleCreateManyRoleInputEnvelope
    connect?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
  }

  export type RealmUpdateOneRequiredWithoutRolesNestedInput = {
    create?: XOR<RealmCreateWithoutRolesInput, RealmUncheckedCreateWithoutRolesInput>
    connectOrCreate?: RealmCreateOrConnectWithoutRolesInput
    upsert?: RealmUpsertWithoutRolesInput
    connect?: RealmWhereUniqueInput
    update?: XOR<XOR<RealmUpdateToOneWithWhereWithoutRolesInput, RealmUpdateWithoutRolesInput>, RealmUncheckedUpdateWithoutRolesInput>
  }

  export type ClientUpdateOneWithoutRolesNestedInput = {
    create?: XOR<ClientCreateWithoutRolesInput, ClientUncheckedCreateWithoutRolesInput>
    connectOrCreate?: ClientCreateOrConnectWithoutRolesInput
    upsert?: ClientUpsertWithoutRolesInput
    disconnect?: ClientWhereInput | boolean
    delete?: ClientWhereInput | boolean
    connect?: ClientWhereUniqueInput
    update?: XOR<XOR<ClientUpdateToOneWithWhereWithoutRolesInput, ClientUpdateWithoutRolesInput>, ClientUncheckedUpdateWithoutRolesInput>
  }

  export type UserRoleUpdateManyWithoutRoleNestedInput = {
    create?: XOR<UserRoleCreateWithoutRoleInput, UserRoleUncheckedCreateWithoutRoleInput> | UserRoleCreateWithoutRoleInput[] | UserRoleUncheckedCreateWithoutRoleInput[]
    connectOrCreate?: UserRoleCreateOrConnectWithoutRoleInput | UserRoleCreateOrConnectWithoutRoleInput[]
    upsert?: UserRoleUpsertWithWhereUniqueWithoutRoleInput | UserRoleUpsertWithWhereUniqueWithoutRoleInput[]
    createMany?: UserRoleCreateManyRoleInputEnvelope
    set?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
    disconnect?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
    delete?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
    connect?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
    update?: UserRoleUpdateWithWhereUniqueWithoutRoleInput | UserRoleUpdateWithWhereUniqueWithoutRoleInput[]
    updateMany?: UserRoleUpdateManyWithWhereWithoutRoleInput | UserRoleUpdateManyWithWhereWithoutRoleInput[]
    deleteMany?: UserRoleScalarWhereInput | UserRoleScalarWhereInput[]
  }

  export type UserRoleUncheckedUpdateManyWithoutRoleNestedInput = {
    create?: XOR<UserRoleCreateWithoutRoleInput, UserRoleUncheckedCreateWithoutRoleInput> | UserRoleCreateWithoutRoleInput[] | UserRoleUncheckedCreateWithoutRoleInput[]
    connectOrCreate?: UserRoleCreateOrConnectWithoutRoleInput | UserRoleCreateOrConnectWithoutRoleInput[]
    upsert?: UserRoleUpsertWithWhereUniqueWithoutRoleInput | UserRoleUpsertWithWhereUniqueWithoutRoleInput[]
    createMany?: UserRoleCreateManyRoleInputEnvelope
    set?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
    disconnect?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
    delete?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
    connect?: UserRoleWhereUniqueInput | UserRoleWhereUniqueInput[]
    update?: UserRoleUpdateWithWhereUniqueWithoutRoleInput | UserRoleUpdateWithWhereUniqueWithoutRoleInput[]
    updateMany?: UserRoleUpdateManyWithWhereWithoutRoleInput | UserRoleUpdateManyWithWhereWithoutRoleInput[]
    deleteMany?: UserRoleScalarWhereInput | UserRoleScalarWhereInput[]
  }

  export type UserCreateNestedOneWithoutRolesInput = {
    create?: XOR<UserCreateWithoutRolesInput, UserUncheckedCreateWithoutRolesInput>
    connectOrCreate?: UserCreateOrConnectWithoutRolesInput
    connect?: UserWhereUniqueInput
  }

  export type RoleCreateNestedOneWithoutUserLinksInput = {
    create?: XOR<RoleCreateWithoutUserLinksInput, RoleUncheckedCreateWithoutUserLinksInput>
    connectOrCreate?: RoleCreateOrConnectWithoutUserLinksInput
    connect?: RoleWhereUniqueInput
  }

  export type UserUpdateOneRequiredWithoutRolesNestedInput = {
    create?: XOR<UserCreateWithoutRolesInput, UserUncheckedCreateWithoutRolesInput>
    connectOrCreate?: UserCreateOrConnectWithoutRolesInput
    upsert?: UserUpsertWithoutRolesInput
    connect?: UserWhereUniqueInput
    update?: XOR<XOR<UserUpdateToOneWithWhereWithoutRolesInput, UserUpdateWithoutRolesInput>, UserUncheckedUpdateWithoutRolesInput>
  }

  export type RoleUpdateOneRequiredWithoutUserLinksNestedInput = {
    create?: XOR<RoleCreateWithoutUserLinksInput, RoleUncheckedCreateWithoutUserLinksInput>
    connectOrCreate?: RoleCreateOrConnectWithoutUserLinksInput
    upsert?: RoleUpsertWithoutUserLinksInput
    connect?: RoleWhereUniqueInput
    update?: XOR<XOR<RoleUpdateToOneWithWhereWithoutUserLinksInput, RoleUpdateWithoutUserLinksInput>, RoleUncheckedUpdateWithoutUserLinksInput>
  }

  export type ClientCreateredirect_urisInput = {
    set: string[]
  }

  export type ClientCreategrant_typesInput = {
    set: string[]
  }

  export type RealmCreateNestedOneWithoutClientsInput = {
    create?: XOR<RealmCreateWithoutClientsInput, RealmUncheckedCreateWithoutClientsInput>
    connectOrCreate?: RealmCreateOrConnectWithoutClientsInput
    connect?: RealmWhereUniqueInput
  }

  export type RoleCreateNestedManyWithoutClientInput = {
    create?: XOR<RoleCreateWithoutClientInput, RoleUncheckedCreateWithoutClientInput> | RoleCreateWithoutClientInput[] | RoleUncheckedCreateWithoutClientInput[]
    connectOrCreate?: RoleCreateOrConnectWithoutClientInput | RoleCreateOrConnectWithoutClientInput[]
    createMany?: RoleCreateManyClientInputEnvelope
    connect?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
  }

  export type ClientScopeCreateNestedManyWithoutClientInput = {
    create?: XOR<ClientScopeCreateWithoutClientInput, ClientScopeUncheckedCreateWithoutClientInput> | ClientScopeCreateWithoutClientInput[] | ClientScopeUncheckedCreateWithoutClientInput[]
    connectOrCreate?: ClientScopeCreateOrConnectWithoutClientInput | ClientScopeCreateOrConnectWithoutClientInput[]
    createMany?: ClientScopeCreateManyClientInputEnvelope
    connect?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
  }

  export type UserSessionCreateNestedManyWithoutClientInput = {
    create?: XOR<UserSessionCreateWithoutClientInput, UserSessionUncheckedCreateWithoutClientInput> | UserSessionCreateWithoutClientInput[] | UserSessionUncheckedCreateWithoutClientInput[]
    connectOrCreate?: UserSessionCreateOrConnectWithoutClientInput | UserSessionCreateOrConnectWithoutClientInput[]
    createMany?: UserSessionCreateManyClientInputEnvelope
    connect?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
  }

  export type TokenCreateNestedManyWithoutClientInput = {
    create?: XOR<TokenCreateWithoutClientInput, TokenUncheckedCreateWithoutClientInput> | TokenCreateWithoutClientInput[] | TokenUncheckedCreateWithoutClientInput[]
    connectOrCreate?: TokenCreateOrConnectWithoutClientInput | TokenCreateOrConnectWithoutClientInput[]
    createMany?: TokenCreateManyClientInputEnvelope
    connect?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
  }

  export type AuthorizationCodeCreateNestedManyWithoutClientInput = {
    create?: XOR<AuthorizationCodeCreateWithoutClientInput, AuthorizationCodeUncheckedCreateWithoutClientInput> | AuthorizationCodeCreateWithoutClientInput[] | AuthorizationCodeUncheckedCreateWithoutClientInput[]
    connectOrCreate?: AuthorizationCodeCreateOrConnectWithoutClientInput | AuthorizationCodeCreateOrConnectWithoutClientInput[]
    createMany?: AuthorizationCodeCreateManyClientInputEnvelope
    connect?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
  }

  export type RoleUncheckedCreateNestedManyWithoutClientInput = {
    create?: XOR<RoleCreateWithoutClientInput, RoleUncheckedCreateWithoutClientInput> | RoleCreateWithoutClientInput[] | RoleUncheckedCreateWithoutClientInput[]
    connectOrCreate?: RoleCreateOrConnectWithoutClientInput | RoleCreateOrConnectWithoutClientInput[]
    createMany?: RoleCreateManyClientInputEnvelope
    connect?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
  }

  export type ClientScopeUncheckedCreateNestedManyWithoutClientInput = {
    create?: XOR<ClientScopeCreateWithoutClientInput, ClientScopeUncheckedCreateWithoutClientInput> | ClientScopeCreateWithoutClientInput[] | ClientScopeUncheckedCreateWithoutClientInput[]
    connectOrCreate?: ClientScopeCreateOrConnectWithoutClientInput | ClientScopeCreateOrConnectWithoutClientInput[]
    createMany?: ClientScopeCreateManyClientInputEnvelope
    connect?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
  }

  export type UserSessionUncheckedCreateNestedManyWithoutClientInput = {
    create?: XOR<UserSessionCreateWithoutClientInput, UserSessionUncheckedCreateWithoutClientInput> | UserSessionCreateWithoutClientInput[] | UserSessionUncheckedCreateWithoutClientInput[]
    connectOrCreate?: UserSessionCreateOrConnectWithoutClientInput | UserSessionCreateOrConnectWithoutClientInput[]
    createMany?: UserSessionCreateManyClientInputEnvelope
    connect?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
  }

  export type TokenUncheckedCreateNestedManyWithoutClientInput = {
    create?: XOR<TokenCreateWithoutClientInput, TokenUncheckedCreateWithoutClientInput> | TokenCreateWithoutClientInput[] | TokenUncheckedCreateWithoutClientInput[]
    connectOrCreate?: TokenCreateOrConnectWithoutClientInput | TokenCreateOrConnectWithoutClientInput[]
    createMany?: TokenCreateManyClientInputEnvelope
    connect?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
  }

  export type AuthorizationCodeUncheckedCreateNestedManyWithoutClientInput = {
    create?: XOR<AuthorizationCodeCreateWithoutClientInput, AuthorizationCodeUncheckedCreateWithoutClientInput> | AuthorizationCodeCreateWithoutClientInput[] | AuthorizationCodeUncheckedCreateWithoutClientInput[]
    connectOrCreate?: AuthorizationCodeCreateOrConnectWithoutClientInput | AuthorizationCodeCreateOrConnectWithoutClientInput[]
    createMany?: AuthorizationCodeCreateManyClientInputEnvelope
    connect?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
  }

  export type ClientUpdateredirect_urisInput = {
    set?: string[]
    push?: string | string[]
  }

  export type ClientUpdategrant_typesInput = {
    set?: string[]
    push?: string | string[]
  }

  export type RealmUpdateOneRequiredWithoutClientsNestedInput = {
    create?: XOR<RealmCreateWithoutClientsInput, RealmUncheckedCreateWithoutClientsInput>
    connectOrCreate?: RealmCreateOrConnectWithoutClientsInput
    upsert?: RealmUpsertWithoutClientsInput
    connect?: RealmWhereUniqueInput
    update?: XOR<XOR<RealmUpdateToOneWithWhereWithoutClientsInput, RealmUpdateWithoutClientsInput>, RealmUncheckedUpdateWithoutClientsInput>
  }

  export type RoleUpdateManyWithoutClientNestedInput = {
    create?: XOR<RoleCreateWithoutClientInput, RoleUncheckedCreateWithoutClientInput> | RoleCreateWithoutClientInput[] | RoleUncheckedCreateWithoutClientInput[]
    connectOrCreate?: RoleCreateOrConnectWithoutClientInput | RoleCreateOrConnectWithoutClientInput[]
    upsert?: RoleUpsertWithWhereUniqueWithoutClientInput | RoleUpsertWithWhereUniqueWithoutClientInput[]
    createMany?: RoleCreateManyClientInputEnvelope
    set?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
    disconnect?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
    delete?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
    connect?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
    update?: RoleUpdateWithWhereUniqueWithoutClientInput | RoleUpdateWithWhereUniqueWithoutClientInput[]
    updateMany?: RoleUpdateManyWithWhereWithoutClientInput | RoleUpdateManyWithWhereWithoutClientInput[]
    deleteMany?: RoleScalarWhereInput | RoleScalarWhereInput[]
  }

  export type ClientScopeUpdateManyWithoutClientNestedInput = {
    create?: XOR<ClientScopeCreateWithoutClientInput, ClientScopeUncheckedCreateWithoutClientInput> | ClientScopeCreateWithoutClientInput[] | ClientScopeUncheckedCreateWithoutClientInput[]
    connectOrCreate?: ClientScopeCreateOrConnectWithoutClientInput | ClientScopeCreateOrConnectWithoutClientInput[]
    upsert?: ClientScopeUpsertWithWhereUniqueWithoutClientInput | ClientScopeUpsertWithWhereUniqueWithoutClientInput[]
    createMany?: ClientScopeCreateManyClientInputEnvelope
    set?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
    disconnect?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
    delete?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
    connect?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
    update?: ClientScopeUpdateWithWhereUniqueWithoutClientInput | ClientScopeUpdateWithWhereUniqueWithoutClientInput[]
    updateMany?: ClientScopeUpdateManyWithWhereWithoutClientInput | ClientScopeUpdateManyWithWhereWithoutClientInput[]
    deleteMany?: ClientScopeScalarWhereInput | ClientScopeScalarWhereInput[]
  }

  export type UserSessionUpdateManyWithoutClientNestedInput = {
    create?: XOR<UserSessionCreateWithoutClientInput, UserSessionUncheckedCreateWithoutClientInput> | UserSessionCreateWithoutClientInput[] | UserSessionUncheckedCreateWithoutClientInput[]
    connectOrCreate?: UserSessionCreateOrConnectWithoutClientInput | UserSessionCreateOrConnectWithoutClientInput[]
    upsert?: UserSessionUpsertWithWhereUniqueWithoutClientInput | UserSessionUpsertWithWhereUniqueWithoutClientInput[]
    createMany?: UserSessionCreateManyClientInputEnvelope
    set?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
    disconnect?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
    delete?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
    connect?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
    update?: UserSessionUpdateWithWhereUniqueWithoutClientInput | UserSessionUpdateWithWhereUniqueWithoutClientInput[]
    updateMany?: UserSessionUpdateManyWithWhereWithoutClientInput | UserSessionUpdateManyWithWhereWithoutClientInput[]
    deleteMany?: UserSessionScalarWhereInput | UserSessionScalarWhereInput[]
  }

  export type TokenUpdateManyWithoutClientNestedInput = {
    create?: XOR<TokenCreateWithoutClientInput, TokenUncheckedCreateWithoutClientInput> | TokenCreateWithoutClientInput[] | TokenUncheckedCreateWithoutClientInput[]
    connectOrCreate?: TokenCreateOrConnectWithoutClientInput | TokenCreateOrConnectWithoutClientInput[]
    upsert?: TokenUpsertWithWhereUniqueWithoutClientInput | TokenUpsertWithWhereUniqueWithoutClientInput[]
    createMany?: TokenCreateManyClientInputEnvelope
    set?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
    disconnect?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
    delete?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
    connect?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
    update?: TokenUpdateWithWhereUniqueWithoutClientInput | TokenUpdateWithWhereUniqueWithoutClientInput[]
    updateMany?: TokenUpdateManyWithWhereWithoutClientInput | TokenUpdateManyWithWhereWithoutClientInput[]
    deleteMany?: TokenScalarWhereInput | TokenScalarWhereInput[]
  }

  export type AuthorizationCodeUpdateManyWithoutClientNestedInput = {
    create?: XOR<AuthorizationCodeCreateWithoutClientInput, AuthorizationCodeUncheckedCreateWithoutClientInput> | AuthorizationCodeCreateWithoutClientInput[] | AuthorizationCodeUncheckedCreateWithoutClientInput[]
    connectOrCreate?: AuthorizationCodeCreateOrConnectWithoutClientInput | AuthorizationCodeCreateOrConnectWithoutClientInput[]
    upsert?: AuthorizationCodeUpsertWithWhereUniqueWithoutClientInput | AuthorizationCodeUpsertWithWhereUniqueWithoutClientInput[]
    createMany?: AuthorizationCodeCreateManyClientInputEnvelope
    set?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
    disconnect?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
    delete?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
    connect?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
    update?: AuthorizationCodeUpdateWithWhereUniqueWithoutClientInput | AuthorizationCodeUpdateWithWhereUniqueWithoutClientInput[]
    updateMany?: AuthorizationCodeUpdateManyWithWhereWithoutClientInput | AuthorizationCodeUpdateManyWithWhereWithoutClientInput[]
    deleteMany?: AuthorizationCodeScalarWhereInput | AuthorizationCodeScalarWhereInput[]
  }

  export type RoleUncheckedUpdateManyWithoutClientNestedInput = {
    create?: XOR<RoleCreateWithoutClientInput, RoleUncheckedCreateWithoutClientInput> | RoleCreateWithoutClientInput[] | RoleUncheckedCreateWithoutClientInput[]
    connectOrCreate?: RoleCreateOrConnectWithoutClientInput | RoleCreateOrConnectWithoutClientInput[]
    upsert?: RoleUpsertWithWhereUniqueWithoutClientInput | RoleUpsertWithWhereUniqueWithoutClientInput[]
    createMany?: RoleCreateManyClientInputEnvelope
    set?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
    disconnect?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
    delete?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
    connect?: RoleWhereUniqueInput | RoleWhereUniqueInput[]
    update?: RoleUpdateWithWhereUniqueWithoutClientInput | RoleUpdateWithWhereUniqueWithoutClientInput[]
    updateMany?: RoleUpdateManyWithWhereWithoutClientInput | RoleUpdateManyWithWhereWithoutClientInput[]
    deleteMany?: RoleScalarWhereInput | RoleScalarWhereInput[]
  }

  export type ClientScopeUncheckedUpdateManyWithoutClientNestedInput = {
    create?: XOR<ClientScopeCreateWithoutClientInput, ClientScopeUncheckedCreateWithoutClientInput> | ClientScopeCreateWithoutClientInput[] | ClientScopeUncheckedCreateWithoutClientInput[]
    connectOrCreate?: ClientScopeCreateOrConnectWithoutClientInput | ClientScopeCreateOrConnectWithoutClientInput[]
    upsert?: ClientScopeUpsertWithWhereUniqueWithoutClientInput | ClientScopeUpsertWithWhereUniqueWithoutClientInput[]
    createMany?: ClientScopeCreateManyClientInputEnvelope
    set?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
    disconnect?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
    delete?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
    connect?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
    update?: ClientScopeUpdateWithWhereUniqueWithoutClientInput | ClientScopeUpdateWithWhereUniqueWithoutClientInput[]
    updateMany?: ClientScopeUpdateManyWithWhereWithoutClientInput | ClientScopeUpdateManyWithWhereWithoutClientInput[]
    deleteMany?: ClientScopeScalarWhereInput | ClientScopeScalarWhereInput[]
  }

  export type UserSessionUncheckedUpdateManyWithoutClientNestedInput = {
    create?: XOR<UserSessionCreateWithoutClientInput, UserSessionUncheckedCreateWithoutClientInput> | UserSessionCreateWithoutClientInput[] | UserSessionUncheckedCreateWithoutClientInput[]
    connectOrCreate?: UserSessionCreateOrConnectWithoutClientInput | UserSessionCreateOrConnectWithoutClientInput[]
    upsert?: UserSessionUpsertWithWhereUniqueWithoutClientInput | UserSessionUpsertWithWhereUniqueWithoutClientInput[]
    createMany?: UserSessionCreateManyClientInputEnvelope
    set?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
    disconnect?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
    delete?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
    connect?: UserSessionWhereUniqueInput | UserSessionWhereUniqueInput[]
    update?: UserSessionUpdateWithWhereUniqueWithoutClientInput | UserSessionUpdateWithWhereUniqueWithoutClientInput[]
    updateMany?: UserSessionUpdateManyWithWhereWithoutClientInput | UserSessionUpdateManyWithWhereWithoutClientInput[]
    deleteMany?: UserSessionScalarWhereInput | UserSessionScalarWhereInput[]
  }

  export type TokenUncheckedUpdateManyWithoutClientNestedInput = {
    create?: XOR<TokenCreateWithoutClientInput, TokenUncheckedCreateWithoutClientInput> | TokenCreateWithoutClientInput[] | TokenUncheckedCreateWithoutClientInput[]
    connectOrCreate?: TokenCreateOrConnectWithoutClientInput | TokenCreateOrConnectWithoutClientInput[]
    upsert?: TokenUpsertWithWhereUniqueWithoutClientInput | TokenUpsertWithWhereUniqueWithoutClientInput[]
    createMany?: TokenCreateManyClientInputEnvelope
    set?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
    disconnect?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
    delete?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
    connect?: TokenWhereUniqueInput | TokenWhereUniqueInput[]
    update?: TokenUpdateWithWhereUniqueWithoutClientInput | TokenUpdateWithWhereUniqueWithoutClientInput[]
    updateMany?: TokenUpdateManyWithWhereWithoutClientInput | TokenUpdateManyWithWhereWithoutClientInput[]
    deleteMany?: TokenScalarWhereInput | TokenScalarWhereInput[]
  }

  export type AuthorizationCodeUncheckedUpdateManyWithoutClientNestedInput = {
    create?: XOR<AuthorizationCodeCreateWithoutClientInput, AuthorizationCodeUncheckedCreateWithoutClientInput> | AuthorizationCodeCreateWithoutClientInput[] | AuthorizationCodeUncheckedCreateWithoutClientInput[]
    connectOrCreate?: AuthorizationCodeCreateOrConnectWithoutClientInput | AuthorizationCodeCreateOrConnectWithoutClientInput[]
    upsert?: AuthorizationCodeUpsertWithWhereUniqueWithoutClientInput | AuthorizationCodeUpsertWithWhereUniqueWithoutClientInput[]
    createMany?: AuthorizationCodeCreateManyClientInputEnvelope
    set?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
    disconnect?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
    delete?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
    connect?: AuthorizationCodeWhereUniqueInput | AuthorizationCodeWhereUniqueInput[]
    update?: AuthorizationCodeUpdateWithWhereUniqueWithoutClientInput | AuthorizationCodeUpdateWithWhereUniqueWithoutClientInput[]
    updateMany?: AuthorizationCodeUpdateManyWithWhereWithoutClientInput | AuthorizationCodeUpdateManyWithWhereWithoutClientInput[]
    deleteMany?: AuthorizationCodeScalarWhereInput | AuthorizationCodeScalarWhereInput[]
  }

  export type RealmCreateNestedOneWithoutScopesInput = {
    create?: XOR<RealmCreateWithoutScopesInput, RealmUncheckedCreateWithoutScopesInput>
    connectOrCreate?: RealmCreateOrConnectWithoutScopesInput
    connect?: RealmWhereUniqueInput
  }

  export type ClientScopeCreateNestedManyWithoutScopeInput = {
    create?: XOR<ClientScopeCreateWithoutScopeInput, ClientScopeUncheckedCreateWithoutScopeInput> | ClientScopeCreateWithoutScopeInput[] | ClientScopeUncheckedCreateWithoutScopeInput[]
    connectOrCreate?: ClientScopeCreateOrConnectWithoutScopeInput | ClientScopeCreateOrConnectWithoutScopeInput[]
    createMany?: ClientScopeCreateManyScopeInputEnvelope
    connect?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
  }

  export type ClientScopeUncheckedCreateNestedManyWithoutScopeInput = {
    create?: XOR<ClientScopeCreateWithoutScopeInput, ClientScopeUncheckedCreateWithoutScopeInput> | ClientScopeCreateWithoutScopeInput[] | ClientScopeUncheckedCreateWithoutScopeInput[]
    connectOrCreate?: ClientScopeCreateOrConnectWithoutScopeInput | ClientScopeCreateOrConnectWithoutScopeInput[]
    createMany?: ClientScopeCreateManyScopeInputEnvelope
    connect?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
  }

  export type RealmUpdateOneRequiredWithoutScopesNestedInput = {
    create?: XOR<RealmCreateWithoutScopesInput, RealmUncheckedCreateWithoutScopesInput>
    connectOrCreate?: RealmCreateOrConnectWithoutScopesInput
    upsert?: RealmUpsertWithoutScopesInput
    connect?: RealmWhereUniqueInput
    update?: XOR<XOR<RealmUpdateToOneWithWhereWithoutScopesInput, RealmUpdateWithoutScopesInput>, RealmUncheckedUpdateWithoutScopesInput>
  }

  export type ClientScopeUpdateManyWithoutScopeNestedInput = {
    create?: XOR<ClientScopeCreateWithoutScopeInput, ClientScopeUncheckedCreateWithoutScopeInput> | ClientScopeCreateWithoutScopeInput[] | ClientScopeUncheckedCreateWithoutScopeInput[]
    connectOrCreate?: ClientScopeCreateOrConnectWithoutScopeInput | ClientScopeCreateOrConnectWithoutScopeInput[]
    upsert?: ClientScopeUpsertWithWhereUniqueWithoutScopeInput | ClientScopeUpsertWithWhereUniqueWithoutScopeInput[]
    createMany?: ClientScopeCreateManyScopeInputEnvelope
    set?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
    disconnect?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
    delete?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
    connect?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
    update?: ClientScopeUpdateWithWhereUniqueWithoutScopeInput | ClientScopeUpdateWithWhereUniqueWithoutScopeInput[]
    updateMany?: ClientScopeUpdateManyWithWhereWithoutScopeInput | ClientScopeUpdateManyWithWhereWithoutScopeInput[]
    deleteMany?: ClientScopeScalarWhereInput | ClientScopeScalarWhereInput[]
  }

  export type ClientScopeUncheckedUpdateManyWithoutScopeNestedInput = {
    create?: XOR<ClientScopeCreateWithoutScopeInput, ClientScopeUncheckedCreateWithoutScopeInput> | ClientScopeCreateWithoutScopeInput[] | ClientScopeUncheckedCreateWithoutScopeInput[]
    connectOrCreate?: ClientScopeCreateOrConnectWithoutScopeInput | ClientScopeCreateOrConnectWithoutScopeInput[]
    upsert?: ClientScopeUpsertWithWhereUniqueWithoutScopeInput | ClientScopeUpsertWithWhereUniqueWithoutScopeInput[]
    createMany?: ClientScopeCreateManyScopeInputEnvelope
    set?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
    disconnect?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
    delete?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
    connect?: ClientScopeWhereUniqueInput | ClientScopeWhereUniqueInput[]
    update?: ClientScopeUpdateWithWhereUniqueWithoutScopeInput | ClientScopeUpdateWithWhereUniqueWithoutScopeInput[]
    updateMany?: ClientScopeUpdateManyWithWhereWithoutScopeInput | ClientScopeUpdateManyWithWhereWithoutScopeInput[]
    deleteMany?: ClientScopeScalarWhereInput | ClientScopeScalarWhereInput[]
  }

  export type ClientCreateNestedOneWithoutScopesInput = {
    create?: XOR<ClientCreateWithoutScopesInput, ClientUncheckedCreateWithoutScopesInput>
    connectOrCreate?: ClientCreateOrConnectWithoutScopesInput
    connect?: ClientWhereUniqueInput
  }

  export type ScopeCreateNestedOneWithoutClientsInput = {
    create?: XOR<ScopeCreateWithoutClientsInput, ScopeUncheckedCreateWithoutClientsInput>
    connectOrCreate?: ScopeCreateOrConnectWithoutClientsInput
    connect?: ScopeWhereUniqueInput
  }

  export type ClientUpdateOneRequiredWithoutScopesNestedInput = {
    create?: XOR<ClientCreateWithoutScopesInput, ClientUncheckedCreateWithoutScopesInput>
    connectOrCreate?: ClientCreateOrConnectWithoutScopesInput
    upsert?: ClientUpsertWithoutScopesInput
    connect?: ClientWhereUniqueInput
    update?: XOR<XOR<ClientUpdateToOneWithWhereWithoutScopesInput, ClientUpdateWithoutScopesInput>, ClientUncheckedUpdateWithoutScopesInput>
  }

  export type ScopeUpdateOneRequiredWithoutClientsNestedInput = {
    create?: XOR<ScopeCreateWithoutClientsInput, ScopeUncheckedCreateWithoutClientsInput>
    connectOrCreate?: ScopeCreateOrConnectWithoutClientsInput
    upsert?: ScopeUpsertWithoutClientsInput
    connect?: ScopeWhereUniqueInput
    update?: XOR<XOR<ScopeUpdateToOneWithWhereWithoutClientsInput, ScopeUpdateWithoutClientsInput>, ScopeUncheckedUpdateWithoutClientsInput>
  }

  export type UserCreateNestedOneWithoutAuthorizationCodesInput = {
    create?: XOR<UserCreateWithoutAuthorizationCodesInput, UserUncheckedCreateWithoutAuthorizationCodesInput>
    connectOrCreate?: UserCreateOrConnectWithoutAuthorizationCodesInput
    connect?: UserWhereUniqueInput
  }

  export type ClientCreateNestedOneWithoutAuthorizationCodesInput = {
    create?: XOR<ClientCreateWithoutAuthorizationCodesInput, ClientUncheckedCreateWithoutAuthorizationCodesInput>
    connectOrCreate?: ClientCreateOrConnectWithoutAuthorizationCodesInput
    connect?: ClientWhereUniqueInput
  }

  export type UserUpdateOneRequiredWithoutAuthorizationCodesNestedInput = {
    create?: XOR<UserCreateWithoutAuthorizationCodesInput, UserUncheckedCreateWithoutAuthorizationCodesInput>
    connectOrCreate?: UserCreateOrConnectWithoutAuthorizationCodesInput
    upsert?: UserUpsertWithoutAuthorizationCodesInput
    connect?: UserWhereUniqueInput
    update?: XOR<XOR<UserUpdateToOneWithWhereWithoutAuthorizationCodesInput, UserUpdateWithoutAuthorizationCodesInput>, UserUncheckedUpdateWithoutAuthorizationCodesInput>
  }

  export type ClientUpdateOneRequiredWithoutAuthorizationCodesNestedInput = {
    create?: XOR<ClientCreateWithoutAuthorizationCodesInput, ClientUncheckedCreateWithoutAuthorizationCodesInput>
    connectOrCreate?: ClientCreateOrConnectWithoutAuthorizationCodesInput
    upsert?: ClientUpsertWithoutAuthorizationCodesInput
    connect?: ClientWhereUniqueInput
    update?: XOR<XOR<ClientUpdateToOneWithWhereWithoutAuthorizationCodesInput, ClientUpdateWithoutAuthorizationCodesInput>, ClientUncheckedUpdateWithoutAuthorizationCodesInput>
  }

  export type UserCreateNestedOneWithoutTokensInput = {
    create?: XOR<UserCreateWithoutTokensInput, UserUncheckedCreateWithoutTokensInput>
    connectOrCreate?: UserCreateOrConnectWithoutTokensInput
    connect?: UserWhereUniqueInput
  }

  export type ClientCreateNestedOneWithoutTokensInput = {
    create?: XOR<ClientCreateWithoutTokensInput, ClientUncheckedCreateWithoutTokensInput>
    connectOrCreate?: ClientCreateOrConnectWithoutTokensInput
    connect?: ClientWhereUniqueInput
  }

  export type EnumTokenTypeFieldUpdateOperationsInput = {
    set?: $Enums.TokenType
  }

  export type UserUpdateOneWithoutTokensNestedInput = {
    create?: XOR<UserCreateWithoutTokensInput, UserUncheckedCreateWithoutTokensInput>
    connectOrCreate?: UserCreateOrConnectWithoutTokensInput
    upsert?: UserUpsertWithoutTokensInput
    disconnect?: UserWhereInput | boolean
    delete?: UserWhereInput | boolean
    connect?: UserWhereUniqueInput
    update?: XOR<XOR<UserUpdateToOneWithWhereWithoutTokensInput, UserUpdateWithoutTokensInput>, UserUncheckedUpdateWithoutTokensInput>
  }

  export type ClientUpdateOneRequiredWithoutTokensNestedInput = {
    create?: XOR<ClientCreateWithoutTokensInput, ClientUncheckedCreateWithoutTokensInput>
    connectOrCreate?: ClientCreateOrConnectWithoutTokensInput
    upsert?: ClientUpsertWithoutTokensInput
    connect?: ClientWhereUniqueInput
    update?: XOR<XOR<ClientUpdateToOneWithWhereWithoutTokensInput, ClientUpdateWithoutTokensInput>, ClientUncheckedUpdateWithoutTokensInput>
  }

  export type NestedStringFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[] | ListStringFieldRefInput<$PrismaModel>
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel>
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    not?: NestedStringFilter<$PrismaModel> | string
  }

  export type NestedStringNullableFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | ListStringFieldRefInput<$PrismaModel> | null
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel> | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    not?: NestedStringNullableFilter<$PrismaModel> | string | null
  }

  export type NestedDateTimeFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeFilter<$PrismaModel> | Date | string
  }

  export type NestedStringWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[] | ListStringFieldRefInput<$PrismaModel>
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel>
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    not?: NestedStringWithAggregatesFilter<$PrismaModel> | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedStringFilter<$PrismaModel>
    _max?: NestedStringFilter<$PrismaModel>
  }

  export type NestedIntFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[] | ListIntFieldRefInput<$PrismaModel>
    notIn?: number[] | ListIntFieldRefInput<$PrismaModel>
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntFilter<$PrismaModel> | number
  }

  export type NestedStringNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | ListStringFieldRefInput<$PrismaModel> | null
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel> | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    not?: NestedStringNullableWithAggregatesFilter<$PrismaModel> | string | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedStringNullableFilter<$PrismaModel>
    _max?: NestedStringNullableFilter<$PrismaModel>
  }

  export type NestedIntNullableFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel> | null
    in?: number[] | ListIntFieldRefInput<$PrismaModel> | null
    notIn?: number[] | ListIntFieldRefInput<$PrismaModel> | null
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntNullableFilter<$PrismaModel> | number | null
  }

  export type NestedDateTimeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeWithAggregatesFilter<$PrismaModel> | Date | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedDateTimeFilter<$PrismaModel>
    _max?: NestedDateTimeFilter<$PrismaModel>
  }

  export type NestedDateTimeNullableFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel> | null
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeNullableFilter<$PrismaModel> | Date | string | null
  }

  export type NestedDateTimeNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel> | null
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeNullableWithAggregatesFilter<$PrismaModel> | Date | string | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedDateTimeNullableFilter<$PrismaModel>
    _max?: NestedDateTimeNullableFilter<$PrismaModel>
  }

  export type NestedBoolFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolFilter<$PrismaModel> | boolean
  }

  export type NestedIntWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[] | ListIntFieldRefInput<$PrismaModel>
    notIn?: number[] | ListIntFieldRefInput<$PrismaModel>
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntWithAggregatesFilter<$PrismaModel> | number
    _count?: NestedIntFilter<$PrismaModel>
    _avg?: NestedFloatFilter<$PrismaModel>
    _sum?: NestedIntFilter<$PrismaModel>
    _min?: NestedIntFilter<$PrismaModel>
    _max?: NestedIntFilter<$PrismaModel>
  }

  export type NestedFloatFilter<$PrismaModel = never> = {
    equals?: number | FloatFieldRefInput<$PrismaModel>
    in?: number[] | ListFloatFieldRefInput<$PrismaModel>
    notIn?: number[] | ListFloatFieldRefInput<$PrismaModel>
    lt?: number | FloatFieldRefInput<$PrismaModel>
    lte?: number | FloatFieldRefInput<$PrismaModel>
    gt?: number | FloatFieldRefInput<$PrismaModel>
    gte?: number | FloatFieldRefInput<$PrismaModel>
    not?: NestedFloatFilter<$PrismaModel> | number
  }

  export type NestedBoolWithAggregatesFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolWithAggregatesFilter<$PrismaModel> | boolean
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedBoolFilter<$PrismaModel>
    _max?: NestedBoolFilter<$PrismaModel>
  }

  export type NestedEnumTokenTypeFilter<$PrismaModel = never> = {
    equals?: $Enums.TokenType | EnumTokenTypeFieldRefInput<$PrismaModel>
    in?: $Enums.TokenType[] | ListEnumTokenTypeFieldRefInput<$PrismaModel>
    notIn?: $Enums.TokenType[] | ListEnumTokenTypeFieldRefInput<$PrismaModel>
    not?: NestedEnumTokenTypeFilter<$PrismaModel> | $Enums.TokenType
  }

  export type NestedEnumTokenTypeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.TokenType | EnumTokenTypeFieldRefInput<$PrismaModel>
    in?: $Enums.TokenType[] | ListEnumTokenTypeFieldRefInput<$PrismaModel>
    notIn?: $Enums.TokenType[] | ListEnumTokenTypeFieldRefInput<$PrismaModel>
    not?: NestedEnumTokenTypeWithAggregatesFilter<$PrismaModel> | $Enums.TokenType
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumTokenTypeFilter<$PrismaModel>
    _max?: NestedEnumTokenTypeFilter<$PrismaModel>
  }

  export type RealmKeyCreateWithoutRealmInput = {
    id?: string
    kid: string
    public_key: string
    private_key_enc: string
    alg: string
    created_at?: Date | string
    expires_at?: Date | string | null
  }

  export type RealmKeyUncheckedCreateWithoutRealmInput = {
    id?: string
    kid: string
    public_key: string
    private_key_enc: string
    alg: string
    created_at?: Date | string
    expires_at?: Date | string | null
  }

  export type RealmKeyCreateOrConnectWithoutRealmInput = {
    where: RealmKeyWhereUniqueInput
    create: XOR<RealmKeyCreateWithoutRealmInput, RealmKeyUncheckedCreateWithoutRealmInput>
  }

  export type RealmKeyCreateManyRealmInputEnvelope = {
    data: RealmKeyCreateManyRealmInput | RealmKeyCreateManyRealmInput[]
    skipDuplicates?: boolean
  }

  export type UserCreateWithoutRealmInput = {
    id?: string
    username: string
    email: string
    password_hash: string
    password_salt: string
    pbkdf2_iter: number
    totp_secret?: string | null
    totp_enabled?: boolean
    email_verified?: boolean
    is_active?: boolean
    created_at?: Date | string
    updated_at?: Date | string
    roles?: UserRoleCreateNestedManyWithoutUserInput
    sessions?: UserSessionCreateNestedManyWithoutUserInput
    tokens?: TokenCreateNestedManyWithoutUserInput
    authorizationCodes?: AuthorizationCodeCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateWithoutRealmInput = {
    id?: string
    username: string
    email: string
    password_hash: string
    password_salt: string
    pbkdf2_iter: number
    totp_secret?: string | null
    totp_enabled?: boolean
    email_verified?: boolean
    is_active?: boolean
    created_at?: Date | string
    updated_at?: Date | string
    roles?: UserRoleUncheckedCreateNestedManyWithoutUserInput
    sessions?: UserSessionUncheckedCreateNestedManyWithoutUserInput
    tokens?: TokenUncheckedCreateNestedManyWithoutUserInput
    authorizationCodes?: AuthorizationCodeUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserCreateOrConnectWithoutRealmInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutRealmInput, UserUncheckedCreateWithoutRealmInput>
  }

  export type UserCreateManyRealmInputEnvelope = {
    data: UserCreateManyRealmInput | UserCreateManyRealmInput[]
    skipDuplicates?: boolean
  }

  export type RoleCreateWithoutRealmInput = {
    id?: string
    name: string
    description?: string | null
    is_client_role?: boolean
    client?: ClientCreateNestedOneWithoutRolesInput
    userLinks?: UserRoleCreateNestedManyWithoutRoleInput
  }

  export type RoleUncheckedCreateWithoutRealmInput = {
    id?: string
    client_id?: string | null
    name: string
    description?: string | null
    is_client_role?: boolean
    userLinks?: UserRoleUncheckedCreateNestedManyWithoutRoleInput
  }

  export type RoleCreateOrConnectWithoutRealmInput = {
    where: RoleWhereUniqueInput
    create: XOR<RoleCreateWithoutRealmInput, RoleUncheckedCreateWithoutRealmInput>
  }

  export type RoleCreateManyRealmInputEnvelope = {
    data: RoleCreateManyRealmInput | RoleCreateManyRealmInput[]
    skipDuplicates?: boolean
  }

  export type ClientCreateWithoutRealmInput = {
    id?: string
    client_id: string
    client_name?: string | null
    client_secret_hash: string
    redirect_uris?: ClientCreateredirect_urisInput | string[]
    grant_types?: ClientCreategrant_typesInput | string[]
    access_token_life?: number
    refresh_token_life?: number
    created_at?: Date | string
    roles?: RoleCreateNestedManyWithoutClientInput
    scopes?: ClientScopeCreateNestedManyWithoutClientInput
    userSessions?: UserSessionCreateNestedManyWithoutClientInput
    tokens?: TokenCreateNestedManyWithoutClientInput
    authorizationCodes?: AuthorizationCodeCreateNestedManyWithoutClientInput
  }

  export type ClientUncheckedCreateWithoutRealmInput = {
    id?: string
    client_id: string
    client_name?: string | null
    client_secret_hash: string
    redirect_uris?: ClientCreateredirect_urisInput | string[]
    grant_types?: ClientCreategrant_typesInput | string[]
    access_token_life?: number
    refresh_token_life?: number
    created_at?: Date | string
    roles?: RoleUncheckedCreateNestedManyWithoutClientInput
    scopes?: ClientScopeUncheckedCreateNestedManyWithoutClientInput
    userSessions?: UserSessionUncheckedCreateNestedManyWithoutClientInput
    tokens?: TokenUncheckedCreateNestedManyWithoutClientInput
    authorizationCodes?: AuthorizationCodeUncheckedCreateNestedManyWithoutClientInput
  }

  export type ClientCreateOrConnectWithoutRealmInput = {
    where: ClientWhereUniqueInput
    create: XOR<ClientCreateWithoutRealmInput, ClientUncheckedCreateWithoutRealmInput>
  }

  export type ClientCreateManyRealmInputEnvelope = {
    data: ClientCreateManyRealmInput | ClientCreateManyRealmInput[]
    skipDuplicates?: boolean
  }

  export type ScopeCreateWithoutRealmInput = {
    id?: string
    name: string
    description?: string | null
    clients?: ClientScopeCreateNestedManyWithoutScopeInput
  }

  export type ScopeUncheckedCreateWithoutRealmInput = {
    id?: string
    name: string
    description?: string | null
    clients?: ClientScopeUncheckedCreateNestedManyWithoutScopeInput
  }

  export type ScopeCreateOrConnectWithoutRealmInput = {
    where: ScopeWhereUniqueInput
    create: XOR<ScopeCreateWithoutRealmInput, ScopeUncheckedCreateWithoutRealmInput>
  }

  export type ScopeCreateManyRealmInputEnvelope = {
    data: ScopeCreateManyRealmInput | ScopeCreateManyRealmInput[]
    skipDuplicates?: boolean
  }

  export type RealmKeyUpsertWithWhereUniqueWithoutRealmInput = {
    where: RealmKeyWhereUniqueInput
    update: XOR<RealmKeyUpdateWithoutRealmInput, RealmKeyUncheckedUpdateWithoutRealmInput>
    create: XOR<RealmKeyCreateWithoutRealmInput, RealmKeyUncheckedCreateWithoutRealmInput>
  }

  export type RealmKeyUpdateWithWhereUniqueWithoutRealmInput = {
    where: RealmKeyWhereUniqueInput
    data: XOR<RealmKeyUpdateWithoutRealmInput, RealmKeyUncheckedUpdateWithoutRealmInput>
  }

  export type RealmKeyUpdateManyWithWhereWithoutRealmInput = {
    where: RealmKeyScalarWhereInput
    data: XOR<RealmKeyUpdateManyMutationInput, RealmKeyUncheckedUpdateManyWithoutRealmInput>
  }

  export type RealmKeyScalarWhereInput = {
    AND?: RealmKeyScalarWhereInput | RealmKeyScalarWhereInput[]
    OR?: RealmKeyScalarWhereInput[]
    NOT?: RealmKeyScalarWhereInput | RealmKeyScalarWhereInput[]
    id?: StringFilter<"RealmKey"> | string
    realm_id?: StringFilter<"RealmKey"> | string
    kid?: StringFilter<"RealmKey"> | string
    public_key?: StringFilter<"RealmKey"> | string
    private_key_enc?: StringFilter<"RealmKey"> | string
    alg?: StringFilter<"RealmKey"> | string
    created_at?: DateTimeFilter<"RealmKey"> | Date | string
    expires_at?: DateTimeNullableFilter<"RealmKey"> | Date | string | null
  }

  export type UserUpsertWithWhereUniqueWithoutRealmInput = {
    where: UserWhereUniqueInput
    update: XOR<UserUpdateWithoutRealmInput, UserUncheckedUpdateWithoutRealmInput>
    create: XOR<UserCreateWithoutRealmInput, UserUncheckedCreateWithoutRealmInput>
  }

  export type UserUpdateWithWhereUniqueWithoutRealmInput = {
    where: UserWhereUniqueInput
    data: XOR<UserUpdateWithoutRealmInput, UserUncheckedUpdateWithoutRealmInput>
  }

  export type UserUpdateManyWithWhereWithoutRealmInput = {
    where: UserScalarWhereInput
    data: XOR<UserUpdateManyMutationInput, UserUncheckedUpdateManyWithoutRealmInput>
  }

  export type UserScalarWhereInput = {
    AND?: UserScalarWhereInput | UserScalarWhereInput[]
    OR?: UserScalarWhereInput[]
    NOT?: UserScalarWhereInput | UserScalarWhereInput[]
    id?: StringFilter<"User"> | string
    realm_id?: StringFilter<"User"> | string
    username?: StringFilter<"User"> | string
    email?: StringFilter<"User"> | string
    password_hash?: StringFilter<"User"> | string
    password_salt?: StringFilter<"User"> | string
    pbkdf2_iter?: IntFilter<"User"> | number
    totp_secret?: StringNullableFilter<"User"> | string | null
    totp_enabled?: BoolFilter<"User"> | boolean
    email_verified?: BoolFilter<"User"> | boolean
    is_active?: BoolFilter<"User"> | boolean
    created_at?: DateTimeFilter<"User"> | Date | string
    updated_at?: DateTimeFilter<"User"> | Date | string
  }

  export type RoleUpsertWithWhereUniqueWithoutRealmInput = {
    where: RoleWhereUniqueInput
    update: XOR<RoleUpdateWithoutRealmInput, RoleUncheckedUpdateWithoutRealmInput>
    create: XOR<RoleCreateWithoutRealmInput, RoleUncheckedCreateWithoutRealmInput>
  }

  export type RoleUpdateWithWhereUniqueWithoutRealmInput = {
    where: RoleWhereUniqueInput
    data: XOR<RoleUpdateWithoutRealmInput, RoleUncheckedUpdateWithoutRealmInput>
  }

  export type RoleUpdateManyWithWhereWithoutRealmInput = {
    where: RoleScalarWhereInput
    data: XOR<RoleUpdateManyMutationInput, RoleUncheckedUpdateManyWithoutRealmInput>
  }

  export type RoleScalarWhereInput = {
    AND?: RoleScalarWhereInput | RoleScalarWhereInput[]
    OR?: RoleScalarWhereInput[]
    NOT?: RoleScalarWhereInput | RoleScalarWhereInput[]
    id?: StringFilter<"Role"> | string
    realm_id?: StringFilter<"Role"> | string
    client_id?: StringNullableFilter<"Role"> | string | null
    name?: StringFilter<"Role"> | string
    description?: StringNullableFilter<"Role"> | string | null
    is_client_role?: BoolFilter<"Role"> | boolean
  }

  export type ClientUpsertWithWhereUniqueWithoutRealmInput = {
    where: ClientWhereUniqueInput
    update: XOR<ClientUpdateWithoutRealmInput, ClientUncheckedUpdateWithoutRealmInput>
    create: XOR<ClientCreateWithoutRealmInput, ClientUncheckedCreateWithoutRealmInput>
  }

  export type ClientUpdateWithWhereUniqueWithoutRealmInput = {
    where: ClientWhereUniqueInput
    data: XOR<ClientUpdateWithoutRealmInput, ClientUncheckedUpdateWithoutRealmInput>
  }

  export type ClientUpdateManyWithWhereWithoutRealmInput = {
    where: ClientScalarWhereInput
    data: XOR<ClientUpdateManyMutationInput, ClientUncheckedUpdateManyWithoutRealmInput>
  }

  export type ClientScalarWhereInput = {
    AND?: ClientScalarWhereInput | ClientScalarWhereInput[]
    OR?: ClientScalarWhereInput[]
    NOT?: ClientScalarWhereInput | ClientScalarWhereInput[]
    id?: StringFilter<"Client"> | string
    realm_id?: StringFilter<"Client"> | string
    client_id?: StringFilter<"Client"> | string
    client_name?: StringNullableFilter<"Client"> | string | null
    client_secret_hash?: StringFilter<"Client"> | string
    redirect_uris?: StringNullableListFilter<"Client">
    grant_types?: StringNullableListFilter<"Client">
    access_token_life?: IntFilter<"Client"> | number
    refresh_token_life?: IntFilter<"Client"> | number
    created_at?: DateTimeFilter<"Client"> | Date | string
  }

  export type ScopeUpsertWithWhereUniqueWithoutRealmInput = {
    where: ScopeWhereUniqueInput
    update: XOR<ScopeUpdateWithoutRealmInput, ScopeUncheckedUpdateWithoutRealmInput>
    create: XOR<ScopeCreateWithoutRealmInput, ScopeUncheckedCreateWithoutRealmInput>
  }

  export type ScopeUpdateWithWhereUniqueWithoutRealmInput = {
    where: ScopeWhereUniqueInput
    data: XOR<ScopeUpdateWithoutRealmInput, ScopeUncheckedUpdateWithoutRealmInput>
  }

  export type ScopeUpdateManyWithWhereWithoutRealmInput = {
    where: ScopeScalarWhereInput
    data: XOR<ScopeUpdateManyMutationInput, ScopeUncheckedUpdateManyWithoutRealmInput>
  }

  export type ScopeScalarWhereInput = {
    AND?: ScopeScalarWhereInput | ScopeScalarWhereInput[]
    OR?: ScopeScalarWhereInput[]
    NOT?: ScopeScalarWhereInput | ScopeScalarWhereInput[]
    id?: StringFilter<"Scope"> | string
    realm_id?: StringFilter<"Scope"> | string
    name?: StringFilter<"Scope"> | string
    description?: StringNullableFilter<"Scope"> | string | null
  }

  export type RealmCreateWithoutKeysInput = {
    id?: string
    name: string
    description?: string | null
    created_at?: Date | string
    users?: UserCreateNestedManyWithoutRealmInput
    roles?: RoleCreateNestedManyWithoutRealmInput
    clients?: ClientCreateNestedManyWithoutRealmInput
    scopes?: ScopeCreateNestedManyWithoutRealmInput
  }

  export type RealmUncheckedCreateWithoutKeysInput = {
    id?: string
    name: string
    description?: string | null
    created_at?: Date | string
    users?: UserUncheckedCreateNestedManyWithoutRealmInput
    roles?: RoleUncheckedCreateNestedManyWithoutRealmInput
    clients?: ClientUncheckedCreateNestedManyWithoutRealmInput
    scopes?: ScopeUncheckedCreateNestedManyWithoutRealmInput
  }

  export type RealmCreateOrConnectWithoutKeysInput = {
    where: RealmWhereUniqueInput
    create: XOR<RealmCreateWithoutKeysInput, RealmUncheckedCreateWithoutKeysInput>
  }

  export type RealmUpsertWithoutKeysInput = {
    update: XOR<RealmUpdateWithoutKeysInput, RealmUncheckedUpdateWithoutKeysInput>
    create: XOR<RealmCreateWithoutKeysInput, RealmUncheckedCreateWithoutKeysInput>
    where?: RealmWhereInput
  }

  export type RealmUpdateToOneWithWhereWithoutKeysInput = {
    where?: RealmWhereInput
    data: XOR<RealmUpdateWithoutKeysInput, RealmUncheckedUpdateWithoutKeysInput>
  }

  export type RealmUpdateWithoutKeysInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    users?: UserUpdateManyWithoutRealmNestedInput
    roles?: RoleUpdateManyWithoutRealmNestedInput
    clients?: ClientUpdateManyWithoutRealmNestedInput
    scopes?: ScopeUpdateManyWithoutRealmNestedInput
  }

  export type RealmUncheckedUpdateWithoutKeysInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    users?: UserUncheckedUpdateManyWithoutRealmNestedInput
    roles?: RoleUncheckedUpdateManyWithoutRealmNestedInput
    clients?: ClientUncheckedUpdateManyWithoutRealmNestedInput
    scopes?: ScopeUncheckedUpdateManyWithoutRealmNestedInput
  }

  export type RealmCreateWithoutUsersInput = {
    id?: string
    name: string
    description?: string | null
    created_at?: Date | string
    keys?: RealmKeyCreateNestedManyWithoutRealmInput
    roles?: RoleCreateNestedManyWithoutRealmInput
    clients?: ClientCreateNestedManyWithoutRealmInput
    scopes?: ScopeCreateNestedManyWithoutRealmInput
  }

  export type RealmUncheckedCreateWithoutUsersInput = {
    id?: string
    name: string
    description?: string | null
    created_at?: Date | string
    keys?: RealmKeyUncheckedCreateNestedManyWithoutRealmInput
    roles?: RoleUncheckedCreateNestedManyWithoutRealmInput
    clients?: ClientUncheckedCreateNestedManyWithoutRealmInput
    scopes?: ScopeUncheckedCreateNestedManyWithoutRealmInput
  }

  export type RealmCreateOrConnectWithoutUsersInput = {
    where: RealmWhereUniqueInput
    create: XOR<RealmCreateWithoutUsersInput, RealmUncheckedCreateWithoutUsersInput>
  }

  export type UserRoleCreateWithoutUserInput = {
    role: RoleCreateNestedOneWithoutUserLinksInput
  }

  export type UserRoleUncheckedCreateWithoutUserInput = {
    role_id: string
  }

  export type UserRoleCreateOrConnectWithoutUserInput = {
    where: UserRoleWhereUniqueInput
    create: XOR<UserRoleCreateWithoutUserInput, UserRoleUncheckedCreateWithoutUserInput>
  }

  export type UserRoleCreateManyUserInputEnvelope = {
    data: UserRoleCreateManyUserInput | UserRoleCreateManyUserInput[]
    skipDuplicates?: boolean
  }

  export type UserSessionCreateWithoutUserInput = {
    id?: string
    ip_addr: string
    user_agent: string
    login_time?: Date | string
    logout_time?: Date | string | null
    client: ClientCreateNestedOneWithoutUserSessionsInput
  }

  export type UserSessionUncheckedCreateWithoutUserInput = {
    id?: string
    client_id: string
    ip_addr: string
    user_agent: string
    login_time?: Date | string
    logout_time?: Date | string | null
  }

  export type UserSessionCreateOrConnectWithoutUserInput = {
    where: UserSessionWhereUniqueInput
    create: XOR<UserSessionCreateWithoutUserInput, UserSessionUncheckedCreateWithoutUserInput>
  }

  export type UserSessionCreateManyUserInputEnvelope = {
    data: UserSessionCreateManyUserInput | UserSessionCreateManyUserInput[]
    skipDuplicates?: boolean
  }

  export type TokenCreateWithoutUserInput = {
    id?: string
    token_type: $Enums.TokenType
    jwt_id: string
    issued_at?: Date | string
    expires_at: Date | string
    revoked_at?: Date | string | null
    scope: string
    client: ClientCreateNestedOneWithoutTokensInput
  }

  export type TokenUncheckedCreateWithoutUserInput = {
    id?: string
    client_id: string
    token_type: $Enums.TokenType
    jwt_id: string
    issued_at?: Date | string
    expires_at: Date | string
    revoked_at?: Date | string | null
    scope: string
  }

  export type TokenCreateOrConnectWithoutUserInput = {
    where: TokenWhereUniqueInput
    create: XOR<TokenCreateWithoutUserInput, TokenUncheckedCreateWithoutUserInput>
  }

  export type TokenCreateManyUserInputEnvelope = {
    data: TokenCreateManyUserInput | TokenCreateManyUserInput[]
    skipDuplicates?: boolean
  }

  export type AuthorizationCodeCreateWithoutUserInput = {
    code: string
    redirect_uri: string
    scope: string
    expires_at: Date | string
    created_at?: Date | string
    code_challenge?: string | null
    client: ClientCreateNestedOneWithoutAuthorizationCodesInput
  }

  export type AuthorizationCodeUncheckedCreateWithoutUserInput = {
    code: string
    client_id: string
    redirect_uri: string
    scope: string
    expires_at: Date | string
    created_at?: Date | string
    code_challenge?: string | null
  }

  export type AuthorizationCodeCreateOrConnectWithoutUserInput = {
    where: AuthorizationCodeWhereUniqueInput
    create: XOR<AuthorizationCodeCreateWithoutUserInput, AuthorizationCodeUncheckedCreateWithoutUserInput>
  }

  export type AuthorizationCodeCreateManyUserInputEnvelope = {
    data: AuthorizationCodeCreateManyUserInput | AuthorizationCodeCreateManyUserInput[]
    skipDuplicates?: boolean
  }

  export type RealmUpsertWithoutUsersInput = {
    update: XOR<RealmUpdateWithoutUsersInput, RealmUncheckedUpdateWithoutUsersInput>
    create: XOR<RealmCreateWithoutUsersInput, RealmUncheckedCreateWithoutUsersInput>
    where?: RealmWhereInput
  }

  export type RealmUpdateToOneWithWhereWithoutUsersInput = {
    where?: RealmWhereInput
    data: XOR<RealmUpdateWithoutUsersInput, RealmUncheckedUpdateWithoutUsersInput>
  }

  export type RealmUpdateWithoutUsersInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    keys?: RealmKeyUpdateManyWithoutRealmNestedInput
    roles?: RoleUpdateManyWithoutRealmNestedInput
    clients?: ClientUpdateManyWithoutRealmNestedInput
    scopes?: ScopeUpdateManyWithoutRealmNestedInput
  }

  export type RealmUncheckedUpdateWithoutUsersInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    keys?: RealmKeyUncheckedUpdateManyWithoutRealmNestedInput
    roles?: RoleUncheckedUpdateManyWithoutRealmNestedInput
    clients?: ClientUncheckedUpdateManyWithoutRealmNestedInput
    scopes?: ScopeUncheckedUpdateManyWithoutRealmNestedInput
  }

  export type UserRoleUpsertWithWhereUniqueWithoutUserInput = {
    where: UserRoleWhereUniqueInput
    update: XOR<UserRoleUpdateWithoutUserInput, UserRoleUncheckedUpdateWithoutUserInput>
    create: XOR<UserRoleCreateWithoutUserInput, UserRoleUncheckedCreateWithoutUserInput>
  }

  export type UserRoleUpdateWithWhereUniqueWithoutUserInput = {
    where: UserRoleWhereUniqueInput
    data: XOR<UserRoleUpdateWithoutUserInput, UserRoleUncheckedUpdateWithoutUserInput>
  }

  export type UserRoleUpdateManyWithWhereWithoutUserInput = {
    where: UserRoleScalarWhereInput
    data: XOR<UserRoleUpdateManyMutationInput, UserRoleUncheckedUpdateManyWithoutUserInput>
  }

  export type UserRoleScalarWhereInput = {
    AND?: UserRoleScalarWhereInput | UserRoleScalarWhereInput[]
    OR?: UserRoleScalarWhereInput[]
    NOT?: UserRoleScalarWhereInput | UserRoleScalarWhereInput[]
    user_id?: StringFilter<"UserRole"> | string
    role_id?: StringFilter<"UserRole"> | string
  }

  export type UserSessionUpsertWithWhereUniqueWithoutUserInput = {
    where: UserSessionWhereUniqueInput
    update: XOR<UserSessionUpdateWithoutUserInput, UserSessionUncheckedUpdateWithoutUserInput>
    create: XOR<UserSessionCreateWithoutUserInput, UserSessionUncheckedCreateWithoutUserInput>
  }

  export type UserSessionUpdateWithWhereUniqueWithoutUserInput = {
    where: UserSessionWhereUniqueInput
    data: XOR<UserSessionUpdateWithoutUserInput, UserSessionUncheckedUpdateWithoutUserInput>
  }

  export type UserSessionUpdateManyWithWhereWithoutUserInput = {
    where: UserSessionScalarWhereInput
    data: XOR<UserSessionUpdateManyMutationInput, UserSessionUncheckedUpdateManyWithoutUserInput>
  }

  export type UserSessionScalarWhereInput = {
    AND?: UserSessionScalarWhereInput | UserSessionScalarWhereInput[]
    OR?: UserSessionScalarWhereInput[]
    NOT?: UserSessionScalarWhereInput | UserSessionScalarWhereInput[]
    id?: StringFilter<"UserSession"> | string
    user_id?: StringFilter<"UserSession"> | string
    client_id?: StringFilter<"UserSession"> | string
    ip_addr?: StringFilter<"UserSession"> | string
    user_agent?: StringFilter<"UserSession"> | string
    login_time?: DateTimeFilter<"UserSession"> | Date | string
    logout_time?: DateTimeNullableFilter<"UserSession"> | Date | string | null
  }

  export type TokenUpsertWithWhereUniqueWithoutUserInput = {
    where: TokenWhereUniqueInput
    update: XOR<TokenUpdateWithoutUserInput, TokenUncheckedUpdateWithoutUserInput>
    create: XOR<TokenCreateWithoutUserInput, TokenUncheckedCreateWithoutUserInput>
  }

  export type TokenUpdateWithWhereUniqueWithoutUserInput = {
    where: TokenWhereUniqueInput
    data: XOR<TokenUpdateWithoutUserInput, TokenUncheckedUpdateWithoutUserInput>
  }

  export type TokenUpdateManyWithWhereWithoutUserInput = {
    where: TokenScalarWhereInput
    data: XOR<TokenUpdateManyMutationInput, TokenUncheckedUpdateManyWithoutUserInput>
  }

  export type TokenScalarWhereInput = {
    AND?: TokenScalarWhereInput | TokenScalarWhereInput[]
    OR?: TokenScalarWhereInput[]
    NOT?: TokenScalarWhereInput | TokenScalarWhereInput[]
    id?: StringFilter<"Token"> | string
    user_id?: StringNullableFilter<"Token"> | string | null
    client_id?: StringFilter<"Token"> | string
    token_type?: EnumTokenTypeFilter<"Token"> | $Enums.TokenType
    jwt_id?: StringFilter<"Token"> | string
    issued_at?: DateTimeFilter<"Token"> | Date | string
    expires_at?: DateTimeFilter<"Token"> | Date | string
    revoked_at?: DateTimeNullableFilter<"Token"> | Date | string | null
    scope?: StringFilter<"Token"> | string
  }

  export type AuthorizationCodeUpsertWithWhereUniqueWithoutUserInput = {
    where: AuthorizationCodeWhereUniqueInput
    update: XOR<AuthorizationCodeUpdateWithoutUserInput, AuthorizationCodeUncheckedUpdateWithoutUserInput>
    create: XOR<AuthorizationCodeCreateWithoutUserInput, AuthorizationCodeUncheckedCreateWithoutUserInput>
  }

  export type AuthorizationCodeUpdateWithWhereUniqueWithoutUserInput = {
    where: AuthorizationCodeWhereUniqueInput
    data: XOR<AuthorizationCodeUpdateWithoutUserInput, AuthorizationCodeUncheckedUpdateWithoutUserInput>
  }

  export type AuthorizationCodeUpdateManyWithWhereWithoutUserInput = {
    where: AuthorizationCodeScalarWhereInput
    data: XOR<AuthorizationCodeUpdateManyMutationInput, AuthorizationCodeUncheckedUpdateManyWithoutUserInput>
  }

  export type AuthorizationCodeScalarWhereInput = {
    AND?: AuthorizationCodeScalarWhereInput | AuthorizationCodeScalarWhereInput[]
    OR?: AuthorizationCodeScalarWhereInput[]
    NOT?: AuthorizationCodeScalarWhereInput | AuthorizationCodeScalarWhereInput[]
    code?: StringFilter<"AuthorizationCode"> | string
    user_id?: StringFilter<"AuthorizationCode"> | string
    client_id?: StringFilter<"AuthorizationCode"> | string
    redirect_uri?: StringFilter<"AuthorizationCode"> | string
    scope?: StringFilter<"AuthorizationCode"> | string
    expires_at?: DateTimeFilter<"AuthorizationCode"> | Date | string
    created_at?: DateTimeFilter<"AuthorizationCode"> | Date | string
    code_challenge?: StringNullableFilter<"AuthorizationCode"> | string | null
  }

  export type UserCreateWithoutSessionsInput = {
    id?: string
    username: string
    email: string
    password_hash: string
    password_salt: string
    pbkdf2_iter: number
    totp_secret?: string | null
    totp_enabled?: boolean
    email_verified?: boolean
    is_active?: boolean
    created_at?: Date | string
    updated_at?: Date | string
    realm: RealmCreateNestedOneWithoutUsersInput
    roles?: UserRoleCreateNestedManyWithoutUserInput
    tokens?: TokenCreateNestedManyWithoutUserInput
    authorizationCodes?: AuthorizationCodeCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateWithoutSessionsInput = {
    id?: string
    realm_id: string
    username: string
    email: string
    password_hash: string
    password_salt: string
    pbkdf2_iter: number
    totp_secret?: string | null
    totp_enabled?: boolean
    email_verified?: boolean
    is_active?: boolean
    created_at?: Date | string
    updated_at?: Date | string
    roles?: UserRoleUncheckedCreateNestedManyWithoutUserInput
    tokens?: TokenUncheckedCreateNestedManyWithoutUserInput
    authorizationCodes?: AuthorizationCodeUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserCreateOrConnectWithoutSessionsInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutSessionsInput, UserUncheckedCreateWithoutSessionsInput>
  }

  export type ClientCreateWithoutUserSessionsInput = {
    id?: string
    client_id: string
    client_name?: string | null
    client_secret_hash: string
    redirect_uris?: ClientCreateredirect_urisInput | string[]
    grant_types?: ClientCreategrant_typesInput | string[]
    access_token_life?: number
    refresh_token_life?: number
    created_at?: Date | string
    realm: RealmCreateNestedOneWithoutClientsInput
    roles?: RoleCreateNestedManyWithoutClientInput
    scopes?: ClientScopeCreateNestedManyWithoutClientInput
    tokens?: TokenCreateNestedManyWithoutClientInput
    authorizationCodes?: AuthorizationCodeCreateNestedManyWithoutClientInput
  }

  export type ClientUncheckedCreateWithoutUserSessionsInput = {
    id?: string
    realm_id: string
    client_id: string
    client_name?: string | null
    client_secret_hash: string
    redirect_uris?: ClientCreateredirect_urisInput | string[]
    grant_types?: ClientCreategrant_typesInput | string[]
    access_token_life?: number
    refresh_token_life?: number
    created_at?: Date | string
    roles?: RoleUncheckedCreateNestedManyWithoutClientInput
    scopes?: ClientScopeUncheckedCreateNestedManyWithoutClientInput
    tokens?: TokenUncheckedCreateNestedManyWithoutClientInput
    authorizationCodes?: AuthorizationCodeUncheckedCreateNestedManyWithoutClientInput
  }

  export type ClientCreateOrConnectWithoutUserSessionsInput = {
    where: ClientWhereUniqueInput
    create: XOR<ClientCreateWithoutUserSessionsInput, ClientUncheckedCreateWithoutUserSessionsInput>
  }

  export type UserUpsertWithoutSessionsInput = {
    update: XOR<UserUpdateWithoutSessionsInput, UserUncheckedUpdateWithoutSessionsInput>
    create: XOR<UserCreateWithoutSessionsInput, UserUncheckedCreateWithoutSessionsInput>
    where?: UserWhereInput
  }

  export type UserUpdateToOneWithWhereWithoutSessionsInput = {
    where?: UserWhereInput
    data: XOR<UserUpdateWithoutSessionsInput, UserUncheckedUpdateWithoutSessionsInput>
  }

  export type UserUpdateWithoutSessionsInput = {
    id?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password_hash?: StringFieldUpdateOperationsInput | string
    password_salt?: StringFieldUpdateOperationsInput | string
    pbkdf2_iter?: IntFieldUpdateOperationsInput | number
    totp_secret?: NullableStringFieldUpdateOperationsInput | string | null
    totp_enabled?: BoolFieldUpdateOperationsInput | boolean
    email_verified?: BoolFieldUpdateOperationsInput | boolean
    is_active?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    realm?: RealmUpdateOneRequiredWithoutUsersNestedInput
    roles?: UserRoleUpdateManyWithoutUserNestedInput
    tokens?: TokenUpdateManyWithoutUserNestedInput
    authorizationCodes?: AuthorizationCodeUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateWithoutSessionsInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password_hash?: StringFieldUpdateOperationsInput | string
    password_salt?: StringFieldUpdateOperationsInput | string
    pbkdf2_iter?: IntFieldUpdateOperationsInput | number
    totp_secret?: NullableStringFieldUpdateOperationsInput | string | null
    totp_enabled?: BoolFieldUpdateOperationsInput | boolean
    email_verified?: BoolFieldUpdateOperationsInput | boolean
    is_active?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    roles?: UserRoleUncheckedUpdateManyWithoutUserNestedInput
    tokens?: TokenUncheckedUpdateManyWithoutUserNestedInput
    authorizationCodes?: AuthorizationCodeUncheckedUpdateManyWithoutUserNestedInput
  }

  export type ClientUpsertWithoutUserSessionsInput = {
    update: XOR<ClientUpdateWithoutUserSessionsInput, ClientUncheckedUpdateWithoutUserSessionsInput>
    create: XOR<ClientCreateWithoutUserSessionsInput, ClientUncheckedCreateWithoutUserSessionsInput>
    where?: ClientWhereInput
  }

  export type ClientUpdateToOneWithWhereWithoutUserSessionsInput = {
    where?: ClientWhereInput
    data: XOR<ClientUpdateWithoutUserSessionsInput, ClientUncheckedUpdateWithoutUserSessionsInput>
  }

  export type ClientUpdateWithoutUserSessionsInput = {
    id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    client_name?: NullableStringFieldUpdateOperationsInput | string | null
    client_secret_hash?: StringFieldUpdateOperationsInput | string
    redirect_uris?: ClientUpdateredirect_urisInput | string[]
    grant_types?: ClientUpdategrant_typesInput | string[]
    access_token_life?: IntFieldUpdateOperationsInput | number
    refresh_token_life?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    realm?: RealmUpdateOneRequiredWithoutClientsNestedInput
    roles?: RoleUpdateManyWithoutClientNestedInput
    scopes?: ClientScopeUpdateManyWithoutClientNestedInput
    tokens?: TokenUpdateManyWithoutClientNestedInput
    authorizationCodes?: AuthorizationCodeUpdateManyWithoutClientNestedInput
  }

  export type ClientUncheckedUpdateWithoutUserSessionsInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    client_name?: NullableStringFieldUpdateOperationsInput | string | null
    client_secret_hash?: StringFieldUpdateOperationsInput | string
    redirect_uris?: ClientUpdateredirect_urisInput | string[]
    grant_types?: ClientUpdategrant_typesInput | string[]
    access_token_life?: IntFieldUpdateOperationsInput | number
    refresh_token_life?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    roles?: RoleUncheckedUpdateManyWithoutClientNestedInput
    scopes?: ClientScopeUncheckedUpdateManyWithoutClientNestedInput
    tokens?: TokenUncheckedUpdateManyWithoutClientNestedInput
    authorizationCodes?: AuthorizationCodeUncheckedUpdateManyWithoutClientNestedInput
  }

  export type RealmCreateWithoutRolesInput = {
    id?: string
    name: string
    description?: string | null
    created_at?: Date | string
    keys?: RealmKeyCreateNestedManyWithoutRealmInput
    users?: UserCreateNestedManyWithoutRealmInput
    clients?: ClientCreateNestedManyWithoutRealmInput
    scopes?: ScopeCreateNestedManyWithoutRealmInput
  }

  export type RealmUncheckedCreateWithoutRolesInput = {
    id?: string
    name: string
    description?: string | null
    created_at?: Date | string
    keys?: RealmKeyUncheckedCreateNestedManyWithoutRealmInput
    users?: UserUncheckedCreateNestedManyWithoutRealmInput
    clients?: ClientUncheckedCreateNestedManyWithoutRealmInput
    scopes?: ScopeUncheckedCreateNestedManyWithoutRealmInput
  }

  export type RealmCreateOrConnectWithoutRolesInput = {
    where: RealmWhereUniqueInput
    create: XOR<RealmCreateWithoutRolesInput, RealmUncheckedCreateWithoutRolesInput>
  }

  export type ClientCreateWithoutRolesInput = {
    id?: string
    client_id: string
    client_name?: string | null
    client_secret_hash: string
    redirect_uris?: ClientCreateredirect_urisInput | string[]
    grant_types?: ClientCreategrant_typesInput | string[]
    access_token_life?: number
    refresh_token_life?: number
    created_at?: Date | string
    realm: RealmCreateNestedOneWithoutClientsInput
    scopes?: ClientScopeCreateNestedManyWithoutClientInput
    userSessions?: UserSessionCreateNestedManyWithoutClientInput
    tokens?: TokenCreateNestedManyWithoutClientInput
    authorizationCodes?: AuthorizationCodeCreateNestedManyWithoutClientInput
  }

  export type ClientUncheckedCreateWithoutRolesInput = {
    id?: string
    realm_id: string
    client_id: string
    client_name?: string | null
    client_secret_hash: string
    redirect_uris?: ClientCreateredirect_urisInput | string[]
    grant_types?: ClientCreategrant_typesInput | string[]
    access_token_life?: number
    refresh_token_life?: number
    created_at?: Date | string
    scopes?: ClientScopeUncheckedCreateNestedManyWithoutClientInput
    userSessions?: UserSessionUncheckedCreateNestedManyWithoutClientInput
    tokens?: TokenUncheckedCreateNestedManyWithoutClientInput
    authorizationCodes?: AuthorizationCodeUncheckedCreateNestedManyWithoutClientInput
  }

  export type ClientCreateOrConnectWithoutRolesInput = {
    where: ClientWhereUniqueInput
    create: XOR<ClientCreateWithoutRolesInput, ClientUncheckedCreateWithoutRolesInput>
  }

  export type UserRoleCreateWithoutRoleInput = {
    user: UserCreateNestedOneWithoutRolesInput
  }

  export type UserRoleUncheckedCreateWithoutRoleInput = {
    user_id: string
  }

  export type UserRoleCreateOrConnectWithoutRoleInput = {
    where: UserRoleWhereUniqueInput
    create: XOR<UserRoleCreateWithoutRoleInput, UserRoleUncheckedCreateWithoutRoleInput>
  }

  export type UserRoleCreateManyRoleInputEnvelope = {
    data: UserRoleCreateManyRoleInput | UserRoleCreateManyRoleInput[]
    skipDuplicates?: boolean
  }

  export type RealmUpsertWithoutRolesInput = {
    update: XOR<RealmUpdateWithoutRolesInput, RealmUncheckedUpdateWithoutRolesInput>
    create: XOR<RealmCreateWithoutRolesInput, RealmUncheckedCreateWithoutRolesInput>
    where?: RealmWhereInput
  }

  export type RealmUpdateToOneWithWhereWithoutRolesInput = {
    where?: RealmWhereInput
    data: XOR<RealmUpdateWithoutRolesInput, RealmUncheckedUpdateWithoutRolesInput>
  }

  export type RealmUpdateWithoutRolesInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    keys?: RealmKeyUpdateManyWithoutRealmNestedInput
    users?: UserUpdateManyWithoutRealmNestedInput
    clients?: ClientUpdateManyWithoutRealmNestedInput
    scopes?: ScopeUpdateManyWithoutRealmNestedInput
  }

  export type RealmUncheckedUpdateWithoutRolesInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    keys?: RealmKeyUncheckedUpdateManyWithoutRealmNestedInput
    users?: UserUncheckedUpdateManyWithoutRealmNestedInput
    clients?: ClientUncheckedUpdateManyWithoutRealmNestedInput
    scopes?: ScopeUncheckedUpdateManyWithoutRealmNestedInput
  }

  export type ClientUpsertWithoutRolesInput = {
    update: XOR<ClientUpdateWithoutRolesInput, ClientUncheckedUpdateWithoutRolesInput>
    create: XOR<ClientCreateWithoutRolesInput, ClientUncheckedCreateWithoutRolesInput>
    where?: ClientWhereInput
  }

  export type ClientUpdateToOneWithWhereWithoutRolesInput = {
    where?: ClientWhereInput
    data: XOR<ClientUpdateWithoutRolesInput, ClientUncheckedUpdateWithoutRolesInput>
  }

  export type ClientUpdateWithoutRolesInput = {
    id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    client_name?: NullableStringFieldUpdateOperationsInput | string | null
    client_secret_hash?: StringFieldUpdateOperationsInput | string
    redirect_uris?: ClientUpdateredirect_urisInput | string[]
    grant_types?: ClientUpdategrant_typesInput | string[]
    access_token_life?: IntFieldUpdateOperationsInput | number
    refresh_token_life?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    realm?: RealmUpdateOneRequiredWithoutClientsNestedInput
    scopes?: ClientScopeUpdateManyWithoutClientNestedInput
    userSessions?: UserSessionUpdateManyWithoutClientNestedInput
    tokens?: TokenUpdateManyWithoutClientNestedInput
    authorizationCodes?: AuthorizationCodeUpdateManyWithoutClientNestedInput
  }

  export type ClientUncheckedUpdateWithoutRolesInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    client_name?: NullableStringFieldUpdateOperationsInput | string | null
    client_secret_hash?: StringFieldUpdateOperationsInput | string
    redirect_uris?: ClientUpdateredirect_urisInput | string[]
    grant_types?: ClientUpdategrant_typesInput | string[]
    access_token_life?: IntFieldUpdateOperationsInput | number
    refresh_token_life?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    scopes?: ClientScopeUncheckedUpdateManyWithoutClientNestedInput
    userSessions?: UserSessionUncheckedUpdateManyWithoutClientNestedInput
    tokens?: TokenUncheckedUpdateManyWithoutClientNestedInput
    authorizationCodes?: AuthorizationCodeUncheckedUpdateManyWithoutClientNestedInput
  }

  export type UserRoleUpsertWithWhereUniqueWithoutRoleInput = {
    where: UserRoleWhereUniqueInput
    update: XOR<UserRoleUpdateWithoutRoleInput, UserRoleUncheckedUpdateWithoutRoleInput>
    create: XOR<UserRoleCreateWithoutRoleInput, UserRoleUncheckedCreateWithoutRoleInput>
  }

  export type UserRoleUpdateWithWhereUniqueWithoutRoleInput = {
    where: UserRoleWhereUniqueInput
    data: XOR<UserRoleUpdateWithoutRoleInput, UserRoleUncheckedUpdateWithoutRoleInput>
  }

  export type UserRoleUpdateManyWithWhereWithoutRoleInput = {
    where: UserRoleScalarWhereInput
    data: XOR<UserRoleUpdateManyMutationInput, UserRoleUncheckedUpdateManyWithoutRoleInput>
  }

  export type UserCreateWithoutRolesInput = {
    id?: string
    username: string
    email: string
    password_hash: string
    password_salt: string
    pbkdf2_iter: number
    totp_secret?: string | null
    totp_enabled?: boolean
    email_verified?: boolean
    is_active?: boolean
    created_at?: Date | string
    updated_at?: Date | string
    realm: RealmCreateNestedOneWithoutUsersInput
    sessions?: UserSessionCreateNestedManyWithoutUserInput
    tokens?: TokenCreateNestedManyWithoutUserInput
    authorizationCodes?: AuthorizationCodeCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateWithoutRolesInput = {
    id?: string
    realm_id: string
    username: string
    email: string
    password_hash: string
    password_salt: string
    pbkdf2_iter: number
    totp_secret?: string | null
    totp_enabled?: boolean
    email_verified?: boolean
    is_active?: boolean
    created_at?: Date | string
    updated_at?: Date | string
    sessions?: UserSessionUncheckedCreateNestedManyWithoutUserInput
    tokens?: TokenUncheckedCreateNestedManyWithoutUserInput
    authorizationCodes?: AuthorizationCodeUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserCreateOrConnectWithoutRolesInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutRolesInput, UserUncheckedCreateWithoutRolesInput>
  }

  export type RoleCreateWithoutUserLinksInput = {
    id?: string
    name: string
    description?: string | null
    is_client_role?: boolean
    realm: RealmCreateNestedOneWithoutRolesInput
    client?: ClientCreateNestedOneWithoutRolesInput
  }

  export type RoleUncheckedCreateWithoutUserLinksInput = {
    id?: string
    realm_id: string
    client_id?: string | null
    name: string
    description?: string | null
    is_client_role?: boolean
  }

  export type RoleCreateOrConnectWithoutUserLinksInput = {
    where: RoleWhereUniqueInput
    create: XOR<RoleCreateWithoutUserLinksInput, RoleUncheckedCreateWithoutUserLinksInput>
  }

  export type UserUpsertWithoutRolesInput = {
    update: XOR<UserUpdateWithoutRolesInput, UserUncheckedUpdateWithoutRolesInput>
    create: XOR<UserCreateWithoutRolesInput, UserUncheckedCreateWithoutRolesInput>
    where?: UserWhereInput
  }

  export type UserUpdateToOneWithWhereWithoutRolesInput = {
    where?: UserWhereInput
    data: XOR<UserUpdateWithoutRolesInput, UserUncheckedUpdateWithoutRolesInput>
  }

  export type UserUpdateWithoutRolesInput = {
    id?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password_hash?: StringFieldUpdateOperationsInput | string
    password_salt?: StringFieldUpdateOperationsInput | string
    pbkdf2_iter?: IntFieldUpdateOperationsInput | number
    totp_secret?: NullableStringFieldUpdateOperationsInput | string | null
    totp_enabled?: BoolFieldUpdateOperationsInput | boolean
    email_verified?: BoolFieldUpdateOperationsInput | boolean
    is_active?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    realm?: RealmUpdateOneRequiredWithoutUsersNestedInput
    sessions?: UserSessionUpdateManyWithoutUserNestedInput
    tokens?: TokenUpdateManyWithoutUserNestedInput
    authorizationCodes?: AuthorizationCodeUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateWithoutRolesInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password_hash?: StringFieldUpdateOperationsInput | string
    password_salt?: StringFieldUpdateOperationsInput | string
    pbkdf2_iter?: IntFieldUpdateOperationsInput | number
    totp_secret?: NullableStringFieldUpdateOperationsInput | string | null
    totp_enabled?: BoolFieldUpdateOperationsInput | boolean
    email_verified?: BoolFieldUpdateOperationsInput | boolean
    is_active?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    sessions?: UserSessionUncheckedUpdateManyWithoutUserNestedInput
    tokens?: TokenUncheckedUpdateManyWithoutUserNestedInput
    authorizationCodes?: AuthorizationCodeUncheckedUpdateManyWithoutUserNestedInput
  }

  export type RoleUpsertWithoutUserLinksInput = {
    update: XOR<RoleUpdateWithoutUserLinksInput, RoleUncheckedUpdateWithoutUserLinksInput>
    create: XOR<RoleCreateWithoutUserLinksInput, RoleUncheckedCreateWithoutUserLinksInput>
    where?: RoleWhereInput
  }

  export type RoleUpdateToOneWithWhereWithoutUserLinksInput = {
    where?: RoleWhereInput
    data: XOR<RoleUpdateWithoutUserLinksInput, RoleUncheckedUpdateWithoutUserLinksInput>
  }

  export type RoleUpdateWithoutUserLinksInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    is_client_role?: BoolFieldUpdateOperationsInput | boolean
    realm?: RealmUpdateOneRequiredWithoutRolesNestedInput
    client?: ClientUpdateOneWithoutRolesNestedInput
  }

  export type RoleUncheckedUpdateWithoutUserLinksInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    client_id?: NullableStringFieldUpdateOperationsInput | string | null
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    is_client_role?: BoolFieldUpdateOperationsInput | boolean
  }

  export type RealmCreateWithoutClientsInput = {
    id?: string
    name: string
    description?: string | null
    created_at?: Date | string
    keys?: RealmKeyCreateNestedManyWithoutRealmInput
    users?: UserCreateNestedManyWithoutRealmInput
    roles?: RoleCreateNestedManyWithoutRealmInput
    scopes?: ScopeCreateNestedManyWithoutRealmInput
  }

  export type RealmUncheckedCreateWithoutClientsInput = {
    id?: string
    name: string
    description?: string | null
    created_at?: Date | string
    keys?: RealmKeyUncheckedCreateNestedManyWithoutRealmInput
    users?: UserUncheckedCreateNestedManyWithoutRealmInput
    roles?: RoleUncheckedCreateNestedManyWithoutRealmInput
    scopes?: ScopeUncheckedCreateNestedManyWithoutRealmInput
  }

  export type RealmCreateOrConnectWithoutClientsInput = {
    where: RealmWhereUniqueInput
    create: XOR<RealmCreateWithoutClientsInput, RealmUncheckedCreateWithoutClientsInput>
  }

  export type RoleCreateWithoutClientInput = {
    id?: string
    name: string
    description?: string | null
    is_client_role?: boolean
    realm: RealmCreateNestedOneWithoutRolesInput
    userLinks?: UserRoleCreateNestedManyWithoutRoleInput
  }

  export type RoleUncheckedCreateWithoutClientInput = {
    id?: string
    realm_id: string
    name: string
    description?: string | null
    is_client_role?: boolean
    userLinks?: UserRoleUncheckedCreateNestedManyWithoutRoleInput
  }

  export type RoleCreateOrConnectWithoutClientInput = {
    where: RoleWhereUniqueInput
    create: XOR<RoleCreateWithoutClientInput, RoleUncheckedCreateWithoutClientInput>
  }

  export type RoleCreateManyClientInputEnvelope = {
    data: RoleCreateManyClientInput | RoleCreateManyClientInput[]
    skipDuplicates?: boolean
  }

  export type ClientScopeCreateWithoutClientInput = {
    is_default?: boolean
    scope: ScopeCreateNestedOneWithoutClientsInput
  }

  export type ClientScopeUncheckedCreateWithoutClientInput = {
    scope_id: string
    is_default?: boolean
  }

  export type ClientScopeCreateOrConnectWithoutClientInput = {
    where: ClientScopeWhereUniqueInput
    create: XOR<ClientScopeCreateWithoutClientInput, ClientScopeUncheckedCreateWithoutClientInput>
  }

  export type ClientScopeCreateManyClientInputEnvelope = {
    data: ClientScopeCreateManyClientInput | ClientScopeCreateManyClientInput[]
    skipDuplicates?: boolean
  }

  export type UserSessionCreateWithoutClientInput = {
    id?: string
    ip_addr: string
    user_agent: string
    login_time?: Date | string
    logout_time?: Date | string | null
    user: UserCreateNestedOneWithoutSessionsInput
  }

  export type UserSessionUncheckedCreateWithoutClientInput = {
    id?: string
    user_id: string
    ip_addr: string
    user_agent: string
    login_time?: Date | string
    logout_time?: Date | string | null
  }

  export type UserSessionCreateOrConnectWithoutClientInput = {
    where: UserSessionWhereUniqueInput
    create: XOR<UserSessionCreateWithoutClientInput, UserSessionUncheckedCreateWithoutClientInput>
  }

  export type UserSessionCreateManyClientInputEnvelope = {
    data: UserSessionCreateManyClientInput | UserSessionCreateManyClientInput[]
    skipDuplicates?: boolean
  }

  export type TokenCreateWithoutClientInput = {
    id?: string
    token_type: $Enums.TokenType
    jwt_id: string
    issued_at?: Date | string
    expires_at: Date | string
    revoked_at?: Date | string | null
    scope: string
    user?: UserCreateNestedOneWithoutTokensInput
  }

  export type TokenUncheckedCreateWithoutClientInput = {
    id?: string
    user_id?: string | null
    token_type: $Enums.TokenType
    jwt_id: string
    issued_at?: Date | string
    expires_at: Date | string
    revoked_at?: Date | string | null
    scope: string
  }

  export type TokenCreateOrConnectWithoutClientInput = {
    where: TokenWhereUniqueInput
    create: XOR<TokenCreateWithoutClientInput, TokenUncheckedCreateWithoutClientInput>
  }

  export type TokenCreateManyClientInputEnvelope = {
    data: TokenCreateManyClientInput | TokenCreateManyClientInput[]
    skipDuplicates?: boolean
  }

  export type AuthorizationCodeCreateWithoutClientInput = {
    code: string
    redirect_uri: string
    scope: string
    expires_at: Date | string
    created_at?: Date | string
    code_challenge?: string | null
    user: UserCreateNestedOneWithoutAuthorizationCodesInput
  }

  export type AuthorizationCodeUncheckedCreateWithoutClientInput = {
    code: string
    user_id: string
    redirect_uri: string
    scope: string
    expires_at: Date | string
    created_at?: Date | string
    code_challenge?: string | null
  }

  export type AuthorizationCodeCreateOrConnectWithoutClientInput = {
    where: AuthorizationCodeWhereUniqueInput
    create: XOR<AuthorizationCodeCreateWithoutClientInput, AuthorizationCodeUncheckedCreateWithoutClientInput>
  }

  export type AuthorizationCodeCreateManyClientInputEnvelope = {
    data: AuthorizationCodeCreateManyClientInput | AuthorizationCodeCreateManyClientInput[]
    skipDuplicates?: boolean
  }

  export type RealmUpsertWithoutClientsInput = {
    update: XOR<RealmUpdateWithoutClientsInput, RealmUncheckedUpdateWithoutClientsInput>
    create: XOR<RealmCreateWithoutClientsInput, RealmUncheckedCreateWithoutClientsInput>
    where?: RealmWhereInput
  }

  export type RealmUpdateToOneWithWhereWithoutClientsInput = {
    where?: RealmWhereInput
    data: XOR<RealmUpdateWithoutClientsInput, RealmUncheckedUpdateWithoutClientsInput>
  }

  export type RealmUpdateWithoutClientsInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    keys?: RealmKeyUpdateManyWithoutRealmNestedInput
    users?: UserUpdateManyWithoutRealmNestedInput
    roles?: RoleUpdateManyWithoutRealmNestedInput
    scopes?: ScopeUpdateManyWithoutRealmNestedInput
  }

  export type RealmUncheckedUpdateWithoutClientsInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    keys?: RealmKeyUncheckedUpdateManyWithoutRealmNestedInput
    users?: UserUncheckedUpdateManyWithoutRealmNestedInput
    roles?: RoleUncheckedUpdateManyWithoutRealmNestedInput
    scopes?: ScopeUncheckedUpdateManyWithoutRealmNestedInput
  }

  export type RoleUpsertWithWhereUniqueWithoutClientInput = {
    where: RoleWhereUniqueInput
    update: XOR<RoleUpdateWithoutClientInput, RoleUncheckedUpdateWithoutClientInput>
    create: XOR<RoleCreateWithoutClientInput, RoleUncheckedCreateWithoutClientInput>
  }

  export type RoleUpdateWithWhereUniqueWithoutClientInput = {
    where: RoleWhereUniqueInput
    data: XOR<RoleUpdateWithoutClientInput, RoleUncheckedUpdateWithoutClientInput>
  }

  export type RoleUpdateManyWithWhereWithoutClientInput = {
    where: RoleScalarWhereInput
    data: XOR<RoleUpdateManyMutationInput, RoleUncheckedUpdateManyWithoutClientInput>
  }

  export type ClientScopeUpsertWithWhereUniqueWithoutClientInput = {
    where: ClientScopeWhereUniqueInput
    update: XOR<ClientScopeUpdateWithoutClientInput, ClientScopeUncheckedUpdateWithoutClientInput>
    create: XOR<ClientScopeCreateWithoutClientInput, ClientScopeUncheckedCreateWithoutClientInput>
  }

  export type ClientScopeUpdateWithWhereUniqueWithoutClientInput = {
    where: ClientScopeWhereUniqueInput
    data: XOR<ClientScopeUpdateWithoutClientInput, ClientScopeUncheckedUpdateWithoutClientInput>
  }

  export type ClientScopeUpdateManyWithWhereWithoutClientInput = {
    where: ClientScopeScalarWhereInput
    data: XOR<ClientScopeUpdateManyMutationInput, ClientScopeUncheckedUpdateManyWithoutClientInput>
  }

  export type ClientScopeScalarWhereInput = {
    AND?: ClientScopeScalarWhereInput | ClientScopeScalarWhereInput[]
    OR?: ClientScopeScalarWhereInput[]
    NOT?: ClientScopeScalarWhereInput | ClientScopeScalarWhereInput[]
    client_id?: StringFilter<"ClientScope"> | string
    scope_id?: StringFilter<"ClientScope"> | string
    is_default?: BoolFilter<"ClientScope"> | boolean
  }

  export type UserSessionUpsertWithWhereUniqueWithoutClientInput = {
    where: UserSessionWhereUniqueInput
    update: XOR<UserSessionUpdateWithoutClientInput, UserSessionUncheckedUpdateWithoutClientInput>
    create: XOR<UserSessionCreateWithoutClientInput, UserSessionUncheckedCreateWithoutClientInput>
  }

  export type UserSessionUpdateWithWhereUniqueWithoutClientInput = {
    where: UserSessionWhereUniqueInput
    data: XOR<UserSessionUpdateWithoutClientInput, UserSessionUncheckedUpdateWithoutClientInput>
  }

  export type UserSessionUpdateManyWithWhereWithoutClientInput = {
    where: UserSessionScalarWhereInput
    data: XOR<UserSessionUpdateManyMutationInput, UserSessionUncheckedUpdateManyWithoutClientInput>
  }

  export type TokenUpsertWithWhereUniqueWithoutClientInput = {
    where: TokenWhereUniqueInput
    update: XOR<TokenUpdateWithoutClientInput, TokenUncheckedUpdateWithoutClientInput>
    create: XOR<TokenCreateWithoutClientInput, TokenUncheckedCreateWithoutClientInput>
  }

  export type TokenUpdateWithWhereUniqueWithoutClientInput = {
    where: TokenWhereUniqueInput
    data: XOR<TokenUpdateWithoutClientInput, TokenUncheckedUpdateWithoutClientInput>
  }

  export type TokenUpdateManyWithWhereWithoutClientInput = {
    where: TokenScalarWhereInput
    data: XOR<TokenUpdateManyMutationInput, TokenUncheckedUpdateManyWithoutClientInput>
  }

  export type AuthorizationCodeUpsertWithWhereUniqueWithoutClientInput = {
    where: AuthorizationCodeWhereUniqueInput
    update: XOR<AuthorizationCodeUpdateWithoutClientInput, AuthorizationCodeUncheckedUpdateWithoutClientInput>
    create: XOR<AuthorizationCodeCreateWithoutClientInput, AuthorizationCodeUncheckedCreateWithoutClientInput>
  }

  export type AuthorizationCodeUpdateWithWhereUniqueWithoutClientInput = {
    where: AuthorizationCodeWhereUniqueInput
    data: XOR<AuthorizationCodeUpdateWithoutClientInput, AuthorizationCodeUncheckedUpdateWithoutClientInput>
  }

  export type AuthorizationCodeUpdateManyWithWhereWithoutClientInput = {
    where: AuthorizationCodeScalarWhereInput
    data: XOR<AuthorizationCodeUpdateManyMutationInput, AuthorizationCodeUncheckedUpdateManyWithoutClientInput>
  }

  export type RealmCreateWithoutScopesInput = {
    id?: string
    name: string
    description?: string | null
    created_at?: Date | string
    keys?: RealmKeyCreateNestedManyWithoutRealmInput
    users?: UserCreateNestedManyWithoutRealmInput
    roles?: RoleCreateNestedManyWithoutRealmInput
    clients?: ClientCreateNestedManyWithoutRealmInput
  }

  export type RealmUncheckedCreateWithoutScopesInput = {
    id?: string
    name: string
    description?: string | null
    created_at?: Date | string
    keys?: RealmKeyUncheckedCreateNestedManyWithoutRealmInput
    users?: UserUncheckedCreateNestedManyWithoutRealmInput
    roles?: RoleUncheckedCreateNestedManyWithoutRealmInput
    clients?: ClientUncheckedCreateNestedManyWithoutRealmInput
  }

  export type RealmCreateOrConnectWithoutScopesInput = {
    where: RealmWhereUniqueInput
    create: XOR<RealmCreateWithoutScopesInput, RealmUncheckedCreateWithoutScopesInput>
  }

  export type ClientScopeCreateWithoutScopeInput = {
    is_default?: boolean
    client: ClientCreateNestedOneWithoutScopesInput
  }

  export type ClientScopeUncheckedCreateWithoutScopeInput = {
    client_id: string
    is_default?: boolean
  }

  export type ClientScopeCreateOrConnectWithoutScopeInput = {
    where: ClientScopeWhereUniqueInput
    create: XOR<ClientScopeCreateWithoutScopeInput, ClientScopeUncheckedCreateWithoutScopeInput>
  }

  export type ClientScopeCreateManyScopeInputEnvelope = {
    data: ClientScopeCreateManyScopeInput | ClientScopeCreateManyScopeInput[]
    skipDuplicates?: boolean
  }

  export type RealmUpsertWithoutScopesInput = {
    update: XOR<RealmUpdateWithoutScopesInput, RealmUncheckedUpdateWithoutScopesInput>
    create: XOR<RealmCreateWithoutScopesInput, RealmUncheckedCreateWithoutScopesInput>
    where?: RealmWhereInput
  }

  export type RealmUpdateToOneWithWhereWithoutScopesInput = {
    where?: RealmWhereInput
    data: XOR<RealmUpdateWithoutScopesInput, RealmUncheckedUpdateWithoutScopesInput>
  }

  export type RealmUpdateWithoutScopesInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    keys?: RealmKeyUpdateManyWithoutRealmNestedInput
    users?: UserUpdateManyWithoutRealmNestedInput
    roles?: RoleUpdateManyWithoutRealmNestedInput
    clients?: ClientUpdateManyWithoutRealmNestedInput
  }

  export type RealmUncheckedUpdateWithoutScopesInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    keys?: RealmKeyUncheckedUpdateManyWithoutRealmNestedInput
    users?: UserUncheckedUpdateManyWithoutRealmNestedInput
    roles?: RoleUncheckedUpdateManyWithoutRealmNestedInput
    clients?: ClientUncheckedUpdateManyWithoutRealmNestedInput
  }

  export type ClientScopeUpsertWithWhereUniqueWithoutScopeInput = {
    where: ClientScopeWhereUniqueInput
    update: XOR<ClientScopeUpdateWithoutScopeInput, ClientScopeUncheckedUpdateWithoutScopeInput>
    create: XOR<ClientScopeCreateWithoutScopeInput, ClientScopeUncheckedCreateWithoutScopeInput>
  }

  export type ClientScopeUpdateWithWhereUniqueWithoutScopeInput = {
    where: ClientScopeWhereUniqueInput
    data: XOR<ClientScopeUpdateWithoutScopeInput, ClientScopeUncheckedUpdateWithoutScopeInput>
  }

  export type ClientScopeUpdateManyWithWhereWithoutScopeInput = {
    where: ClientScopeScalarWhereInput
    data: XOR<ClientScopeUpdateManyMutationInput, ClientScopeUncheckedUpdateManyWithoutScopeInput>
  }

  export type ClientCreateWithoutScopesInput = {
    id?: string
    client_id: string
    client_name?: string | null
    client_secret_hash: string
    redirect_uris?: ClientCreateredirect_urisInput | string[]
    grant_types?: ClientCreategrant_typesInput | string[]
    access_token_life?: number
    refresh_token_life?: number
    created_at?: Date | string
    realm: RealmCreateNestedOneWithoutClientsInput
    roles?: RoleCreateNestedManyWithoutClientInput
    userSessions?: UserSessionCreateNestedManyWithoutClientInput
    tokens?: TokenCreateNestedManyWithoutClientInput
    authorizationCodes?: AuthorizationCodeCreateNestedManyWithoutClientInput
  }

  export type ClientUncheckedCreateWithoutScopesInput = {
    id?: string
    realm_id: string
    client_id: string
    client_name?: string | null
    client_secret_hash: string
    redirect_uris?: ClientCreateredirect_urisInput | string[]
    grant_types?: ClientCreategrant_typesInput | string[]
    access_token_life?: number
    refresh_token_life?: number
    created_at?: Date | string
    roles?: RoleUncheckedCreateNestedManyWithoutClientInput
    userSessions?: UserSessionUncheckedCreateNestedManyWithoutClientInput
    tokens?: TokenUncheckedCreateNestedManyWithoutClientInput
    authorizationCodes?: AuthorizationCodeUncheckedCreateNestedManyWithoutClientInput
  }

  export type ClientCreateOrConnectWithoutScopesInput = {
    where: ClientWhereUniqueInput
    create: XOR<ClientCreateWithoutScopesInput, ClientUncheckedCreateWithoutScopesInput>
  }

  export type ScopeCreateWithoutClientsInput = {
    id?: string
    name: string
    description?: string | null
    realm: RealmCreateNestedOneWithoutScopesInput
  }

  export type ScopeUncheckedCreateWithoutClientsInput = {
    id?: string
    realm_id: string
    name: string
    description?: string | null
  }

  export type ScopeCreateOrConnectWithoutClientsInput = {
    where: ScopeWhereUniqueInput
    create: XOR<ScopeCreateWithoutClientsInput, ScopeUncheckedCreateWithoutClientsInput>
  }

  export type ClientUpsertWithoutScopesInput = {
    update: XOR<ClientUpdateWithoutScopesInput, ClientUncheckedUpdateWithoutScopesInput>
    create: XOR<ClientCreateWithoutScopesInput, ClientUncheckedCreateWithoutScopesInput>
    where?: ClientWhereInput
  }

  export type ClientUpdateToOneWithWhereWithoutScopesInput = {
    where?: ClientWhereInput
    data: XOR<ClientUpdateWithoutScopesInput, ClientUncheckedUpdateWithoutScopesInput>
  }

  export type ClientUpdateWithoutScopesInput = {
    id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    client_name?: NullableStringFieldUpdateOperationsInput | string | null
    client_secret_hash?: StringFieldUpdateOperationsInput | string
    redirect_uris?: ClientUpdateredirect_urisInput | string[]
    grant_types?: ClientUpdategrant_typesInput | string[]
    access_token_life?: IntFieldUpdateOperationsInput | number
    refresh_token_life?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    realm?: RealmUpdateOneRequiredWithoutClientsNestedInput
    roles?: RoleUpdateManyWithoutClientNestedInput
    userSessions?: UserSessionUpdateManyWithoutClientNestedInput
    tokens?: TokenUpdateManyWithoutClientNestedInput
    authorizationCodes?: AuthorizationCodeUpdateManyWithoutClientNestedInput
  }

  export type ClientUncheckedUpdateWithoutScopesInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    client_name?: NullableStringFieldUpdateOperationsInput | string | null
    client_secret_hash?: StringFieldUpdateOperationsInput | string
    redirect_uris?: ClientUpdateredirect_urisInput | string[]
    grant_types?: ClientUpdategrant_typesInput | string[]
    access_token_life?: IntFieldUpdateOperationsInput | number
    refresh_token_life?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    roles?: RoleUncheckedUpdateManyWithoutClientNestedInput
    userSessions?: UserSessionUncheckedUpdateManyWithoutClientNestedInput
    tokens?: TokenUncheckedUpdateManyWithoutClientNestedInput
    authorizationCodes?: AuthorizationCodeUncheckedUpdateManyWithoutClientNestedInput
  }

  export type ScopeUpsertWithoutClientsInput = {
    update: XOR<ScopeUpdateWithoutClientsInput, ScopeUncheckedUpdateWithoutClientsInput>
    create: XOR<ScopeCreateWithoutClientsInput, ScopeUncheckedCreateWithoutClientsInput>
    where?: ScopeWhereInput
  }

  export type ScopeUpdateToOneWithWhereWithoutClientsInput = {
    where?: ScopeWhereInput
    data: XOR<ScopeUpdateWithoutClientsInput, ScopeUncheckedUpdateWithoutClientsInput>
  }

  export type ScopeUpdateWithoutClientsInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    realm?: RealmUpdateOneRequiredWithoutScopesNestedInput
  }

  export type ScopeUncheckedUpdateWithoutClientsInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type UserCreateWithoutAuthorizationCodesInput = {
    id?: string
    username: string
    email: string
    password_hash: string
    password_salt: string
    pbkdf2_iter: number
    totp_secret?: string | null
    totp_enabled?: boolean
    email_verified?: boolean
    is_active?: boolean
    created_at?: Date | string
    updated_at?: Date | string
    realm: RealmCreateNestedOneWithoutUsersInput
    roles?: UserRoleCreateNestedManyWithoutUserInput
    sessions?: UserSessionCreateNestedManyWithoutUserInput
    tokens?: TokenCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateWithoutAuthorizationCodesInput = {
    id?: string
    realm_id: string
    username: string
    email: string
    password_hash: string
    password_salt: string
    pbkdf2_iter: number
    totp_secret?: string | null
    totp_enabled?: boolean
    email_verified?: boolean
    is_active?: boolean
    created_at?: Date | string
    updated_at?: Date | string
    roles?: UserRoleUncheckedCreateNestedManyWithoutUserInput
    sessions?: UserSessionUncheckedCreateNestedManyWithoutUserInput
    tokens?: TokenUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserCreateOrConnectWithoutAuthorizationCodesInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutAuthorizationCodesInput, UserUncheckedCreateWithoutAuthorizationCodesInput>
  }

  export type ClientCreateWithoutAuthorizationCodesInput = {
    id?: string
    client_id: string
    client_name?: string | null
    client_secret_hash: string
    redirect_uris?: ClientCreateredirect_urisInput | string[]
    grant_types?: ClientCreategrant_typesInput | string[]
    access_token_life?: number
    refresh_token_life?: number
    created_at?: Date | string
    realm: RealmCreateNestedOneWithoutClientsInput
    roles?: RoleCreateNestedManyWithoutClientInput
    scopes?: ClientScopeCreateNestedManyWithoutClientInput
    userSessions?: UserSessionCreateNestedManyWithoutClientInput
    tokens?: TokenCreateNestedManyWithoutClientInput
  }

  export type ClientUncheckedCreateWithoutAuthorizationCodesInput = {
    id?: string
    realm_id: string
    client_id: string
    client_name?: string | null
    client_secret_hash: string
    redirect_uris?: ClientCreateredirect_urisInput | string[]
    grant_types?: ClientCreategrant_typesInput | string[]
    access_token_life?: number
    refresh_token_life?: number
    created_at?: Date | string
    roles?: RoleUncheckedCreateNestedManyWithoutClientInput
    scopes?: ClientScopeUncheckedCreateNestedManyWithoutClientInput
    userSessions?: UserSessionUncheckedCreateNestedManyWithoutClientInput
    tokens?: TokenUncheckedCreateNestedManyWithoutClientInput
  }

  export type ClientCreateOrConnectWithoutAuthorizationCodesInput = {
    where: ClientWhereUniqueInput
    create: XOR<ClientCreateWithoutAuthorizationCodesInput, ClientUncheckedCreateWithoutAuthorizationCodesInput>
  }

  export type UserUpsertWithoutAuthorizationCodesInput = {
    update: XOR<UserUpdateWithoutAuthorizationCodesInput, UserUncheckedUpdateWithoutAuthorizationCodesInput>
    create: XOR<UserCreateWithoutAuthorizationCodesInput, UserUncheckedCreateWithoutAuthorizationCodesInput>
    where?: UserWhereInput
  }

  export type UserUpdateToOneWithWhereWithoutAuthorizationCodesInput = {
    where?: UserWhereInput
    data: XOR<UserUpdateWithoutAuthorizationCodesInput, UserUncheckedUpdateWithoutAuthorizationCodesInput>
  }

  export type UserUpdateWithoutAuthorizationCodesInput = {
    id?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password_hash?: StringFieldUpdateOperationsInput | string
    password_salt?: StringFieldUpdateOperationsInput | string
    pbkdf2_iter?: IntFieldUpdateOperationsInput | number
    totp_secret?: NullableStringFieldUpdateOperationsInput | string | null
    totp_enabled?: BoolFieldUpdateOperationsInput | boolean
    email_verified?: BoolFieldUpdateOperationsInput | boolean
    is_active?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    realm?: RealmUpdateOneRequiredWithoutUsersNestedInput
    roles?: UserRoleUpdateManyWithoutUserNestedInput
    sessions?: UserSessionUpdateManyWithoutUserNestedInput
    tokens?: TokenUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateWithoutAuthorizationCodesInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password_hash?: StringFieldUpdateOperationsInput | string
    password_salt?: StringFieldUpdateOperationsInput | string
    pbkdf2_iter?: IntFieldUpdateOperationsInput | number
    totp_secret?: NullableStringFieldUpdateOperationsInput | string | null
    totp_enabled?: BoolFieldUpdateOperationsInput | boolean
    email_verified?: BoolFieldUpdateOperationsInput | boolean
    is_active?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    roles?: UserRoleUncheckedUpdateManyWithoutUserNestedInput
    sessions?: UserSessionUncheckedUpdateManyWithoutUserNestedInput
    tokens?: TokenUncheckedUpdateManyWithoutUserNestedInput
  }

  export type ClientUpsertWithoutAuthorizationCodesInput = {
    update: XOR<ClientUpdateWithoutAuthorizationCodesInput, ClientUncheckedUpdateWithoutAuthorizationCodesInput>
    create: XOR<ClientCreateWithoutAuthorizationCodesInput, ClientUncheckedCreateWithoutAuthorizationCodesInput>
    where?: ClientWhereInput
  }

  export type ClientUpdateToOneWithWhereWithoutAuthorizationCodesInput = {
    where?: ClientWhereInput
    data: XOR<ClientUpdateWithoutAuthorizationCodesInput, ClientUncheckedUpdateWithoutAuthorizationCodesInput>
  }

  export type ClientUpdateWithoutAuthorizationCodesInput = {
    id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    client_name?: NullableStringFieldUpdateOperationsInput | string | null
    client_secret_hash?: StringFieldUpdateOperationsInput | string
    redirect_uris?: ClientUpdateredirect_urisInput | string[]
    grant_types?: ClientUpdategrant_typesInput | string[]
    access_token_life?: IntFieldUpdateOperationsInput | number
    refresh_token_life?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    realm?: RealmUpdateOneRequiredWithoutClientsNestedInput
    roles?: RoleUpdateManyWithoutClientNestedInput
    scopes?: ClientScopeUpdateManyWithoutClientNestedInput
    userSessions?: UserSessionUpdateManyWithoutClientNestedInput
    tokens?: TokenUpdateManyWithoutClientNestedInput
  }

  export type ClientUncheckedUpdateWithoutAuthorizationCodesInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    client_name?: NullableStringFieldUpdateOperationsInput | string | null
    client_secret_hash?: StringFieldUpdateOperationsInput | string
    redirect_uris?: ClientUpdateredirect_urisInput | string[]
    grant_types?: ClientUpdategrant_typesInput | string[]
    access_token_life?: IntFieldUpdateOperationsInput | number
    refresh_token_life?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    roles?: RoleUncheckedUpdateManyWithoutClientNestedInput
    scopes?: ClientScopeUncheckedUpdateManyWithoutClientNestedInput
    userSessions?: UserSessionUncheckedUpdateManyWithoutClientNestedInput
    tokens?: TokenUncheckedUpdateManyWithoutClientNestedInput
  }

  export type UserCreateWithoutTokensInput = {
    id?: string
    username: string
    email: string
    password_hash: string
    password_salt: string
    pbkdf2_iter: number
    totp_secret?: string | null
    totp_enabled?: boolean
    email_verified?: boolean
    is_active?: boolean
    created_at?: Date | string
    updated_at?: Date | string
    realm: RealmCreateNestedOneWithoutUsersInput
    roles?: UserRoleCreateNestedManyWithoutUserInput
    sessions?: UserSessionCreateNestedManyWithoutUserInput
    authorizationCodes?: AuthorizationCodeCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateWithoutTokensInput = {
    id?: string
    realm_id: string
    username: string
    email: string
    password_hash: string
    password_salt: string
    pbkdf2_iter: number
    totp_secret?: string | null
    totp_enabled?: boolean
    email_verified?: boolean
    is_active?: boolean
    created_at?: Date | string
    updated_at?: Date | string
    roles?: UserRoleUncheckedCreateNestedManyWithoutUserInput
    sessions?: UserSessionUncheckedCreateNestedManyWithoutUserInput
    authorizationCodes?: AuthorizationCodeUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserCreateOrConnectWithoutTokensInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutTokensInput, UserUncheckedCreateWithoutTokensInput>
  }

  export type ClientCreateWithoutTokensInput = {
    id?: string
    client_id: string
    client_name?: string | null
    client_secret_hash: string
    redirect_uris?: ClientCreateredirect_urisInput | string[]
    grant_types?: ClientCreategrant_typesInput | string[]
    access_token_life?: number
    refresh_token_life?: number
    created_at?: Date | string
    realm: RealmCreateNestedOneWithoutClientsInput
    roles?: RoleCreateNestedManyWithoutClientInput
    scopes?: ClientScopeCreateNestedManyWithoutClientInput
    userSessions?: UserSessionCreateNestedManyWithoutClientInput
    authorizationCodes?: AuthorizationCodeCreateNestedManyWithoutClientInput
  }

  export type ClientUncheckedCreateWithoutTokensInput = {
    id?: string
    realm_id: string
    client_id: string
    client_name?: string | null
    client_secret_hash: string
    redirect_uris?: ClientCreateredirect_urisInput | string[]
    grant_types?: ClientCreategrant_typesInput | string[]
    access_token_life?: number
    refresh_token_life?: number
    created_at?: Date | string
    roles?: RoleUncheckedCreateNestedManyWithoutClientInput
    scopes?: ClientScopeUncheckedCreateNestedManyWithoutClientInput
    userSessions?: UserSessionUncheckedCreateNestedManyWithoutClientInput
    authorizationCodes?: AuthorizationCodeUncheckedCreateNestedManyWithoutClientInput
  }

  export type ClientCreateOrConnectWithoutTokensInput = {
    where: ClientWhereUniqueInput
    create: XOR<ClientCreateWithoutTokensInput, ClientUncheckedCreateWithoutTokensInput>
  }

  export type UserUpsertWithoutTokensInput = {
    update: XOR<UserUpdateWithoutTokensInput, UserUncheckedUpdateWithoutTokensInput>
    create: XOR<UserCreateWithoutTokensInput, UserUncheckedCreateWithoutTokensInput>
    where?: UserWhereInput
  }

  export type UserUpdateToOneWithWhereWithoutTokensInput = {
    where?: UserWhereInput
    data: XOR<UserUpdateWithoutTokensInput, UserUncheckedUpdateWithoutTokensInput>
  }

  export type UserUpdateWithoutTokensInput = {
    id?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password_hash?: StringFieldUpdateOperationsInput | string
    password_salt?: StringFieldUpdateOperationsInput | string
    pbkdf2_iter?: IntFieldUpdateOperationsInput | number
    totp_secret?: NullableStringFieldUpdateOperationsInput | string | null
    totp_enabled?: BoolFieldUpdateOperationsInput | boolean
    email_verified?: BoolFieldUpdateOperationsInput | boolean
    is_active?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    realm?: RealmUpdateOneRequiredWithoutUsersNestedInput
    roles?: UserRoleUpdateManyWithoutUserNestedInput
    sessions?: UserSessionUpdateManyWithoutUserNestedInput
    authorizationCodes?: AuthorizationCodeUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateWithoutTokensInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password_hash?: StringFieldUpdateOperationsInput | string
    password_salt?: StringFieldUpdateOperationsInput | string
    pbkdf2_iter?: IntFieldUpdateOperationsInput | number
    totp_secret?: NullableStringFieldUpdateOperationsInput | string | null
    totp_enabled?: BoolFieldUpdateOperationsInput | boolean
    email_verified?: BoolFieldUpdateOperationsInput | boolean
    is_active?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    roles?: UserRoleUncheckedUpdateManyWithoutUserNestedInput
    sessions?: UserSessionUncheckedUpdateManyWithoutUserNestedInput
    authorizationCodes?: AuthorizationCodeUncheckedUpdateManyWithoutUserNestedInput
  }

  export type ClientUpsertWithoutTokensInput = {
    update: XOR<ClientUpdateWithoutTokensInput, ClientUncheckedUpdateWithoutTokensInput>
    create: XOR<ClientCreateWithoutTokensInput, ClientUncheckedCreateWithoutTokensInput>
    where?: ClientWhereInput
  }

  export type ClientUpdateToOneWithWhereWithoutTokensInput = {
    where?: ClientWhereInput
    data: XOR<ClientUpdateWithoutTokensInput, ClientUncheckedUpdateWithoutTokensInput>
  }

  export type ClientUpdateWithoutTokensInput = {
    id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    client_name?: NullableStringFieldUpdateOperationsInput | string | null
    client_secret_hash?: StringFieldUpdateOperationsInput | string
    redirect_uris?: ClientUpdateredirect_urisInput | string[]
    grant_types?: ClientUpdategrant_typesInput | string[]
    access_token_life?: IntFieldUpdateOperationsInput | number
    refresh_token_life?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    realm?: RealmUpdateOneRequiredWithoutClientsNestedInput
    roles?: RoleUpdateManyWithoutClientNestedInput
    scopes?: ClientScopeUpdateManyWithoutClientNestedInput
    userSessions?: UserSessionUpdateManyWithoutClientNestedInput
    authorizationCodes?: AuthorizationCodeUpdateManyWithoutClientNestedInput
  }

  export type ClientUncheckedUpdateWithoutTokensInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    client_name?: NullableStringFieldUpdateOperationsInput | string | null
    client_secret_hash?: StringFieldUpdateOperationsInput | string
    redirect_uris?: ClientUpdateredirect_urisInput | string[]
    grant_types?: ClientUpdategrant_typesInput | string[]
    access_token_life?: IntFieldUpdateOperationsInput | number
    refresh_token_life?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    roles?: RoleUncheckedUpdateManyWithoutClientNestedInput
    scopes?: ClientScopeUncheckedUpdateManyWithoutClientNestedInput
    userSessions?: UserSessionUncheckedUpdateManyWithoutClientNestedInput
    authorizationCodes?: AuthorizationCodeUncheckedUpdateManyWithoutClientNestedInput
  }

  export type RealmKeyCreateManyRealmInput = {
    id?: string
    kid: string
    public_key: string
    private_key_enc: string
    alg: string
    created_at?: Date | string
    expires_at?: Date | string | null
  }

  export type UserCreateManyRealmInput = {
    id?: string
    username: string
    email: string
    password_hash: string
    password_salt: string
    pbkdf2_iter: number
    totp_secret?: string | null
    totp_enabled?: boolean
    email_verified?: boolean
    is_active?: boolean
    created_at?: Date | string
    updated_at?: Date | string
  }

  export type RoleCreateManyRealmInput = {
    id?: string
    client_id?: string | null
    name: string
    description?: string | null
    is_client_role?: boolean
  }

  export type ClientCreateManyRealmInput = {
    id?: string
    client_id: string
    client_name?: string | null
    client_secret_hash: string
    redirect_uris?: ClientCreateredirect_urisInput | string[]
    grant_types?: ClientCreategrant_typesInput | string[]
    access_token_life?: number
    refresh_token_life?: number
    created_at?: Date | string
  }

  export type ScopeCreateManyRealmInput = {
    id?: string
    name: string
    description?: string | null
  }

  export type RealmKeyUpdateWithoutRealmInput = {
    id?: StringFieldUpdateOperationsInput | string
    kid?: StringFieldUpdateOperationsInput | string
    public_key?: StringFieldUpdateOperationsInput | string
    private_key_enc?: StringFieldUpdateOperationsInput | string
    alg?: StringFieldUpdateOperationsInput | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    expires_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type RealmKeyUncheckedUpdateWithoutRealmInput = {
    id?: StringFieldUpdateOperationsInput | string
    kid?: StringFieldUpdateOperationsInput | string
    public_key?: StringFieldUpdateOperationsInput | string
    private_key_enc?: StringFieldUpdateOperationsInput | string
    alg?: StringFieldUpdateOperationsInput | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    expires_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type RealmKeyUncheckedUpdateManyWithoutRealmInput = {
    id?: StringFieldUpdateOperationsInput | string
    kid?: StringFieldUpdateOperationsInput | string
    public_key?: StringFieldUpdateOperationsInput | string
    private_key_enc?: StringFieldUpdateOperationsInput | string
    alg?: StringFieldUpdateOperationsInput | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    expires_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type UserUpdateWithoutRealmInput = {
    id?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password_hash?: StringFieldUpdateOperationsInput | string
    password_salt?: StringFieldUpdateOperationsInput | string
    pbkdf2_iter?: IntFieldUpdateOperationsInput | number
    totp_secret?: NullableStringFieldUpdateOperationsInput | string | null
    totp_enabled?: BoolFieldUpdateOperationsInput | boolean
    email_verified?: BoolFieldUpdateOperationsInput | boolean
    is_active?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    roles?: UserRoleUpdateManyWithoutUserNestedInput
    sessions?: UserSessionUpdateManyWithoutUserNestedInput
    tokens?: TokenUpdateManyWithoutUserNestedInput
    authorizationCodes?: AuthorizationCodeUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateWithoutRealmInput = {
    id?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password_hash?: StringFieldUpdateOperationsInput | string
    password_salt?: StringFieldUpdateOperationsInput | string
    pbkdf2_iter?: IntFieldUpdateOperationsInput | number
    totp_secret?: NullableStringFieldUpdateOperationsInput | string | null
    totp_enabled?: BoolFieldUpdateOperationsInput | boolean
    email_verified?: BoolFieldUpdateOperationsInput | boolean
    is_active?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    roles?: UserRoleUncheckedUpdateManyWithoutUserNestedInput
    sessions?: UserSessionUncheckedUpdateManyWithoutUserNestedInput
    tokens?: TokenUncheckedUpdateManyWithoutUserNestedInput
    authorizationCodes?: AuthorizationCodeUncheckedUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateManyWithoutRealmInput = {
    id?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password_hash?: StringFieldUpdateOperationsInput | string
    password_salt?: StringFieldUpdateOperationsInput | string
    pbkdf2_iter?: IntFieldUpdateOperationsInput | number
    totp_secret?: NullableStringFieldUpdateOperationsInput | string | null
    totp_enabled?: BoolFieldUpdateOperationsInput | boolean
    email_verified?: BoolFieldUpdateOperationsInput | boolean
    is_active?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type RoleUpdateWithoutRealmInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    is_client_role?: BoolFieldUpdateOperationsInput | boolean
    client?: ClientUpdateOneWithoutRolesNestedInput
    userLinks?: UserRoleUpdateManyWithoutRoleNestedInput
  }

  export type RoleUncheckedUpdateWithoutRealmInput = {
    id?: StringFieldUpdateOperationsInput | string
    client_id?: NullableStringFieldUpdateOperationsInput | string | null
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    is_client_role?: BoolFieldUpdateOperationsInput | boolean
    userLinks?: UserRoleUncheckedUpdateManyWithoutRoleNestedInput
  }

  export type RoleUncheckedUpdateManyWithoutRealmInput = {
    id?: StringFieldUpdateOperationsInput | string
    client_id?: NullableStringFieldUpdateOperationsInput | string | null
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    is_client_role?: BoolFieldUpdateOperationsInput | boolean
  }

  export type ClientUpdateWithoutRealmInput = {
    id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    client_name?: NullableStringFieldUpdateOperationsInput | string | null
    client_secret_hash?: StringFieldUpdateOperationsInput | string
    redirect_uris?: ClientUpdateredirect_urisInput | string[]
    grant_types?: ClientUpdategrant_typesInput | string[]
    access_token_life?: IntFieldUpdateOperationsInput | number
    refresh_token_life?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    roles?: RoleUpdateManyWithoutClientNestedInput
    scopes?: ClientScopeUpdateManyWithoutClientNestedInput
    userSessions?: UserSessionUpdateManyWithoutClientNestedInput
    tokens?: TokenUpdateManyWithoutClientNestedInput
    authorizationCodes?: AuthorizationCodeUpdateManyWithoutClientNestedInput
  }

  export type ClientUncheckedUpdateWithoutRealmInput = {
    id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    client_name?: NullableStringFieldUpdateOperationsInput | string | null
    client_secret_hash?: StringFieldUpdateOperationsInput | string
    redirect_uris?: ClientUpdateredirect_urisInput | string[]
    grant_types?: ClientUpdategrant_typesInput | string[]
    access_token_life?: IntFieldUpdateOperationsInput | number
    refresh_token_life?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    roles?: RoleUncheckedUpdateManyWithoutClientNestedInput
    scopes?: ClientScopeUncheckedUpdateManyWithoutClientNestedInput
    userSessions?: UserSessionUncheckedUpdateManyWithoutClientNestedInput
    tokens?: TokenUncheckedUpdateManyWithoutClientNestedInput
    authorizationCodes?: AuthorizationCodeUncheckedUpdateManyWithoutClientNestedInput
  }

  export type ClientUncheckedUpdateManyWithoutRealmInput = {
    id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    client_name?: NullableStringFieldUpdateOperationsInput | string | null
    client_secret_hash?: StringFieldUpdateOperationsInput | string
    redirect_uris?: ClientUpdateredirect_urisInput | string[]
    grant_types?: ClientUpdategrant_typesInput | string[]
    access_token_life?: IntFieldUpdateOperationsInput | number
    refresh_token_life?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type ScopeUpdateWithoutRealmInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    clients?: ClientScopeUpdateManyWithoutScopeNestedInput
  }

  export type ScopeUncheckedUpdateWithoutRealmInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    clients?: ClientScopeUncheckedUpdateManyWithoutScopeNestedInput
  }

  export type ScopeUncheckedUpdateManyWithoutRealmInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type UserRoleCreateManyUserInput = {
    role_id: string
  }

  export type UserSessionCreateManyUserInput = {
    id?: string
    client_id: string
    ip_addr: string
    user_agent: string
    login_time?: Date | string
    logout_time?: Date | string | null
  }

  export type TokenCreateManyUserInput = {
    id?: string
    client_id: string
    token_type: $Enums.TokenType
    jwt_id: string
    issued_at?: Date | string
    expires_at: Date | string
    revoked_at?: Date | string | null
    scope: string
  }

  export type AuthorizationCodeCreateManyUserInput = {
    code: string
    client_id: string
    redirect_uri: string
    scope: string
    expires_at: Date | string
    created_at?: Date | string
    code_challenge?: string | null
  }

  export type UserRoleUpdateWithoutUserInput = {
    role?: RoleUpdateOneRequiredWithoutUserLinksNestedInput
  }

  export type UserRoleUncheckedUpdateWithoutUserInput = {
    role_id?: StringFieldUpdateOperationsInput | string
  }

  export type UserRoleUncheckedUpdateManyWithoutUserInput = {
    role_id?: StringFieldUpdateOperationsInput | string
  }

  export type UserSessionUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    ip_addr?: StringFieldUpdateOperationsInput | string
    user_agent?: StringFieldUpdateOperationsInput | string
    login_time?: DateTimeFieldUpdateOperationsInput | Date | string
    logout_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    client?: ClientUpdateOneRequiredWithoutUserSessionsNestedInput
  }

  export type UserSessionUncheckedUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    ip_addr?: StringFieldUpdateOperationsInput | string
    user_agent?: StringFieldUpdateOperationsInput | string
    login_time?: DateTimeFieldUpdateOperationsInput | Date | string
    logout_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type UserSessionUncheckedUpdateManyWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    ip_addr?: StringFieldUpdateOperationsInput | string
    user_agent?: StringFieldUpdateOperationsInput | string
    login_time?: DateTimeFieldUpdateOperationsInput | Date | string
    logout_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type TokenUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    token_type?: EnumTokenTypeFieldUpdateOperationsInput | $Enums.TokenType
    jwt_id?: StringFieldUpdateOperationsInput | string
    issued_at?: DateTimeFieldUpdateOperationsInput | Date | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    revoked_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    scope?: StringFieldUpdateOperationsInput | string
    client?: ClientUpdateOneRequiredWithoutTokensNestedInput
  }

  export type TokenUncheckedUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    token_type?: EnumTokenTypeFieldUpdateOperationsInput | $Enums.TokenType
    jwt_id?: StringFieldUpdateOperationsInput | string
    issued_at?: DateTimeFieldUpdateOperationsInput | Date | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    revoked_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    scope?: StringFieldUpdateOperationsInput | string
  }

  export type TokenUncheckedUpdateManyWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    token_type?: EnumTokenTypeFieldUpdateOperationsInput | $Enums.TokenType
    jwt_id?: StringFieldUpdateOperationsInput | string
    issued_at?: DateTimeFieldUpdateOperationsInput | Date | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    revoked_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    scope?: StringFieldUpdateOperationsInput | string
  }

  export type AuthorizationCodeUpdateWithoutUserInput = {
    code?: StringFieldUpdateOperationsInput | string
    redirect_uri?: StringFieldUpdateOperationsInput | string
    scope?: StringFieldUpdateOperationsInput | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    code_challenge?: NullableStringFieldUpdateOperationsInput | string | null
    client?: ClientUpdateOneRequiredWithoutAuthorizationCodesNestedInput
  }

  export type AuthorizationCodeUncheckedUpdateWithoutUserInput = {
    code?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    redirect_uri?: StringFieldUpdateOperationsInput | string
    scope?: StringFieldUpdateOperationsInput | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    code_challenge?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type AuthorizationCodeUncheckedUpdateManyWithoutUserInput = {
    code?: StringFieldUpdateOperationsInput | string
    client_id?: StringFieldUpdateOperationsInput | string
    redirect_uri?: StringFieldUpdateOperationsInput | string
    scope?: StringFieldUpdateOperationsInput | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    code_challenge?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type UserRoleCreateManyRoleInput = {
    user_id: string
  }

  export type UserRoleUpdateWithoutRoleInput = {
    user?: UserUpdateOneRequiredWithoutRolesNestedInput
  }

  export type UserRoleUncheckedUpdateWithoutRoleInput = {
    user_id?: StringFieldUpdateOperationsInput | string
  }

  export type UserRoleUncheckedUpdateManyWithoutRoleInput = {
    user_id?: StringFieldUpdateOperationsInput | string
  }

  export type RoleCreateManyClientInput = {
    id?: string
    realm_id: string
    name: string
    description?: string | null
    is_client_role?: boolean
  }

  export type ClientScopeCreateManyClientInput = {
    scope_id: string
    is_default?: boolean
  }

  export type UserSessionCreateManyClientInput = {
    id?: string
    user_id: string
    ip_addr: string
    user_agent: string
    login_time?: Date | string
    logout_time?: Date | string | null
  }

  export type TokenCreateManyClientInput = {
    id?: string
    user_id?: string | null
    token_type: $Enums.TokenType
    jwt_id: string
    issued_at?: Date | string
    expires_at: Date | string
    revoked_at?: Date | string | null
    scope: string
  }

  export type AuthorizationCodeCreateManyClientInput = {
    code: string
    user_id: string
    redirect_uri: string
    scope: string
    expires_at: Date | string
    created_at?: Date | string
    code_challenge?: string | null
  }

  export type RoleUpdateWithoutClientInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    is_client_role?: BoolFieldUpdateOperationsInput | boolean
    realm?: RealmUpdateOneRequiredWithoutRolesNestedInput
    userLinks?: UserRoleUpdateManyWithoutRoleNestedInput
  }

  export type RoleUncheckedUpdateWithoutClientInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    is_client_role?: BoolFieldUpdateOperationsInput | boolean
    userLinks?: UserRoleUncheckedUpdateManyWithoutRoleNestedInput
  }

  export type RoleUncheckedUpdateManyWithoutClientInput = {
    id?: StringFieldUpdateOperationsInput | string
    realm_id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    is_client_role?: BoolFieldUpdateOperationsInput | boolean
  }

  export type ClientScopeUpdateWithoutClientInput = {
    is_default?: BoolFieldUpdateOperationsInput | boolean
    scope?: ScopeUpdateOneRequiredWithoutClientsNestedInput
  }

  export type ClientScopeUncheckedUpdateWithoutClientInput = {
    scope_id?: StringFieldUpdateOperationsInput | string
    is_default?: BoolFieldUpdateOperationsInput | boolean
  }

  export type ClientScopeUncheckedUpdateManyWithoutClientInput = {
    scope_id?: StringFieldUpdateOperationsInput | string
    is_default?: BoolFieldUpdateOperationsInput | boolean
  }

  export type UserSessionUpdateWithoutClientInput = {
    id?: StringFieldUpdateOperationsInput | string
    ip_addr?: StringFieldUpdateOperationsInput | string
    user_agent?: StringFieldUpdateOperationsInput | string
    login_time?: DateTimeFieldUpdateOperationsInput | Date | string
    logout_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    user?: UserUpdateOneRequiredWithoutSessionsNestedInput
  }

  export type UserSessionUncheckedUpdateWithoutClientInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    ip_addr?: StringFieldUpdateOperationsInput | string
    user_agent?: StringFieldUpdateOperationsInput | string
    login_time?: DateTimeFieldUpdateOperationsInput | Date | string
    logout_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type UserSessionUncheckedUpdateManyWithoutClientInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    ip_addr?: StringFieldUpdateOperationsInput | string
    user_agent?: StringFieldUpdateOperationsInput | string
    login_time?: DateTimeFieldUpdateOperationsInput | Date | string
    logout_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type TokenUpdateWithoutClientInput = {
    id?: StringFieldUpdateOperationsInput | string
    token_type?: EnumTokenTypeFieldUpdateOperationsInput | $Enums.TokenType
    jwt_id?: StringFieldUpdateOperationsInput | string
    issued_at?: DateTimeFieldUpdateOperationsInput | Date | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    revoked_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    scope?: StringFieldUpdateOperationsInput | string
    user?: UserUpdateOneWithoutTokensNestedInput
  }

  export type TokenUncheckedUpdateWithoutClientInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: NullableStringFieldUpdateOperationsInput | string | null
    token_type?: EnumTokenTypeFieldUpdateOperationsInput | $Enums.TokenType
    jwt_id?: StringFieldUpdateOperationsInput | string
    issued_at?: DateTimeFieldUpdateOperationsInput | Date | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    revoked_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    scope?: StringFieldUpdateOperationsInput | string
  }

  export type TokenUncheckedUpdateManyWithoutClientInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: NullableStringFieldUpdateOperationsInput | string | null
    token_type?: EnumTokenTypeFieldUpdateOperationsInput | $Enums.TokenType
    jwt_id?: StringFieldUpdateOperationsInput | string
    issued_at?: DateTimeFieldUpdateOperationsInput | Date | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    revoked_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    scope?: StringFieldUpdateOperationsInput | string
  }

  export type AuthorizationCodeUpdateWithoutClientInput = {
    code?: StringFieldUpdateOperationsInput | string
    redirect_uri?: StringFieldUpdateOperationsInput | string
    scope?: StringFieldUpdateOperationsInput | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    code_challenge?: NullableStringFieldUpdateOperationsInput | string | null
    user?: UserUpdateOneRequiredWithoutAuthorizationCodesNestedInput
  }

  export type AuthorizationCodeUncheckedUpdateWithoutClientInput = {
    code?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    redirect_uri?: StringFieldUpdateOperationsInput | string
    scope?: StringFieldUpdateOperationsInput | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    code_challenge?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type AuthorizationCodeUncheckedUpdateManyWithoutClientInput = {
    code?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    redirect_uri?: StringFieldUpdateOperationsInput | string
    scope?: StringFieldUpdateOperationsInput | string
    expires_at?: DateTimeFieldUpdateOperationsInput | Date | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    code_challenge?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type ClientScopeCreateManyScopeInput = {
    client_id: string
    is_default?: boolean
  }

  export type ClientScopeUpdateWithoutScopeInput = {
    is_default?: BoolFieldUpdateOperationsInput | boolean
    client?: ClientUpdateOneRequiredWithoutScopesNestedInput
  }

  export type ClientScopeUncheckedUpdateWithoutScopeInput = {
    client_id?: StringFieldUpdateOperationsInput | string
    is_default?: BoolFieldUpdateOperationsInput | boolean
  }

  export type ClientScopeUncheckedUpdateManyWithoutScopeInput = {
    client_id?: StringFieldUpdateOperationsInput | string
    is_default?: BoolFieldUpdateOperationsInput | boolean
  }



  /**
   * Batch Payload for updateMany & deleteMany & createMany
   */

  export type BatchPayload = {
    count: number
  }

  /**
   * DMMF
   */
  export const dmmf: runtime.BaseDMMF
}