const prisma = require('../config/prismaClient');
const { randomUUID } = require('crypto');

class PrismaAdapter {
  constructor(name) {
    this.name = name; // e.g. 'Client', 'AuthorizationCode', 'AccessToken'
  }

  _model() {
    switch (this.name) {
      case 'AuthorizationCode':  return prisma.authorizationCode;
      case 'AccessToken':        return prisma.token;
      case 'RefreshToken':       return prisma.token;
      case 'Client':             return prisma.client;
      // thêm tuỳ ý
      default: throw new Error('Unknown model');
    }
  }

  async upsert(id, payload, expiresIn) {
    const data = {
      id,
      jwt_id: id,
      issued_at: new Date(),
      expires_at: new Date(Date.now() + expiresIn * 1000),
      scope: payload.scope || '',
      client_id: payload.client_id,
      user_id: payload.accountId || null,
      token_type: this.name === 'RefreshToken' ? 'refresh' : 'access',
    };
    await this._model().upsert({ where: { id }, update: data, create: data });
  }

  async find(id) {
    return this._model().findUnique({ where: { id } });
  }

  async findByUserCode() { return undefined; }
  async findByUid()       { return undefined; }

  async destroy(id) {
    await this._model().delete({ where: { id } }).catch(() => {});
  }

  async consume(id) {
    await this._model().update({ where: { id }, data: { revoked_at: new Date() } });
  }
}

module.exports = PrismaAdapter;
