const asyncHandler   = require('express-async-handler');
const prisma         = require('../config/prismaClient');
const { randomUUID, generateKeyPairSync } = require('crypto');

/* GET /admin/realms/:realmId/keys */
exports.listKeys = asyncHandler(async (req, res) => {
  const { realmId } = req.params;
  const keys = await prisma.realmKey.findMany({
    where: { realm_id: realmId },
    orderBy: { created_at: 'desc' },
  });
  res.json(keys);
});

/* POST /admin/realms/:realmId/keys  (generate & store) */
exports.createKey = asyncHandler(async (req, res) => {
  const { realmId } = req.params;
  const { alg = 'RS256' } = req.body;

  const { publicKey, privateKey } = generateKeyPairSync('rsa', { modulusLength: 2048 });
  const key = await prisma.realmKey.create({
    data: {
      id: randomUUID(),
      realm_id: realmId,
      kid: randomUUID(),
      public_key: publicKey.export({ type: 'pkcs1', format: 'pem' }),
      private_key_enc: privateKey.export({ type: 'pkcs1', format: 'pem' }), // demo: chưa mã hóa
      alg,
      created_at: new Date(),
    },
  });
  res.status(201).json(key);
});

/* PATCH /admin/keys/:kid  (update expires_at / active toggle) */
exports.updateKey = asyncHandler(async (req, res) => {
  const { kid } = req.params;
  const key = await prisma.realmKey.update({
    where: { kid },
    data: req.body,
  });
  res.json(key);
});
