const asyncHandler = require('express-async-handler');
const prisma       = require('../config/prismaClient');
const { randomUUID } = require('crypto');

/* GET /admin/realms */
exports.listRealms = asyncHandler(async (_req, res) => {
  const realms = await prisma.realm.findMany({ orderBy: { created_at: 'desc' } });
  res.json(realms);
});

/* POST /admin/realms */
exports.createRealm = asyncHandler(async (req, res) => {
  const { name, description } = req.body;
  const realm = await prisma.realm.create({
    data: { id: randomUUID(), name, description },
  });
  res.status(201).json(realm);
});

/* PUT /admin/realms/:id */
exports.updateRealm = asyncHandler(async (req, res) => {
  const { id } = req.params;
  const realm = await prisma.realm.update({ where: { id }, data: req.body });
  res.json(realm);
});

/* DELETE /admin/realms/:id */
exports.deleteRealm = asyncHandler(async (req, res) => {
  const { id } = req.params;
  await prisma.realm.delete({ where: { id } });
  res.status(204).end();
});
