const asyncHandler = require('express-async-handler');
const prisma       = require('../config/prismaClient');
const { randomUUID } = require('crypto');
const { hashPassword } = require('../utils/passwordUtils');
const { generateSecret } = require('../services/totpService');

/* GET /admin/realms/:realmId/users */
exports.listUsers = asyncHandler(async (req, res) => {
  const { realmId } = req.params;
  const users = await prisma.user.findMany({
    where: { realm_id: realmId },
    orderBy: { created_at: 'desc' },
  });
  res.json(users);
});

/* POST /admin/realms/:realmId/users */
exports.createUser = asyncHandler(async (req, res) => {
  const { realmId } = req.params;
  const { username, email, password } = req.body;
  const { hash, salt, iter } = hashPassword(password);

  const user = await prisma.user.create({
    data: {
      id: randomUUID(),
      realm_id: realmId,
      username,
      email,
      password_hash: hash,
      password_salt: salt,
      pbkdf2_iter: iter,
    },
  });
  res.status(201).json(user);
});

/* PATCH /admin/users/:id/totp   { enable: true|false } */
exports.toggleTotp = asyncHandler(async (req, res) => {
  const { id } = req.params;
  const { enable } = req.body;

  let data = {};
  if (enable) {
    data.totp_secret  = generateSecret();
    data.totp_enabled = false;           // chờ user quét QR & verify
  } else {
    data.totp_secret  = null;
    data.totp_enabled = false;
  }

  const user = await prisma.user.update({ where: { id }, data });
  res.json(user);
});
