const jwt = require('jsonwebtoken');
const prisma = require('../config/prismaClient');

async function authMiddleware(req, res, next) {
  const auth = req.headers.authorization || '';
  if (!auth.startsWith('Bearer ')) return res.status(401).json({ message: 'Missing token' });
  const tokenStr = auth.slice(7);
  const decoded = jwt.decode(tokenStr, { complete: true });
  if (!decoded) return res.status(401).json({ message: 'Bad token' });

  // Lấy khoá thích hợp
  const key = await prisma.realmKey.findUnique({ where: { kid: decoded.header.kid } });
  if (!key) return res.status(401).json({ message: 'Key not found' });

  try {
    const payload = jwt.verify(tokenStr, key.public_key, { algorithms: [key.alg] });
    req.user = payload;
    next();
  } catch {
    res.status(401).json({ message: 'Token expired/invalid' });
  }
}

module.exports = authMiddleware;
