function rbac(requiredRoles = []) {
    return (req, res, next) => {
      const userRoles = req.user?.roles || [];
      const ok = requiredRoles.every(r => userRoles.includes(r));
      return ok ? next() : res.status(403).json({ message: 'Forbidden' });
    };
  }
  
  module.exports = rbac;
  