// ──────────────────────────────────────────
// src/models/Client.js
// ──────────────────────────────────────────
const prisma          = require('../config/prismaClient');
const { randomUUID }  = require('crypto');

function createClient({
  realm_id,
  client_id,
  client_name,
  client_secret_hash,
  redirect_uris,
  grant_types,
}) {
  return prisma.client.create({
    data: {
      id: randomUUID(),
      realm_id,
      client_id,
      client_name,
      client_secret_hash,
      redirect_uris,
      grant_types,
    },
  });
}

function findByClientId(realm_id, client_id) {
  return prisma.client.findUnique({
    where: { client_id_realm_id: { client_id, realm_id } },
  });
}

function listClientsByRealm(realm_id, skip = 0, take = 20) {
  return prisma.client.findMany({ where: { realm_id }, skip, take });
}

module.exports = { createClient, findByClientId, listClientsByRealm };
