// ──────────────────────────────────────────
// src/models/Realm.js
// ──────────────────────────────────────────
const prisma            = require('../config/prismaClient');
const { randomUUID }    = require('crypto');

/** Tạo realm mới */
async function createRealm({ name, description }) {
  return prisma.realm.create({
    data: { id: randomUUID(), name, description },
  });
}

/** Lấy realm theo name */
function getRealmByName(name) {
  return prisma.realm.findUnique({ where: { name } });
}

/** Danh sách realm (phân trang đơn giản) */
function listRealms(skip = 0, take = 20) {
  return prisma.realm.findMany({ skip, take, orderBy: { created_at: 'desc' } });
}

module.exports = { createRealm, getRealmByName, listRealms };
