// ──────────────────────────────────────────
// src/models/Role.js
// ──────────────────────────────────────────
const prisma          = require('../config/prismaClient');
const { randomUUID }  = require('crypto');

function createRole({ realm_id, client_id = null, name, description }) {
  return prisma.role.create({
    data: {
      id: randomUUID(),
      realm_id,
      client_id,
      name,
      description,
      is_client_role: !!client_id,
    },
  });
}

function listRolesByRealm(realm_id) {
  return prisma.role.findMany({ where: { realm_id, client_id: null } });
}

function listRolesByClient(client_id) {
  return prisma.role.findMany({ where: { client_id } });
}

module.exports = { createRole, listRolesByRealm, listRolesByClient };
