// ──────────────────────────────────────────
// src/models/Token.js
// ──────────────────────────────────────────
const prisma          = require('../config/prismaClient');
const { randomUUID }  = require('crypto');

/** Lưu record token (đã được sign) */
function createToken({ user_id = null, client_id, token_type, jwt_id, expires_at, scope = '' }) {
  return prisma.token.create({
    data: {
      id: randomUUID(),
      user_id,
      client_id,
      token_type,
      jwt_id,
      issued_at: new Date(),
      expires_at,
      scope,
    },
  });
}

/** Đánh dấu token đã thu hồi */
function revokeToken(jwt_id) {
  return prisma.token.update({
    where: { jwt_id },
    data: { revoked_at: new Date() },
  });
}

/** Kiểm tra token còn hiệu lực & chưa bị revoke */
function isTokenActive(jwt_id) {
  return prisma.token.findFirst({
    where: {
      jwt_id,
      revoked_at: null,
      expires_at: { gt: new Date() },
    },
  });
}

module.exports = { createToken, revokeToken, isTokenActive };
