// ──────────────────────────────────────────
// src/models/UserRole.js
// ──────────────────────────────────────────
const prisma = require('../config/prismaClient');

function assignRoleToUser(user_id, role_id) {
  return prisma.userRole.create({ data: { user_id, role_id } });
}

function removeRoleFromUser(user_id, role_id) {
  return prisma.userRole.delete({
    where: { user_id_role_id: { user_id, role_id } },
  });
}

function getUserRoles(user_id) {
  return prisma.userRole.findMany({
    where: { user_id },
    include: { role: true },
  });
}

module.exports = { assignRoleToUser, removeRoleFromUser, getUserRoles };
