const router = require('express').Router();
const c      = require('../../controllers/keyAdminController');
const auth   = require('../../middlewares/authMiddleware');
const rbac   = require('../../middlewares/rbacMiddleware');

router.use(auth, rbac(['admin']));

router.get('/realms/:realmId/keys', c.listKeys);
router.post('/realms/:realmId/keys', c.createKey);
router.patch('/keys/:kid',          c.updateKey);

module.exports = router;
