const router = require('express').Router();
const c      = require('../../controllers/realmAdminController');
const auth   = require('../../middlewares/authMiddleware');
const rbac   = require('../../middlewares/rbacMiddleware');

router.use(auth, rbac(['admin']));

router.get('/',          c.listRealms);
router.post('/',         c.createRealm);
router.put('/:id',       c.updateRealm);
router.delete('/:id',    c.deleteRealm);

module.exports = router;
