const router = require('express').Router();
const c      = require('../../controllers/userAdminController');
const auth   = require('../../middlewares/authMiddleware');
const rbac   = require('../../middlewares/rbacMiddleware');

router.use(auth, rbac(['admin']));

router.get('/realms/:realmId/users', c.listUsers);
router.post('/realms/:realmId/users', c.createUser);
router.patch('/users/:id/totp',       c.toggleTotp);

module.exports = router;
