const prisma = require('../config/prismaClient');
const { randomUUID, generateKeyPairSync } = require('crypto');

/** Lấy khoá đang hoạt động (chưa hết hạn) của realm */
async function getActiveKey(realm_id) {
  const now = new Date();
  return prisma.realmKey.findFirst({
    where: { realm_id, OR: [ { expires_at: null }, { expires_at: { gt: now } } ] },
    orderBy: { created_at: 'desc' },
  });
}

/** Nếu realm chưa có khoá, tạo mới (RSA‑256) */
async function ensureRealmKey(realm_id) {
  let key = await getActiveKey(realm_id);
  if (!key) {
    const { publicKey, privateKey } = generateKeyPairSync('rsa', { modulusLength: 2048 });
    key = await prisma.realmKey.create({
      data: {
        id: randomUUID(),
        realm_id,
        kid: randomUUID(),
        public_key: publicKey.export({ type: 'pkcs1', format: 'pem' }),
        private_key_enc: privateKey.export({ type: 'pkcs1', format: 'pem' }), // demo: chưa mã hoá
        alg: 'RS256',
      },
    });
  }
  return key;
}

module.exports = { getActiveKey, ensureRealmKey };
