const { authenticator } = require('otplib');
const { randomBytes }   = require('crypto');

function generateSecret() {
  return authenticator.generateSecret();      // Base32
}

function generateOTP(secret) {
  return authenticator.generate(secret);
}

function verifyOTP(token, secret, window = Number(process.env.TOTP_WINDOW || 1)) {
  return authenticator.check(token, secret, { window });
}

function otpauthURL(secret, username, issuer = 'AuthServer') {
  return authenticator.keyuri(username, issuer, secret);
}

module.exports = { generateSecret, generateOTP, verifyOTP, otpauthURL };
