const crypto = require('crypto');

const HASH_ALG   = 'sha512';
const ITERATIONS = 100_000;          // Có thể tăng dần
const KEYLEN     = 64;               // 512 bit

function hashPassword(password, salt = crypto.randomBytes(16).toString('hex'), iter = ITERATIONS) {
  const hash = crypto.pbkdf2Sync(password, salt, iter, KEYLEN, HASH_ALG).toString('hex');
  return { hash, salt, iter };
}

function verifyPassword(plain, { hash, salt, iter }) {
  console.log('Verifying password with:', { hash, salt, iter });
  const calc = crypto.pbkdf2Sync(plain, salt, iter, KEYLEN, HASH_ALG).toString('hex');
  return crypto.timingSafeEqual(Buffer.from(hash, 'hex'), Buffer.from(calc, 'hex'));
}

module.exports = { hashPassword, verifyPassword };
